C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c Time and space interpolations for Velocity picks
c
c Author: Yaohui Zhang
c
c Date  : August, 1995
c
c Amoco Tulsa Technology Center
c
c
        subroutine tsinterp(tpik,vpik,npik,isingle,nsamp,ddt,indptr,
     1                      inters,intere,is,ie,isp,irec,tp,vp)
        dimension tpik(1),vpik(1),npik(1),indptr(1),inters(1),intere(1)
        dimension is(1),ie(1),isp(1),tp(1),vp(1),vv1(9999),vv2(9999)
        dimension t1(9999),v1(9999),t2(9999),v2(9999)
        integer ddt
c
c       tpik,vpivks: time and velocity picks                   (input)
c       npik(irec): number of picks in record irec             (input)
c       isingle    : velocity flag                             (input)
c       nsamp    : number of samples per trace                 (input)
c       ddt      : sample interval in ms                       (input)
c       indptr   : index array                                 (input)
c       inters,intere,is,ie,isp: interpolation guide arrays    (input)
c       is,ie    : interpolation guide index                   (input)
c       irec     : current interpolation record index          (input)
c       tp       : interpolated time trace                     (output)
c       vp       : interpolated P-wave velocity trace          (output)
c
c
c
c

c ???? JOE
             print *, '11111', nsamp, ddt, nsjj, irec, is(irec)

         do i=1,nsamp
            v1(i)=0.0
            v2(i)=0.0
            vv1(i)=0.0
            vv2(i)=0.0
            t1(i)=0.0
            t2(i)=0.0
            tp(i)=0.0
            vp(i)=0.0
         enddo

c ???? JOE
             print *, '22222', nsamp, ddt, nsjj, irec, is(irec)

c
c
c      P-wave velocity picks time and space interpolations
c      if necessary.
c
         IF(isingle .ne. 1) THEN
c
c P-wave Velocity space time and space interpolations
c
         if(isp(irec) .eq. 0) then
c
c     No space interpolation is needed for the current trace
c
             call mvdat(vpik(1+indptr(is(irec))),npik(is(irec)),v1)
             call mvdat(tpik(1+indptr(is(irec))),npik(is(irec)),t1)
             nsjj=npik(is(irec))

c ???? JOE
c At this point nsjj is trash
             print *, '33333', nsamp, ddt, nsjj, irec, is(irec)

             call vinterp(t1,v1,nsamp,ddt,nsjj,tp,vp,irec)
         else
c
c     Space interpolcation is needed. trace(irec) is obtained from
c     trace[inters(irec)] and trace[inters(irec)] by linear interpolation
c
             call mvdat(vpik(1+indptr(is(irec))),npik(is(irec)),v1)
             call mvdat(tpik(1+indptr(is(irec))),npik(is(irec)),t1)
             nsjj=npik(is(irec))
             call vinterp(t1,v1,nsamp,ddt,nsjj,tp,vv1,irec)
c         do i=1,nsamp
c            write(21,*) tp(i),vv1(i)
c         enddo
c            write(21,*)
c            write(21,*)
  
             call mvdat(vpik(1+indptr(ie(irec))),npik(ie(irec)),v2)
             call mvdat(tpik(1+indptr(ie(irec))),npik(ie(irec)),t2)
             nejj=npik(ie(irec))
c             write(*,*) 'ddt=',ddt
             call vinterp(t2,v2,nsamp,ddt,nejj,tp,vv2,irec)
c         do i=1,nsamp
c            write(21,*) tp(i),vv2(i)
c         enddo
             xs=inters(irec)
             xe=intere(irec)
             xx=isp(irec)
             call linterp(nsamp,xs,vv1,xe,vv2,xx,vp)
         endif
c
       ELSE
             call mvdat(vpik(1),npik(1),v1)
             call mvdat(tpik(1),npik(1),t1)
             nsjj=npik(1)
             call vinterp(t1,v1,nsamp,ddt,nsjj,tp,vp,irec)
       ENDIF
c
c      Now, vp is the P-wave velocity (in tp) ready to be used by the routine
c      "tpsvel" for Vs/Vp ratio scan. Nonhyperbolic aprroach.
c
       return
       end
