/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* declare field descriptor stuff */
/* 10sep93 phil fincannon - added selection option */
/* 08dec93 phil fincannon - added uppercase option */
#ifndef EOF
#include <stdio.h>
#endif

/* general defs */
#define MAXFIELDS 5000   /* max number of panel fields */
#define MAXCHECKS 10    /* max number of runtime checks per field */
#define MAXDISPLA 80    /* max display length for field (was 40) */ 
#define MAXTOKEN  8192  /* max token length for parsing */

/* p_type field values */
#define PTANY	  0	/* any file */
#define PTREG	  1	/* regular file */
#define PTDIR	  2	/* directory */
#define PTCHAR	  4	/* char special */
#define PTBLOCK	  8	/* block special */
#define PTSOC	 16	/* socket */
#define PTFIFO	 32	/* named-pipe */
#define PTCONSOL 64	/* console */

/* field types */
typedef enum {FTNONE,FTLABEL,FTSTRING,FTINTEGER,FTREAL,
	      FTYESNO,FTPATH,FTTOGGLE,FTSLIDER,FTCMNT,FTPWORD} field_t;

typedef enum {NO,YES} boolean;

struct field {
	field_t f_type;
	char *f_name, *f_prompt, *f_suffix, *f_minv, *f_cmnt,
		*f_maxv, *f_tag, *f_iniv, *f_script, *f_on, *f_off, *f_pword,
		*f_select, *f_pick;
	short f_row, f_col, f_length, f_prec, f_read, f_write, f_exec, f_ptype;
	short f_uppercase;
	int (*f_checks[MAXCHECKS+1])();
};

typedef struct field Field;
