/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <string.h>
#include <stdlib.h>
#include "field.h"

pathckmin(f,value) /* check length of each path component against min */
Field *f; char *value;
{
	double atof();

	char *p = value;

	int n = strlen(value), minlen = atof(f->f_minv);

	if (n > 1 && value[--n] == '/') 
		value[n] = '\0';

	for (n = 0; *p; p++)
		if (*p != '/')
			n++;
		else if (p != value && n < minlen)
			break;
		else n = 0;

	if (n < minlen) {
		char msg[255];
		sprintf(msg,
		"%s: no path component may be less than %d character%s",
		f->f_name,minlen,(minlen == 1 ? "" : "s"));		
		doalert(msg);
		return 1;
	}

	return 0;
				
}
