/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>

runcommand(cline,bkgrnd) /* fork and exec another program */
char **cline;
int bkgrnd; /* wait if non-zero */
{
        int pid, exitstat, ret;

        if ((pid=fork()) < 0) {
                perror("");
                return(-1);
        }

        if (pid==0) { /* child */
                execvp(*cline,cline);
                perror(*cline);
                exit(255);
        }
 
        /* parent */
 
        if (bkgrnd) {
                fprintf(stderr,"[%d]\n",pid);
                return(0);
        }

        while ((ret=wait(&exitstat)) != pid && ret != -1)
                ;

	if (ret == -1 || exitstat >> 8 == 255)
		return -1;

	return (exitstat & 0377 ? exitstat : exitstat >> 8);
 
}
