/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "field.h"
#include <ctype.h>

#define MAXCMD 1023
#define SUBST  '%'

scriptck(f,val) /* pass script the value and return its exit status */
Field *f;
char *val;
{
	int pid, exitstat, ret, flag = 0;
	register int c, i, j, k;
	char command[MAXCMD+1];
        char tag[20];
        char *val2;
	extern char *findval();

	for (i=j=0; i<MAXCMD && f->f_script[j]; j++) {
	    if (f->f_script[j] != SUBST) {
	        command[i++] = f->f_script[j];
	    } else {
		j++;
		if (!(isalnum(c = f->f_script[j]) || c == '-' || c == '_' )) {
	            for (k=0; i<MAXCMD && val[k]; k++) {
			 if (ispunct((c = val[k])))
				command[i++] = '\\';
			 if (i < MAXCMD)
				command[i++] = val[k];
		    }
		} else {
		    k = 0;
	            while (isalnum(c = f->f_script[j+k]) || c == '-' || c == '_' ) {
			tag[k++] = c;
		    }
		    tag[k] = 0; 
		    j = j + k;
		    val2 = findval(tag);
		    if (val2) {
	               	for (k=0; i<MAXCMD && val2[k]; k++) {
				if (ispunct((c = val2[k])))
					command[i++] = '\\';
				if (i < MAXCMD)
					command[i++] = val2[k];
			}
		    }
		}
		j--;
	        flag++;
	    }
	}


	if (!flag && i < MAXCMD) {
	    command[i++] = ' ';
	    for (k=0; i<MAXCMD && val[k]; i++, k++) {
		 if (ispunct((c = val[k])))
			command[i++] = '\\';
		 if (i < MAXCMD)
		 	command[i] = val[k];
	    }
	}

	command[i] = '\0';

	/* fprintf(stderr,"scriptck: [%s]\n", command);  debug */

	if ((pid = fork()) < 0) {
		perror("scriptck [fork]");
		return -1;
	}

	if (pid == 0) {
		execlp("sh","sh","-c",command,(char *)0);
		perror("scriptck [execlp]");
		exit(255);
	}

	while ((ret=wait(&exitstat)) != pid && ret != -1)
		;

	if (ret == -1) {
		perror("scriptck [wait]");
		return -1;
	}

	return (exitstat & 0377 ? exitstat : exitstat >> 8);

}
