#include <stdio.h>
#include <fcntl.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>

#define ERR fprintf(stderr,
#define DBG fprintf(stderr,

void
print (dpy, w)
    Display *dpy;
    Window w;

{
  Window wchild, rootwin;
  int xroot, yroot;
  char buf[1050], tmp[1024], printcmd[1050];
  XWindowAttributes winfo;
  Screen *screen;

/* Check for TEK_PRINTER. */
    strcpy (printcmd, (char *)getenv("XSHOWRAS_PRINT_CMD"));
    if (strlen(printcmd)==0) { 
        ERR "Error: environment variable XSHOWRAS_PRINT_CMD missing.\n");
        return;
    }
  
/* get output file name */
    strcpy (tmp, tmpnam(NULL));
  
/* get window coord */
    XGetWindowAttributes (dpy, w, &winfo);
DBG "print win x=%d y=%d\n", winfo.x, winfo.y);

    screen = XDefaultScreenOfDisplay(dpy);

    rootwin = XRootWindowOfScreen(screen);

    XTranslateCoordinates (dpy, w, rootwin,
			   winfo.x, winfo.y, &xroot, &yroot, &wchild);
DBG "print root x=%d y=%d\n", xroot, yroot);

/* do screen dump */
    sprintf (buf, "screendump -x %d -y %d -X %d -Y %d %s",
    	     abs(xroot), abs(yroot), winfo.width, winfo.height, tmp);
    system (buf);
    XBell (dpy, 100);
    XFlush (dpy);

/* execute the printcmd */
    sprintf (buf, "%s %s", printcmd, tmp);
    system (buf);
    unlink (tmp); 

    return;
}
