/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* seticon - read a bitmap file to use for icon display */
/* written 30apr91 by Phil Fincannon                    */
/* based on example from O'Reilly Volume 4M             */

#include <X11/Intrinsic.h>	/* Intrinsics Definitions */
#include <X11/StringDefs.h>	/* Standard Name-String definitions */
/* #include <X11/Xaw/Label.h> */	/* Athena Label Widget */
#include <Xm/Xm.h>
#include <stdio.h>

void
seticon (toplevel, fn)
   Widget toplevel;
   char *fn;
{
   Arg arg;
   Pixmap  iconptr;
   unsigned int width,height;
   int x_hot,y_hot;

	if (XReadBitmapFile(XtDisplay(toplevel),XtWindow(toplevel),
		fn,&width,&height,&iconptr,&x_hot,&y_hot) != 0)
	  fprintf(stderr, "seticon: could not find icon pixmap: %s\n",fn);
	else
	  XtVaSetValues (toplevel, XmNiconPixmap, iconptr, NULL); 

	return;
}
