C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  tim2hed3d: read velocity flat files for 3D
C                     and using XY info and LI/DI limits output
c                            of given ampl. at specified times
c
c     Changes:
c
c     June 4, 2002 -  fixed call to median in timmod to correspond to
c                     changes made in the utilities library routine.
c                     Also added code to allow surface fit QCUSP output
c                     from usp input which was previously dissallowed.
c     Garossino
c
c     June 6 2000,  - fixed logic in basic xsd pick reader so that
c                     RC option would function.  Previous version
c                     supported RC in flat format only - request by
c                     Kenny Gullette to support installing a mute
c                     horizon picked in xsd to an offset volume.
c     Garossino

c     currently reads the following format styles:
c     usp
c     xsd
c     xsdheader
c     flatfile
C
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     itr (SZLNHD)
      INTEGER     vtr (SZLNHD)
      integer     argis
      real        fmscl, mfscl
#include <f77/pid.h>
      REAL*8      XX, XY, YX, YY, XXT, XYT, YXT, YYT
      integer     limin, limax, lidel, dimin, dimax, didel
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout, luusp
      
      CHARACTER   NAME * 9, ntap * 256, otap * 256, vtap * 256
      CHARACTER   stawrd*6, ftap * 256

      real        times, filter
      pointer     (wktimes , times  (1000000))
      pointer     (wkwork  , work   (1000000))
      pointer     (wkfilter, filter (1000000))

      logical     verbos,gecovel,bfilevel,xsd,smooth,noedge
      logical     heap, f2m, m2f, notrp, stk, QC, fit, diff, usp
      logical     vverbos,flt,RC,QCUSP
 
      DATA NAME     /'TIM2HED3D'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./

      fmscl = 0.30480
      mfscl = 3.28084

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,vtap,limin,limax,dimin,dimax,iend,verbos,
     1           IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,luin,lupik,luout,
     2           gecovel,bfilevel,xsd,stawrd,f2m,m2f,notrp,stk,
     3           smooth, nf, QC, fit,iord,irtype, ilim, diff,flt,
     4           RC,vverbos,didel,lidel,noedge,QCUSP,ftap,usp,tscl)

c----
c  XY feet -> m or m-> feet scaler
c----
          if     ( f2m ) then
             xyscl = fmscl
          elseif ( m2f ) then
             xyscl = mfscl
          else
             xyscl = 1.0
          endif

     
      IF (.not. QC .AND. .not. QCUSP) THEN
         call getln(luin , ntap,'r', 0)
         call getln(luout, otap,'w', 1)
         if (usp) then
            call getln(lupik, vtap,'r', -1)
         endif
c----
c  read line header of input save certain parameters
c----
         call rtape(luin,itr,lbytes)
         if(lbytes.eq.0)then
               write(LER,*)'FATAL ERROR in tim2hed3d:'
            write(LER,*)'tim2hed3d: no header read from unit ',luin
            write(LER,*)'FATAL'
            stop
         endif
         if (usp) then
            call rtape(lupik,vtr,lvytes)
            if(lvytes.eq.0)then
               write(LER,*)'FATAL ERROR in tim2hed3d:'
               write(LER,*)'tim2hed3d: no header read from unit ',lupik
               write(LER,*)'FATAL'
               stop
            endif
            call saver(vtr, 'NumSmp', nsampv, LINHED)
            call saver(vtr, 'SmpInt', nsiv  , LINHED)
            call saver(vtr, 'NumTrc', ntrcv , LINHED)
            call saver(vtr, 'NumRec', nrecv , LINHED)
            if (nrecv .ne. 1) then
               write(LER,*)'FATAL ERROR in tim2hed3d:'
               write(LER,*)'Number of usp fmt horizon records must be 1'
               write(LER,*)'Found ',nrecv,' on data set ',vtap
               stop
            endif
            ndip = nsampv
            nlip = ntrcv
            write(LERR,*)'usp format horizon file:'
            write(LERR,*)'Number DIs = ',ndip
            write(LERR,*)'Number LIs = ',nlip
         endif

         itscl = tscl
         call saver(itr, 'NumSmp', nsamp, LINHED)
         call saver(itr, 'SmpInt', nsi  , LINHED)
         call saver(itr, 'NumTrc', ntrc , LINHED)
         call saver(itr, 'NumRec', nrec , LINHED)
         call saver(itr, 'Format', iform, LINHED)
         call savew(itr, 'T_Unit', itscl, LINHED)
         call hlhprt (itr, lbytes, name, 9, LERR)

         itrchdr = TRACEHEADER
         call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrchdr)
         call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,itrchdr)
         call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,itrchdr)
         call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,itrchdr)
         call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,itrchdr)
         call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,itrchdr)
         call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,itrchdr)
         call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,itrchdr)
         call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,itrchdr)
         call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,itrchdr)
         call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,itrchdr)
         call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,itrchdr)
         call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,itrchdr)
         call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,itrchdr)
         call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,itrchdr)
         call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,itrchdr)

         call savelu(stawrd,ifmt_stawrd,l_stawrd,ln_stawrd,itrchdr)

c define number output bytes
 
         obytes = SZTRHD + nsamp * SZSMPD
 
c inject command line into historical lineheader
 
         call savhlh ( itr, lbytes, lbyout )
 
c write output lineheader
 
         call wrtape ( luout, itr, lbyout )

      ELSEIF (QCUSP) THEN

         if (ftap .eq. ' ') ftap = 'TIMHED.usp'
         call getln(luusp, ftap, 'w', -1)
         if (luusp .lt. 1) then
            write(LER,*)'FATAL ERROR in tim2h3ed QCUSP option:'
            write(LER,*)'Cannot open output  QC usp file!'
            write(LER,*)'Check directory permissions...'
            call ccexit (666)
         endif
         itrchdr = TRACEHEADER
         call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,itrchdr)
         call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,itrchdr)

         if (usp) then
            call getln(lupik, vtap,'r', -1)
            call rtape(lupik,vtr,lvytes)
            if(lvytes.eq.0)then
               write(LER,*)'FATAL ERROR in tim2hed3d:'
               write(LER,*)'tim2hed3d: no header read from unit ',lupik
               write(LER,*)'FATAL'
               stop
            endif
            call saver(vtr, 'NumSmp', nsampv, LINHED)
            call saver(vtr, 'SmpInt', nsiv  , LINHED)
            call saver(vtr, 'NumTrc', ntrcv , LINHED)
            call saver(vtr, 'NumRec', nrecv , LINHED)
            if (nrecv .ne. 1) then
               write(LER,*)'FATAL ERROR in tim2hed3d:'
               write(LER,*)'Number of usp fmt horizon records must be 1'
               write(LER,*)'Found ',nrecv,' on data set ',vtap
               stop
            endif
            ndip = nsampv
            nlip = ntrcv
            write(LERR,*)'usp format horizon file:'
            write(LERR,*)'Number DIs = ',ndip
            write(LERR,*)'Number LIs = ',nlip
         endif

      ELSEIF (QC) THEN

         if (ftap .eq. ' ') ftap = 'TIMHED'
         call alloclun ( luqc )

      ENDIF

C**********************************************************************C
C     build LI/DI coordinates
C**********************************************************************C

      IF ( .not. RC ) THEN

         CALL XFMI  (IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,NX,NY,
     1               IWRN, XX, XY, YX, YY, XXT, XYT, YXT, YYT)

         if (limax .eq. 0) then
             maxli = NX
         else
             maxli = limax
         endif
         if (limin .eq. 0) then
             minli = 1
         else
             minli = limin
         endif
         if (dimax .eq. 0) then
             maxdi = NY
         else
             maxdi = dimax
         endif
         if (dimin .eq. 0) then
             mindi = 1
         else
             mindi = dimin
         endif
         NDI    = maxdi - mindi + 1
         NLI    = maxli - minli + 1
      ELSE
         minli = limin
         maxli = limax
         mindi = dimin
         maxdi = dimax
         NDI    = (maxdi - mindi)/didel + 1
         NLI    = (maxli - minli)/lidel + 1
         
         if (usp) then
            if (NDI .ne. ndip) then
               write(LERR,*)'FATAL ERROR in tim2hed3d:'
               write(LERR,*)'Number of DIs from cmd line = ',NDI
               write(LERR,*)'is not equal to number on usp format'
               write(LERR,*)'horizon file = ',ndip
               write(LERR,*)'Check dimensions of survey'
               write(LER ,*)'FATAL ERROR in tim2hed3d:'
               write(LER ,*)'Number of DIs from cmd line = ',NDI
               write(LER ,*)'is not equal to number on usp format'
               write(LER ,*)'horizon file = ',ndip
               write(LER ,*)'Check dimensions of survey'
               go to 999
            endif
            if (NLI .ne. nlip) then
               write(LERR,*)'FATAL ERROR in tim2hed3d:'
               write(LERR,*)'Number of LIs from cmd line = ',NLI
               write(LERR,*)'is not equal to number on usp format'
               write(LERR,*)'horizon file = ',nlip
               write(LERR,*)'Check dimensions of survey'
               write(LER ,*)'FATAL ERROR in tim2hed3d:'
               write(LER ,*)'Number of DIs from cmd line = ',NLI
               write(LER ,*)'is not equal to number on usp format'
               write(LER ,*)'horizon file = ',nlip
               write(LER ,*)'Check dimensions of survey'
               go to 999
            endif
         endif
         dx = float(lidel)
         dy = float(didel)

      ENDIF

 
      write(LER,*)' '
      write(LER,*)'*********************************'
      write(LER,*)' '
      write(LER,*)'Min LI asked for =  ',minli
      write(LER,*)'Max LI asked for =  ',maxli
      write(LER,*)'LI increment     =  ',lidel
      write(LER,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LER,*)'Min DI asked for =  ',mindi
      write(LER,*)'Max DI asked for =  ',maxdi
      write(LER,*)'DI increment     =  ',didel
      write(LER,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LER,*)'XY scaler        =  ',xyscl
      write(LER,*)'Time scaler      =  ',tscl
      if (RC)
     1write(LER,*)'Use Line/Trace numbers out of horizon file'
      if (stk)
     1write(LER,*)'Input is stacked volume'
      if (xsd) then
        write(LER,*)'xsd pick file horizon input'
      elseif (usp) then
        write(LER,*)'usp format horizon input'
      else
        write(LER,*)'Landmark horizon input'
      endif
      if (smooth)
     1write(LER,*)'median smoothing length = ',nf
      if (fit) then
      write(LER,*)'Surface order     = ',iord
      write(LER,*)'Number iterations = ',ilim
      write(LER,*)'Fit type          = ',irtype
      write(LER,*)'(1=robust; 0=least squares)'
      if ((smooth .or. fit) .and. diff)
     1write(LER,*)'Use difference between input times & fitted or smooth
     2ed surface'
      endif
      write(LERR,*)'*********************************'
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'*********************************'
      write(LERR,*)' '
      write(LERR,*)'Min LI asked for =  ',minli
      write(LERR,*)'Max LI asked for =  ',maxli
      write(LERR,*)'LI increment     =  ',lidel
      write(LERR,*)'Number of LIs    =  ',nli,' along side 2-3'
      write(LERR,*)'Min DI asked for =  ',mindi
      write(LERR,*)'Max DI asked for =  ',maxdi
      write(LERR,*)'DI increment     =  ',didel
      write(LERR,*)'Number of DIs    =  ',ndi,' along side 1-2'
      write(LERR,*)'XY scaler        =  ',xyscl
      write(LERR,*)'Time scaler      =  ',tscl
      if (RC)
     1write(LERR,*)'Use Line/Trace numbers out of horizon file'
      if (stk)
     1write(LERR,*)'Input is stacked volume'
      if (xsd) then
        write(LERR,*)'xsd pick file horizon input'
      elseif (usp) then
        write(LERR,*)'usp format horizon input'
      else
        write(LERR,*)'Landmark horizon input'
      endif
      if (smooth)
     1write(LERR,*)'median smoothing length = ',nf
      if (fit) then
      write(LERR,*)'Surface order     = ',iord
      write(LERR,*)'Number iterations = ',ilim
      write(LERR,*)'Fit type          = ',irtype
      write(LERR,*)'(1=robust; 0=least squares)'
      if ((smooth .or. fit) .and. diff)
     1write(LERR,*)'Use difference between input times & fitted or smoot
     2hed surface'
      endif
      write(LERR,*)'*********************************'
      write(LERR,*)' '

      heap = .true.
      item = nli * ndi
      call galloc (wktimes, item * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      if (smooth .or. fit) then
         if (smooth) then
            itemf = nf * nf
         else
            itemf = 1
         endif
         itemw = nli * ndi
      else
         itemf = 1
         itemw = 1
      endif
      call galloc (wkfilter, itemf * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      call galloc (wkwork  , itemw * SZSMPD, ierr, iab)
      if (ierr .ne. 0)  heap = .false.
      if (.not. heap) then
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item*SZSMPD,'  bytes'
         write(LER ,*) itemf*SZSMPD,'  bytes'
         write(LER ,*) itemw*SZSMPD,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item*SZSMPD,'  bytes'
         write(LER ,*) itemf*SZSMPD,'  bytes'
         write(LER ,*) itemw*SZSMPD,'  bytes'
      endif

c----
c   build matrix of times (nli by ndi) from the times read
c   from the pick file (that fall within the given coords)
c----
      call timmat (lupik, minli, maxli, mindi, maxdi, nli, ndi,
     1             IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2             DX, DY, times, xyscl, nsi, notrp, vverbos, xsd,
     3             QC, RC, verbos, lidel, didel, noedge, luqc,
     4             QCUSP, luusp, lbyout, itr, SZSMPD, SZTRHD,
     5             HSTOFF, SZHFWD, ITHWP1, smooth, fit, ftap, usp,
     6             ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     7             ifmt_RecNum,l_RecNum,ln_RecNum,tscl)

c----
c   modify time matrix by:
c   (1) fit robust or least squares surface to times, or
c   (2) do median smoothing of time matrix
c----
      if (smooth .OR. fit) then
         call timmod (nli, ndi, nf, filter, times, work, QC, diff,
     1                smooth, fit, iord, irtype, ilim, luqc,
     2                QCUSP, luusp, lbyout, itr, SZSMPD, SZTRHD,
     3                HSTOFF, SZHFWD, ITHWP1,
     4                ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     5                ifmt_RecNum,l_RecNum,ln_RecNum)
      endif

c----
c   we just want to see the time surfaces
c----
      IF (QC) THEN
         write(LER,*)' '
         write(LER,*)'End of tim2hed3d QC run: use plotxy to look at'
         write(LER,*)'surface files TIMHED1 & TIMHED2'
         go to 999
      ENDIF

      IF (QCUSP) THEN
         write(LER,*)' '
         write(LER,*)'End of tim2hed3d QCUSP run: USP format file'
         write(LER,*)'created in 2 records: rec1 unsmoothed;'
         write(LER,*)'                      rec2 smoothed'
         go to 999
      ENDIF
c----
c   read through data. find midpoint LI & DI for each trace. locate 
c   this on grid of times and stuff time into trace header word.
c----

      itot = 0
      itrc = 0
      irec = 1
      lc   = 0

      DO  while (1.eq.1)

          nbytes = 0
          call rtape (luin, itr, nbytes)
          if(nbytes .eq. 0) then
             write(LERR,*)'End of file on input:'
             write(LERR,*)'  rec= ',irec,'  trace= ',irec
             go to 999
          endif

          itrc = itrc + 1
          if (itrc .gt. ntrc) then
              itrc = 1
              irec = irec + 1
              if (verbos) then
              write(LERR,*)'Reading record ',irec
              write(LER ,*)'Reading record ',irec
              endif
          endif
          lc = lc + 1

          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                istatic  , TRACEHEADER)

          IF ( istatic .ne. 30000) THEN

             IWRN = 0

C *** CHOOSE RECNUM/TRCNUM or XYs

             IF ( RC ) THEN

             call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   ICDPX   , TRACEHEADER)
             call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                   ICDPY   , TRACEHEADER)
             CX = ICDPX
             CY = ICDPY
             ICLI = (CX - minli) / lidel + 1
             ICDI = (CY - mindi) / didel + 1
             IF (ICLI .LT.     1) IWRN = 1
             IF (ICLI .GT.   NLI) IWRN = 1
             IF (ICDI .LT.     1) IWRN = 1
             IF (ICDI .GT.   NDI) IWRN = 1

             ELSE

C *** GET SHOT COORDINATE                                               00004930
 
             call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                   ISX     , TRACEHEADER)
             call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                   ISY     , TRACEHEADER)
             SX = ISX
             SY = ISY
 
C *** GET RECEIVER COORDINATE                                           00004980
 
             call saver2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                   IRX     , TRACEHEADER)
             call saver2(itr,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                   IRY     , TRACEHEADER)
             RX = IRX
             RY = IRY
 
C *** COMPUTE THE CDP COORDINATE
             if (stk) then

                call saver2(itr,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                      ICDPX   , TRACEHEADER)
                call saver2(itr,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                      ICDPY   , TRACEHEADER)
             else
 
                ICDPX = 0.5 * float (ISX + IRX) + 0.5
                ICDPY = 0.5 * float (ISY + IRY) + 0.5

             endif

             CX = ICDPX
             CY = ICDPY
c----
c   if this trace within survey coords?
c   if so then stuff time into trace header
c----
             CALL XFMFWD (CX, CY, ICLI, ICDI, CXT, CYT, BXT, BYT, IWRN,
     1                    IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, YYT,
     2                    DX, DY, NDI, NLI)
             IF (ICLI .LT. MINLI) IWRN = 1
             IF (ICLI .GT. MAXLI) IWRN = 1
             IF (ICDI .LT. MINDI) IWRN = 1
             IF (ICDI .GT. MAXDI) IWRN = 1

             ENDIF

             IF (IWRN .EQ. 0) THEN

                if ( .not. RC ) then
                   jcl   = ICLI - minli
                   icd   = ICDI - mindi
                   ipntr = icd + jcl * ndi + 1
                else
                   jcl   = ICLI
                   icd   = ICDI
                   ipntr = icd + (jcl-1) * ndi
                endif
                tim   = times (ipntr )
                itim  = nint ( tim )
                itot  = itot + 1

                if (verbos) then
                write(LERR,*)'LI, DI, time= ',ICLI,ICDI,itim
                endif

                if (flt) then

                   call savew2(itr,ifmt_stawrd,l_stawrd, ln_stawrd,
     1                          tim    , TRACEHEADER)

                else

                   call savew2(itr,ifmt_stawrd,l_stawrd, ln_stawrd,
     1                         itim    , TRACEHEADER)
                endif

             ELSE

                if ( vverbos ) then
                ICX = CX
                ICY = CY
                write(LERR,777)ICLI,ICDI,ICX,ICY
777             format('LI/DI= ',2(i8,2x),
     1          ' bin center XY= ',2(i8,2x),' out of survey')
                endif

             ENDIF

          ENDIF

          call wrtape (luout, itr, nbytes)


      ENDDO

999   continue


      if (.not. QC .AND. .not. QCUSP) then
         write(LERR,*)'tim2hed3d completed processing ',irec,' records'
         write(LER ,*)'tim2hed3d completed processing ',irec,' records'
         write(LERR,*)'Found ',itot,' traces inside survey boundary'
         write(LER ,*)'Found ',itot,' traces inside survey boundary'
         call lbclos (luin)
         call lbclos (luout)
      endif

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for tim2hed3d: read flat'
        write(LER,*)'file of 3D workstation time picks keyed to XYs'
        write(LER,*)'and stuff them into input traces'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] (def = stdin) : input seismic data'
        write(LER,*)'-P[vtap] (def = none)  : workstation pick file'
        write(LER,*)'-O[otap] (def = stdout): output seismic data'
        write(LER,*)' '
        write(LER,*)
     :' -sw[stawrd]  (def = StaCor): trc hdr word to store times'
        write(LER,*)
     :'-flt                     : header word will be a float number'
        write(LER,*)
     :' -ts[tscl]    (def = 1.0) : time scale factor'
        write(LER,*)' '
        write(LER,*)'Use XY Coordinates'
        write(LER,*)'(and trace header src/rcv XYs or bin center XYs)'
        write(LER,*)
     :' -x1[x1]      (def = none)  : X-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -y1[y1]      (def = none)  : Y-coord of Corner 1 (N-E)'
        write(LER,*)
     :' -x2[x2]      (def = none)  : X-coord of Corner 2'
        write(LER,*)
     :' -y2[y2]      (def = none)  : Y-coord of Corner 2'
        write(LER,*)
     :' -x3[x3]      (def = none)  : X-coord of Corner 3'
        write(LER,*)
     :' -y3[y3]      (def = none)  : Y-coord of Corner 3'
        write(LER,*)
     :' -x4[x4]      (def = none)  : X-coord of Corner 4'
        write(LER,*)
     :' -y4[y4]      (def = none)  : Y-coord of Corner 4'
        write(LER,*)
     :' -ildm[ildm]  (def = none)  : spacing along 1-2 direction (dy)'
        write(LER,*)
     :' -cldm[cldm]  (def = none)  : spacing along 2-3 direction (dx)'

        write(LER,*)' '
        write(LER,*)'Use Line/Trace Number Coordinates'
        write(LER,*)'-RC        : use line/trc numbers from horz file'
        write(LER,*)'             and RecNum & TrcNum header values'
        write(LER,*)
     :' -limin[limin]  (def = 1)     : min LI to use'
        write(LER,*)
     :' -limax[limax]  (def = none)  : max LI to use'
        write(LER,*)
     :' -lidel[lidel]  (def = 1)     : LI numbering increment'
        write(LER,*)
     :' -dimin[dimin]  (def = 1)     : min DI to use'
        write(LER,*)
     :' -dimax[dimax]  (def = none)  : max DI to use'
        write(LER,*)
     :' -didel[didel]  (def = 1)     : DI numbering increment'
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)'-stk       : input data is stack volume - use'
        write(LER,*)'             CDPBCX & CDPBCY'
        write(LER,*)'-f2m       : scale XYs from feet to meters'
        write(LER,*)'-m2f       : scale XYs from meters to feet'
        write(LER,*)'             otherwise no XY scaling'
        write(LER,*)'-I         : turn off interpolation/extrapolation'
        write(LER,*)'-E         : interpolation out to edges'
        write(LER,*)' '
        write(LER,*)'-xsd       : XY-t is extended xsd header file'
        write(LER,*)'-usp       : XY-t is usp file (1 record)'
        write(LER,*)'             else, XY-t file is Landmark format'
        write(LER,*)' '
        write(LER,*)'-SM        : nf x nf point median smooth times'
        write(LER,*)
     :' -nf[nf]   (def = none)  : length of side of median smoother'
        write(LER,*)'-FT        : fit surface to times'
        write(LER,*)
     :' -ord[ord]  (def = none) : fix surf order; else compute it'
        write(LER,*)
     :' -iter[iter] (def = 5)   : number iterations for surf fit'
        write(LER,*)
     :' -ityp[ityp] (def = 1)   : 1=robust fit; 0=least squares'
        write(LER,*)'-DF        : use difference between input times and
     : fitted or smoothed surface'
        write(LER,*)'-QC        : output x,y,z file for plotxy & stop'
        write(LER,*)'-QCUSP     : output x,y,z usp fmt file & stop'
        write(LER,*)'-F[ftap] (def = TIMHED): QC file name (usp fmt)'
        write(LER,*)'-V         : verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   tim2hed3d -N[] -P[] -O[] -x1[] -y1[] -x2[]'
        write(LER,*)'     -y2[] -x3[] -y3[] -x4[] -y4[] -ildm[] -icdm[]'
        write(LER,*)'      [ -xsd -usp -I -E -QC -QCUSP]'
        write(LER,*)'      [ -DF -F[] -SM -nf[] ] [ -FT -ord[] -iter[]'
        write(LER,*)'      [ -ityp[]] -flt -ts[] -RC ]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of spikes
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,vtap,limin,limax,dimin,dimax,iend,
     1                 verbos,IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,DY,DX,
     2                 luin,lupik,luout,gecovel,bfilevel,xsd,stawrd,
     3                 f2m,m2f,notrp,stk,smooth,nf, QC, fit,iord,
     4                 irtype,ilim, diff,flt,
     4                 RC,vverbos,didel,lidel,noedge,QCUSP,ftap,usp,
     6                 tscl)

#include <f77/iounit.h>
      character  ntap*(*), otap*(*), vtap*(*), stawrd * 6, ftap*(*)
      integer    argis
      real       tscl
      integer    limin,limax,lidel,dimin,dimax,didel, iend
      logical    verbos,gecovel,bfilevel,f2m,m2f,notrp,xsd,stk,smooth
      logical    QC, QCUSP, fit, diff, flt, vverbos, RC, noedge, usp

         RC        = ( argis( '-RC' ) .gt. 0 )
         fit       = ( argis( '-FT' ) .gt. 0 )
         usp       = ( argis( '-usp' ) .gt. 0 )
         xsd       = ( argis( '-xsd' ) .gt. 0 )
         if (usp .AND. .not. RC) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d: -usp option'
            write(LERR,*)'Must have -RC flag on cmd line - see doc'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d: -usp option'
            write(LER ,*)'Must have -RC flag on cmd line - see doc'
            stop
         endif


         call argstr ('-N',ntap,' ',' ')
         call argstr ('-O',otap,' ',' ')
         call argstr ('-P',vtap,' ',' ')
         call argstr ('-F',ftap,' ',' ')
         call argstr ('-sw',stawrd,'StaCor','StaCor')

         IF (.not. usp) THEN
            call alloclun ( lupik )
            ln = lenth ( vtap )

            open (lupik,file = vtap(1:ln),status = 'old',iostat = ierr)
            if(ierr .ne. 0) then
               write(LER,*)'tim2hed3d: Could not open input pick file ',
     :              vtap
               write(LER,*)'Check permissions/spelling and rerun '
               write(LER,*)'FATAL'
               stop
            endif
         ENDIF

         call argi4 ('-x1', ix1, 0 , 0 )
         call argi4 ('-y1', iy1, 0 , 0 )
 
         call argi4 ('-x2', ix2, 0 , 0 )
         call argi4 ('-y2', iy2, 0 , 0 )
 
         call argi4 ('-x3', ix3, 0 , 0 )
         call argi4 ('-y3', iy3, 0 , 0 )
 
         call argi4 ('-x4', ix4, 0 , 0 )
         call argi4 ('-y4', iy4, 0 , 0 )
 
         call argr4 ('-cldm', dx, 0., 0.)
         call argr4 ('-ildm', dy, 0., 0.)
 
         if (.not. RC .AND. dx .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d:'
            write(LERR,*)'Must enter x-line cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d:'
            write(LER ,*)'Must enter x-line cell dimension -cldm[]'
            stop
         endif
 
         if (.not. RC .AND. dy .eq. 0.) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d:'
            write(LERR,*)'Must enter inline cell dimension -cldm[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d:'
            write(LER ,*)'Must enter inline cell dimension -ildm[]'
            stop
         endif
 
         IF ( .not. RC ) THEN
         if (ix1.eq.0 .AND. iy1.eq.0 .AND. ix2.eq.0 .AND. iy2.eq.0
     1   .AND.
     2       ix3.eq.0 .AND. iy3.eq.0 .AND. ix4.eq.0 .AND. iy4.eq.0)
     3   then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d:'
            write(LERR,*)'Must enter 4 corners of survey using -x1[]'
            write(LERR,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d:'
            write(LER ,*)'Must enter 4 corners of survey using -x1[]'
            write(LER ,*)'-y1[] -x2[] -y2[] -x3[] -y3[] -x4[] -y4[]'
            stop
         endif
         ENDIF

         call argi4 ('-dimin', dimin , 1 , 1 )
         call argi4 ('-dimax', dimax , 0 , 0 )
         call argi4 ('-didel', didel , 1 , 1 )
         call argi4 ('-limin', limin , 1 , 1 )
         call argi4 ('-limax', limax , 0 , 0 )
         call argi4 ('-lidel', lidel , 1 , 1 )

         call argr4 ('-ts', tscl , 1. , 1. )
         itscl = tscl
         tscl  = itscl

         smooth    = ( argis( '-SM' ) .gt. 0 )
         call argi4 ('-nf', nf, 1 , 1 )
         if (smooth .AND. nf .ge. 3) then
            if (mod(nf,2) .eq. 0) then
                nf = nf + 1
            endif
         elseif (smooth .AND. nf .lt. 3) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d:'
            write(LERR,*)'Must have smoothing length >= 3'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d:'
            write(LER ,*)'Must have smoothing length >= 3'
            stop
         endif

         call argi4 ('-ord' , iord, 0 , 0 )
         call argi4 ('-iter', ilim, 5 , 5 )
         call argi4 ('-ityp', irtype, 1 , 1 )

         if (fit .and. smooth) then
            write(LERR,*)' '
            write(LERR,*)'Fatal Error in tim2hed3d:'
            write(LERR,*)'Cannot have both -SM & -FT'
            write(LER ,*)' '
            write(LER ,*)'Fatal Error in tim2hed3d:'
            write(LER ,*)'Cannot have both -SM & -FT'
            stop
         endif

         noedge    = ( argis( '-E' ) .gt. 0 )
         flt       = ( argis( '-flt' ) .gt. 0 )
         diff      = ( argis( '-DF' ) .gt. 0 )
         QCUSP     = ( argis( '-QCUSP' ) .gt. 0 )
         QC        = ( argis( '-QC' ) .gt. 0 )
         stk       = ( argis( '-stk' ) .gt. 0 )
         f2m       = ( argis( '-f2m' ) .gt. 0 )
         m2f       = ( argis( '-m2f' ) .gt. 0 )
         gecovel   = ( argis( '-geco' ) .gt. 0 )
         bfilevel  = ( argis( '-bfile' ) .gt. 0 )
         notrp     = ( argis( '-I' ) .gt. 0 )
         vverbos   = ( argis( '-VV' ) .gt. 0 )
         verbos    = ( argis( '-V' ) .gt. 0 )

      return
      end
