/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#ifndef _Save_h
#define _Save_h

#include <save_defs.h>

/*

   An extra element in the structure has been added to
   indicate the length of character strings in the
   headers. This enables the retrieval of a character
   string on one pass instead of having to call once
   for each character. As a result, entries have been 
   added to the structure which point to multi-character
   strings available for retrieval or storage.

				- Joe M. Wade 10/27/89

   Extended this to all data types. I also made the 
   position entry relative to 0 offset rather than 1;
   that means that anybody who had snatched this file
   in the past to use in their own program had better
   modify their code accordingly. My regrets, but I have
   my reasons.
				- Joe M. Wade  2/18/92

   Took the previous C comment for each entry and made it a part of
   the structure. At the current time, this is for the benefit of xsd,
   although other programs may now take advantage of this.

				- Joe M. Wade 12/12/95
*/

/*
   NOTE:
	When you note the following acronyms in the comment of a particular
	field (which may be "overloaded"), it refers to this type of code...

		MBS - Migration Before Stack
		MC  - Multi-component
*/


/*						*/
/*	LINE/TRACE HEADER MASTER		*/
/*  {"string",	ind,	pos }.		*/
/*						*/
struct hdr {
	char	*str;	/* pattern string				*/
	int	ind;	/* type; see definitions in save_defs.h	     	*/
	int	pos;	/* position in array (relative to type)		*/
        int 	length; /* length of header variable (relative to type) */
	char	*comment; /* brief description of entry			*/
	}  ;
/*
#ifdef UNIX       - what? Cray isn't UNIX ??????
*/
#ifndef CRAYSYSTEM

static struct hdr lhdr[] = {
	/* line header  	*/
  {"EqpCod", SAVE_CHAR_DEF,    0,  1, " Equipment code		" },
  {"CrwNam", SAVE_CHAR_DEF,    1,  6, " Crew Six Characters		" },
  {"Crew01", SAVE_CHAR_DEF,    1,  1, " Crew Six Characters		" },
  {"Crew02", SAVE_CHAR_DEF,    2,  1, " Crew Six Characters		" },
  {"Crew03", SAVE_CHAR_DEF,    3,  1, " Crew Six Characters		" },
  {"Crew04", SAVE_CHAR_DEF,    4,  1, " Crew Six Characters		" },
  {"Crew05", SAVE_CHAR_DEF,    5,  1, " Crew Six Characters		" },
  {"Crew06", SAVE_CHAR_DEF,    6,  1, " Crew Six Characters		" },
  {"DatTyp", SAVE_CHAR_DEF,    7,  1, " Data Type			" },
  {"DgTrkS", SAVE_CHAR_DEF,    8,  2, " Digital Truck System		" },
  {"DgTrk1", SAVE_CHAR_DEF,    8,  1, " Digital Truck System		" },
  {"DgTrk2", SAVE_CHAR_DEF,    9,  1, " Digital Truck System		" },
  {"PrcNam", SAVE_CHAR_DEF,   10, 10, " Processor Name		" },
  {"PrNm01", SAVE_CHAR_DEF,   10,  1, " Processor Name		" },
  {"PrNm02", SAVE_CHAR_DEF,   11,  1, " Processor Name		" },
  {"PrNm03", SAVE_CHAR_DEF,   12,  1, " Processor Name		" },
  {"PrNm04", SAVE_CHAR_DEF,   13,  1, " Processor Name		" },
  {"PrNm05", SAVE_CHAR_DEF,   14,  1, " Processor Name		" },
  {"PrNm06", SAVE_CHAR_DEF,   15,  1, " Processor Name		" },
  {"PrNm07", SAVE_CHAR_DEF,   16,  1, " Processor Name		" },
  {"PrNm08", SAVE_CHAR_DEF,   17,  1, " Processor Name		" },
  {"PrNm09", SAVE_CHAR_DEF,   18,  1, " Processor Name		" },
  {"PrNm10", SAVE_CHAR_DEF,   19,  1, " Processor Name		" },
  {"PrcDat", SAVE_CHAR_DEF,   24,  8, " Processing Date		" },
  {"Date01", SAVE_CHAR_DEF,   24,  1, " Processing Date		" },
  {"Date02", SAVE_CHAR_DEF,   25,  1, " Processing Date		" },
  {"Date03", SAVE_CHAR_DEF,   26,  1, " Processing Date		" },
  {"Date04", SAVE_CHAR_DEF,   27,  1, " Processing Date		" },
  {"Date05", SAVE_CHAR_DEF,   28,  1, " Processing Date		" },
  {"Date06", SAVE_CHAR_DEF,   29,  1, " Processing Date		" },
  {"Date07", SAVE_CHAR_DEF,   30,  1, " Processing Date		" },
  {"Date08", SAVE_CHAR_DEF,   31,  1, " Processing Date		" },
  {"OACLin", SAVE_CHAR_DEF,   32,  8, " OAC Line 8 char 		" },
  {"OACL01", SAVE_CHAR_DEF,   32,  1, " OAC Line 7 char right just	" },
  {"OACL02", SAVE_CHAR_DEF,   33,  1, " OAC Line			" },
  {"OACL03", SAVE_CHAR_DEF,   34,  1, " OAC Line			" },
  {"OACL04", SAVE_CHAR_DEF,   35,  1, " OAC Line			" },
  {"OACL05", SAVE_CHAR_DEF,   36,  1, " OAC Line			" },
  {"OACL06", SAVE_CHAR_DEF,   37,  1, " OAC Line			" },
  {"OACL07", SAVE_CHAR_DEF,   38,  1, " OAC Line			" },
  {"OACL08", SAVE_CHAR_DEF,   39,  1, " OAC Line			" },
  {"JobNum", SAVE_CHAR_DEF,   40,  8, " JOB Number 			" },
  {"JOBN01", SAVE_CHAR_DEF,   40,  1, " JOB Number 7 char right just	" },
  {"JOBN02", SAVE_CHAR_DEF,   41,  1, " JOB Number 7 char right just	" },
  {"JOBN03", SAVE_CHAR_DEF,   42,  1, " JOB Number 7 char right just	" },
  {"JOBN04", SAVE_CHAR_DEF,   43,  1, " JOB Number 7 char right just	" },
  {"JOBN05", SAVE_CHAR_DEF,   44,  1, " JOB Number 7 char right just	" },
  {"JOBN06", SAVE_CHAR_DEF,   45,  1, " JOB Number 7 char right just	" },
  {"JOBN07", SAVE_CHAR_DEF,   46,  1, " JOB Number 7 char right just	" },
  {"JOBN08", SAVE_CHAR_DEF,   47,  1, " JOB Number 7 char right just	" },
  {"NumTrc", SAVE_LONG_DEF,   12,  1, " number traces per record	" },
  {"NumRec", SAVE_LONG_DEF,   13,  1, " number records per line	" },
  {"SmpInt", SAVE_LONG_DEF,   14,  1, " sample interval ms		" },
  {"NumSmp", SAVE_LONG_DEF,   15,  1, " number samples per trace	" },
  {"Format", SAVE_SHORT_DEF,  32,  1, " format code			" },
  {"IndAdj", SAVE_SHORT_DEF,  33,  1, " index adjustment		" },
  {"OpGrFl", SAVE_SHORT_DEF,  34,  1, " Opposite/Between Group Flag	" },
  {"SrtTyp", SAVE_CHAR_DEF,   72,  2, " Sort Type	0=FIFO 		" },
  {"SrTy01", SAVE_CHAR_DEF,   72,  1, "		2=max to min	" },
  {"SrTy02", SAVE_CHAR_DEF,   73,  1, "				" },
  {"CDPFld", SAVE_SHORT_DEF,  37,  1, " CDP Fold			" },
  {"GrpInt", SAVE_CHAR_DEF,   76,  4, " Group Inverval		" },
  {"GrpIn0", SAVE_CHAR_DEF,   76,  1, " Group Inverval		" },
  {"GrpIn1", SAVE_CHAR_DEF,   77,  1, " Group Inverval		" },
  {"GrpIn2", SAVE_CHAR_DEF,   78,  1, " Group Inverval		" },
  {"GrpIn3", SAVE_CHAR_DEF,   79,  1, " Group Inverval		" },
  {"DtInFl", SAVE_LONG_DEF,   20,  1, " Data Indicator Flag		" },
  {"Dy1000", SAVE_LONG_DEF,   20,  1, " Record Interval * 1000 (MBS) " },
  {"MxSPEl", SAVE_SHORT_DEF,  42,  1, " Max Source Point Elevation	" },
  {"MnSPEl", SAVE_SHORT_DEF,  43,  1, " Min Source Point Elevation	" },
  {"MxRSEL", SAVE_SHORT_DEF,  44,  1, " Max Ref Surface Elevation	" },
  {"MnRSEL", SAVE_SHORT_DEF,  45,  1, " Min Ref Surface Elevation	" },
  {"MxGrEl", SAVE_SHORT_DEF,  46,  1, " Maximum group Elevation	" },
  {"MnGrEl", SAVE_SHORT_DEF,  47,  1, " Minimum group Elevation	" },
  {"MxTrSt", SAVE_SHORT_DEF,  48,  1, " Maximum trace Static		" },
  {"MnTrSt", SAVE_SHORT_DEF,  49,  1, " Minimum trace Static		" },
  {"LinDir", SAVE_CHAR_DEF,  100,  4, " Line Direction e.g., N45E	" },
  {"LnDi01", SAVE_CHAR_DEF,  100,  1, " Line Direction e.g., N45E	" },
  {"LnDi02", SAVE_CHAR_DEF,  101,  1, " Line Direction e.g., N45E	" },
  {"LnDi03", SAVE_CHAR_DEF,  102,  1, " Line Direction e.g., N45E	" },
  {"LnDi04", SAVE_CHAR_DEF,  103,  1, " Line Direction e.g., N45E	" },
  {"AERcPr", SAVE_LONG_DEF,   26,  1, " Accumulative Est Rec Proc	" },
  {"OrNTRC", SAVE_SHORT_DEF,  54,  1, " Original traces Per Record	" },
  {"OrNREC", SAVE_SHORT_DEF,  55,  1, " Original Number records	" },
  {"MutVel", SAVE_FLOAT_DEF,  28,  1, " Muting Velocity		" },
  {"ZDMuTm", SAVE_SHORT_DEF,  58,  1, " Zero Distance Mutine Time	" },
  {"IntInc", SAVE_SHORT_DEF,  59,  1, " interpolation increment	" },
  {"WatVel", SAVE_LONG_DEF,   30,  1, " Water Velocity		" },
  {"RefVel", SAVE_LONG_DEF,   30,  1, " SLNT Reference Velocity(MBS) " },
  {"MxShDp", SAVE_SHORT_DEF,  62,  1, " Maximum Shot Depth		" },
  {"MnShDp", SAVE_SHORT_DEF,  63,  1, " Minimum Shot Depth		" },
  {"MxUHTm", SAVE_SHORT_DEF,  64,  1, " Maximum Uphole Time		" },
  {"MnUHTm", SAVE_SHORT_DEF,  65,  1, " Minimum Uphole Time		" },
  {"MxTrOf", SAVE_SHORT_DEF,  66,  1, " Maximum traverse Offset	" },
  {"MnTrOf", SAVE_SHORT_DEF,  67,  1, " Minimum traverse Offset	" },
  {"RATTrc", SAVE_SHORT_DEF,  68,  1, " RATS Traces per Record Entry	" },
  {"AnglSt", SAVE_SHORT_DEF,  68,  1, " SLNT Starting Angle    (MBS) " },
  {"RATFld", SAVE_SHORT_DEF,  69,  1, " RATS Fold Entry		" },
  {"AngInc", SAVE_SHORT_DEF,  69,  1, " SLNT Angle Increment   (MBS) " },
  {"UnitFl", SAVE_SHORT_DEF,  70,  1, " Units Flag 0=ft 1=m		" },
  {"FrstSP", SAVE_SHORT_DEF,  71,  1, " 1st SP Number on Line	" },
  {"DpN1SP", SAVE_SHORT_DEF,  72,  1, " Dep Pt Num Below 1st Src Pt	" },
  {"NmDpIn", SAVE_SHORT_DEF,  73,  1, " Num Dep Pt Int per Unit Inc	" },
  {"StWdFl", SAVE_SHORT_DEF,  74,  1, " Static Wd Flag 0=old >=1 new	" },
  {"DptInt", SAVE_SHORT_DEF,  75,  1, " Depth Point interval		" },
  {"TmMsSl", SAVE_LONG_DEF,   38,  1, " Time in ms of First Slice	" },
  {"Dx1000", SAVE_LONG_DEF,   38,  1, " Trace interval * 1000  (MBS) " },
  {"TmSlIn", SAVE_LONG_DEF,   39,  1, " Time Slice increment in ms	" },
  {"Dz1000", SAVE_LONG_DEF,   39,  1, " Depth Interval * 1000  (MBS) " },
  {"TmMsFS", SAVE_FLOAT_DEF,  40,  1, " Time in ms of First Sample	" },
  {"NTrLnS", SAVE_LONG_DEF,   41,  1, " Number Traces/Line Sorted In	" },
  {"PltDir", SAVE_SHORT_DEF,  84,  1, " Plot Direction		" },
  {"LgRfEl", SAVE_SHORT_DEF,  85,  1, " Log Reference Elevation	" },
  {"MnLnIn", SAVE_SHORT_DEF,  86,  1, " Minimum line Index		" },
  {"MxLnIn", SAVE_SHORT_DEF,  87,  1, " Maximum line Index		" },
  {"MnDpIn", SAVE_SHORT_DEF,  88,  1, " Minimum depth Index		" },
  {"MxDpIn", SAVE_SHORT_DEF,  89,  1, " Maximum depth Index		" },
  {"ILClIn", SAVE_FLOAT_DEF,  45,  1, " In Line Cell Increment	" },
  {"CLClIn", SAVE_FLOAT_DEF,  46,  1, " Cross Line Cell Increment	" },
  {"ReSpFm", SAVE_SHORT_DEF,  94,  1, " Reserved Special Format	" },
  {"VlFnRF", SAVE_SHORT_DEF,  95,  1, " Vel Func Ref Flag 0=RI 1=DI	" },
  {"OACUsr", SAVE_CHAR_DEF,  192,  4, " OAC USER Field		" },
  {"OACUF0", SAVE_CHAR_DEF,  192,  1, " OAC USER Field		" },
  {"OACUF1", SAVE_CHAR_DEF,  193,  1, " OAC USER Field		" },
  {"OACUF2", SAVE_CHAR_DEF,  194,  1, " OAC USER Field		" },
  {"OACUF3", SAVE_CHAR_DEF,  195,  1, " OAC USER Field		" },
  {"LinNam", SAVE_CHAR_DEF,  196,  8, " Line Name			" },
  {"LnNm00", SAVE_CHAR_DEF,  196,  1, " Line Name			" },
  {"LnNm01", SAVE_CHAR_DEF,  197,  1, " Line Name			" },
  {"LnNm02", SAVE_CHAR_DEF,  198,  1, " Line Name			" },
  {"LnNm03", SAVE_CHAR_DEF,  199,  1, " Line Name			" },
  {"LnNm04", SAVE_CHAR_DEF,  200,  1, " Line Name			" },
  {"LnNm05", SAVE_CHAR_DEF,  201,  1, " Line Name			" },
  {"LnNm06", SAVE_CHAR_DEF,  202,  1, " Line Name			" },
  {"LnNm07", SAVE_CHAR_DEF,  203,  1, " Line Name			" },
  {"MutFlg", SAVE_SHORT_DEF, 102,  1, " Mute Flag 0=yes 1=no		" },
  {"SPBias", SAVE_CHAR_DEF,  206,  2, " Shot point Bias 		" },
  {"SPBi00", SAVE_CHAR_DEF,  206,  1, " Shot point Bias 		" },
  {"SPBi01", SAVE_CHAR_DEF,  207,  1, " Shot point Bias 		" },
  {"SpBiFl", SAVE_SHORT_DEF, 104,  1, " Shot Point Bias Flag		" },
  {"APIWNo", SAVE_CHAR_DEF,  210, 12, " API Well Number		" },
  {"APIWN0", SAVE_CHAR_DEF,  210,  1, " API Well Number		" },
  {"APIWN1", SAVE_CHAR_DEF,  211,  1, " API Well Number		" },
  {"APIWN2", SAVE_CHAR_DEF,  212,  1, " API Well Number		" },
  {"APIWN3", SAVE_CHAR_DEF,  213,  1, " API Well Number		" },
  {"APIWN4", SAVE_CHAR_DEF,  214,  1, " API Well Number		" },
  {"APIWN5", SAVE_CHAR_DEF,  215,  1, " API Well Number		" },
  {"APIWN6", SAVE_CHAR_DEF,  216,  1, " API Well Number		" },
  {"APIWN7", SAVE_CHAR_DEF,  217,  1, " API Well Number		" },
  {"APIWN8", SAVE_CHAR_DEF,  218,  1, " API Well Number		" },
  {"APIWN9", SAVE_CHAR_DEF,  219,  1, " API Well Number		" },
  {"APIWNA", SAVE_CHAR_DEF,  220,  1, " API Well Number		" },
  {"APIWNB", SAVE_CHAR_DEF,  221,  1, " API Well Number		" },
/*
 * Unclaimed line-header space. Data within this unused area
 * ( bytes 223-224 ) are not translated when converted to Cray format.
 * Thus, the most likely use for this area would be to store 
 * ASCII character information.
 */
  {"NmSpMi", SAVE_FLOAT_DEF,  56,  1, " Number Shot points per Mile  " },
/*
 * More unclaimed line-header space. ( Bytes 229-600 ) These are also
 * not translated when converted to Cray format.
 */
  {"MinVel", SAVE_SHORT_DEF, 300,  1, " Minimum velocity       (MBS) " },
  {"MaxVel", SAVE_SHORT_DEF, 301,  1, " Maximum velocity       (MBS) " },
  {"Nx_Pad", SAVE_SHORT_DEF, 302,  1, " No of Padded Traces (in X)   " },
  {"Nx_Win", SAVE_SHORT_DEF, 303,  1, " No of Traces in Window (in X)" },
  {"Nx_Rec", SAVE_SHORT_DEF, 304,  1, " No of Windowed Records (in X)" },
  {"NxLine", SAVE_SHORT_DEF, 305,  1, " Number of Lines (in X)       " },
  {"Nx_Trc", SAVE_SHORT_DEF, 306,  1, " Number of Traces (in X)      " },
  {"Ny_Pad", SAVE_SHORT_DEF, 307,  1, " No of Padded Traces (in Y)   " },
  {"Ny_Win", SAVE_SHORT_DEF, 308,  1, " No of Traces in Window (in Y)" },
  {"Ny_Rec", SAVE_SHORT_DEF, 309,  1, " No of Windowed Records (in Y)" },
  {"NyLine", SAVE_SHORT_DEF, 310,  1, " Number of Lines (in Y)       " },
  {"Ny_Trc", SAVE_SHORT_DEF, 311,  1, " Number of Traces (in Y)      " },
  {"MCTrSp", SAVE_SHORT_DEF, 312,  1, " Multicomponent trace spacing (MC) " },
  {"NumCmp", SAVE_SHORT_DEF, 313,  1, " Number of Components (MC) " },
  {"MCList", SAVE_SHORT_DEF, 314, 16, " Comp. List (10*Src+Rec) (MC) " },
  {"MCLE01", SAVE_SHORT_DEF, 314,  1, " Component (MC) " },
  {"MCLE02", SAVE_SHORT_DEF, 315,  1, " Component (MC) " },
  {"MCLE03", SAVE_SHORT_DEF, 316,  1, " Component (MC) " },
  {"MCLE04", SAVE_SHORT_DEF, 317,  1, " Component (MC) " },
  {"MCLE05", SAVE_SHORT_DEF, 318,  1, " Component (MC) " },
  {"MCLE06", SAVE_SHORT_DEF, 319,  1, " Component (MC) " },
  {"MCLE07", SAVE_SHORT_DEF, 320,  1, " Component (MC) " },
  {"MCLE08", SAVE_SHORT_DEF, 321,  1, " Component (MC) " },
  {"MCLE09", SAVE_SHORT_DEF, 322,  1, " Component (MC) " },
  {"MCLE10", SAVE_SHORT_DEF, 323,  1, " Component (MC) " },
  {"MCLE11", SAVE_SHORT_DEF, 324,  1, " Component (MC) " },
  {"MCLE12", SAVE_SHORT_DEF, 325,  1, " Component (MC) " },
  {"MCLE13", SAVE_SHORT_DEF, 326,  1, " Component (MC) " },
  {"MCLE14", SAVE_SHORT_DEF, 327,  1, " Component (MC) " },
  {"MCLE15", SAVE_SHORT_DEF, 328,  1, " Component (MC) " },
  {"MCLE16", SAVE_SHORT_DEF, 329,  1, " Component (max 16 in list) (MC) " },
/*
 * Left a little hole here in case we need some more for MC stuff
 */
  {"OrNSMP", SAVE_SHORT_DEF, 340,  1, " Original Number of Samples/Trace " },
  {"AziIln", SAVE_FKFLT_DEF, 341,  1, " In-Line Azimuth      	" },
  {"      ", SAVE_DUMMY_DEF, 342,  1, " ..continued in-line azimuth  " },
  {"AziXln", SAVE_FKFLT_DEF, 343,  1, " Cross-Line Azimuth 		" },
  {"      ", SAVE_DUMMY_DEF, 344,  1, " ..continued x-line azimuth   " },
  {"HrzNul", SAVE_FKFLT_DEF, 345,  1, " Null Horizon Flag Value      " },
  {"      ", SAVE_DUMMY_DEF, 346,  1, " ..continued HrzNul           " },
  {"T_Unit", SAVE_SHORT_DEF, 347,  1, " Time Units (0=ms, 1=micro-sec" },
  {"UnitSc", SAVE_FKFLT_DEF, 348,  1, " Smp Units Multiplier 1.==secs" },
  {"      ", SAVE_DUMMY_DEF, 349,  1, " ..continued UnitSc           " },
  {"SmpFlt", SAVE_FKFLT_DEF, 350,  1, " Flt Pt Sample Interval       " },
  {"      ", SAVE_DUMMY_DEF, 351,  1, " ..continued SmpFlt           " },
  {"MaxAmp", SAVE_FKFLT_DEF, 352,  1, " Maximum Absolute Amplitude   " },
  {"      ", SAVE_DUMMY_DEF, 353,  1, " ..continued MaxAmp           " },
  {"AvgAmp", SAVE_FKFLT_DEF, 354,  1, " Average Absolute Amplitude   " },
  {"      ", SAVE_DUMMY_DEF, 355,  1, " ..continued AvgAmp           " },
  {"RmsAmp", SAVE_FKFLT_DEF, 356,  1, " RMS Absolute Amplitude       " },
  {"      ", SAVE_DUMMY_DEF, 357,  1, " ..continued RmsAmp           " },
  {"VelTyp", SAVE_SHORT_DEF, 358,  1, " Velocity Type (0=RMS, 1=Avg, 2=Int, 3=Inst" },
  {"WlfCol", SAVE_SHORT_DEF, 359,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBas", SAVE_SHORT_DEF, 360,  1, " Wavelet Basis" },
  {"WavMom", SAVE_SHORT_DEF, 361,  1, " Wavelet Moment" },
  {"WlfCo1", SAVE_SHORT_DEF, 362,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBa1", SAVE_SHORT_DEF, 363,  1, " Wavelet Basis" },
  {"WavMo1", SAVE_SHORT_DEF, 364,  1, " Wavelet Moment" },
  {"WlfCo2", SAVE_SHORT_DEF, 365,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBa2", SAVE_SHORT_DEF, 366,  1, " Wavelet Basis" },
  {"WavMo2", SAVE_SHORT_DEF, 367,  1, " Wavelet Moment" },
  {"FreQst", SAVE_FKFLT_DEF, 368,  1, " Frequency Start" },
  {"      ", SAVE_DUMMY_DEF, 369,  1, " Frequency Start (cont)" },
  {"FreQnd", SAVE_FKFLT_DEF, 370,  1, " Frequency End" },
  {"      ", SAVE_DUMMY_DEF, 371,  1, " Frequency End (cont)" },

/*
 * Unclaimed line-header space. The old "velocity information" block
 * of the line header began at byte 601 and extended to byte 1000.
 * Data in this area are converted in Cray format as short integers.
 */
  {"HlhEnt", SAVE_SHORT_DEF, 500,  1, " Number of Entries in HLH	" },
  {"HlhByt", SAVE_SHORT_DEF, 501,  1, " Number of Bytes in HLH	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;


	
	/* trace header		*/
static struct hdr thdr[] = {
  {"SGRNum", SAVE_SHORT_DEF,   0,  1, " SGR number			" },
  {"SGRAmp", SAVE_SHORT_DEF,   1,  1, " SGR PreAmp Gain, Filter	" },
  {"SGRDat", SAVE_LONG_DEF,    1,  1, " SGR Julian Date Recorded	" },
  {"FlReFN", SAVE_SHORT_DEF,   4,  1, " Field Record File Number	" },
  {"FlStNm", SAVE_SHORT_DEF,   5,  1, " Field Station Number		" },
  {"PREPIn", SAVE_SHORT_DEF,   6,  1, " PREP Initiation Static .25ms	" },
  {"InStUn", SAVE_SHORT_DEF,   7,  1, " Initiation Static Unapplied	" },
  {"InStAp", SAVE_SHORT_DEF,   8,  1, " Initiation Static Applied	" },
  {"PREPRc", SAVE_SHORT_DEF,   9,  1, " PREP Reception Static .25ms	" },
  {"RcStUn", SAVE_SHORT_DEF,  10,  1, " Reception Static Unapplied	" },
  {"RcStAp", SAVE_SHORT_DEF,  11,  1, " Reception Static Applied	" },
  {"ToStAp", SAVE_SHORT_DEF,  12,  1, " Total Static Applied 	" },
  {"ToTmAA", SAVE_SHORT_DEF,  13,  1, " Total Timing Adjust Applied	" },
  {"ToStUn", SAVE_SHORT_DEF,  14,  1, " Total Static Unapplied 	" },
  {"ToTmAU", SAVE_SHORT_DEF,  15,  1, " Total Timing Adjust Unapplied " },
					/* all ten above are .25ms units */
  {"SrComp", SAVE_SHORT_DEF,  16,  1, " Source Component Number (MC) " },
  {"RcComp", SAVE_SHORT_DEF,  17,  1, " Receiver Component Number (MC) " },
  {"TrHdID", SAVE_SHORT_DEF,  20,  1, " Trace Header Identifier	" },
  {"SrRcAz", SAVE_SHORT_DEF,  21,  1, " Source-to-Receiver Azimuth	" },
  {"SrPtXC", SAVE_LONG_DEF,   11,  1, " Src Point X-Coordinate 3D	" },
  {"SrPtYC", SAVE_LONG_DEF,   12,  1, " Src Point Y-Coordinate 3D	" },
  {"RcPtXC", SAVE_LONG_DEF,   13,  1, " Rec Point X-Coordinate 3D	" },
  {"RcPtYC", SAVE_LONG_DEF,   14,  1, " Rec Point Y-Coordinate 3D	" },
  {"SrRcMX", SAVE_LONG_DEF,   15,  1, " Src Rec Midpoint X 3D	" },
  {"SrRcMY", SAVE_LONG_DEF,   16,  1, " Src Rec Midpoint Y 3D	" },
  {"CDPBCX", SAVE_LONG_DEF,   17,  1, " CDP Bin Center X Coordinate	" },
                            /* also used by lm3dvtosis for real world x */
  {"CDPBCY", SAVE_LONG_DEF,   18,  1, " CDP Bin Center Y Coordinate	" },
                            /* also used by lm3dvtosis for real world Y */
  {"InTrCn", SAVE_LONG_DEF,   19,  1, " Incremental Trace Counter	" },
  {"FlDtEl", SAVE_SHORT_DEF,  40,  1, " Floating Datum Elev this CDP	" },
  {"MulSkw", SAVE_SHORT_DEF,  41,  1, " Multiplex Skew (ms*1000)	" },
  {"PerSPO", SAVE_SHORT_DEF,  42,  1, " Perpendicular Src Pt Off y	" },
  {"InlSPO", SAVE_SHORT_DEF,  43,  1, " Inline Src Pt Off x		" },
  {"SrXAzm", SAVE_SHORT_DEF,  44,  1, " Source X Azimuth (*10)  (MC) " },
  {"TiLiI1", SAVE_SHORT_DEF,  44,  1, " Tie Line Indicator 1		" },
  {"SrYRot", SAVE_SHORT_DEF,  45,  1, " Source Y Rotation (*10) (MC) " },
  {"TiLiI2", SAVE_SHORT_DEF,  45,  1, " Tie Line Indicator 2		" },
  {"SrZRot", SAVE_SHORT_DEF,  46,  1, " Source Z Rotation (*10) (MC) " },
  {"TiLiI3", SAVE_SHORT_DEF,  46,  1, " Tie Line Indicator 3		" },
  {"RcXAzm", SAVE_SHORT_DEF,  47,  1, " Receiver X Azimuth (*10)(MC) " },
  {"TiLiI4", SAVE_SHORT_DEF,  47,  1, " Tie Line Indicator 4		" },
  {"RcYRot", SAVE_SHORT_DEF,  48,  1, " Receiver Y Rotation (*10)(MC)" },
  {"TiLiI5", SAVE_SHORT_DEF,  48,  1, " Tie Line Indicator 5		" },
  {"RcZRot", SAVE_SHORT_DEF,  49,  1, " Receiver Z Rotation (*10)(MC)" },
  {"TiLiI6", SAVE_SHORT_DEF,  49,  1, " Tie Line Indicator 6		" },
  {"TVPT01", SAVE_SHORT_DEF,  50,  1, " Time of Time-Vel Pair	" },
  {"Horz01", SAVE_FKFLT_DEF,  50,  1, " Horizon #1                   " },
  {"TVPV01", SAVE_SHORT_DEF,  51,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT02", SAVE_SHORT_DEF,  52,  1, " Time of Time-Vel Pair	" },
  {"Horz02", SAVE_FKFLT_DEF,  52,  1, " Horizon #2                   " },
  {"TVPV02", SAVE_SHORT_DEF,  53,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT03", SAVE_SHORT_DEF,  54,  1, " Time of Time-Vel Pair	" },
  {"Horz03", SAVE_FKFLT_DEF,  54,  1, " Horizon #3                   " },
  {"TVPV03", SAVE_SHORT_DEF,  55,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT04", SAVE_SHORT_DEF,  56,  1, " Time of Time-Vel Pair	" },
  {"Horz04", SAVE_FKFLT_DEF,  56,  1, " Horizon #4                   " },
  {"TVPV04", SAVE_SHORT_DEF,  57,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT05", SAVE_SHORT_DEF,  58,  1, " Time of Time-Vel Pair	" },
  {"Horz05", SAVE_FKFLT_DEF,  58,  1, " Horizon #5                   " },
  {"TVPV05", SAVE_SHORT_DEF,  59,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT06", SAVE_SHORT_DEF,  60,  1, " Time of Time-Vel Pair	" },
  {"Horz06", SAVE_FKFLT_DEF,  60,  1, " Horizon #6                   " },
  {"TVPV06", SAVE_SHORT_DEF,  61,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT07", SAVE_SHORT_DEF,  62,  1, " Time of Time-Vel Pair	" },
  {"Horz07", SAVE_FKFLT_DEF,  62,  1, " Horizon #7                   " },
  {"TVPV07", SAVE_SHORT_DEF,  63,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT08", SAVE_SHORT_DEF,  64,  1, " Time of Time-Vel Pair	" },
  {"Horz08", SAVE_FKFLT_DEF,  64,  1, " Horizon #8                   " },
  {"TVPV08", SAVE_SHORT_DEF,  65,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT09", SAVE_SHORT_DEF,  66,  1, " Time of Time-Vel Pair	" },
  {"TVPV09", SAVE_SHORT_DEF,  67,  1, " Velocity of Time-Vel Pair	" },
  {"AvDaSt", SAVE_SHORT_DEF,  67,  1, " Avg CDP datum static in ms." },
  {"TVPT10", SAVE_SHORT_DEF,  68,  1, " Time of Time-Vel Pair	" },
  {"TrSrSt", SAVE_SHORT_DEF,  68,  1, " Trace surface static in ms." },
  {"TVPV10", SAVE_SHORT_DEF,  69,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT11", SAVE_SHORT_DEF,  70,  1, " Time of Time-Vel Pair	" },
  {"TVPV11", SAVE_SHORT_DEF,  71,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT12", SAVE_SHORT_DEF,  72,  1, " Time of Time-Vel Pair	" },
  {"TVPV12", SAVE_SHORT_DEF,  73,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT13", SAVE_SHORT_DEF,  74,  1, " Time of Time-Vel Pair	" },
  {"TVPV13", SAVE_SHORT_DEF,  75,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT14", SAVE_SHORT_DEF,  76,  1, " Time of Time-Vel Pair	" },
  {"TVPV14", SAVE_SHORT_DEF,  77,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT15", SAVE_SHORT_DEF,  78,  1, " Time of Time-Vel Pair	" },
  {"TVPV15", SAVE_SHORT_DEF,  79,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT16", SAVE_SHORT_DEF,  80,  1, " Time of Time-Vel Pair	" },
  {"TVPV16", SAVE_SHORT_DEF,  81,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT17", SAVE_SHORT_DEF,  82,  1, " Time of Time-Vel Pair	" },
  {"TVPV17", SAVE_SHORT_DEF,  83,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT18", SAVE_SHORT_DEF,  84,  1, " Time of Time-Vel Pair	" },
  {"TVPV18", SAVE_SHORT_DEF,  85,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT19", SAVE_SHORT_DEF,  86,  1, " Time of Time-Vel Pair	" },
  {"TVPV19", SAVE_SHORT_DEF,  87,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT20", SAVE_SHORT_DEF,  88,  1, " Time of Time-Vel Pair	" },
  {"TVPV20", SAVE_SHORT_DEF,  89,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT21", SAVE_SHORT_DEF,  90,  1, " Time of Time-Vel Pair	" },
  {"TVPV21", SAVE_SHORT_DEF,  91,  1, " Velocity of Time-Vel Pair	" },
  {"RedVel", SAVE_SHORT_DEF,  90,  1, " Reduction Velocity for vred	" },
  {"RedTim", SAVE_SHORT_DEF,  91,  1, " Time of first sample for vred " },
  {"VPick1", SAVE_SHORT_DEF,  92,  1, " Auto Static Pick 1		" },
  {"VPick2", SAVE_SHORT_DEF,  93,  1, " Auto Static Pick 2		" },
  {"LRcCDP", SAVE_SHORT_DEF,  94,  1, " Last Record CDP		" },
  {"CabDep", SAVE_SHORT_DEF,  95,  1, " Cable Depth			" },
  {"WDepDP", SAVE_SHORT_DEF,  96,  1, " Water Depth Above Depth Point " },
  {"DPOPer", SAVE_SHORT_DEF,  97,  1, " Depth Point Offset Perpendic	" },
  {"ShtDep", SAVE_SHORT_DEF,  98,  1, " shot depth			" },
  {"UphlTm", SAVE_SHORT_DEF,  99,  1, " uphole time in ms		" },
  {"DpPtLt", SAVE_LONG_DEF,   50,  1, " depth pt lat (deg* 10^5)	" },
  {"DpPtLn", SAVE_LONG_DEF,   51,  1, " depth pt lon (deg* 10^5)	" },
  {"FoldNm", SAVE_SHORT_DEF, 104,  1, " fold				" },
  {"RecNum", SAVE_SHORT_DEF, 105,  1, " record number		" },
  {"TrcNum", SAVE_SHORT_DEF, 106,  1, " trace number			" },
  {"SrcPnt", SAVE_SHORT_DEF, 107,  1, " src point above this depth pt " },
  {"SrcLoc", SAVE_SHORT_DEF, 108,  1, " src location ind mult by 10	" },
  {"PrRcNm", SAVE_SHORT_DEF, 109,  1, " permanent record number PRI	" },
  {"PrTrNm", SAVE_SHORT_DEF, 110,  1, " permanent trace number  PTI	" },
  {"SrPtEl", SAVE_SHORT_DEF, 111,  1, " source point elevation	" },
  {"SrPrLt", SAVE_LONG_DEF,   56,  1, " source point lat (deg* 10^5)	" },
  {"SrPrLn", SAVE_LONG_DEF,   57,  1, " source point lon (deg* 10^5)	" },
  {"DstUsg", SAVE_SHORT_DEF, 116,  1, " unsigned trace distance	" },
  {"RecInd", SAVE_SHORT_DEF, 117,  1, " rec location index	GI	" },
  {"DstSgn", SAVE_SHORT_DEF, 118,  1, " signed trace distance	" },
  {"GrpElv", SAVE_SHORT_DEF, 119,  1, " group elevation		" },
  {"LinInd", SAVE_SHORT_DEF, 120,  1, " line index 3D		" },
  {"DphInd", SAVE_SHORT_DEF, 121,  1, " depth index			" },
  {"DePtEl", SAVE_SHORT_DEF, 122,  1, " depth point elevation	" },
  {"RfSrEl", SAVE_SHORT_DEF, 123,  1, " reference surface elevation	" },
  {"StaCor", SAVE_SHORT_DEF, 124,  1, " correction			" },
  {"DatShf", SAVE_SHORT_DEF, 125,  1, " datum shift			" },
  {"SoPtNm", SAVE_SHORT_DEF, 126,  1, " source point number		" },
  {"SoPtAl", SAVE_CHAR_DEF,  254,  1, " source point alphabetic sufix " },
  {"SoPtBi", SAVE_CHAR_DEF,  255,  1, " source point bias /10000	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;

	/* vanl analysis header		*/
static struct hdr vnlhdr[] = {
  {"CDPNum", SAVE_LONG_DEF,    0,  1, " RI(CDP) Number of this anal. " },
  {"LinNum", SAVE_CHAR_DEF,    4,  4, " Line Number			" },
  {"CohRec", SAVE_LONG_DEF,    2,  1, " # of coherence records       " },
  {"FstCoh", SAVE_LONG_DEF,    3,  1, " number of 1st coherence samp " },
  {"NumCoh", SAVE_LONG_DEF,    4,  1, " # of coherence values/record " },
  {"VelPrs", SAVE_LONG_DEF,    5,  1, " # of v,delta-v pairs in hdr  " },
  {"RsmpIn", SAVE_LONG_DEF,    6,  1, " resampling increment used	" },
  {"SmpInt", SAVE_LONG_DEF,    7,  1, " coherence sample interval(ms)" },
  {"StFlag", SAVE_SHORT_DEF,  16,  1, " statics application flag 	" },
					/*	0=reg. ref.		*/
					/*	1=No statics		*/
					/*	2=Mean ground		*/
  {"PanWid", SAVE_SHORT_DEF,  17,  1, " panel width in CDPs		" },
  {"AvPnSt", SAVE_SHORT_DEF,  18,  1, " average panel statics in ms. " },
  {"RfSfEl", SAVE_SHORT_DEF,  19,  1, " reference surface elevation  " },
  {"SrcPNm", SAVE_LONG_DEF,   10,  1, " source point number 		" },
  {"LinInd", SAVE_SHORT_DEF,  22,  1, " line index			" },
  {"CDPFld", SAVE_SHORT_DEF,  23,  1, " fold				" },
  {"NStkTr", SAVE_SHORT_DEF,  24,  1, " # stacked traces in analysis " },
  {"DphInd", SAVE_SHORT_DEF,  25,  1, " depth index			" },
  {"WDepDP", SAVE_SHORT_DEF,  26,  1, " water depth above depth point " },
  {"WatVel", SAVE_SHORT_DEF,  27,  1, " water velocity		" },
  {"OACCod", SAVE_CHAR_DEF,   56,  4, " OAC code			" },
  {"SoPtBi", SAVE_SHORT_DEF,  30,  1, " source point bias		" },
  {"EMFlag", SAVE_SHORT_DEF,  30,  1, " english/metric flag		" },
  {"LevNum", SAVE_SHORT_DEF,  31,  1, " VANL tape level number	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;

static struct hdr vspn_hdr[] = {
  {"RecLng", SAVE_SHORT_DEF,   0,  1, " Record length in bytes	" },
  {"LevNum", SAVE_SHORT_DEF,   1,  1, " VSPN tape level number-unused " },
  {"FFDLat", SAVE_SHORT_DEF,   2,  1, " 1st four digits of Latitude  " },
  {"LFDLat", SAVE_SHORT_DEF,   3,  1, " Last four digits of Latitude " },
  {"FFDLon", SAVE_SHORT_DEF,   4,  1, " 1st four digits of Longitude " },
  {"LFDLon", SAVE_SHORT_DEF,   5,  1, " Last four digits of Longitude " },
  {"AVFNum", SAVE_LONG_DEF,    3,  1, " Archival Vel. File number	" },
  {"OACCod", SAVE_CHAR_DEF,   16,  3, " OAC code			" },
  {"OAVFNm", SAVE_LONG_DEF,    5,  1, " OAVF number			" },
  {"DatSrc", SAVE_CHAR_DEF,   24,  1, " Data Source			" },
  {"MthCmp", SAVE_CHAR_DEF,   25,  1, " Method of Computation        " },
  {"TmLsEn", SAVE_SHORT_DEF,  13,  1, " Time Last Entry for Well Func " },
  {"LinCod", SAVE_SHORT_DEF,  13,  1, " Line Code for Reflection Func " },
  {"MonDay", SAVE_SHORT_DEF,  14,  1, " Month & Day in integer form	" },
  {"Year  ", SAVE_SHORT_DEF,  15,  1, " Year in integer form		" },
  {"CDPNum", SAVE_SHORT_DEF,  16,  1, " RI(CDP) Number of this anal. " },
  {"MaxDst", SAVE_SHORT_DEF,  17,  1, " Maximum Distance		" },
  {"DirSht", SAVE_SHORT_DEF,  18,  1, " Direction of Shooting	" },
  {"CDPFld", SAVE_SHORT_DEF,  19,  1, " fold				" },
  {"PanWid", SAVE_SHORT_DEF,  20,  1, " panel width in CDPs		" },
  {"WinLng", SAVE_SHORT_DEF,  21,  1, " Window Length ( in ms )	" },
  {"SrfElv", SAVE_SHORT_DEF,  22,  1, " Surface Elevation		" },
  {"RgRSEL", SAVE_SHORT_DEF,  23,  1, " Regional Ref Surface Elev	" },
  {"TCRfSf", SAVE_SHORT_DEF,  24,  1, " Time Corr to Ref Surface	" },
  {"VelSbW", SAVE_SHORT_DEF,  25,  1, " Velocity of Subweathering	" },
  {"VelPrs", SAVE_SHORT_DEF,  26,  1, " # of time,velocity pairs 	" },
  {"HrzPrs", SAVE_SHORT_DEF,  27,  1, " # of seismic horizon,time prs " },
  {"ICNByt", SAVE_SHORT_DEF,  28,  1, " # of bytes in int. comments	" },
  {"WatDep", SAVE_SHORT_DEF,  29,  1, " Water Depth 			" },
  {"DivCod", SAVE_SHORT_DEF,  30,  1, " Division Code		" },
  {"StNoAr", SAVE_SHORT_DEF,  31,  1, " Strat. Nomenclature Area	" },
  {"HstOAC", SAVE_CHAR_DEF,   64,  3, " Historical OAC		" },
  {"SrcPnt", SAVE_LONG_DEF,   17,  1, " Source Point			" },
  {"SoPtAl", SAVE_CHAR_DEF,   72,  1, " Source Point Alpha		" },
  {"LinNum", SAVE_CHAR_DEF,   73,  5, " Line Number			" },
  {"DrSht1", SAVE_CHAR_DEF,   78,  1, " Direction of Shooting	" },
  {"DrSht2", SAVE_CHAR_DEF,   80,  1, " Direction of Shooting	" },
  {"RelFlg", SAVE_CHAR_DEF,   82,  1, " Reliablity			" },
  {"RlAlFg", SAVE_CHAR_DEF,   83,  1, " Reliablity Alpha Flag	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;

#endif

/*
#ifdef CSOS
*/
#ifdef CRAYSYSTEM

static struct hdr lhdr[] = {
	/* line header  	*/
  {"EqpCod", SAVE_CHAR_DEF,    0,  1, " Equipment code		" },
  {"CrwNam", SAVE_CHAR_DEF,    8,  6, " Crew Six Characters		" },
  {"Crew01", SAVE_CHAR_DEF,    8,  1, " Crew Six Characters		" },
  {"Crew02", SAVE_CHAR_DEF,    9,  1, " Crew Six Characters		" },
  {"Crew03", SAVE_CHAR_DEF,   10,  1, " Crew Six Characters		" },
  {"Crew04", SAVE_CHAR_DEF,   11,  1, " Crew Six Characters		" },
  {"Crew05", SAVE_CHAR_DEF,   12,  1, " Crew Six Characters		" },
  {"Crew06", SAVE_CHAR_DEF,   13,  1, " Crew Six Characters		" },
  {"DatTyp", SAVE_CHAR_DEF,   16,  1, " Data Type			" },
  {"DgTrkS", SAVE_CHAR_DEF,   24,  2, " Digital Truck System		" },
  {"DgTrk1", SAVE_CHAR_DEF,   24,  1, " Digital Truck System		" },
  {"DgTrk2", SAVE_CHAR_DEF,   25,  1, " Digital Truck System		" },
  {"PrcNam", SAVE_CHAR_DEF,   32, 10, " Processor Name		" },
  {"PrNm01", SAVE_CHAR_DEF,   32,  1, " Processor Name		" },
  {"PrNm02", SAVE_CHAR_DEF,   33,  1, " Processor Name		" },
  {"PrNm03", SAVE_CHAR_DEF,   34,  1, " Processor Name		" },
  {"PrNm04", SAVE_CHAR_DEF,   35,  1, " Processor Name		" },
  {"PrNm05", SAVE_CHAR_DEF,   36,  1, " Processor Name		" },
  {"PrNm06", SAVE_CHAR_DEF,   37,  1, " Processor Name		" },
  {"PrNm07", SAVE_CHAR_DEF,   38,  1, " Processor Name		" },
  {"PrNm08", SAVE_CHAR_DEF,   39,  1, " Processor Name		" },
  {"PrNm09", SAVE_CHAR_DEF,   40,  1, " Processor Name		" },
  {"PrNm10", SAVE_CHAR_DEF,   41,  1, " Processor Name		" },
  {"PrcDat", SAVE_CHAR_DEF,   56,  8, " Processing Date		" },
  {"Date01", SAVE_CHAR_DEF,   56,  1, " Processing Date		" },
  {"Date02", SAVE_CHAR_DEF,   57,  1, " Processing Date		" },
  {"Date03", SAVE_CHAR_DEF,   58,  1, " Processing Date		" },
  {"Date04", SAVE_CHAR_DEF,   59,  1, " Processing Date		" },
  {"Date05", SAVE_CHAR_DEF,   60,  1, " Processing Date		" },
  {"Date06", SAVE_CHAR_DEF,   61,  1, " Processing Date		" },
  {"Date07", SAVE_CHAR_DEF,   62,  1, " Processing Date		" },
  {"Date08", SAVE_CHAR_DEF,   63,  1, " Processing Date		" },
  {"OACLin", SAVE_CHAR_DEF,   64,  8, " OAC Line 			" },
  {"OACL01", SAVE_CHAR_DEF,   64,  1, " OAC Line 7 char right just	" },
  {"OACL02", SAVE_CHAR_DEF,   65,  1, " OAC Line			" },
  {"OACL03", SAVE_CHAR_DEF,   66,  1, " OAC Line			" },
  {"OACL04", SAVE_CHAR_DEF,   67,  1, " OAC Line			" },
  {"OACL05", SAVE_CHAR_DEF,   68,  1, " OAC Line			" },
  {"OACL06", SAVE_CHAR_DEF,   69,  1, " OAC Line			" },
  {"OACL07", SAVE_CHAR_DEF,   70,  1, " OAC Line			" },
  {"OACL08", SAVE_CHAR_DEF,   71,  1, " OAC Line			" },
  {"JobNum", SAVE_CHAR_DEF,   72,  8, " JOB Number 7 char right just " },
  {"JOBN01", SAVE_CHAR_DEF,   72,  1, " JOB Number 7 char right just " },
  {"JOBN02", SAVE_CHAR_DEF,   73,  1, " JOB Number 7 char right just " },
  {"JOBN03", SAVE_CHAR_DEF,   74,  1, " JOB Number 7 char right just " },
  {"JOBN04", SAVE_CHAR_DEF,   75,  1, " JOB Number 7 char right just " },
  {"JOBN05", SAVE_CHAR_DEF,   76,  1, " JOB Number 7 char right just " },
  {"JOBN06", SAVE_CHAR_DEF,   77,  1, " JOB Number 7 char right just " },
  {"JOBN07", SAVE_CHAR_DEF,   78,  1, " JOB Number 7 char right just " },
  {"JOBN08", SAVE_CHAR_DEF,   79,  1, " JOB Number 7 char right just " },
  {"NumTrc", SAVE_LONG_DEF,   10,  1, " number traces per record	" },
  {"NumRec", SAVE_LONG_DEF,   11,  1, " number records per line	" },
  {"SmpInt", SAVE_LONG_DEF,   12,  1, " sample interval ms		" },
  {"NumSmp", SAVE_LONG_DEF,   13,  1, " number samples per trace	" },
  {"Format", SAVE_LONG_DEF,   14,  1, " format code			" },
  {"IndAdj", SAVE_LONG_DEF,   15,  1, " index adjustment		" },
  {"OpGrFl", SAVE_LONG_DEF,   16,  1, " Opposite/Between Group Flag	" },
  {"SrtTyp", SAVE_CHAR_DEF,  144,  2, " Sort Type 0=FIFO 1=LgArrow	" },
  {"SrTy01", SAVE_CHAR_DEF,  144,  1, "           2=max to min	" },
  {"SrTy02", SAVE_CHAR_DEF,  145,  1, "           			" },
  {"CDPFld", SAVE_LONG_DEF,   19,  1, " CDP Fold			" },
  {"GrpInt", SAVE_CHAR_DEF,  160,  4, " Group Inverval		" },
  {"GrpIn0", SAVE_CHAR_DEF,  160,  1, " Group Inverval		" },
  {"GrpIn1", SAVE_CHAR_DEF,  161,  1, " Group Inverval		" },
  {"GrpIn2", SAVE_CHAR_DEF,  162,  1, " Group Inverval		" },
  {"GrpIn3", SAVE_CHAR_DEF,  163,  1, " Group Inverval		" },
  {"DtInFl", SAVE_LONG_DEF,   21,  1, " Data Indicator Flag		" },
  {"Dy1000", SAVE_LONG_DEF,   21,  1, " Record Interval * 1000 (MBS) " },
  {"MxSPEl", SAVE_LONG_DEF,   22,  1, " Max Source Point Elevation	" },
  {"MnSPEl", SAVE_LONG_DEF,   23,  1, " Min Source Point Elevation	" },
  {"MxRSEL", SAVE_LONG_DEF,   24,  1, " Max Ref Surface Elevation	" },
  {"MnRSEL", SAVE_LONG_DEF,   25,  1, " Min Ref Surface Elevation	" },
  {"MxGrEl", SAVE_LONG_DEF,   26,  1, " Maximum group Elevation	" },
  {"MnGrEl", SAVE_LONG_DEF,   27,  1, " Minimum group Elevation	" },
  {"MxTrSt", SAVE_LONG_DEF,   28,  1, " Maximum trace Static		" },
  {"MnTrSt", SAVE_LONG_DEF,   29,  1, " Minimum trace Static		" },
  {"LinDir", SAVE_CHAR_DEF,  240,  4, " Line Direction e.g., N45E	" },
  {"LnDi01", SAVE_CHAR_DEF,  240,  1, " Line Direction e.g., N45E	" },
  {"LnDi02", SAVE_CHAR_DEF,  241,  1, " Line Direction e.g., N45E	" },
  {"LnDi03", SAVE_CHAR_DEF,  242,  1, " Line Direction e.g., N45E	" },
  {"LnDi04", SAVE_CHAR_DEF,  243,  1, " Line Direction e.g., N45E	" },
  {"AERcPr", SAVE_LONG_DEF,   31,  1, " Accumulative Est Rec Proc	" },
  {"OrNTRC", SAVE_LONG_DEF,   32,  1, " Original traces Per Record	" },
  {"OrNREC", SAVE_LONG_DEF,   33,  1, " Original Number records	" },
  {"MutVel", SAVE_FLOAT_DEF,  34,  1, " Muting Velocity		" },
  {"ZDMuTm", SAVE_LONG_DEF,   35,  1, " Zero Distance Mutine Time	" },
  {"IntInc", SAVE_LONG_DEF,   36,  1, " interpolation increment	" },
  {"WatVel", SAVE_LONG_DEF,   37,  1, " Water Velocity		" },
  {"RefVel", SAVE_LONG_DEF,   37,  1, " SLNT Reference Velocity(MBS) " },
  {"MxShDp", SAVE_LONG_DEF,   38,  1, " Maximum Shot Depth		" },
  {"MnShDp", SAVE_LONG_DEF,   39,  1, " Minimum Shot Depth		" },
  {"MxUHTm", SAVE_LONG_DEF,   40,  1, " Maximum Uphole Time		" },
  {"MnUHTm", SAVE_LONG_DEF,   41,  1, " Minimum Uphole Time		" },
  {"MxTrOf", SAVE_LONG_DEF,   42,  1, " Maximum traverse Offset	" },
  {"MnTrOf", SAVE_LONG_DEF,   43,  1, " Minimum traverse Offset	" },
  {"RATTrc", SAVE_LONG_DEF,   44,  1, " RATS Traces per Record Entry " },
  {"AnglSt", SAVE_LONG_DEF,   44,  1, " SLNT Starting Angle    (MBS) " },
  {"RATFld", SAVE_LONG_DEF,   45,  1, " RATS Fold Entry		" },
  {"AngInc", SAVE_LONG_DEF,   45,  1, " SLNT Angle Increment   (MBS) " },
  {"UnitFl", SAVE_LONG_DEF,   46,  1, " Units Flag 0=ft 1=m		" },
  {"FrstSP", SAVE_LONG_DEF,   47,  1, " 1st SP Number on Line	" },
  {"DpN1SP", SAVE_LONG_DEF,   48,  1, " Dep Pt Num Below 1st Src Pt	" },
  {"NmDpIn", SAVE_LONG_DEF,   49,  1, " Num Dep Pt Int per Unit Inc	" },
  {"StWdFl", SAVE_LONG_DEF,   50,  1, " Static Wd Flag 0=old >=1 new	" },
  {"DptInt", SAVE_LONG_DEF,   51,  1, " Depth Point interval		" },
  {"TmMsSl", SAVE_LONG_DEF,   52,  1, " Time in ms of First Slice	" },
  {"Dx1000", SAVE_LONG_DEF,   52,  1, " Trace interval * 1000  (MBS) " },
  {"TmSlIn", SAVE_LONG_DEF,   53,  1, " Time Slice increment in ms	" },
  {"Dz1000", SAVE_LONG_DEF,   53,  1, " Depth Interval * 1000  (MBS) " },
  {"TmMsFS", SAVE_FLOAT_DEF,  54,  1, " Time in ms of First Sample	" },
  {"NTrLnS", SAVE_LONG_DEF,   55,  1, " Number Traces/Line Sorted In	" },
  {"PltDir", SAVE_LONG_DEF,   56,  1, " Plot Direction		" },
  {"LgRfEl", SAVE_LONG_DEF,   57,  1, " Log Reference Elevation	" },
  {"MnLnIn", SAVE_LONG_DEF,   58,  1, " Minimum line Index		" },
  {"MxLnIn", SAVE_LONG_DEF,   59,  1, " Maximum line Index		" },
  {"MnDpIn", SAVE_LONG_DEF,   60,  1, " Minimum depth Index		" },
  {"MxDpIn", SAVE_LONG_DEF,   61,  1, " Maximum depth Index		" },
  {"ILClIn", SAVE_FLOAT_DEF,  62,  1, " In Line Cell Increment	" },
  {"CLClIn", SAVE_FLOAT_DEF,  63,  1, " Cross Line Cell Increment	" },
  {"ReSpFm", SAVE_LONG_DEF,   64,  1, " Reserved Special Format	" },
  {"VlFnRF", SAVE_LONG_DEF,   65,  1, " Vel Func Ref Flag 0=RI 1=DI	" },
  {"OACUsr", SAVE_CHAR_DEF,  528,  4, " OAC USER Field		" },
  {"OACUF0", SAVE_CHAR_DEF,  528,  1, " OAC USER Field		" },
  {"OACUF1", SAVE_CHAR_DEF,  529,  1, " OAC USER Field		" },
  {"OACUF2", SAVE_CHAR_DEF,  530,  1, " OAC USER Field		" },
  {"OACUF3", SAVE_CHAR_DEF,  531,  1, " OAC USER Field		" },
  {"LinNam", SAVE_CHAR_DEF,  536,  8, " Line Name			" },
  {"LnNm00", SAVE_CHAR_DEF,  536,  1, " Line Name			" },
  {"LnNm01", SAVE_CHAR_DEF,  537,  1, " Line Name			" },
  {"LnNm02", SAVE_CHAR_DEF,  538,  1, " Line Name			" },
  {"LnNm03", SAVE_CHAR_DEF,  539,  1, " Line Name			" },
  {"LnNm04", SAVE_CHAR_DEF,  540,  1, " Line Name			" },
  {"LnNm05", SAVE_CHAR_DEF,  541,  1, " Line Name			" },
  {"LnNm06", SAVE_CHAR_DEF,  542,  1, " Line Name			" },
  {"LnNm07", SAVE_CHAR_DEF,  543,  1, " Line Name			" },
  {"MutFlg", SAVE_LONG_DEF,   68,  1, " Mute Flag 0=yes 1=no		" },
  {"SPBias", SAVE_CHAR_DEF,  552,  2, " Shot point Bias		" },
  {"SPBi00", SAVE_CHAR_DEF,  552,  1, " Shot point Bias		" },
  {"SPBi01", SAVE_CHAR_DEF,  553,  1, " Shot point Bias		" },
  {"SpBiFl", SAVE_LONG_DEF,   70,  1, " Shot Point Bias Flag		" },
  {"APIWNo", SAVE_CHAR_DEF,  568, 12, " API Well Number		" },
  {"APIWN0", SAVE_CHAR_DEF,  568,  1, " API Well Number		" },
  {"APIWN1", SAVE_CHAR_DEF,  569,  1, " API Well Number		" },
  {"APIWN2", SAVE_CHAR_DEF,  570,  1, " API Well Number		" },
  {"APIWN3", SAVE_CHAR_DEF,  571,  1, " API Well Number		" },
  {"APIWN4", SAVE_CHAR_DEF,  572,  1, " API Well Number		" },
  {"APIWN5", SAVE_CHAR_DEF,  573,  1, " API Well Number		" },
  {"APIWN6", SAVE_CHAR_DEF,  574,  1, " API Well Number		" },
  {"APIWN7", SAVE_CHAR_DEF,  575,  1, " API Well Number		" },
  {"APIWN8", SAVE_CHAR_DEF,  576,  1, " API Well Number		" },
  {"APIWN9", SAVE_CHAR_DEF,  577,  1, " API Well Number		" },
  {"APIWNA", SAVE_CHAR_DEF,  578,  1, " API Well Number		" },
  {"APIWNB", SAVE_CHAR_DEF,  579,  1, " API Well Number		" },
/*
 * Unclaimed line-header space. Data within this unused area
 * ( bytes 585-592 ) have not been translated during conversion
 * to Cray format. Thus, the most likely use for this area would
 * be to store ASCII character information. ( 2 bytes only )
 */
  {"NmSpMi", SAVE_FLOAT_DEF,  74,  1, " Number Shot points per Mile " },
/*
 * More unclaimed line-header space. ( Bytes 601-976 ) These are also
 * not translated when converted to Cray format.
 */
  {"MinVel", SAVE_LONG_DEF, 122,  1, " Minimum velocity       (MBS) " },
  {"MaxVel", SAVE_LONG_DEF, 123,  1, " Maximum velocity       (MBS) " },
  {"Nx_Pad", SAVE_LONG_DEF, 124,  1, " No of Padded Traces (in X)   " },
  {"Nx_Win", SAVE_LONG_DEF, 125,  1, " No of Traces in Window (in X)" },
  {"Nx_Rec", SAVE_LONG_DEF, 126,  1, " No of Windowed Records (in X)" },
  {"NxLine", SAVE_LONG_DEF, 127,  1, " Number of Lines (in X)       " },
  {"Nx_Trc", SAVE_LONG_DEF, 128,  1, " Number of Traces (in X)      " },
  {"Ny_Pad", SAVE_LONG_DEF, 129,  1, " No of Padded Traces (in Y)   " },
  {"Ny_Win", SAVE_LONG_DEF, 130,  1, " No of Traces in Window (in Y)" },
  {"Ny_Rec", SAVE_LONG_DEF, 131,  1, " No of Windowed Records (in Y)" },
  {"NyLine", SAVE_LONG_DEF, 132,  1, " Number of Lines (in Y)       " },
  {"Ny_Trc", SAVE_LONG_DEF, 133,  1, " Number of Traces (in Y)      " },
  {"MCTrSp", SAVE_LONG_DEF, 134,  1, " Multicomponent trace spacing (MC) " },
  {"NumCmp", SAVE_LONG_DEF, 135,  1, " Number of Components (MC) " },
  {"MCList", SAVE_LONG_DEF, 136, 16, " Comp. List (10*Src+Rec) (MC) " },
  {"MCLE01", SAVE_LONG_DEF, 136,  1, " Component (MC) " },
  {"MCLE02", SAVE_LONG_DEF, 137,  1, " Component (MC) " },
  {"MCLE03", SAVE_LONG_DEF, 138,  1, " Component (MC) " },
  {"MCLE04", SAVE_LONG_DEF, 139,  1, " Component (MC) " },
  {"MCLE05", SAVE_LONG_DEF, 140,  1, " Component (MC) " },
  {"MCLE06", SAVE_LONG_DEF, 141,  1, " Component (MC) " },
  {"MCLE07", SAVE_LONG_DEF, 142,  1, " Component (MC) " },
  {"MCLE08", SAVE_LONG_DEF, 143,  1, " Component (MC) " },
  {"MCLE09", SAVE_LONG_DEF, 144,  1, " Component (MC) " },
  {"MCLE10", SAVE_LONG_DEF, 145,  1, " Component (MC) " },
  {"MCLE11", SAVE_LONG_DEF, 146,  1, " Component (MC) " },
  {"MCLE12", SAVE_LONG_DEF, 147,  1, " Component (MC) " },
  {"MCLE13", SAVE_LONG_DEF, 148,  1, " Component (MC) " },
  {"MCLE14", SAVE_LONG_DEF, 149,  1, " Component (MC) " },
  {"MCLE15", SAVE_LONG_DEF, 150,  1, " Component (MC) " },
  {"MCLE16", SAVE_LONG_DEF, 151,  1, " Component (max 16 in list) (MC) " },
/*
 * Left a little hole here in case we need some more for MC stuff
 */
  {"OrNSMP", SAVE_LONG_DEF, 162,  1, "* Original Number of Samples/Trace " },
  {"AziIln", SAVE_FKFLT_DEF, 163,  1, " In-Line Azimuth      	" },
  {"      ", SAVE_DUMMY_DEF, 164,  1, " ..continued in-line azimuth  " },
  {"AziXln", SAVE_FKFLT_DEF, 165,  1, " Cross-Line Azimuth 		" },
  {"      ", SAVE_DUMMY_DEF, 166,  1, " ..continued x-line azimuth   " },
  {"HrzNul", SAVE_FKFLT_DEF, 167,  1, " Null Horizon Flag Value      " },
  {"      ", SAVE_DUMMY_DEF, 168,  1, " ..continued HrzNul           " },
  {"T_Unit", SAVE_LONG_DEF,  169,  1, " Time Units (0=ms, 1=micro-sec" },
  {"UnitSc", SAVE_FKFLT_DEF, 170,  1, " Smp Units Multiplier 1.==secs" },
  {"      ", SAVE_DUMMY_DEF, 171,  1, " ..continued UnitSc           " },
  {"SmpFlt", SAVE_FKFLT_DEF, 172,  1, " Flt Pt Sample Interval       " },
  {"      ", SAVE_DUMMY_DEF, 173,  1, " ..continued SmpFlt           " },
  {"MaxAmp", SAVE_FKFLT_DEF, 174,  1, " Maximum Absolute Amplitude   " },
  {"      ", SAVE_DUMMY_DEF, 175,  1, " ..continued MaxAmp           " },
  {"AvgAmp", SAVE_FKFLT_DEF, 176,  1, " Average Absolute Amplitude   " },
  {"      ", SAVE_DUMMY_DEF, 177,  1, " ..continued AvgAmp           " },
  {"RmsAmp", SAVE_FKFLT_DEF, 178,  1, " RMS Absolute Amplitude       " },
  {"      ", SAVE_DUMMY_DEF, 179,  1, " ..continued RmsAmp           " },
  {"VelTyp", SAVE_SHORT_DEF, 180,  1, " Velocity Type (0=RMS, 1=Avg, 2=Int, 3=Inst" },
  {"WlfCol", SAVE_SHORT_DEF, 181,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBas", SAVE_SHORT_DEF, 182,  1, " Wavelet Basis" },
  {"WavMom", SAVE_SHORT_DEF, 183,  1, " Wavelet Moment" },
  {"WlfCo1", SAVE_SHORT_DEF, 184,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBa1", SAVE_SHORT_DEF, 185,  1, " Wavelet Basis" },
  {"WavMo1", SAVE_SHORT_DEF, 186,  1, " Wavelet Moment" },
  {"WlfCo2", SAVE_SHORT_DEF, 187,  1, " Wavelet Low Frequency cutoff level" },
  {"WavBa2", SAVE_SHORT_DEF, 188,  1, " Wavelet Basis" },
  {"WavMo2", SAVE_SHORT_DEF, 189,  1, " Wavelet Moment" },
  {"FreQst", SAVE_FKFLT_DEF, 190,  1, " Frequency Start" },
  {"      ", SAVE_DUMMY_DEF, 191,  1, " Frequency Start (cont)" },
  {"FreQnd", SAVE_FKFLT_DEF, 192,  1, " Frequency End" },
  {"      ", SAVE_DUMMY_DEF, 193,  1, " Frequency End (cont)" },
/*
 * Unclaimed line-header space. The old "velocity information" block
 * of the line header began at byte 977 and extended to byte 2576.
 * Data in this area are converted in Cray format as short integers.
 * (Note that on the Cray "short" integers are just as long as long
 * integers, 8 bytes long.)
 */
  {"HlhEnt", SAVE_LONG_DEF,  322,  1, " Number of Entries in HLH	" },
  {"HlhByt", SAVE_LONG_DEF,  323,  1, " Number of Bytes in HLH	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;


	
	/* trace header		*/
static struct hdr thdr[] = {
  {"SGRNum", SAVE_LONG_DEF,    0,  1, " SGR number			" },
  {"SGRAmp", SAVE_LONG_DEF,    1,  1, " SGR PreAmp Gain, Filter	" },
  {"SGRDat", SAVE_LONG_DEF,    2,  1, " SGR Julian Date Recorded	" },
  {"FlReFN", SAVE_LONG_DEF,    4,  1, " Field Record File Number	" },
  {"FlStNm", SAVE_LONG_DEF,    5,  1, " Field Station Number		" },
  {"PREPIn", SAVE_LONG_DEF,    6,  1, " PREP Initiation Static .25ms	" },
  {"InStUn", SAVE_LONG_DEF,    7,  1, " Initiation Static Unapplied	" },
  {"InStAp", SAVE_LONG_DEF,    8,  1, " Initiation Static Applied	" },
  {"PREPRc", SAVE_LONG_DEF,    9,  1, " PREP Reception Static .25ms	" },
  {"RcStUn", SAVE_LONG_DEF,   10,  1, " Reception Static Unapplied	" },
  {"RcStAp", SAVE_LONG_DEF,   11,  1, " Reception Static Applied	" },
  {"ToStAp", SAVE_LONG_DEF,   12,  1, " Total Static Applied 	" },
  {"ToTmAA", SAVE_LONG_DEF,   13,  1, " Total Timing Adjust Applied	" },
  {"ToStUn", SAVE_LONG_DEF,   14,  1, " Total Static Unapplied 	" },
  {"ToTmAU", SAVE_LONG_DEF,   15,  1, " Total Timing Adjust Unapplied " },
					/* all ten above are .25ms units */
  {"SrComp", SAVE_LONG_DEF,   16,  1, " Source Component Number (MC) " },
  {"RcComp", SAVE_LONG_DEF,   17,  1, " Receiver Component Number (MC) " },
  {"TrHdID", SAVE_LONG_DEF,   20,  1, " Trace Header Identifier	" },
  {"SrRcAz", SAVE_LONG_DEF,   21,  1, " Source-to-Receiver Azimuth	" },
  {"SrPtXC", SAVE_LONG_DEF,   22,  1, " Src Point X-Coordinate 3D	" },
  {"SrPtYC", SAVE_LONG_DEF,   24,  1, " Src Point Y-Coordinate 3D	" },
  {"RcPtXC", SAVE_LONG_DEF,   26,  1, " Rec Point X-Coordinate 3D	" },
  {"RcPtYC", SAVE_LONG_DEF,   28,  1, " Rec Point Y-Coordinate 3D	" },
  {"SrRcMX", SAVE_LONG_DEF,   30,  1, " Src Rec Midpoint X 3D	" },
  {"SrRcMY", SAVE_LONG_DEF,   32,  1, " Src Rec Midpoint Y 3D	" },
  {"CDPBCX", SAVE_LONG_DEF,   34,  1, " CDP Bin Center X Coordinate	" },
                            /* also used by lm3dvtosis for real world X */
  {"CDPBCY", SAVE_LONG_DEF,   36,  1, " CDP Bin Center Y Coordinate	" },
                            /* also used by lm3dvtosis for real world Y */
  {"InTrCn", SAVE_LONG_DEF,   38,  1, " Incremental Trace Counter	" },
  {"FlDtEl", SAVE_LONG_DEF,   40,  1, " Floating Datum Elev this CDP	" },
  {"MulSkw", SAVE_LONG_DEF,   41,  1, " Multiplex Skew (ms*1000)	" },
  {"PerSPO", SAVE_LONG_DEF,   42,  1, " Perpendicular Src Pt Off y	" },
  {"InlSPO", SAVE_LONG_DEF,   43,  1, " Inline Src Pt Off x		" },
  {"SrXAzm", SAVE_LONG_DEF,   44,  1, " Source X Azimuth (*10)  (MC) " },
  {"TiLiI1", SAVE_LONG_DEF,   44,  1, " Tie Line Indicator 1		" },
  {"SrYRot", SAVE_LONG_DEF,   45,  1, " Source Y Rotation (*10) (MC) " },
  {"TiLiI2", SAVE_LONG_DEF,   45,  1, " Tie Line Indicator 2		" },
  {"SrZRot", SAVE_LONG_DEF,   46,  1, " Source Z Rotation (*10) (MC) " },
  {"TiLiI3", SAVE_LONG_DEF,   46,  1, " Tie Line Indicator 3		" },
  {"RcXAzm", SAVE_LONG_DEF,   47,  1, " Receiver X Azimuth (*10)(MC) " },
  {"TiLiI4", SAVE_LONG_DEF,   47,  1, " Tie Line Indicator 4		" },
  {"RcYRot", SAVE_LONG_DEF,   48,  1, " Receiver Y Rotation (*10)(MC)" },
  {"TiLiI5", SAVE_LONG_DEF,   48,  1, " Tie Line Indicator 5		" },
  {"RcZRot", SAVE_LONG_DEF,   49,  1, " Receiver Z Rotation (*10)(MC)" },
  {"TiLiI6", SAVE_LONG_DEF,   49,  1, " Tie Line Indicator 6		" },
  {"TVPT01", SAVE_LONG_DEF,   50,  1, " Time of Time-Vel Pair	" },
  {"Horz01", SAVE_FKFLT_DEF,  50,  1, " Horizon #1                   " },
  {"TVPV01", SAVE_LONG_DEF,   51,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT02", SAVE_LONG_DEF,   52,  1, " Time of Time-Vel Pair	" },
  {"Horz02", SAVE_FKFLT_DEF,  52,  1, " Horizon #2                   " },
  {"TVPV02", SAVE_LONG_DEF,   53,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT03", SAVE_LONG_DEF,   54,  1, " Time of Time-Vel Pair	" },
  {"Horz03", SAVE_FKFLT_DEF,  54,  1, " Horizon #3                   " },
  {"TVPV03", SAVE_LONG_DEF,   55,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT04", SAVE_LONG_DEF,   56,  1, " Time of Time-Vel Pair	" },
  {"Horz04", SAVE_FKFLT_DEF,  56,  1, " Horizon #4                   " },
  {"TVPV04", SAVE_LONG_DEF,   57,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT05", SAVE_LONG_DEF,   58,  1, " Time of Time-Vel Pair	" },
  {"Horz05", SAVE_FKFLT_DEF,  58,  1, " Horizon #5                   " },
  {"TVPV05", SAVE_LONG_DEF,   59,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT06", SAVE_LONG_DEF,   60,  1, " Time of Time-Vel Pair	" },
  {"Horz06", SAVE_FKFLT_DEF,  60,  1, " Horizon #6                   " },
  {"TVPV06", SAVE_LONG_DEF,   61,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT07", SAVE_LONG_DEF,   62,  1, " Time of Time-Vel Pair	" },
  {"Horz07", SAVE_FKFLT_DEF,  62,  1, " Horizon #7                   " },
  {"TVPV07", SAVE_LONG_DEF,   63,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT08", SAVE_LONG_DEF,   64,  1, " Time of Time-Vel Pair	" },
  {"Horz08", SAVE_FKFLT_DEF,  64,  1, " Horizon #8                   " },
  {"TVPV08", SAVE_LONG_DEF,   65,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT09", SAVE_LONG_DEF,   66,  1, " Time of Time-Vel Pair	" },
  {"TVPV09", SAVE_LONG_DEF,   67,  1, " Velocity of Time-Vel Pair	" },
  {"AvDaSt", SAVE_LONG_DEF,   67,  1, " Avg CDP datum static in ms." },
  {"TVPT10", SAVE_LONG_DEF,   68,  1, " Time of Time-Vel Pair	" },
  {"TrSrSt", SAVE_LONG_DEF,   68,  1, " Trace surface static in ms." },
  {"TVPV10", SAVE_LONG_DEF,   69,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT11", SAVE_LONG_DEF,   70,  1, " Time of Time-Vel Pair	" },
  {"TVPV11", SAVE_LONG_DEF,   71,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT12", SAVE_LONG_DEF,   72,  1, " Time of Time-Vel Pair	" },
  {"TVPV12", SAVE_LONG_DEF,   73,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT13", SAVE_LONG_DEF,   74,  1, " Time of Time-Vel Pair	" },
  {"TVPV13", SAVE_LONG_DEF,   75,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT14", SAVE_LONG_DEF,   76,  1, " Time of Time-Vel Pair	" },
  {"TVPV14", SAVE_LONG_DEF,   77,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT15", SAVE_LONG_DEF,   78,  1, " Time of Time-Vel Pair	" },
  {"TVPV15", SAVE_LONG_DEF,   79,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT16", SAVE_LONG_DEF,   80,  1, " Time of Time-Vel Pair	" },
  {"TVPV16", SAVE_LONG_DEF,   81,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT17", SAVE_LONG_DEF,   82,  1, " Time of Time-Vel Pair	" },
  {"TVPV17", SAVE_LONG_DEF,   83,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT18", SAVE_LONG_DEF,   84,  1, " Time of Time-Vel Pair	" },
  {"TVPV18", SAVE_LONG_DEF,   85,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT19", SAVE_LONG_DEF,   86,  1, " Time of Time-Vel Pair	" },
  {"TVPV19", SAVE_LONG_DEF,   87,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT20", SAVE_LONG_DEF,   88,  1, " Time of Time-Vel Pair	" },
  {"TVPV20", SAVE_LONG_DEF,   89,  1, " Velocity of Time-Vel Pair	" },
  {"TVPT21", SAVE_LONG_DEF,   90,  1, " Time of Time-Vel Pair	" },
  {"TVPV21", SAVE_LONG_DEF,   91,  1, " Velocity of Time-Vel Pair	" },
  {"RedVel", SAVE_LONG_DEF,   90,  1, " Reduction Velocity for vred	" },
  {"RedTim", SAVE_LONG_DEF,   91,  1, " Time of first sample for vred " },
  {"VPick1", SAVE_LONG_DEF,   92,  1, " Auto Static Pick 1		" },
  {"VPick2", SAVE_LONG_DEF,   93,  1, " Auto Static Pick 2		" },
  {"LRcCDP", SAVE_LONG_DEF,   94,  1, " Last Record CDP		" },
  {"CabDep", SAVE_LONG_DEF,   95,  1, " Cable Depth			" },
  {"WDepDP", SAVE_LONG_DEF,   96,  1, " Water Depth Above Depth Point " },
  {"DPOPer", SAVE_LONG_DEF,   97,  1, " Depth Point Offset Perpendic	" },
  {"ShtDep", SAVE_LONG_DEF,   98,  1, " shot depth			" },
  {"UphlTm", SAVE_LONG_DEF,   99,  1, " uphole time in ms		" },
  {"DpPtLt", SAVE_LONG_DEF,  100,  1, " depth pt lat (deg* 10^5)	" },
  {"DpPtLn", SAVE_LONG_DEF,  102,  1, " depth pt lon (deg* 10^5)	" },
  {"FoldNm", SAVE_LONG_DEF,  104,  1, " fold				" },
  {"RecNum", SAVE_LONG_DEF,  105,  1, " record number		" },
  {"TrcNum", SAVE_LONG_DEF,  106,  1, " trace number			" },
  {"SrcPnt", SAVE_LONG_DEF,  107,  1, " src point above this depth pt " },
  {"SrcLoc", SAVE_LONG_DEF,  108,  1, " src location ind mult by 10	" },
  {"PrRcNm", SAVE_LONG_DEF,  109,  1, " permanent record number PRI	" },
  {"PrTrNm", SAVE_LONG_DEF,  110,  1, " permanent trace number  PTI	" },
  {"SrPtEl", SAVE_LONG_DEF,  111,  1, " source point elevation	" },
  {"SrPrLt", SAVE_LONG_DEF,  112,  1, " source point lat (deg* 10^5)	" },
  {"SrPrLn", SAVE_LONG_DEF,  114,  1, " source point lon (deg* 10^5)	" },
  {"DstUsg", SAVE_LONG_DEF,  116,  1, " unsigned trace distance	" },
  {"RecInd", SAVE_LONG_DEF,  117,  1, " rec location index	GI	" },
  {"DstSgn", SAVE_LONG_DEF,  118,  1, " signed trace distance	" },
  {"GrpElv", SAVE_LONG_DEF,  119,  1, " group elevation		" },
  {"LinInd", SAVE_LONG_DEF,  120,  1, " line index 3D		" },
  {"DphInd", SAVE_LONG_DEF,  121,  1, " depth index			" },
  {"DePtEl", SAVE_LONG_DEF,  122,  1, " depth point elevation	" },
  {"RfSrEl", SAVE_LONG_DEF,  123,  1, " reference surface elevation	" },
  {"StaCor", SAVE_LONG_DEF,  124,  1, " correction			" },
  {"DatShf", SAVE_LONG_DEF,  125,  1, " datum shift			" },
  {"SoPtNm", SAVE_LONG_DEF,  126,  1, " source point number		" },
  {"SoPtAl", SAVE_CHAR_DEF, 1016,  1, " source point alphabetic sufix " },
  {"SoPtBi", SAVE_CHAR_DEF, 1017,  1, " source point bias /10000	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	};

		/* vanl analysis header		*/
static struct hdr vnlhdr[] = {
  {"CDPNum", SAVE_LONG_DEF,    0,  1, " RI(CDP) Number of this anal. " },
  {"LinNum", SAVE_CHAR_DEF,    8,  4, " Line Number			" },
  {"CohRec", SAVE_LONG_DEF,    2,  1, " # of coherence records       " },
  {"FstCoh", SAVE_LONG_DEF,    3,  1, " number of 1st coherence samp " },
  {"NumCoh", SAVE_LONG_DEF,    4,  1, " # of coherence values/record " },
  {"VelPrs", SAVE_LONG_DEF,    5,  1, " # of v,delta-v pairs in hdr  " },
  {"RsmpIn", SAVE_LONG_DEF,    6,  1, " resampling increment used	" },
  {"SmpInt", SAVE_LONG_DEF,    7,  1, " coherence sample interval(ms)" },
  {"StFlag", SAVE_LONG_DEF,    8,  1, " statics application flag 	" },
					/*	0=reg. ref.		*/
					/*	1=No statics		*/
					/*	2=Mean ground		*/
  {"PanWid", SAVE_LONG_DEF,    9,  1, " panel width in CDPs		" },
  {"AvPnSt", SAVE_LONG_DEF,   10,  1, " average panel statics in ms. " },
  {"RfSfEl", SAVE_LONG_DEF,   11,  1, " reference surface elevation  " },
  {"SrcPNm", SAVE_LONG_DEF,   12,  1, " source point number 		" },
  {"LinInd", SAVE_LONG_DEF,   13,  1, " line index			" },
  {"CDPFld", SAVE_LONG_DEF,   14,  1, " fold				" },
  {"NStkTr", SAVE_LONG_DEF,   15,  1, " # stacked traces in analysis " },
  {"DphInd", SAVE_LONG_DEF,   16,  1, " depth index			" },
  {"WDepDP", SAVE_LONG_DEF,   17,  1, " water depth above depth point " },
  {"WatVel", SAVE_LONG_DEF,   18,  1, " water velocity		" },
  {"OACCod", SAVE_CHAR_DEF,  152,  4, " OAC code			" },
  {"SoPtBi", SAVE_LONG_DEF,   20,  1, " source point bias		" },
  {"EMFlag", SAVE_LONG_DEF,   20,  1, " english/metric flag		" },
  {"LevNum", SAVE_LONG_DEF,   21,  1, " VANL tape level number	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	} ;

static struct hdr vspn_hdr[] = {
  {"RecLng", SAVE_LONG_DEF,    0,  1, " Record length in bytes	" },
  {"LevNum", SAVE_LONG_DEF,    1,  1, " VSPN tape level number-unused " },
  {"FFDLat", SAVE_LONG_DEF,    2,  1, " 1st four digits of Latitude  " },
  {"LFDLat", SAVE_LONG_DEF,    3,  1, " Last four digits of Latitude " },
  {"FFDLon", SAVE_LONG_DEF,    4,  1, " 1st four digits of Longitude " },
  {"LFDLon", SAVE_LONG_DEF,    5,  1, " Last four digits of Longitude " },
  {"AVFNum", SAVE_LONG_DEF,    6,  1, " Archival Vel. File number	" },
  {"OACCod", SAVE_CHAR_DEF,   56,  3, " OAC code			" },
  {"OAVFNm", SAVE_LONG_DEF,    8,  1, " OAVF number			" },
  {"DatSrc", SAVE_CHAR_DEF,   72,  1, " Data Source			" },
  {"MthCmp", SAVE_CHAR_DEF,   80,  1, " Method of Computation        " },
  {"TmLsEn", SAVE_LONG_DEF,   11,  1, " Time Last Entry for Well Func " },
  {"LinCod", SAVE_LONG_DEF,   11,  1, " Line Code for Reflection Func " },
  {"MonDay", SAVE_LONG_DEF,   12,  1, " Month & Day in integer form	" },
  {"Year  ", SAVE_LONG_DEF,   13,  1, " Year in integer form		" },
  {"CDPNum", SAVE_LONG_DEF,   14,  1, " RI(CDP) Number of this anal. " },
  {"MaxDst", SAVE_LONG_DEF,   15,  1, " Maximum Distance		" },
  {"DirSht", SAVE_LONG_DEF,   16,  1, " Direction of Shooting	" },
  {"CDPFld", SAVE_LONG_DEF,   17,  1, " fold				" },
  {"PanWid", SAVE_LONG_DEF,   18,  1, " panel width in CDPs		" },
  {"WinLng", SAVE_LONG_DEF,   19,  1, " Window Length ( in ms )	" },
  {"SrfElv", SAVE_LONG_DEF,   20,  1, " Surface Elevation		" },
  {"RgRSEL", SAVE_LONG_DEF,   21,  1, " Regional Ref Surface Elev	" },
  {"TCRfSf", SAVE_LONG_DEF,   22,  1, " Time Corr to Ref Surface	" },
  {"VelSbW", SAVE_LONG_DEF,   23,  1, " Velocity of Subweathering	" },
  {"VelPrs", SAVE_LONG_DEF,   24,  1, " # of time,velocity pairs 	" },
  {"HrzPrs", SAVE_LONG_DEF,   25,  1, " # of seismic horizon,time prs " },
  {"ICNByt", SAVE_LONG_DEF,   26,  1, " # of bytes in int. comments	" },
  {"WatDep", SAVE_LONG_DEF,   27,  1, " Water Depth 			" },
  {"DivCod", SAVE_LONG_DEF,   28,  1, " Division Code		" },
  {"StNoAr", SAVE_LONG_DEF,   29,  1, " Strat. Nomenclature Area	" },
  {"HstOAC", SAVE_CHAR_DEF,  240,  3, " Historical OAC		" },
  {"SrcPnt", SAVE_LONG_DEF,   31,  1, " Source Point			" },
  {"SoPtAl", SAVE_CHAR_DEF,  256,  1, " Source Point Alpha		" },
  {"LinNum", SAVE_CHAR_DEF,  264,  5, " Line Number			" },
  {"DrSht1", SAVE_CHAR_DEF,  272,  1, " Direction of Shooting	" },
  {"DrSht2", SAVE_CHAR_DEF,  280,  1, " Direction of Shooting	" },
  {"RelFlg", SAVE_CHAR_DEF,  288,  1, " Reliablity			" },
  {"RlAlFg", SAVE_CHAR_DEF,  296,  1, " Reliablity Alpha Flag	" },
  {(char *)0,		 -1,  -1, -1, " end of list			" }
	};
#endif

#include <segy_save.h>

#endif
