C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ampspec --> generate summed fft for dataset
c
c Changes:
c
c   Mar 19, 2002:
c         Added a policeman to watch for number of samples into the
c         rfftb[] routine greater than 2 to the 15th [16384] which is 
c         the largest time series convertible by the MathAdv fft routines
c         [see qtc008.f] for the sorry story.
c   Garossino
c
c   Mar 19, 2002:
c         Added a policeman to watch for zero values in the transform
c         prior to conversion of the spectrum to db.  This results in
c         a -inf which is hard to graph.  Currently I set the zero to
c         1.0e-32 and warn the user that such a thing has happened.
c         [reported by Richard Crider]
c   Garossino
c   
c
c   Mar 15, 2002:
c         Added -promax option to facilitate forward transform normalization
c         by 1/N rather than 1/(2N) used by Math Advantage.  This make the 
c         output numerics compatible with promax if that is desired.
c         Requested by Kent Andorsen.
c         Also redid memory management to be able to handle very large input
c         traces.  Requested by Scott Michell
c   Garossino
c
c   Nov 1, 2001:
c         Changed -db option to use 20 * log for amplitude, 10*log should
c         be used for power spectrum as then you are using amplitude**2
c         hence the extra power of 2.  Also I have  changed the behaviour
c         of the nomalization option so that -db output is only normalized
c         if requested.  The previous iteration had -db output normalized
c         as the default.  This was all requested by Ganyuan Xia.
c   Garossino
c
c   Oct 25, 2001:
c         Fix output to be at correct frequency.  The original routine
c         did NOT unpack the complex fft before cvabs() resulting in
c         the real part of Nyqust being used as the imaginary part of
c         DC [which makes no sense].  The number of frequency estimates
c         was corrected to N/2+1 where N is the closest next power of
c         2 to the number of input samples.  The frequency axis also 
c         had to be corrected as it was not being labled from DC but from
c         delta f.  I also put in implicit none.  Next time in I will 
c         add dynamic memory allocation as this routine uses way too much
c         memory.
c   Garossino

      implicit none

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin, luout, lbytes, nbytes
      integer     argis, jerr, ist, iend, nst, ned, nrst, nred
      integer ntr, nrecc

      real unitsc

      character   name * 7,  ntap * 256, otap * 256

      logical     verbos

c declare variables used in dynamic memory allocation
c      real  tri ( 16*SZLNHD ), work (16*SZLNHD )
c      real  sum (16*SZLNHD )
c      complex ctr ( 8*SZLNHD )
c      integer     itr ( 5*SZLNHD )

      integer alloc_size, itr, errcd1, errcd2, errcd3, errcd4, abort

      real tri, work, sum

      complex ctr

      pointer ( mem_itr, itr(2) )
      pointer ( mem_tri, tri(2) )
      pointer ( mem_sum, sum(2) )
      pointer ( mem_work, work(2) )
      pointer ( mem_ctr, ctr(2) )

c declare local variables

      integer ordfft, lc, nsampo, irec, ierr, iostat, length, lenth
      integer ist0, nsamp_in, nu, n2, JJ, KK, ik, i
      integer ifmt_StaCor, l_StaCor, ln_StaCor, Stacor
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_RecNum, l_RecNum, ln_RecNum
      

      real  radeg, thresh, smax, dt, fnyq, df, vfreq, dfreq

      complex czero

      character char1 * 256

      logical norm, graph, db, MathAdvScaling, zeroes

c initialize variables

      data name /'AMPSPEC'/
      data radeg/57.29578/
      data abort/0/
      data czero/0.0/
      data zeroes/.false./

c---------------------------------
c  get online help if necessary
c---------------------------------

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0) then
         call help ()
         stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>
      
c---------------------------------------------------------------
c     read program parameters from command line
c---------------------------------------------------------------
      call cmdln ( ntap, otap, ist, iend, nst, ned, nrst, nred, verbos, 
     :     norm, thresh, graph, db, MathAdvScaling )
      

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      
      call getln( luin, ntap, 'r', 0)
      
      if (otap(1:1) .eq. ' ') then
         luout = LOT
      else
         call alloclun(luout)
         open (unit=luout, file=otap, status='unknown', iostat=ierr)
         if ( iostat .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)' error opening output file '
            write(LERR,*)' check permissions and rerun'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'AMPSPEC: '
            write(LER,*)' error opening output file '
            write(LER,*)' check permissions and rerun'
            write(LER,*)'FATAL'
            write(LER,*)' '
            stop
         endif
      endif

c dynamically allocate memory to allow read of line header

      alloc_size = SZLNHD * SZSMPD
      call galloc(mem_itr,alloc_size,errcd1,abort)
      if (errcd1 .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) '       ',alloc_size,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'AMPSPEC: Unable to allocate workspace '
	write(LER,*) '        ',alloc_size,' bytes requested '
	write(LER,*) 'FATAL'
	stop 
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) alloc_size,' bytes requested '
      endif

c read in put line header
      
      lbytes=0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         length = lenth(ntap)
         write(LERR,*)'AMPSPEC: '
         write(LERR,*)' no header read on ',ntap(1:length)
         write(LERR,*)'FATAL'
         write(LER,*)' ' 
         write(LER,*)'AMPSPEC: '
         write(LER,*)' no header read on ',ntap(1:length)
         write(LER,*)'FATAL'
         write(LER,*)' ' 
         stop
      endif

#include <f77/saveh.h>

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

      call hlhprt ( itr , lbytes, name, 7, lerr  )

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------

      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)

      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD

      ntr = ned-nst+1
      nrecc = nred-nrst+1

C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
      dt = float (nsi) * unitsc
      iend=iend/nsi + .5
      ist0 = ist
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp

      nsamp_in=iend-ist+1

c------------------------------
c  find power of 2, nsamp_in

      nu = ordfft (nsamp_in)
      n2 = 2 ** nu
      fnyq = .5 / dt
      df = fnyq / float(n2/2)
      nsampo = n2 / 2 + 1

c Policeman:  if n2 is greater than 16384 the MathAdv rfftb routine cannot do 
c             the transform.  It is internally coded to handle only up to 
c             2**15 values.  If the users trace is to long then send them 
c             packing and make them think about subsetting the calculation.

      if ( n2 .gt. 16384 ) then

         write(LERR,*)' '
         write(LERR,*)' n2 = ', n2
         write(LERR,*)' your trace, when expanded to the next power of'
         write(LERR,*)' 2, contains too many samples for the MathAdv'
         write(LERR,*)' fft routine. The limit is 2**15 [16384] samples'
         write(LERR,*)' Either shorten your trace or call the USP shop'
         write(LERR,*)' for guidance.'
         write(LER,*)' '
         write(LER,*)'AMPSPEC:'
         write(LER,*)' n2 = ', n2
         write(LER,*)' your trace, when expanded to the next power of'
         write(LER,*)' 2, contains too many samples for the MathAdv'
         write(LER,*)' fft routine. The limit is 2**15 [16384] samples'
         write(LER,*)' Either shorten your trace or call the USP shop'
         write(LER,*)' for guidance.'
         write(LER,*)'FATAL'
         write(LER,*)' '
         goto 999
      endif

c------------------------------

      write(LERR,*)
      write(LERR,*)' Line header values after default check '
      write(LERR,*)
      write(LERR,*) ' Input Samples/Trace =  ', nsamp
      write(LERR,*) ' # of Samples/Trace  =  ', nsamp_in
      write(LERR,*) ' power of 2 samples  =  ', n2
      write(LERR,*) ' Sample Interval     =  ', nsi  
      write(LERR,*) ' Input traces/rec    =  ', ntrc
      write(LERR,*) ' Input Records/Line  =  ', nrec
      write(LERR,*) ' Format of Data      =  ', iform
      write(LERR,*) ' Frequency interval (Hz)   = ',df
      if (db) 
     :write(LERR,*) ' Output plotted in db down'
      if (verbos)
     :write(LERR,*) ' verbose output requested'

c dynamically allocate memory for tri, sum, work and reallocate itr
c for trace data rather than line header
c tri ... nsampo
c work ... 
c sum ... n2
c itr ... SZTRHD + SZSMPD * nsampo
c

      alloc_size = SZTRHD + nsamp
      call grealloc (mem_itr,alloc_size*SZSMPD,errcd1,abort)
      if (errcd1 .ne. 0) then
	write(LERR,*) 'ERROR: Unable to allocate trace workspace '
	write(LERR,*) '       ',alloc_size*SZSMPD,' bytes requested '
	write(LERR,*) '       FATAL'
	write(LER,*) 'AMPSPEC: Unable to allocate trace workspace '
	write(LER,*) '       ',alloc_size*SZSMPD,' bytes requested '
	write(LER,*) 'FATAL'
	stop
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) alloc_size,' bytes requested '
      endif

      call vclr ( itr, 1, alloc_size )

      call galloc(mem_tri,nsampo*SZSMPD,errcd1,abort)
      call galloc(mem_sum,n2*SZSMPD,errcd2,abort)
      call galloc(mem_work,n2*SZSMPD,errcd3,abort)
      call galloc(mem_ctr,2*n2*SZSMPD,errcd4,abort)

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 ) then
	write(LERR,*) 'ERROR: Unable to allocate workspace '
	write(LERR,*) nsampo*SZSMPD,' bytes requested '
	write(LERR,*) 3*n2*SZSMPD,' bytes requested '
	write(LERR,*) nsamp_in*SZSMPD,' bytes requested '
	write(LERR,*) 'FATAL'
	write(LER,*) 'AMPSPEC: Unable to allocate workspace '
	write(LER,*) nsampo*SZSMPD,' bytes requested '
	write(LER,*) 3*n2*SZSMPD,' bytes requested '
	write(LER,*) nsamp_in*SZSMPD,' bytes requested '
	write(LER,*) 'FATAL'
	stop 
      else
        write(LERR,*)'Allocating workspace:'
	write(LERR,*) nsampo*SZSMPD,' bytes requested '
	write(LERR,*) 3*n2*SZSMPD,' bytes requested '
	write(LERR,*) nsamp_in*SZSMPD,' bytes requested '
      endif

      call vclr ( sum, 1, n2 )
      call vclr ( work, 1, n2 )
      call vclr ( tri, 1, nsampo )

      do i = 1,n2
         ctr(i) = czero
      enddo

c  skip to start record

      call recskp(1,nrst-1,luin,ntrc,itr)

      DO JJ = nrst, nred

c  skip to start trace

         call trcskp(jj,1,nst-1,luin,ntrc,itr)

         DO KK = nst, ned
 
            nbytes = 0
            call rtape  ( luin , itr, nbytes  )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

            call saver2(itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER )
            call saver2(itr, ifmt_RecNum, l_RecNum, ln_RecNum, irec, 
     :           TRACEHEADER )
            if ( StaCor .ne. 30000 ) then

               call vmov (itr(ITHWP1+ist-1), 1, work, 1, nsamp_in)
               call vclr  (ctr, 1, n2)
               call vclr  (tri, 1, nsampo)

c do complex inplace fft outputting packed format

               call rfftb (work,ctr,n2,1)

               if ( MathAdvScaling ) then
c now scale and unpack to n2/2 + 1 estimates between DC and Nyquist
c by 1/(2N)

                  call rfftsc (ctr,n2,3,1)

c now compute amplitude spectrum

                  call cvabs  (ctr, 2, tri,  1, nsampo )

               else

                  call rfftsc (ctr,n2,3,0)

c now compute amplitude spectrum

                  call cvabs  (ctr, 2, tri,  1, nsampo )

c scale by 1/N rather than 1/(2N) done my Math Adv

                  do i = 1,nsampo
                     tri(i) = tri(i) / n2
                  enddo

               endif


c get the max value of each fft 

               call maxv(tri,1,smax,lc,nsampo)

c keep a running sum of the input

               do ik=1,nsampo
                  sum(ik)=sum(ik)+tri(ik)
               enddo

            endif

         ENDDO

c  skip to the end of current record: trace # ntrc

         call trcskp(jj,kk+1,ntrc,luin,ntrc,itr)

      ENDDO
      
      if(verbos) then
         write(LERR,*)'Output Record ',irec
      endif

      call maxv(sum,1,smax,lc,nsampo)

      if (norm .AND. smax .eq. 0.0) then
         write(LERR,*)'FATAL ERROR in ampspec normalization option:'
         write(LERR,*)'Normalization factor is zero indicating zero'
         write(LERR,*)'data. Check input data.'
         write(LER ,*)'FATAL ERROR in ampspec normalization option:'
         write(LER ,*)'Normalization factor is zero indicating zero'
         write(LER ,*)'data. Check input data.'
         go to 999
      endif

      vfreq=0.
      dfreq=((1./(2.*dt))/(float(n2)/2.))
      vfreq = 0.0 - dfreq

      do i=1,nsampo
         vfreq=vfreq+dfreq
         if(norm) then
            if ( db ) then 

c check for zeroes in spectrum

               if ( sum(i) .le. 1.e-32 ) then
                  zeroes = .true.
                  sum(i) = 1.e-32
               endif

               write(luout,*)vfreq, 20.0*log( sum(i)/smax)
            else
               write(luout,*)vfreq, sum(i)/smax
            endif
         else
            if ( db ) then 

c check for zeroes in spectrum

               if ( sum(i) .le. 1.e-32 ) then
                  zeroes = .true.
                  sum(i) = 1.e-32
               endif

               write(luout,*)vfreq, 20.0*log( sum(i) )
            else
               write(luout,*)vfreq, sum(i)
            endif
         endif
      enddo

      if (graph) then
         char1 = 'usp xgraph '
         char1(12:98) = otap
         char1(99:100) = ' &'
         call systemfu(char1)
      endif

      if ( zeroes ) then
         write(LERR,*)' hard zeroes were generated in the' 
         write(LERR,*)' spectrum.  They were set to 1.0e-32'
         write(LERR,*)' for the purposes of generating a spectrum'
         write(LERR,*)' in db.  To see the location of these'
         write(LERR,*)' zero samples drop the -db from your run'
         write(LER,*)' '
         write(LER,*)'AMPSPEC:'
         write(LER,*)' hard zeroes were generated in the' 
         write(LER,*)' spectrum.  They were set to 1.0e-32'
         write(LER,*)' for the purposes of generating a spectrum'
         write(LER,*)' in db.  To see the location of these'
         write(LER,*)' zero samples drop the -db from your run'
         write(LER,*)'WARNING'
         write(LER,*)' '
         write(LER,*)' '
         goto 999
      endif

      call lbclos(luin)
      close(luout)

      write(LERR,*)' '
      write(LERR,*)' Normal Termination '
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)' ampspec: Normal Termination '
      write(LER,*)' '
      stop

 999  continue

      write(LERR,*)' Abnormal Termination '
      write(LER,*)' ampspec: Abnormal Termination '

      call lbclos(luin)
      close (luout)

      stop

      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for AMPSPEC: '
        write(LER,*)'convert seismic traces to frequency (fft)'
        write(LER,*)'output an ascii file for graphing'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- start time                   (0 ms)'
        write(LER,*)'-e[iend]   -- end time                (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-P         -- normalize summation '
        write(LER,*)'-db        -- spectra in db              (linear)'
        write(LER,*)'-X         -- automatic xgraph          '

        write(LER,*)'-promax    -- scale forward transform by 1/N to '
        write(LER,*)'              promax amplitude spectrum values'
        write(LER,*)'              The default is to scale by 1/(2N)'
        write(LER,*)' '

        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'   ampspec -N[] -O[] -s[] -e[] -ns[] -ne[] '
        write(LER,*)'           -rs[] -re[] [-P] [-db] [-X] -promax -V'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1     verbos,norm,thresh,graph, db, MathAdvScaling )
c-----
c     get command arguments
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      real      thresh
      integer   argis,ist,iend,nst,ned,nrst,nred
      logical   verbos, norm,graph, db, MathAdvScaling, promax

           db = ( argis('-db') .gt. 0 )
           call argi4('-e',iend,0,0) 

           call argi4('-ne',ned,0,0)
           call argi4('-ns',nst,0,0)
           call argstr('-N',ntap,' ',' ')

           call argstr('-O',otap,' ',' ')

           promax = ( argis ( '-promax' ) .gt. 0 )
           norm   = ( argis( '-P' ) .gt. 0 )

           MathAdvScaling = .true.
           if ( promax ) MathAdvScaling = .false.

           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)

           call argi4('-s',ist,1,1)
 
           call argr4 ('-t',thresh, .0, .0)

           verbos = ( argis( '-V' ) .gt. 0 )

           graph   = ( argis( '-X' ) .gt. 0 )



c-----
      return
      end

      subroutine drum (lphz, phz)
      real      phz(*)
      integer   lphz
      pi = 180.

      pj = 0.
      do  40 i = 2, lphz

          if (abs(phz(i)+pj-phz(i-1))-pi) 40,40,10

10        if (phz(i)+pj-phz(i-1)) 20,40,30

20        pj = pj +  2*pi
          go to 40

30        pj = pj -  2*pi

40        phz(i) = phz(i) + pj

      return
      end

