C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes:

c  March 26, 2002
c     added -ssam flag to have counter provide output count in 
c     SSAM style.
c  Garossino
c
c     Program Description:
c
c     provide a count [on stderr] of records passing from stdin
c     to stdout, or alternately from input file to output file.
c

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     argis

      character   ntap*255, otap*255, name*7

c Program Specific _ static memory variables


      integer JJ, KK

      logical ssam

c Initialize variables

      data name/"COUNTER"/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ssam)

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'COUNTER: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 7, LERR)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap )

c BEGIN PROCESSING 


      DO JJ = 1, nrec

         DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call wrtape (luout, itr, obytes)

         ENDDO

         if ( ssam ) then
            write(LER,*)'Processed: Record ',JJ,' of ', nrec
         else
            write(LER,*)'Processed:  Record= ',JJ,'  Trace= ',KK-1
         endif
      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'counter: Normal Termination'
      write(LER,*)'counter: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'counter: ABNORMAL Termination'
      write(LER,*)'counter: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for COUNTER: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-ssam  -- use SSAM style counting '
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       counter -N[] -O[] [-ssam]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ssam )

#include <f77/iounit.h>

      integer argis

      character  ntap*(*), otap*(*)

      logical ssam

      call argstr ( '-N', ntap, ' ', ' ' ) 
      
      call argstr ( '-O', otap, ' ', ' ' ) 

      ssam =   (argis('-ssam') .gt. 0)
           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap)

#include <f77/iounit.h>


      character  ntap*(*), otap*(*)

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
