C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       EGMEDN                                               *
C  ROUTINE TYPE:  FUNCTION  REAL                                       *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      EGMEDN  REAL  (A,N)                                             *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (N) -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MOD     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c                                                                      *
c***********************************************************************
c  routine:       egmedn                                               *
c  routine type:  function  real                                       *
c  purpose:                                                            *
c     find the median value of the elements in array a.                *
c                                                                      *
c  entry points:                                                       *
c      egmedn  real  (a,n)                                             *
c  arguments:                                                          *
c      a       real     ??iou*  (n) -                                  *
c      n       integer  ??iou*      -                                  *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 86/03/12  *
c  language: fortran 77                  date last compiled: 87/01/20  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:                                         *
c      mod     generic -                                               *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      this function determines the median value of the elements       *
c      in array a.  it is used by eigencoding programs proj1, proj2,   *
c      and the versions of program eign (eign1, etc.).                 *
c                                                                      *
c  revised by:  bill done                     revision date: 86/03/12  *
c      installed on ibm.                                               *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      real function egmedn (a, n)
      dimension a(n)
      if (n .le. 1) then
         egmedn = a(1)
         return
       else if (n .eq. 2) then
         egmedn = 0.5*(a(1) + a(2))
         return
       else
         m = n/2 + 1
         do 200 j = 1, m
            l = j
            jj = j + 1
            do 100 i = jj, n
               if (a(l) .gt. a(i)) then
                  l = i
               endif
100         continue
            if (a(l) .ne. a(j)) then
               t = a(l)
               a(l) = a(j)
               a(j) = t
            endif
200      continue
         if (mod(n,2) .eq. 0) then
            egmedn = 0.5*(a(m) + a(m-1))
          else
            egmedn = a(m)
         endif
      endif
      return
      end
