C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       EIGN5B                                               *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      SECON1 -                                                        *
C      OPNLST -                                                        *
C      RDPARM -                                                        *
C      REVVAL -                                                        *
C      LBOPEN -                                                        *
C      RTAPE  -                                                        *
C      SAVER  -                                                        *
C      SAVEW  -                                                        *
C      HLHPRT -                                                        *
C      WRTAPE -                                                        *
C      VMOV   -                                                        *
C      VCLR   -                                                        *
C      RTRAIN -                                                        *
C      LBCLOS -                                                        *
C      REGION -                                                        *
C      LODC2W -                                                        *
C      LODW2Z -                                                        *
C      OLPTRN -                                                        *
C      DATOUT -                                                        *
C      RCOVAR -                                                        *
C      PRMTRX -                                                        *
C      RSEAA  -                                                        *
C      NORMLZ -                                                        *
C      ROBUST -                                                        *
C      ENCODE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUDISK  ( UPDATE SEQUENTIAL ) -                                 *
C      LUPRT   ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      1015     ( 1) -                                                 *
C      1020     ( 1) -                                                 *
C      1030     ( 1) -                                                 *
C      1040     ( 1) -                                                 *
C      1042     ( 1) -                                                 *
C      1044     ( 1) -                                                 *
C      1050     ( 1) -                                                 *
C      1320     ( 1) -                                                 *
C      1400     ( 1) -                                                 *
C      1420     ( 1) -                                                 *
C      1620     ( 1) -                                                 *
C      1640     ( 1) -                                                 *
C      2800     ( 1) -                                                 *
C      3800     ( 1) -                                                 *
C      3820     ( 1) -                                                 *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c  routine:       eign5b                                               *
c  routine type:  main                                                 *
c  purpose:                                                            *
c      implement a procedure to suppress coherent noise by analyzing   *
c      a training zone to extract the eigen structure of the noise     *
c      (signal).  this information is then used to encode a target     *
c      region from which the noise (signal) is to be eliminated.       *
c      the coding uses the eigenvectors of the training region.        *
c                                                                      *
c  entry points:  mainline entry                                       *
c  arguments:     none                                                 *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/25  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      secon1 -                                                        *
c      opnlst -                                                        *
c      rdparm -                                                        *
c      revval -                                                        *
c      lbopen -                                                        *
c      rtape  -                                                        *
c      saver  -                                                        *
c      savew  -                                                        *
c      hlhprt -                                                        *
c      wrtape -                                                        *
c      vmov   -                                                        *
c      vclr   -                                                        *
c      region -                                                        *
c      lodc2w -                                                        *
c      lodw2z -                                                        *
c      rtrain -                                                        *
c      olptrn -                                                        *
c      datout -                                                        *
c      rcovar -                                                        *
c      prmtrx -                                                        *
c      normlz -                                                        *
c      encode -                                                        *
c      robust -                                                        *
c      lbclos -                                                        *
c  intrinsic functions called:  none                                   *
c  files:                                                              *
c      luprt  ( output sequential ) -                                  *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      this program locates a trapezoidal window on seismic data.      *
c      inside the window, data points are vectorized by moving a       *
c      block in both directions (trace wise and time direction).       *
c      then the covariance matrix of this vector is calculated by      *
c      the conventional method.  one feature of the program is that    *
c      data points in each block can have special differences in the   *
c      trace direction or the time direction.                          *
c                                                                      *
c      the eigenstructure of the training data covariance matrix is    *
c      calculated using eigendecomposition software.  then this        *
c      eigenstructure is used for encoding another region of data      *
c      (the target region).  the program locates another trapezoidal   *
c      window on the target data and vectorizes the data by the same   *
c      block method that was used on training data. then by using the  *
c      hoteling transform, the target data is encoded.                 *
c                                                                      *
c      the difference between the original target data and the encoded *
c      target data is found.  this difference is also referred to as   *
c      the residual.  using the above procedure, the covariance matrix *
c      of the residual is used to encode the residual data.  this      *
c      step is for noise cancellation.                                 *
c                                                                      *
c      input data will be read from data file "rdata" or data file     *
c      "cdata", depending on whether using the real data or analytic   *
c      data option, respectively.                                      *
c                                                                      *
c      in this program the results are recorded as:                    *
c        record 1 -- contains the data from the training region;       *
c        record 2 -- contains the encoded training data;               *
c        record 3 -- contains the data from the target region;         *
c        record 4 -- contains the encoded target data;                 *
c        record 5 -- contains difference between the target data and   *
c                    the encoded target data;                          *
c        record 6 -- contains the encoded residual data.               *
c                                                                      *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      this program is a revision of eign5a.  the processing option    *
c      of selecting analytic (complex data) has been eliminated.       *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      add timing and operation count for testing optimization.        *
c                                                                      *
c  revised by:  bill done                     revision date: 87/09/04  *
c      when loading traces, if trace is dead, load zeros into array.   *
c                                                                      *
c  revised by:  bill done                     revision date: 88/01/11  *
c      save covariance matrix into array cvrsav for use later in       *
c      robust encoding.                                                *
c                                                                      *
c  revised by:  bill done                     revision date: 88/02/17  *
c      eliminate eispack eigendecomposition routines and substitute    *
c      math advantage.  make qtc routine correspond to decomp=1 case.  *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/09  *
c      add facility for writing eigenvalues/vectors to a file or       *
c      reading them from a file (training region only).                *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/29  *
c      replace call ccexit with stop.  replace call move with qtc      *
c      call vmov or vclr.  change trace header (ix) and trace data     *
c      (rx) equivalencing:  ix(ithwp1) = rx(1).  use in-line parameter *
c      reading option (in rdparm).  use output listing procedure       *
c      openpr where all sysout from a job is placed in one output      *
c      file, properly sorted by job.  startjob must be used to run     *
c      scripts using the in-line parameter reading and output listing  *
c      features.                                                       *
c                                                                      *
c  revised by:  bill done                     revision date: 88/04/05  *
c      add include files to establish line and trace header sizes      *
c      (hdrsize.h) and logical unit definitions (ludefs.h).            *
c                                                                      *
c  revised by:  bill done                     revision date: 88/04/20  *
c      add code to allow the training zone to be redefined as a        *
c      function of record number.                                      *
c                                                                      *
c  revised by:  bill done                     revision date: 88/08/29  *
c      add code to write historical line header information.           *
c                                                                      *
c  revised by:  bill done                     revision date: 92/12/08  *
c      completely eliminate reference to old eigrs eispack routine.    *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
      program eign5b
c
#include <localsys.h>
#include <f77/LUDefs.h>
#include <f77/HeaderSize.h>
c
c     set up line and trace header arrays and trace data array
c
      parameter (mxnspt = 6000, mxtrac = 150)
      parameter (mxdata = mxnspt*mxtrac, mxzbuf = mxdata)
      parameter (mxtrbf = 4*mxtrac, mxhbuf = itrwrd*mxtrbf)
      integer*2 ix(ithwp1), itrh(mxhbuf)
      integer   nlh(1500)
      real rx(mxnspt)
      equivalence (ix(ithwp1),rx(1))
c
c     set up data block sizes and data block storage
c
      parameter (mxbltr = 5, mxbltm = 5)
      parameter (mxblok = mxbltm*mxbltr, mxblsq = mxblok*mxblok)
      parameter (mxblx3 = 3*mxblok)
      parameter (mxdbuf = 3000000, mxidbl = mxnspt)
c
c     set up work space
c
      parameter (mxwork = 6500)
      dimension iwork(mxwork), work(mxwork)
c
      logical roben1, roben2, lddata
      logical embed, outdat(7)
      logical prtvmn, prtcov, prtvec, prtwin, doreal
      logical gtrain, gtargt
      real a(mxdata), c(mxnspt)
      integer idblk1(mxidbl,3), idblk2(mxidbl,3)
      integer biwet1, biwet2
      integer outopt, outrec
      integer ipsrc(4,2), iptar(4,2), nevptr(mxblok), nevpdf(mxblok)
      real egnval(mxblok), runsum(mxblok), dom(mxblx3)
c
      real zout(mxzbuf)
      integer zcount(mxzbuf)
c
      real dvmean(mxblok), y(mxblok)
      real dblock(mxdbuf)
      real dvcvar(mxblsq), cvrsav(mxblsq), egnvec(mxblsq)
c
c      common block arrays timing marks
c
c      real           clocks(100)    , ops(100)
c      common /timer/ clocks         , ops
c
c     historical line header arrays
c
      character lharr1 * 34, lharr2 * 35, lharr3 * 35
c
c     cray path definitions
c
      logical verbos
      character*120 ntap, otap, cfile, evfile
      character*4 cardid
      data cardid /'EIGN'/
c
      data lharr1 /'EIGN -- coherent noise suppression'/
      data lharr2 /'   -C                              '/
      data lharr3 /'   -N                              '/
      data lhlen1, lhlen2, lhlen3 /34,35,35/
c
      data prtwin /.false./
      data prtvmn,prtcov,prtvec /.false.,.false.,.false./
      data doreal /.true./
      data jobn /11/
      data outdat /7*.false./
      data gtrain, gtargt /2*.true./
c     do 1 j=1,100
c        clocks(j) = 0.
c        ops   (j) = 0.
c   * continue
c
c     start timing, total program
c
      call secon1 (cputo0, wallo0)
c
c     set up file to receive program run information
c
      call opnlst (LUPRT, LUER, LUPPRT, cardid)
c
c     print program name and version
c
      write (luprt,1000)
 1000 format(////' Program eign, version eign5b'//)
c
c     get input processing parameters
c
      call rdparm (luso  , luprt , lucard, mxblok, ntap  , otap  ,
     *             cfile , ipropt, embed , outopt, biwet1, biwet2,
     *             itr   , itm   , itrdel, itmdel, laptr , laptm ,
     *             scattr, ipsrc , iptar , nevtar, nevptr, nevdif,
     *             nevpdf, inirec, lstrec, ltrain, evfile, verbos)
c
c     compute the number of data samples in an analysis block
c
      mblsiz = itr*itm
      mblsq = mblsiz**2
      mxdblk = mxdbuf/mblsiz
c
c     reverse the order of the elements in vectors nevptr and nevpdf
c
      call revval (mblsiz, nevtar, nevptr)
      call revval (mblsiz, nevdif, nevpdf)
c
c     print maximum data size summary
c
      write (luprt,1010) mxnspt, mxtrac, mxdata, mxdblk, mxblok
 1010 format(///' Data size restrictions:'/
     *       '       maximum samples per trace:  ',i8/
     *       '        maximum number of traces:  ',i8/
     *       '  maximum samples--trace product:  ',i8/
     *       '   maximum number of data blocks:  ',i8/
     *       '         maximum data block size:  ',i8/)
c
c     set robust encoding flags
c
      if ((biwet1 .ge. 6) .and. (biwet1 .le. 9)) then
         roben1 = .true.
       else
         roben1 = .false.
      endif
      if ((biwet2 .ge. 6) .and. (biwet2 .le. 9)) then
         roben2 = .true.
       else
         roben2 = .false.
      endif
c
c     open input tape
c
      if (ntap .ne. ' ') then
c
c        open input for data from a file
c
         call lbopen (luntap, ntap, 'r')
         write (luprt,1012) ntap
 1012    format(/' Input file name:  ',a120)
       else
c
c        open input for data from a pipe
c
         luntap = 0
         write (luprt,*) ' Input file name:  from pipe'
      endif
c
c     check for proper input unit number
c
      if (luntap .lt. 0) then
         write (luprt,1015) luntap
 1015    format(/' Could not open unit ',i3,' for input.'/)
         stop 1015
      endif
c
c     read input line header and check input tape requirements
c
      lbytes = 0
      call rtape (luntap, nlh, lbytes)
c
c         check for successful read
c
      if (lbytes .eq. 0) then
         write (luprt,1020)
 1020    format (//' -EOF encountered attempting to read input tape'/
     *           ' lineheader'/' -Execution terminated'//)
         stop 1020
      endif
c
c     define parameters from input line header
c
      call saver (nlh, 'NumTrc', ntpr , linhed)
      call saver (nlh, 'NumRec', nrecs, linhed)
      call saver (nlh, 'NumSmp', nspt , linhed)
      call saver (nlh, 'Format', iform, linhed)
      write (luprt,1025) nrecs, ntpr, nspt
 1025 format(/' Input data summary:'/5x,i5,' records'/5x,i5,
     *       ' traces per record'/5x,i5,' samples per trace'//)
c
c         input data must be format 3
c
      if (iform .ne. 3) then
         write (luprt,1030)
 1030    format (//' -Input tape is not sis format 3'/,
     *           ' -execution terminated'//)
         stop 1030
      endif
c
c     check that input data trace length is within program limitation
c
      if (nspt .gt. mxnspt) then
         write (luprt,1040) mxnspt
 1040    format (//' -No. of samples/trace on input tape is greater',
     *           ' than ',i5/' -Execution terminated'//)
         stop 1040
      endif
c
c     define ntrace from ntpr, which is number of traces per record
c     from lineheader.  check that proceduct of samples per trace
c     and number of traces is within maximum.
c
      ntrace = ntpr
      if (ntrace .gt. mxtrbf) then
         write (luprt,1042) ntrace, mxtrbf
 1042    format (//' -Number of traces/record ',i4,' exceeds maximum'/
     *           ' allowed for trace header storage, ',i4//)
         stop 1042
      endif
      if ((nspt*ntrace) .gt. mxdata) then
         write (luprt,1044) mxdata
 1044    format (//' -Samples/trace -- traces/record product exceeds',
     *           ' maximum ',i5/' -Execution terminated'//)
         stop 1044
      endif
      mbytes = iszbyt*nspt
      nbytes = mbytes + iszbyt*itrwrd
c
c     build output line header
c
      call savew (nlh, 'NumTrc', ntrace, linhed)
c
c     set number of records in output data set
c
      if ((ipropt .eq. 0) .or. (ipropt .eq. 1)) then
         if ((inirec .eq. 1) .and. (lstrec .eq. 99999)) then
            irtemp = nrecs
          else
            irtemp = lstrec - inirec + 1
         endif
       else
         if (outopt .eq. 0) then
            if (nevdif .gt. 0) then
               irtemp = 6
             else
               irtemp = 5
            endif
          else if (outopt .eq. 7) then
            irtemp = 2
          else
            irtemp = 1
         endif
      endif
      call savew (nlh, 'NumRec', irtemp, linhed)
      call savew (nlh, 'NumSmp', nspt  , linhed)
c
c     using outopt parameter, set output flags to control which
c     output arrays are written to disk
c
      if (outopt .eq. 0) then
         do 100 i = 1, 6
            outdat(i) = .true.
  100    continue
       else
         outdat(outopt) = .true.
      endif
c
c     open output file
c
      if (otap .ne. ' ') then
c
c        open output for data to a file
c
         call lbopen (luotap, otap, 'w')
         write (luprt,1046) otap
 1046    format(/' Output file name:  ',a120)
       else
c
c        open output for data to a pipe
c
         luotap = 1
         write (luprt,*) ' Output file name:  to a pipe'
      endif
c
c     check for proper output unit number
c
      if (luotap .lt. 0) then
         write (luprt,1050) luotap
 1050    format(/' Could not open unit ',i3,' for output.'/)
         stop 1050
      endif
c
c     store new information in historical line header
c
      if (cfile .eq. ' ') then
         lharr2(6:20) = '(in-line cards)'
       else
         lharr2(6:35) = cfile
      endif
      if (ntap .eq. ' ') then
         lharr3(6:13) = '(from a pipe)'
       else
         lharr3(6:35) = ntap
      endif
      write (luprt,1055)
 1055 format(///)
      call hlhprt (nlh, lbytes, lharr1, lhlen1, luprt)
      call hlhprt (nlh, lbytes, lharr2, lhlen2, luprt)
      call hlhprt (nlh, lbytes, lharr3, lhlen3, luprt)
c     call savhlh (nlh, lbytes, lbyteo)
c     lbytes = lbyteo
      write (luprt,1055)
      call wrtape (luotap, nlh, lbytes)
c
c     write the name of evfile (associated with -e flag)
c
      if (verbos .and. (evfile .ne. ' ')) then
         if (ipropt .eq. 1) write (luprt,1060) evfile
 1060    format(/' Read training eigenstructure from file name:'/5x,a31)
         if (ipropt .eq. 2) write (luprt,1065) evfile
 1065    format(/' Write training eigenstructure to file name:'/5x,a31)
      endif
c
c     begin reading input data and processing
c
  120 lddata = .false.
      do 130 j = 1, ntrace
         jm1 = j - 1
  125    ibytes = 0
         call rtape (luntap, ix, ibytes)
c
c        check for successful read
c
         if (ibytes .eq. 0) then
            write (luprt,1250)
 1250       format(//' -EOF encountered attempting to read input tape'/
     *             ' -Execution terminated')
            go to 800
         endif
c
c        get record and trace number and compare to start data
c        values inirec and trace number = 1.  once loading
c        begins, ntrace consecutive traces are loaded.
c
c>>      jrec = ix(106)
c>>      jtrc = ix(107)
         call saver (ix, 'RecNum', jrec, trched)
         call saver (ix, 'TrcNum', jtrc, trched)
         if (.not. lddata) then
            if ((jrec .ge. inirec) .and. (jtrc .ge. 1))
     *          lddata = .true.
         endif
         if (lddata) then
c
c           move header into header buffer.
c
c>>         call move (1, itrh((jm1*128)+1), ix, 8*128)
            call vmov (ix, 1, itrh((jm1*itrwrd)+1), 1, itrwrd)
c
c           move data into data buffer (if trace is dead,
c           zero the trace).
c
c>>         istatc = ix(125)
            call saver (ix, 'StaCor', istatc, trched)
            if (istatc .eq. 30000) then
c>>            call move (0, a((jm1*nspt)+1), 0    , mbytes)
               call vclr (a((jm1*nspt)+1), 1, nspt)
             else
c>>            call move (1, a((jm1*nspt)+1), rx(1), mbytes)
               call vmov (rx(1), 1, a((jm1*nspt)+1), 1, nspt)
            endif
          else
            go to 125
         endif
  130 continue
      write (luprt,1300) jrec, jtrc
 1300 format(//' Data loaded:  record ',i5,', traces 1 to ',i5)
c
c     training region flag:  gtrain
c        if gtrain is currently false and the current record
c        number jrec exceeds ltrain (the last record for which
c        this training region applies), read a new set of training
c        region vertices.
c
      if ((.not. gtrain) .and. (jrec .gt. ltrain)) then
         gtrain = .true.
         call rtrain (luprt, lucard, jrec, ipsrc, ltrain, ierr)
         if (ierr .ne. 0) then
            write (luprt,1320) ierr
 1320       format(//' Terminating processing:  rtrain error = ',i5/
     *             ' closing data files to save processing to',
     *             ' this point'/)
            close (LUDISK)
            call lbclos (luntap)
            call lbclos (luotap)
            stop 1320
         endif
      endif
c
c     get training region eigenstructure
c
      if (ipropt .eq. 1) then
         if (gtrain) then
            gtrain = .false.
c
c           get training eigenstructure from file evfile
c
            open (LUDISK, file=evfile, status='OLD', form='FORMATTED',
     *            iostat=ios)
            if (ios .ne. 0) then
               write (luprt,1400) evfile
 1400          format(/' Error opening input eigenvector file:'/
     *                1x,a79//)
               stop 1400
            endif
            read (LUDISK,*) mblsrd
            if (mblsrd .ne. mblsiz) then
               write (luprt,1420) mblsrd, mblsiz
 1420          format(/' Block size = ',i4,' in eigenvector file',
     *                ' does not match block size = ',i4/' specified',
     *                ' for this analysis.  Check eigenvector',
     *                ' filename.'//)
               stop 1420
            endif
            read (LUDISK,1440) (egnval(i), i = 1, mblsiz)
 1440       format(4(1x,1pe19.11))
            read (LUDISK,1440) (egnvec(i), i = 1, mblsq)
c
c           compute running sum of eigenvalues from largest to
c           smallest.  order reversal of nevptr accounted for in the
c           write statement.
c
            if (verbos) then
               runsum(mblsiz) = egnval(mblsiz)
               do 150 ii = mblsiz-1, 1, -1
                  runsum(ii) = runsum(ii+1) + egnval(ii)
  150          continue
               summax = runsum(1)
               write (luprt,1500) evfile, summax
 1500          format(/' Training region:  normalized running sum of',
     *                ' eigenvalues from file'/19x,a31/
     *                19x,'sum of eigenvalues = ',1pe15.8)
               do 160 ii = 1, mblsiz
                  irev = mblsiz + 1 - ii
                  runsum(irev) = runsum(irev)/summax
                  write (luprt,3350) ii, egnval(irev), runsum(irev)
  160          continue
            endif
         endif
       else
         if (gtrain) then
            gtrain = .false.
c
c           locate window on training region
c
            call region (luprt , nspt  , ntrace, itm   , itr   , itmdel,
     *                   itrdel, laptm , laptr , scattr, ipsrc , idblk1,
     *                   mxidbl, iblk1 , nblok1, prtwin)
            if (verbos) write (luprt,1600) iblk1, nblok1
 1600       format(/' Training region data blocks:  iblk1 = ',i5,5x,
     *             'nblok1 = ',i5)
            if (iblk1 .eq. 0) then
               write (luprt,1620)
 1620          format(//' The training region vertices are not'/
     *                ' selected appropriately.')
               stop 1620
            endif
            if (nblok1 .gt. mxdblk) then
               write (luprt,1640) nblok1, mxdblk
 1640          format(//' Number of training zone data blocks = ',i5,
     *                ' exceeds allowed data blocks = ',i5)
               stop 1640
            endif
         endif
c
c        move the training data from array a into the data block
c        array dblock
c
         iop = 0
         call lodc2w (iop   , mxidbl, idblk1, a     , nspt  , ntrace,
     *                iblk1 , itr   , itrdel, laptr , itm   , itmdel,
     *                nblok1, mblsiz, dblock, nbltot)
c
c        move the training data from array dblock into output array zout
c
         call lodw2z (embed , mxidbl, idblk1, iblk1 , itr   , itrdel,
     *                laptr , itm   , itmdel, nblok1, mblsiz, dblock,
     *                nspt  , ntrace, a     , zout  , nbltot, zcount)
c
c        if outdat(7) = 7, load training region weight pattern into
c        output array
c
         if (outdat(7)) then
            write (luprt,2400)
 2400       format(//' Training region:  load data block pattern')
            call olptrn (luprt, zcount, zout, nspt, ntrace)
            outrec = 1
            write (luprt,2420) outrec
 2420       format(/' Data output:  training region weighting, ri = ',
     *             i5)
            call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                   ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                   zout  , datmx7)
         endif
c
c        write output array to disk:  training data
c
         if (outdat(1)) then
            if (outopt .eq. 0) then
               outrec = 1
             else
               outrec = jrec
            endif
            write (luprt,2480) outrec
 2480       format(/' Data output:  training region, ri = ',i5)
            call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                   ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                   zout  , datmx1)
         endif
c
c        calculate mean and covariance matrix of training data.
c        save covariance into array cvrsav.
c
         call rcovar (nblok1, mblsiz, dblock, dvmean, dvcvar)
c>>      call move (1, cvrsav, dvcvar, 8*mblsq)
         call vmov (dvcvar, 1, cvrsav, 1, mblsq)
         if (verbos) write (luprt,2500) nblok1
 2500    format(/' Number of samples used for covariance matrix'/
     *          '   calculation in the training data is ',i5)
         if (prtvmn) then
            write (luprt,2600)
 2600       format(/' Mean of training data:')
            do 270 ii = 1, mblsiz
               write (luprt,2650) dvmean(ii)
 2650          format(5x,1pe15.8)
  270       continue
         endif
         if (prtcov) then
            write (luprt,2700)
 2700       format(/' Covariance of training data:')
            call prmtrx (luprt, mblsiz, dvcvar)
         endif
c
c        calculate eigenstructure of training data
c
         call rseaa (mblsiz, mblsiz, dvcvar, egnval, egnvec, dom,
     *               ier)
c
c        normalize eigenvectors of training data
c
         call normlz (mblsiz, egnvec)
c
c        write eigenvalues/vectors to file evfile
c
         if ((ipropt .eq. 2) .and. (evfile .ne. ' ')) then
            open (LUDISK, file=evfile, status='NEW', form='FORMATTED',
     *            iostat=ios)
            if (ios .ne. 0) then
               write (luprt,2800) evfile
 2800          format(/' Error opening output eigenvector file:'/
     *                1x,a79//)
               stop 2800
            endif
            if (verbos) write (luprt,2810) evfile
 2810       format(/' Write eigenvalues/eigenvectors to file:'/5x,a31)
            write (LUDISK,*) mblsiz
            write (LUDISK,2820) (egnval(i), i = 1, mblsiz)
 2820       format(4(1x,1pe19.11))
            write (LUDISK,2820) (egnvec(i), i = 1, mblsq)
         endif
c
c        compute running sum of eigenvalues from largest to smallest.
c        order reversal of nevptr accounted for in the write statement.
c
         if (verbos) then
            runsum(mblsiz) = egnval(mblsiz)
            do 330 ii = mblsiz-1, 1, -1
               runsum(ii) = runsum(ii+1) + egnval(ii)
  330       continue
            summax = runsum(1)
            write (luprt,3300) summax
 3300       format(/' Training region:  eigenvalues, normalized ',
     *             'running sum'/19x,'sum of eigenvalues = ',1pe15.8)
            do 340 ii = 1, mblsiz
               irev = mblsiz + 1 - ii
               runsum(irev) = runsum(irev)/summax
               write (luprt,3350) ii, egnval(irev), runsum(irev)
 3350          format(5x,i3,':  ',1pe15.8,5x,0pf7.4)
  340       continue
         endif
         if (prtvec) then
            write (luprt,3400)
 3400       format(/' Eigenvectors of the covariance matrix:  training')
            call prmtrx (luprt, mblsiz, egnvec)
         endif
c
c        encode training region by using major eigenvectors
c        of training covariance matrix, move encoded training data
c        into output array zout, and write to disk.  this is only
c        done if outdat(2) is true.
c
         if (outdat(2)) then
            if (verbos) then
               write (luprt,3500) nevtar, mblsiz
 3500          format(/' Encoding training region:'/
     *             5x,'use ',i5,' out of ',i5,' eigenvectors to encode.'
     *             /5x,'Eigenvectors used for encoding (order 1 has ',
     *             'largest eigenvalue):')
               write (luprt,3600) (mblsiz+1-nevptr(ii), ii = 1, nevtar)
 3600          format(5x,10i5)
            endif
            if (roben1) then
c>>            call move (1, dvcvar, cvrsav, 8*mblsq)
               call vmov (dvcvar, 1, cvrsav, 1, mblsq)
               call robust (luprt , nblok1, mblsiz, dblock, dvcvar,
     *                      dvmean, egnvec, egnval, nevptr, nevtar,
     *                      biwet1)
             else
               call encode (mblsiz, nblok1, nevtar, nevptr, dvmean,
     *                      y     , egnvec, dblock)
            endif
            call lodw2z (embed , mxidbl, idblk1, iblk1 , itr   , itrdel,
     *                   laptr , itm   , itmdel, nblok1, mblsiz, dblock,
     *                   nspt  , ntrace, a     , zout  , nbltot, zcount)
            if (outopt .eq. 0) then
               outrec = 2
             else
               outrec = jrec
            endif
            write (luprt,3680) outrec
 3680       format(/' Data output:  encoded training region, ri = ',i5)
            call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                   ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                   zout  , datmx2)
         endif
      endif
c
c     locate window on target region
c
      if (gtargt) then
         gtargt = .false.
         call region (luprt , nspt  , ntrace, itm   , itr   , itmdel,
     *                itrdel, laptm , laptr , scattr, iptar , idblk2,
     *                mxidbl, iblk2 , nblok2, prtwin)
         if (verbos) write (luprt,3700) iblk2, nblok2
 3700    format(/' Target region data blocks:  iblk2 = ',i5,5x,
     *          'nblok2 = ',i5)
         if (iblk2 .eq. 0) then
            write (luprt,3800)
 3800       format(//' The target region vertices are not'/
     *             ' selected appropriately.'//)
            stop 3800
         endif
         if (nblok2 .gt. mxdblk) then
            write (luprt,3820) nblok2, mxdblk
 3820       format(//' Number of target zone data blocks = ',i5,
     *             ' exceeds allowed data blocks = ',i5)
            stop 3820
         endif
      endif
c
c     move the target data from array a into the work array dblock
c
      iop = 0
      call lodc2w (iop   , mxidbl, idblk2, a     , nspt  , ntrace,
     *             iblk2 , itr   , itrdel, laptr , itm   , itmdel,
     *             nblok2, mblsiz, dblock, nbltot)
c
c     move the target data from array dblock into output array zout.
c
      call lodw2z (embed , mxidbl, idblk2, iblk2 , itr   , itrdel,
     *             laptr , itm   , itmdel, nblok2, mblsiz, dblock,
     *             nspt  , ntrace, a     , zout  , nbltot, zcount)
c
c     if outdat(7) = 7, load target region weight pattern into
c     output array
c
      if (outdat(7)) then
         write (luprt,3900)
 3900    format(//' Target region:  load data block pattern')
         call olptrn (luprt, zcount, zout, nspt, ntrace)
         outrec = 2
         write (luprt,3920) outrec
 3920    format(/' Data output:  target region weighting, ri = ',i5)
         call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                zout  , datmx7)
      endif
c
c     write output array to disk:  target data
c
      if (outdat(3)) then
         if (outopt .eq. 0) then
            outrec = 3
          else
            outrec = jrec
         endif
         write (luprt,3940) outrec
 3940    format(/' Data output:  target region, ri = ',i5)
         call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                zout  , datmx3)
      endif
c
c     encode target region with training principle eigenvectors
c
      if (verbos) then
  400    write (luprt,4000) nevtar, mblsiz
 4000    format(/' Encoding target region:'/
     *          5x,'use ',i5,' out of ',i5,' eigenvectors to encode.'/
     *          5x,'Eigenvectors used for encoding (order 1 has ',
     *          'largest eigenvalue):')
         write (luprt,3600) (mblsiz+1-nevptr(ii), ii = 1, nevtar)
      endif
      if (roben1) then
c>>      call move (1, dvcvar, cvrsav, 8*mblsq)
         call vmov (dvcvar, 1, cvrsav, 1, mblsq)
         call robust (luprt , nblok2, mblsiz, dblock, dvcvar, dvmean,
     *                egnvec, egnval, nevptr, nevtar, biwet1)
       else
         call encode (mblsiz, nblok2, nevtar, nevptr, dvmean, y     ,
     *                egnvec, dblock)
      endif
c
c     move the encoded target data from array dblock into
c     output array zout.
c
      call lodw2z (embed , mxidbl, idblk2, iblk2 , itr   , itrdel,
     *             laptr , itm   , itmdel, nblok2, mblsiz, dblock,
     *             nspt  , ntrace, a     , zout  , nbltot, zcount)
c
c     write output array to disk:  encoded target data
c
      if (outdat(4)) then
         if (outopt .eq. 0) then
            outrec = 4
          else
            outrec = jrec
         endif
         write (luprt,4020) outrec
 4020    format(/' Data output:  encoded target region, ri = ',i5)
         call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                zout  , datmx4)
      endif
c
c     move the residual (target minus encoded target) data from array
c     a into the data block array dblock.
c
      if (verbos) write (luprt,4500)
 4500 format(/' Compute target region residual')
      iop = 1
      call lodc2w (iop   , mxidbl, idblk2, a     , nspt  , ntrace,
     *             iblk2 , itr   , itrdel, laptr , itm   , itmdel,
     *             nblok2, mblsiz, dblock, nbltot)
c
c     move the residual data from array dblock into output array zout.
c
      call lodw2z (embed , mxidbl, idblk2, iblk2 , itr   , itrdel,
     *             laptr , itm   , itmdel, nblok2, mblsiz, dblock,
     *             nspt  , ntrace, a     , zout  , nbltot, zcount)
c
c     write output array to disk:  residual
c
      if (outdat(5)) then
         if (outopt .eq. 0) then
            outrec = 5
          else
            outrec = jrec
         endif
         write (luprt,4520) outrec
 4520    format(/' Data output:  residual, ri = ',i5)
         call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                zout  , datmx5)
      endif
c
c     if nevdif is greater than 0, perform analysis and encoding on
c     residual
c
      if (nevdif .gt. 0) then
         if (verbos) write (luprt,4800)
 4800    format(//' Analysis of target region residual.')
c
c        calculate mean and covariance matrix of target region residual
c
         call rcovar (nblok2, mblsiz, dblock, dvmean, dvcvar)
c>>      call move (1, cvrsav, dvcvar, 8*mblsq)
         call vmov (cvrsav, 1, dvcvar, 1, mblsq)
         if (verbos) write (luprt,4900) nblok2
 4900    format(/' Number of samples used for covariance matrix'/
     *          '   calculation in the target region is ',i5)
         if (prtvmn) then
            write (luprt,5000)
 5000       format(/' Mean of target region residual:')
             do 510 ii = 1, mblsiz
                write (luprt,2650) dvmean(ii)
  510        continue
         endif
         if (prtcov) then
            write (luprt,5300)
 5300       format(/' Covariance of target region residual:')
            call prmtrx (luprt, mblsiz, dvcvar)
         endif
c
c        calculate eigenstructure of residual target covariance matrix
c
         call rseaa (mblsiz, mblsiz, dvcvar, egnval, egnvec, dom,
     *               ier)
c
c        normalize eigenvectors of residual target data
c
         call normlz (mblsiz, egnvec)
c
c         compute running sum of eigenvalues from largest to smallest.
c         order reversal of nevpdf accounted for in the write statement.
c
         if (verbos) then
            runsum(mblsiz) = egnval(mblsiz)
            do 560 ii = mblsiz-1, 1, -1
               runsum(ii) = runsum(ii+1) + egnval(ii)
  560       continue
            summax = runsum(1)
            write (luprt,5700) summax
 5700       format(/' Target region residual:  eigenvalues, ',
     *             'normalized running sum'/19x,'sum of eigenvalues',
     *             ' = ',1pe15.8)
            do 580 ii = 1, mblsiz
               irev = mblsiz + 1 - ii
               runsum(irev) = runsum(irev)/summax
               write (luprt,3350) ii, egnval(irev), runsum(irev)
  580       continue
         endif
         if (prtvec) then
            write (luprt,5800)
 5800       format(/' Eigenvectors of covariance matrix:  residual')
            call prmtrx (luprt, mblsiz, egnvec)
         endif
         if (verbos) then
  600       write (luprt,6000) nevdif, mblsiz
 6000       format(/' Encoding target residual:'/
     *             5x,'use ',i5,' out of ',i5,' eigenvectors to ',
     *             'encode.'/5x,'eigenvectors used for encoding ',
     *             '(order 1 has largest eigenvalue):')
            write (luprt,3600) (mblsiz+1-nevpdf(ii), ii = 1, nevdif)
         endif
c
c        encode target region residual by using major eigenvectors
c        of residual target covariance matrix
c
         if (roben2) then
c>>         call move (1, dvcvar, cvrsav, 8*mblsq)
            call vmov (dvcvar, 1, cvrsav, 1, mblsq)
            call robust (luprt , nblok2, mblsiz, dblock, dvcvar, dvmean,
     *                   egnvec, egnval, nevpdf, nevdif, biwet2)
          else
            call encode (mblsiz, nblok2, nevdif, nevpdf, dvmean, y     ,
     *                   egnvec, dblock)
         endif
c
c        move the encoded residual data from array dblock into
c        output array zout, encoded residual data
c
         call lodw2z (embed , mxidbl, idblk2, iblk2 , itr   , itrdel,
     *                laptr , itm   , itmdel, nblok2, mblsiz, dblock,
     *                nspt  , ntrace, a     , zout  , nbltot, zcount)
c
c        write output array to disk:  encoded residual
c
         if (outdat(6)) then
            if (outopt .eq. 0) then
                outrec = 6
              else
                outrec = jrec
            endif
            write (luprt,6020) outrec
 6020       format(/' Data output:  encoded residual, ri = ',i5)
            call datout (luprt , luotap, itrwrd, nbytes, mxhbuf, itrh  ,
     *                   ix    , mxnspt, rx(1) , nspt  , ntrace, outrec,
     *                   zout  , datmx6)
         endif
      endif
c
c     check current record against last record to process and
c     exit if through
c
      if (jrec .lt. lstrec) go to 120
c
c     close i/o data channels
c
  800 write (luprt,8600)
 8600 format(//' Program terminated normally'//)
      close (LUDISK)
      call lbclos (luntap)
      call lbclos (luotap)
c
c     end timing, total program (outer timing loop)
c
      call secon1 (cputo1, wallo1)
      cputo = cputo1 - cputo0
      wallo = wallo1 - wallo0
      write (luprt,8800) cputo, wallo
 8800 format(//' Timing:  outer loop'/5x,' total cpu = ',
     *       f12.3/5x,'wall clock = ',f12.3)
c
c     print out timing marks
c
c     do 890 j=1,100
c        ops(j)=ops(j)/1000000.
c 890 continue
c     write(luprt,*   )' '
c     write(luprt,*   )'timing marks as computed by clocks and ops'
c     write(luprt,*   )'e5acvr:'
c     write(luprt,910)'saxpy     ',clocks( 1),ops( 1),ops( 1)/clocks( 1)
c     write(luprt,910)'cvcsma 1  ',clocks( 2),ops( 2),ops( 2)/clocks( 2)
c     write(luprt,910)'cvcsma 2  ',clocks( 3),ops( 3),ops( 3)/clocks( 3)
c     write(luprt,*   )'e5aenc:'
c     write(luprt,910)'y(k)doloop',clocks( 4),ops( 4),ops( 4)/clocks( 4)
c     write(luprt,910)'cvcsma    ',clocks( 5),ops( 5),ops( 5)/clocks( 5)
c     write(luprt,*   )'e5anrm:'
c     write(luprt,910)'100 loop  ',clocks( 6),ops( 6),ops( 6)/clocks( 6)
c     write(luprt,910)'200 loop  ',clocks( 7),ops( 7),ops( 7)/clocks( 7)
c     write(luprt,910)'e5anrm all',clocks( 8),ops( 8),ops( 8)/clocks( 8)
c     write(luprt,*   )'e5alwz:'
c     write(luprt,910)' 40 loop  ',clocks( 9),ops( 9),ops( 9)/clocks( 9)
c     write(luprt,910)' 80 loop  ',clocks(10),ops(10),ops(10)/clocks(10)
c     write(luprt,910)'100 loop  ',clocks(11),ops(11),ops(11)/clocks(11)
c     write(luprt,*   )'e5aout:'
c     write(luprt,895)'call maxv ',clocks(12),ops(12),ops(12)/clocks(12)
c 895 format(1x,a10,5x, f14.2,' secs', f14.2,' ops', f10.5,' mflops')
c
  900 stop
      end
