C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ENCODE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ENCODE  (MBLSIZ,NDBLOK,NEV,NEVP,DVMEAN,Y,EGNVEC,DBLOCK)         *
C  ARGUMENTS:                                                          *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      NDBLOK  INTEGER  ??IOU*                  -                      *
C      NEV     INTEGER  ??IOU*                  -                      *
C      NEVP    INTEGER  ??IOU*  (MBLSIZ)        -                      *
C      DVMEAN  REAL     ??IOU*  (MBLSIZ)        -                      *
C      Y       REAL     ??IOU*  (MBLSIZ)        -                      *
C      EGNVEC  REAL     ??IOU*  (MBLSIZ,MBLSIZ) -                      *
C      DBLOCK  REAL     ??IOU*  (MBLSIZ,NDBLOK) -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      SECON1 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       encode                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      given a set of eigenvectors, encode data in terms of a          *
c      specified set of those eigenvectors.  assumes real eigenvectors.*
c                                                                      *
c  entry points:                                                       *
c      encode  (mblsiz,ndblok,nev,nevp,dvmean,y,egnvec,dblock)         *
c  arguments:                                                          *
c      mblsiz  integer  ??iou*                  -                      *
c      ndblok  integer  ??iou*                  -                      *
c      nev     integer  ??iou*                  -                      *
c      nevp    integer  ??iou*  (mblsiz)        -                      *
c      dvmean  real     ??iou*  (mblsiz)        -                      *
c      y       real     ??iou*  (mblsiz)        -                      *
c      egnvec  real     ??iou*  (mblsiz,mblsiz) -                      *
c      dblock  real     ??iou*  (mblsiz,ndblok) -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/25  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      secon1 -                                                        *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      the eigenvectors from the covariance matrix from one set of     *
c      data are found in array egnvec.  array nevp contains the        *
c      number designation of those eigenvectors in egnvec to be used   *
c      in encoding another set of data in dblock.                      *
c      use with main program eign5b.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from version e5aenc for use with eign5b.               *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      optimized, as by corvin for e5aenc.                             *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine encode (mblsiz, ndblok, nev   , nevp  , dvmean, y     ,
     *                   egnvec, dblock)
      integer nevp(mblsiz)
      real dvmean(mblsiz), y(mblsiz), egnvec(mblsiz,mblsiz)
      real dblock(mblsiz,ndblok)
c     common /timer/ clocks     , ops
c     real           clocks(100), ops(100)
c
c     encode input data dblock with eigenvectors from egnvec designated
c     in nevp
c
      do 400 j = 1, ndblok
         call secon1(v1,w1)
         do 100 k = 1, nev
            knevp = nevp(k)
            y(k) = 0.0
            do 100 i = 1, mblsiz
               y(k) = y(k) + egnvec(i,knevp)*(dblock(i,j) - dvmean(i))
  100    continue
c        call secon1(v2,w2)
c        clocks(4) = clocks(4) + v2 - v1
c        ops(4) = ops(4) + 3*(nev*mblsiz)
c
c        load mean into dblock
c
         do 200 i = 1, mblsiz
            dblock(i,j) = dvmean(i)
  200    continue
c        call secon1(v1,w1)
         do 320 k = 1, nev
            knevp = nevp(k)
c
c
c
c
            do 300 i = 1, mblsiz
               dblock(i,j) = dblock(i,j) + egnvec(i,knevp)*y(k)
  300       continue
  320    continue
c        call secon1(v2,w2)
c        clocks(5) = clocks(5) + v2 - v1
c        ops(5) = ops(5) + 2*(nev*mblsiz)
  400 continue
      return
      end
