C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       LODC2W                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      LODC2W  (IOP,MXIDBL,IDBLOK,A,NSPT,NTRACE,IBLK,ITR,ITRDEL,       *
C               LAPTR,ITM,ITMDEL,MXDBLK,MBLSIZ,DBLOCK,NBLTOT)          *
C  ARGUMENTS:                                                          *
C      IOP     INTEGER  ??IOU*                  -                      *
C      MXIDBL  INTEGER  ??IOU*                  -                      *
C      IDBLOK  INTEGER  ??IOU*  (MXIDBL,3)      -                      *
C      A       REAL     ??IOU*  (NSPT,NTRACE)   -                      *
C      NSPT    INTEGER  ??IOU*                  -                      *
C      NTRACE  INTEGER  ??IOU*                  -                      *
C      IBLK    INTEGER  ??IOU*                  -                      *
C      ITR     INTEGER  ??IOU*                  -                      *
C      ITRDEL  INTEGER  ??IOU*                  -                      *
C      LAPTR   INTEGER  ??IOU*                  -                      *
C      ITM     INTEGER  ??IOU*                  -                      *
C      ITMDEL  INTEGER  ??IOU*                  -                      *
C      MXDBLK  INTEGER  ??IOU*                  -                      *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      DBLOCK  REAL     ??IOU*  (MBLSIZ,MXDBLK) -                      *
C      NBLTOT  INTEGER  ??IOU*                  -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       lodc2w                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      this routine transfers data from real array a into the real     *
c      array of data blocks, dblock.                                   *
c                                                                      *
c  entry points:                                                       *
c      lodc2w  (iop,mxidbl,idblok,a,nspt,ntrace,iblk,itr,itrdel,       *
c               laptr,itm,itmdel,mxdblk,mblsiz,dblock,nbltot)          *
c  arguments:                                                          *
c      iop     integer  ??iou*                  -                      *
c      mxidbl  integer  ??iou*                  -                      *
c      idblok  integer  ??iou*  (mxidbl,3)      -                      *
c      a       real     ??iou*  (nspt,ntrace)   -                      *
c      nspt    integer  ??iou*                  -                      *
c      ntrace  integer  ??iou*                  -                      *
c      iblk    integer  ??iou*                  -                      *
c      itr     integer  ??iou*                  -                      *
c      itrdel  integer  ??iou*                  -                      *
c      laptr   integer  ??iou*                  -                      *
c      itm     integer  ??iou*                  -                      *
c      itmdel  integer  ??iou*                  -                      *
c      mxdblk  integer  ??iou*                  -                      *
c      mblsiz  integer  ??iou*                  -                      *
c      dblock  real     ??iou*  (mblsiz,mxdblk) -                      *
c      nbltot  integer  ??iou*                  -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/19  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      this routine is called by program eign5b to transfer data from  *
c      the real array a to the real data block array dblock.           *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from version e5alcw for use with eign5b.               *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine lodc2w (iop   , mxidbl, idblok, a     , nspt  , ntrace,
     *                   iblk  , itr   , itrdel, laptr , itm   , itmdel,
     *                   mxdblk, mblsiz, dblock, nbltot)
      integer idblok(mxidbl,3)
      real a(nspt,ntrace), dblock(mblsiz,mxdblk)
      io = 0
      nbltot = 0
      if (iop .eq. 0) then
c
c        transfer a to dblock
c
c        count over number of data block rows
c
         do 100 i = 1, iblk
c
c           get column location of first data block in row i, icol
c           get row location of first data block in row i, irow
c           get number of data blocks in row i, nblk
c
            icol = idblok(i,1)
            irow = idblok(i,2)
            nblk = idblok(i,3)
            nbltot = nbltot + nblk
c
c           count over blocks in this row
c
            do 100 j = 1, nblk
               io = io + 1
               indexj = icol + (itr*itrdel - laptr)*(j - 1)
c
c              count in time direction for this data block
c
               iq = 0
               do 100 k = 1, itm
                  indexk = irow + itmdel*(k - 1)
c
c                 count in trace direction for this data block
c
                  do 100 l = 1, itr
                     iq = iq + 1
                     indexl = indexj + itrdel*(l - 1)
                     dblock(iq,io) = a(indexk,indexl)
  100    continue
       else
c
c        transfer a-dblock to dblock
c
c        count over number of data block rows
c
         do 200 i = 1, iblk
c
c           get column location of first data block in row i, icol
c           get row location of first data block in row i, irow
c           get number of data blocks in row i, nblk
c
            icol = idblok(i,1)
            irow = idblok(i,2)
            nblk = idblok(i,3)
            nbltot = nbltot + nblk
c
c           count over blocks in this row
c
            do 200 j = 1, nblk
               io = io + 1
               indexj = icol + (itr*itrdel - laptr)*(j - 1)
c
c              count in time direction for this data block
c
               iq = 0
               do 200 k = 1, itm
                  indexk = irow + itmdel*(k - 1)
c
c                 count in trace direction for this data block
c
                  do 200 l = 1, itr
                     iq = iq + 1
                     indexl = indexj + itrdel*(l - 1)
                     dblock(iq,io) = a(indexk,indexl) - dblock(iq,io)
  200    continue
      endif
      return
      end
