C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       LODW2Z                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      LODW2Z  (EMBED,MXIDBL,IDBLOK,IBLK,ITR,ITRDEL,LAPTR,ITM,ITMDEL,  *
C               MXDBLK,MBLSIZ,DBLOCK,NSPT,NTRACE,A,Z,NBLTOT,ZCOUNT)    *
C  ARGUMENTS:                                                          *
C      EMBED   LOGICAL  ??IOU*                  -                      *
C      MXIDBL  INTEGER  ??IOU*                  -                      *
C      IDBLOK  INTEGER  ??IOU*  (MXIDBL,3)      -                      *
C      IBLK    INTEGER  ??IOU*                  -                      *
C      ITR     INTEGER  ??IOU*                  -                      *
C      ITRDEL  INTEGER  ??IOU*                  -                      *
C      LAPTR   INTEGER  ??IOU*                  -                      *
C      ITM     INTEGER  ??IOU*                  -                      *
C      ITMDEL  INTEGER  ??IOU*                  -                      *
C      MXDBLK  INTEGER  ??IOU*                  -                      *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      DBLOCK  REAL     ??IOU*  (MBLSIZ,MXDBLK) -                      *
C      NSPT    INTEGER  ??IOU*                  -                      *
C      NTRACE  INTEGER  ??IOU*                  -                      *
C      A       REAL     ??IOU*  (NSPT,NTRACE)   -                      *
C      Z       REAL     ??IOU*  (NSPT,NTRACE)   -                      *
C      NBLTOT  INTEGER  ??IOU*                  -                      *
C      ZCOUNT  INTEGER  ??IOU*  (NSPT,NTRACE)   -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV -                                                          *
C      VCLR -                                                          *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      MAX0    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       lodw2z                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      this routine transfers data from real array dblock into real    *
c      array z.  dblock contains the data in data block format, a data *
c      block being itr traces by itm time samples.  z is the 2-d       *
c      output array organized in trace-time fashion.  if the data      *
c      block parameters are such that data blocks overlap, then        *
c      multiple data block elements will map into a single output      *
c      location in z.                                                  *
c                                                                      *
c  entry points:                                                       *
c      lodw2z  (embed,mxidbl,idblok,iblk,itr,itrdel,laptr,itm,itmdel,  *
c               mxdblk,mblsiz,dblock,nspt,ntrace,a,z,nbltot,zcount)    *
c  arguments:                                                          *
c      embed   logical  ??iou*                  -                      *
c      mxidbl  integer  ??iou*                  -                      *
c      idblok  integer  ??iou*  (mxidbl,3)      -                      *
c      iblk    integer  ??iou*                  -                      *
c      itr     integer  ??iou*                  -                      *
c      itrdel  integer  ??iou*                  -                      *
c      laptr   integer  ??iou*                  -                      *
c      itm     integer  ??iou*                  -                      *
c      itmdel  integer  ??iou*                  -                      *
c      mxdblk  integer  ??iou*                  -                      *
c      mblsiz  integer  ??iou*                  -                      *
c      dblock  real     ??iou*  (mblsiz,mxdblk) -                      *
c      nspt    integer  ??iou*                  -                      *
c      ntrace  integer  ??iou*                  -                      *
c      a       real     ??iou*  (nspt,ntrace)   -                      *
c      z       real     ??iou*  (nspt,ntrace)   -                      *
c      nbltot  integer  ??iou*                  -                      *
c      zcount  integer  ??iou*  (nspt,ntrace)   -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/25  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      vmov -                                                          *
c      vclr -                                                          *
c  intrinsic functions called:                                         *
c      float   real    -                                               *
c      max0    integer -                                               *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      this routine is called by program eign5b to transfer data from  *
c      the real array dblock to a real array z used for output.        *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from e5alwz for use with eign5b.                       *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      optimization, as corvin did with e5alwz.                        *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/29  *
c      replace call move with qtc call vclr and call vmov.             *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine lodw2z (embed , mxidbl, idblok, iblk  , itr   , itrdel,
     *                   laptr , itm   , itmdel, mxdblk, mblsiz, dblock,
     *                   nspt  , ntrace, a     , z     , nbltot, zcount)
      logical embed
      real a(nspt,ntrace), z(nspt,ntrace)
      integer idblok(mxidbl,3), zcount(nspt,ntrace)
      real dblock(mblsiz,mxdblk)
c     common /timer/ clocks     , ops
c     real           clocks(100), ops(100)
c
c     set byte count for moving data
c
      nwords = nspt*ntrace
      nbytes = 8*nwords
c
c     prepare array z according to embed option
c
      if (embed) then
c
c        copy array a into array z
c
c>>      call move (1, z, a, nbytes)
         call vmov (a, 1, z, 1, nwords)
       else
c
c        copy zeros into array z
c
c>>      call move (0, z, 0, nbytes)
         call vclr (z, 1, nwords)
      endif
c
c     zero array zcount and some count variables
c
c>>   call move (0, zcount, 0, nbytes)
      call vclr (zcount, 1, nwords)
      io = 0
      nblzer = 0
      nbltot = 0
c
c     if embedding output in original data, zero the portion of z
c     covered by the data in dblock as determined by the data block
c     locations given in idblok.
c
      if (embed) then
c        call secon1 (v40b, w40b)
         do 260 i = 1, iblk
c
c           get column location of first data block in row i, icol
c           get row location of first data block in row i, irow
c           get number of data blocks in row i, nblk
c
            icol = idblok(i,1)
            irow = idblok(i,2)
            nblk = idblok(i,3)
            nblzer = nblzer + nblk
c
c           count over blocks in this row
c
            do 240 j = 1, nblk
               indexj = icol + (itr*itrdel - laptr)*(j - 1)
c
c              count in time direction for this data block
c
               do 220 k = 1, itm
                  indexk = irow + itmdel*(k - 1)
c
c                 count in trace direction for this data block
c
                  do 200 l = 1, itr
                     indexl = indexj + itrdel*(l - 1)
                     z(indexk,indexl) = 0.0
  200             continue
c                 ops(9) = ops(9) + itr
  220          continue
  240       continue
  260    continue
c        call secon1 (v40e, w40e)
c        clocks(9) = clocks(9) + v40e - v40b
      endif
c
c     transfer data from dblock array to z array
c
c     call secon1 (v80b, w80b)
      do 460 i = 1, iblk
c
c        get column location of first data block in row i, icol
c        get row location of first data block in row i, irow
c        get number of data blocks in row i, nblk
c
         icol = idblok(i,1)
         irow = idblok(i,2)
         nblk = idblok(i,3)
         nbltot = nbltot + nblk
c
c        count over blocks in this row
c
         do 440 j = 1, nblk
            io = io + 1
            indexj = icol + (itr*itrdel - laptr)*(j - 1)
c
c           count in time direction for this data block
c
            iq = 0
            do 420 k = 1, itm
               indexk = irow + itmdel*(k - 1)
c
c              count in trace direction for this data block
c
               do 400 l = 1, itr
                  iq = iq + 1
                  indexl = indexj + itrdel*(l - 1)
                  z(indexk,indexl) = z(indexk,indexl) + dblock(iq,io)
                  zcount(indexk,indexl) = zcount(indexk,indexl) + 1
  400          continue
c              ops(10) = ops(10) + 3*itr
  420       continue
  440    continue
  460 continue
c     call secon1 (v80e, w80e)
c     clocks(10) = clocks(10) + v80e - v80b
c
c     zcount contains the number of times each element of array z
c     was accessed.  normalize each z element by this amount.  if
c     zcount is zero for some element, use the value of 1.
c
c     call secon1 (v100b, w100b)
      do 600 j = 1, ntrace
         do 600 i = 1, nspt
            z(i,j) = z(i,j)/float(max0(1,zcount(i,j)))
  600 continue
c     call secon1 (v100e, w100e)
c     clocks(11) = clocks(11) + v100e - v100b
c     ops   (11) = ops   (11) + 11*nspt*ntrace
      return
      end
