C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RCOVAR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RCOVAR  (NDBLOK,MBLSIZ,DBLOCK,DVMEAN,DVCVAR)                    *
C  ARGUMENTS:                                                          *
C      NDBLOK  INTEGER  ??IOU*                  -                      *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      DBLOCK  REAL     ??IOU*  (MBLSIZ,NDBLOK) -                      *
C      DVMEAN  REAL     ??IOU*  (MBLSIZ)        -                      *
C      DVCVAR  REAL     ??IOU*  (MBLSIZ,MBLSIZ) -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR -                                                          *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       rcovar                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      compute the real covariance matrix for eigencoding program      *
c      eign.                                                           *
c                                                                      *
c  entry points:                                                       *
c      rcovar  (ndblok,mblsiz,dblock,dvmean,dvcvar)                    *
c  arguments:                                                          *
c      ndblok  integer  ??iou*                  -                      *
c      mblsiz  integer  ??iou*                  -                      *
c      dblock  real     ??iou*  (mblsiz,ndblok) -                      *
c      dvmean  real     ??iou*  (mblsiz)        -                      *
c      dvcvar  real     ??iou*  (mblsiz,mblsiz) -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/25  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      vclr -                                                          *
c  intrinsic functions called:                                         *
c      float   real    -                                               *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      given real data in array dblock, this routine computes the      *
c      real covariance matrix dvcvar and the vector of means dvmean.   *
c      use with main program eign5b.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from version e5acvr for use with eign5b.               *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/25  *
c      optimized, as by corvin for e5acvr.                             *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/28  *
c      change to qtc math advantage calls for zeroing arrays.          *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine rcovar (ndblok, mblsiz, dblock, dvmean, dvcvar)
      real dblock(mblsiz,ndblok)
      real dvmean(mblsiz)
      real dvcvar(mblsiz,mblsiz)
c     common /timer/ clocks     , opers
c     real           clocks(100), opers(100)
c
c     set constants
c
      fnd = float(ndblok)
      fndp = fnd - 1.0
      fndin = 1.0/fnd
      fndpin = 1.0/fndp
c
c     initialize mean and covariance arrays to zero
c
c>>   call move (0, dvmean, 0, 8*mblsiz)
      call vclr (dvmean, 1, mblsiz)
c>>   call move (0, dvcvar, 0, 8*mblsiz*mblsiz)
      call vclr (dvcvar, 1, mblsiz*mblsiz)
c
c     calculate mean and covariance matrix of data
c
c     call secon1(v1,w1)
      do 120 j = 1, ndblok
c
c           possible location for routine to replace following loop
c
         do 100 i = 1, mblsiz
            dvmean(i) = dvmean(i) + dblock(i,j)*fndin
  100    continue
  120 continue
c     call secon1(v2,w2)
c     opers(1) = opers(1) + 2*mblsiz*ndblok
c     clocks(1) = clocks(1) + v2 - v1
c
c     call secon1(v1,w1)
      do 240 j = 1, ndblok
         do 220 k = 1, mblsiz
            rwork =  dblock(k,j)*fndpin
c
c           possible location for routine to replace following loop
c
c
            do 200 i = 1, k
               dvcvar(i,k) = dvcvar(i,k) + dblock(i,j)*rwork
  200       continue
  220    continue
  240 continue
c     call secon1(v2,w2)
c     opers(2) = opers(2) + ndblok*((mblsiz + 1)*mblsiz + mblsiz)
c     clocks(2) = clocks(2) + v2 - v1
c
c     take mean out of second order statistics
c
c     call secon1(v1,w1)
      do 320 j = 1, mblsiz
         rwork = -fnd*fndpin*dvmean(j)
c
c           possible location for routine to replace following loop
c
c
         do 300 i = 1, j
            dvcvar(i,j) = dvcvar(i,j) + rwork*dvmean(i)
  300    continue
  320 continue
c     call secon1(v2,w2)
c     opers(3) = opers(3) + (mblsiz+1)*mblsiz + 2*mblsiz
c     clocks(3) = clocks(3) + v2 - v1
c
c     generate the rest of the covariance matrix using the
c     symmetry property
c
      do 400 j = 1, mblsiz-1
         do 400 k = j+1, mblsiz
            dvcvar(k,j) = dvcvar(j,k)
  400 continue
      return
      end
