C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RDPARM                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RDPARM  (LUSO,LUPRT,LUCARD,MXBLOK,NTAP,OTAP,CFILE,IPROPT,       *
C               EMBED,OUTOPT,BIWET1,BIWET2,ITR,ITM,ITRDEL,ITMDEL,      *
C               LAPTR,LAPTM,SCATTR,IPSRC,IPTAR,NEVTAR,NEVPTR,NEVDIF,   *
C               NEVPDF,INIREC,LSTREC,LTRAIN,EVFILE,VERBOS)             *
C  ARGUMENTS:                                                          *
C      LUSO    INTEGER   ??IOU*           -                            *
C      LUPRT   INTEGER   ??IOU*           -                            *
C      LUCARD  INTEGER   ??IOU*           -                            *
C      MXBLOK  INTEGER   ??IOU*           -                            *
C      NTAP    CHAR*120  ??IOU*           -                            *
C      OTAP    CHAR*120  ??IOU*           -                            *
C      CFILE   CHAR*120  ??IOU*           -                            *
C      IPROPT  INTEGER   ??IOU*           -                            *
C      EMBED   LOGICAL   ??IOU*           -                            *
C      OUTOPT  INTEGER   ??IOU*           -                            *
C      BIWET1  INTEGER   ??IOU*           -                            *
C      BIWET2  INTEGER   ??IOU*           -                            *
C      ITR     INTEGER   ??IOU*           -                            *
C      ITM     INTEGER   ??IOU*           -                            *
C      ITRDEL  INTEGER   ??IOU*           -                            *
C      ITMDEL  INTEGER   ??IOU*           -                            *
C      LAPTR   INTEGER   ??IOU*           -                            *
C      LAPTM   INTEGER   ??IOU*           -                            *
C      SCATTR  LOGICAL   ??IOU*           -                            *
C      IPSRC   INTEGER   ??IOU*  (4,2)    -                            *
C      IPTAR   INTEGER   ??IOU*  (4,2)    -                            *
C      NEVTAR  INTEGER   ??IOU*           -                            *
C      NEVPTR  INTEGER   ??IOU*  (MXBLOK) -                            *
C      NEVDIF  INTEGER   ??IOU*           -                            *
C      NEVPDF  INTEGER   ??IOU*  (MXBLOK) -                            *
C      INIREC  INTEGER   ??IOU*           -                            *
C      LSTREC  INTEGER   ??IOU*           -                            *
C      LTRAIN  INTEGER   ??IOU*           -                            *
C      EVFILE  CHAR*120  ??IOU*           -                            *
C      VERBOS  LOGICAL   ??IOU*           -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C      ICOPEN  INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MOD     GENERIC -                                               *
C  FILES:                                                              *
C      LUCARD  ( INPUT  SEQUENTIAL ) -                                 *
C      LUPRT   ( OUTPUT SEQUENTIAL ) -                                 *
C      LUSO    ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C      1025     ( 1) -                                                 *
C      1035     ( 1) -                                                 *
C      1100     ( 1) -                                                 *
C      1300     ( 1) -                                                 *
C      1350     ( 1) -                                                 *
C      2050     ( 1) -                                                 *
C      3100     ( 1) -                                                 *
C      4100     ( 1) -                                                 *
C      5100     ( 1) -                                                 *
C      5400     ( 1) -                                                 *
C      6100     ( 1) -                                                 *
C      6400     ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       rdparm                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      read the input processing parameters for program eign5b.        *
c                                                                      *
c  entry points:                                                       *
c      rdparm  (luso,luprt,lucard,mxblok,ntap,otap,cfile,ipropt,embed, *
c               outopt,biwet1,biwet2,itr,itm,itrdel,itmdel,laptr,      *
c               laptm,scattr,ipsrc,iptar,nevtar,nevptr,nevdif,nevpdf,  *
c               inirec,lstrec,ltrain,evfile,verbos)                    *
c  arguments:                                                          *
c      luso    integer   ??iou*           -                            *
c      luprt   integer  ??iou*           -                             *
c      lucard  integer  ??iou*           -                             *
c      mxblok  integer  ??iou*           -                             *
c      ntap    char*120  ??iou*           -                            *
c      otap    char*120  ??iou*           -                            *
c      cfile   char*120  ??iou*           -                            *
c      ipropt  integer   ??iou*           -                            *
c      embed   logical   ??iou*           -                            *
c      outopt  integer   ??iou*           -                            *
c      biwet1  integer  ??iou*           -                             *
c      biwet2  integer  ??iou*           -                             *
c      itr     integer  ??iou*           -                             *
c      itm     integer  ??iou*           -                             *
c      itrdel  integer  ??iou*           -                             *
c      itmdel  integer  ??iou*           -                             *
c      laptr   integer  ??iou*           -                             *
c      laptm   integer  ??iou*           -                             *
c      scattr  logical  ??iou*           -                             *
c      ipsrc   integer  ??iou*  (4,2)    -                             *
c      iptar   integer  ??iou*  (4,2)    -                             *
c      nevtar  integer  ??iou*           -                             *
c      nevptr  integer  ??iou*  (mxblok) -                             *
c      nevdif  integer  ??iou*           -                             *
c      nevpdf  integer  ??iou*  (mxblok) -                             *
c      inirec  integer  ??iou*           -                             *
c      lstrec  integer   ??iou*           -                            *
c      ltrain  integer   ??iou*           -                            *
c      evfile  char*120  ??iou*           -                            *
c      verbos  logical   ??iou*           -                            *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 88/04/20  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      argis   integer -                                               *
c      argstr          -                                               *
c      icopen  integer -                                               *
c  intrinsic functions called:                                         *
c      mod     generic -                                               *
c  files:                                                              *
c      lucard  ( input  sequential ) -                                 *
c      luprt   ( output sequential ) -                                 *
c      luso    ( output sequential ) -                                 *
c  common:           none                                              *
c  stop codes:                                                         *
c      =blank=  ( 1) -                                                 *
c      1010     ( 1) -                                                 *
c      1030     ( 1) -                                                 *
c      1100     ( 1) -                                                 *
c      1300     ( 1) -                                                 *
c      1350     ( 1) -                                                 *
c      2050     ( 1) -                                                 *
c      3100     ( 1) -                                                 *
c      4100     ( 1) -                                                 *
c      5100     ( 1) -                                                 *
c      5400     ( 1) -                                                 *
c      6100     ( 1) -                                                 *
c      6400     ( 1) -                                                 *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      read and verify input processing parameters for program eign5b. *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from e5ardp for use with eign5b.  parameter kind       *
c      dropped.                                                        *
c                                                                      *
c  revised by:  bill done                     revision date: 88/02/15  *
c      with ipropt=2, correct the action which always set the record   *
c      to be processed as record 1.                                    *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/09  *
c      add command line parameter -e for writing eigenvalues/vectors   *
c      to a file or reading them from a file.                          *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/29  *
c      replace call ccexit with stop.  add code for reading parameters *
c      in-line from job script.                                        *
c                                                                      *
c  revised by:  bill done                     revision date: 88/04/20  *
c      add parameter to 3eign card (which defines training zone).      *
c      this new parameter is the record number through which that      *
c      training zone is good.                                          *
c                                                                      *
c  revised by:  bill done                     revision date: 88/08/29  *
c      pass parameter card file name cfile to calling program.         *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine rdparm (luso  , luprt , lucard, mxblok, ntap  , otap  ,
     *                   cfile ,ipropt, embed , outopt, biwet1, biwet2,
     *                   itr   , itm   , itrdel, itmdel, laptr , laptm ,
     *                   scattr, ipsrc , iptar , nevtar, nevptr, nevdif,
     *                   nevpdf, inirec, lstrec, ltrain, evfile, verbos)
      logical scattr, embed
      integer biwet1, biwet2, outopt
      integer ipsrc(4,2), iptar(4,2)
      integer nevptr(mxblok), nevpdf(mxblok)
      character*80 icard1, icard2, icard3, icard4, icard5, icard6
      character*5 icrd1, icrd2, icrd3, icrd4, icrd5, icrd6
      character*5 name1, name2, name3, name4, name5, name6
c
c     cray input parameter file name
c
      character cfile*120
c
c     definitions for command line input
c
      character ntap*120, otap*120, evfile*120
      logical help, verbos
      integer argis
c
      data name1 /'1EIGN'/
      data name2 /'2EIGN'/
      data name3 /'3EIGN'/
      data name4 /'4EIGN'/
      data name5 /'5EIGN'/
      data name6 /'6EIGN'/
c
c     read help command line entry if present
c
      help = (argis('-H') .gt. 0) .or. (argis('-?') .gt. 0)
      if (help) then
         write (luso,1000)
 1000    format(/
     *     ' eign:  eigendecomposition to suppress coherent noise,'/
     *     '        version eign5b (real analysis)'//
     *     ' -flag{value}..................(default)'/
     *     ' Replace {value} with desired value.  If {value} is not'/
     *     ' present, use (default).'//
     *     ' Usage:'/
     *     '    eign -N{ntap} -O{otap} -C{parmfile} -L{listfile}'/
     *     '         -E{evecfile} -V'//
     *     ' -? or -H     -- print this help section and stop'/
     *     ' -N{ntap}     -- input data file (stdin)'/
     *     ' -O{otap}     -- output data file (stdout)')
         write (luso,1001)
 1001    format(
     *     ' -C{parmfile} -- file containing test parameters.  If -C'/
     *     '                 is present on the command line with no'/
     *     '                 argument, the input parameters are read'/
     *     '                 in-line from the job script file using'/
     *     '                 the STARTJOB syntax.  The flag used to'/
     *     '                 mark the in-line parameters is "-eign.crd"'/
     *     '                 If the -C flag is not present on the'/
     *     '                 command line, then the program will'/
     *     '                 terminate.')
         write (luso,1002)
 1002    format(
     *     ' -L{listfile} -- file to receive program the listing.  If'/
     *     '                 -L is present on the command line with no'/
     *     '                 argument, the listing goes to file'/
     *     '                 EIGN.xxx.yyy where xxx and yyy are'/
     *     '                 numbers obtained from the PID and PPID'/
     *     '                 of this job.  If -L is not present on'/
     *     '                 on the command line, the listing file'/
     *     '                 name is generated using the startjob'/
     *     '                 convention, for use with that system.'/
     *     ' -E{evecfile} -- file to write eigenvalues/eigenvectors'/
     *     '                 from training region to when in single'/
     *     '                 record processing mode (eign.vec)'/
     *     '                 or read from when in processing mode'/
     *     '                 1 (eign.vec)'/
     *     ' -V           -- verbose program run listing'//)
         stop
      endif
c
c     read parameter file name (cfile), input and output file names
c     (ntap, otap), and eigenvalue/eigenvector file name (evfile)
c
      call argstr ('-C', cfile , 'inline'  , 'inline')
      call argstr ('-N', ntap  , ' '       , ' ')
      call argstr ('-O', otap  , ' '       , ' ')
      call argstr ('-E', evfile, 'eign.vec', ' ')
      verbos = (argis('-V') .gt. 0)
c
c     get processing parameters
c        if cfile = non-null file name, get parameters from disk file.
c        if cfile = 'inline', get parameters in-line from job script.
c        if cfile = ' ', abort job.
c
      if (cfile .eq. ' ') then
         write (luprt,1020)
 1020    format(/' -No input parameters available in-line or file'/
     *          ' -Execution terminated'//)
       else if (cfile .eq. 'inline') then
c
c        parameters will be read in-line with execution statement
c
         ncfile = icopen ('-eign.crd', lucard)
         if (ncfile .eq. 0) then
            write (luprt,1025)
 1025       format(' -Error opening parameter card file')
            stop 1025
         endif
       else
c
c        open the file from which to read processing parameters
c
         write (luprt,1030) cfile
 1030    format(/' Get processing parameters from input parameter',
     *          ' file:'/5x,a16/)
         open (lucard, file=cfile, status='OLD', iostat=ios)
         rewind lucard
         if (ios .ne. 0) then
            write (luprt,1035) cfile
 1035       format(/' -Error opening input parameter card file ',a16/
     *             ' -Execution terminated'//)
            stop 1035
         endif
      endif
c
c     read card 1:  data vector block size -- trace (itr) by sample
c                     (itm);
c                   increment between data block samples -- between
c                     traces (itrdel), between time samples (itmdel);
c                   data block overlap -- trace overlap (laptr), time
c                     overlap (laptm);
c                   number of eigenvectors used to encode target
c                     (nevtar)
c                   robust encoding option biweight factor (biwet1)
c                     for target;
c                   number of eigenvectors used to encode residual
c                     (nevdif);
c                   robust encoding option biweight factor (biwet2)
c                     for residual;
c                   random block starting location flag (scattr);
c
      read (lucard,1040) icrd1, itr, itm, itrdel, itmdel,
     *                   laptr, laptm, nevtar, biwet1, nevdif,
     *                   biwet2, scattr, icard1
 1040 format(a5,10i5,4x,l1,t1,a80)
      iblsiz = itr*itm
c
c     check card 1 parameters.
c
      if (icrd1 .ne. name1) then
         write (luprt,1100)
 1100    format(//' First data card missing.'//)
         stop 1100
      endif
      if (itrdel .lt. 1) then
         itrdel = 1
         write (luprt,1200) itrdel
 1200    format(//' Setting data block trace sample increment = ',i5)
      endif
      if (itmdel .lt. 1) then
         itmdel = 1
         write (luprt,1250) itmdel
 1250    format(//' Setting data block time sample increment = ',i5)
      endif
      itrxxx = itr*itrdel
      if ((laptr .lt. 0) .or. (laptr .ge. itrxxx)) then
         write (luprt,1300) laptr, itrxxx
 1300    format(//' Data block trace overlap = ',i5,' must be',
     *          ' greater than or equal to zero'/' and less than',
     *          ' the data block trace width times the data'/
     *          ' block trace increment ',i5//)
         stop 1300
      endif
      itmxxx = itm*itmdel
      if ((laptm .lt. 0) .or. (laptm .ge. itmxxx)) then
         write (luprt,1350) laptm, itmxxx
 1350    format(//' Data block time overlap = ',i5,' must be',
     *          ' greater than or equal to zero'/' and less than',
     *          ' the data block time width times the data'/
     *          ' block time increment ',i5//)
         stop 1350
      endif
      if (nevtar .gt. mxblok) then
         nevtar = mxblok
         write (luprt,1400) mxblok, nevtar
 1400    format(//' Number of eigenvectors used to encode target',
     *          ' exceeds ',i5,', the maximum possible value'/
     *          ' setting value nevtar = ',i5//)
      endif
      if (nevdif .gt. mxblok) then
         nevdif = mxblok
         write (luprt,1450) mxblok, nevdif
 1450    format(//' Number of eigenvectors used to encode residual',
     *          ' exceeds ',i5,', the maximum possible value'/
     *          ' setting value nevdif = ',i5//)
      endif
c
c     print card 1 parameters
c
      write (luprt,1500) itr, itm, itrdel, itmdel, laptr, laptm
 1500 format(//' Processing parameters:'//
     *       5x,'data block size:'/7x,'traces',i5/7x,'time  ',i5//
     *       5x,'data block sample increment:'/7x,'traces',i5/
     *       7x,'time  ',i5//5x,'data block overlap:'/
     *       7x,'traces',i5/7x,'time  ',i5)
      if (scattr) then
         write (luprt,1750)
 1750    format(/5x,'Data block starting locations:  random')
       else
         write (luprt,1800)
 1800    format(/5x,'Data block starting locations:  fixed')
      endif
c
c     read card 2:  processing option (ipropt)
c                     process multiple records, train from each record
c                       (ipropt = 0)
c                     process multiple records, get training eigenvalues
c                       and eigenvectors from file evfile (ipropt = 1)
c                     process only 1 record (ipropt = 2);
c                   output options (outopt) -- all 6 analysis records
c                     or any one of the 6, or the training and target
c                     region patterns;
c                   data embedding option (embed)  -- on output, embed
c                     the various analysis regions within the original
c                     data or within zeros;
c                   initial record to process (inirec)
c                   last record to process (lstrec)
c
      read (lucard,2000) icrd2, ipropt, idummy, outopt, embed, inirec,
     *                   lstrec, icard2
 2000 format(a5,3i5,4x,l1,2i5,t1,a80)
c
c     check card 2 name.
c
      if (icrd2 .ne. name2) then
         write (luprt,2050)
 2050    format(//' Second data card missing.'//)
         stop 2050
      endif
c
c     set initial record default
c
      if (inirec .le. 0) inirec = 1
c
c     print record processing option and training region record
c
      write (luprt,2100) ipropt
 2100 format(//' Record processing option:  ',i1)
      if (ipropt .eq. 0) then
         if (lstrec .eq. 0) then
            lstrec = 99999
            write (luprt,2150)
 2150       format(5x,'Process to last record on data set')
          else
            write (luprt,2200) lstrec
 2200       format(5x,'Process through record ',i5,' on data set')
         endif
         write (luprt,2250)
 2250    format(5x,'Training region -- from each record')
       else if (ipropt .eq. 1) then
         if (lstrec .eq. 0) then
            lstrec = 99999
            write (luprt,2150)
          else
            write (luprt,2200) lstrec
         endif
         write (luprt,2350) evfile
 2350    format(5x,'Training region eigenstructure from file:  ',a31)
       else
         write (luprt,2450) inirec
 2450    format(5x,'Process only record ',i5,' on data set')
         lstrec = inirec
      endif
c
c     set outopt default and print with embed option
c
      if ((outopt .lt. 0) .or. (outopt .gt. 7)) outopt = 5
      if (((ipropt .eq. 0) .or. (ipropt .eq. 1)) .and.
     *      ((outopt .eq. 0) .or. (outopt .eq. 7))) then
         write (luprt,2500)
 2500    format(//' Outopt cannot be 0 or 7 when ipropt',
     *          ' is 0 or 1.'/' Forcing outopt to to default = 5')
         outopt = 5
      endif
      if (embed) then
         write (luprt,2550) outopt
 2550    format(//' Output option:  ',i1/5x,'embed data')
       else
         write (luprt,2600) outopt
 2600    format(//' Output option:  ',i1/5x,'data not embedded')
      endif
c
c     read card 3:  the four vertices which define the training region
c                   and the record number through which this region
c                   holds.
c
      read (lucard,3000) icrd3, ipsrc(1,1), ipsrc(1,2), ipsrc(2,1),
     *                   ipsrc(2,2), ipsrc(3,1), ipsrc(3,2),
     *                   ipsrc(4,1), ipsrc(4,2), ltrain, icard3
 3000 format(a5,5x,9i5,t1,a80)
c
c     check card 3 name.
c
      if (icrd3 .ne. name3) then
         write (luprt,3100)
 3100    format(//' Third data card missing.'//)
         stop 3100
      endif
c
c     set default for ltrain (last record for which this region holds)
c
      if (ltrain .le. 0) ltrain = 99999
      write (luprt,3200)
 3200 format(//' Training region vertices:')
      do 340 i = 1, 4
         write (luprt,3300) ipsrc(i,1), ipsrc(i,2)
 3300    format(1x,i5,3x,i5)
  340 continue
      write (luprt, 3400) ltrain
 3400 format(/' Current training region applies through record ',i5)
c
c     read card 4:  the four vertices which define the target region
c
      read (lucard,4000) icrd4, iptar(1,1), iptar(1,2), iptar(2,1),
     *                   iptar(2,2), iptar(3,1), iptar(3,2),
     *                   iptar(4,1), iptar(4,2), icard4
 4000 format(a5,5x,8i5,t1,a80)
c
c     check card 4 name.
c
      if (icrd4 .ne. name4) then
         write (luprt,4100)
 4100    format(//' Fourth data card missing.'//)
         stop 4100
      endif
      write (luprt,4200)
 4200 format(//' Target region vertices:')
      do 440 i = 1, 4
         write (luprt,4300) iptar(i,1), iptar(i,2)
 4300    format(1x,i5,3x,i5)
  440 continue
c
c     read card 5:  order of eigenvectors to be used for encoding
c                   the target region.
c
      nread = nevtar/10
      irem = mod(nevtar,10)
      if (irem .ne. 0) nread = nread + 1
      if (irem .eq. 0) irem = 10
      nget = 10
      do 520 j = 1, nread
         if (j .eq. nread) nget = irem
         read (lucard,5000) icrd5, (nevptr(10*(j-1)+i), i = 1, nget),
     *                      icard5
 5000    format(a5,10i5,t1,a80)
         if (icrd5 .ne. name5) then
            write (luprt,5100) j
 5100       format(//' Expecting data card 5eign, occurrence ',i5//)
            stop 5100
         endif
  520 continue
      write (luprt,5200) nevtar
 5200 format(//' Encoding:  training region and target region ',i5)
      if ((biwet1 .ge. 6) .and. (biwet1 .le. 9)) then
         write (luprt,5220) biwet1
 5220    format(12x,'Use robust encoding, biweight factor = ',i2)
       else
         write (luprt,5240)
 5240    format(12x,'Robust encoding not used')
      endif
      write (luprt,5280)
 5280 format(12x,'Orders of eigenvectors for encoding')
      write (luprt,5300) (nevptr(i), i = 1, nevtar)
 5300 format(12x,10i5)
      do 550 i = 1, nevtar
         if (nevptr(i) .gt. iblsiz) then
            write (luprt,5400) nevptr(i), iblsiz
 5400       format(//' Eigenvector order ',i4,
     *             ' exceeds data block size of ',i4/
     *             ' check target encoding eigenvector orders.'//)
            stop 5400
         endif
  550 continue
c
c     read card 6:  order of eigenvectors to be used for encoding
c                   the target region after differencing (the
c                   residual).
c
      if (nevdif .gt. 0) then
         nread = nevdif/10
         irem = mod(nevdif,10)
         if (irem .ne. 0) nread = nread + 1
         if (irem .eq. 0) irem = 10
         nget = 10
         do 620 j = 1, nread
            if (j .eq. nread) nget = irem
            read (lucard,6000) icrd6, (nevpdf(10*(j-1)+i), i = 1,
     *                         nget), icard6
 6000       format(a5,10i5,t1,a80)
            if (icrd6 .ne. name6) then
                write (luprt,6100) j
 6100           format(//' Expecting data card 6eign, occurrence ',
     *                 i5//)
                stop 6100
            endif
  620    continue
         write (luprt,6200) nevdif
 6200    format(//' Encoding:  residual (target - encoded target) ',i5)
         if ((biwet2 .ge. 6) .and. (biwet2 .le. 9)) then
            write (luprt,5220) biwet2
          else
            write (luprt,5240)
         endif
         write (luprt,6300)
 6300    format(12x,'Orders of eigenvectors for encoding')
         write (luprt,5300) (nevpdf(i), i = 1, nevdif)
         do 650 i = 1, nevdif
            if (nevpdf(i) .gt. iblsiz) then
               write (luprt,6400) nevpdf(i), iblsiz
 6400          format(//' Eigenvector order ',i4,
     *                ' exceeds data block size of ',i4/' check ',
     *                'residual encoding eigenvector orders.'//)
               stop 6400
            endif
  650    continue
      endif
      return
      end
