C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       REGION                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      REGION  (LUPRT,NSPT,NTRACE,ITM,ITR,ITMDEL,ITRDEL,LAPTM,LAPTR,   *
C               SCATTR,VERTEX,IDBLOK,MAXDIM,IBLK,NBLTOT,PRBLOK)        *
C  ARGUMENTS:                                                          *
C      LUPRT   INTEGER  ??IOU*             -                           *
C      NSPT    INTEGER  ??IOU*             -                           *
C      NTRACE  INTEGER  ??IOU*             -                           *
C      ITM     INTEGER  ??IOU*             -                           *
C      ITR     INTEGER  ??IOU*             -                           *
C      ITMDEL  INTEGER  ??IOU*             -                           *
C      ITRDEL  INTEGER  ??IOU*             -                           *
C      LAPTM   INTEGER  ??IOU*             -                           *
C      LAPTR   INTEGER  ??IOU*             -                           *
C      SCATTR  LOGICAL  ??IOU*             -                           *
C      VERTEX  INTEGER  ??IOU*  (4,2)      -                           *
C      IDBLOK  INTEGER  ??IOU*  (MAXDIM,3) -                           *
C      MAXDIM  INTEGER  ??IOU*             -                           *
C      IBLK    INTEGER  ??IOU*             -                           *
C      NBLTOT  INTEGER  ??IOU*             -                           *
C      PRBLOK  LOGICAL  ??IOU*             -                           *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      PLYCK           -                                               *
C      EGNRAN  INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      ATAN2   GENERIC -                                               *
C      MIN0    INTEGER -                                               *
C      MAX0    INTEGER -                                               *
C  FILES:                                                              *
C      LUPRT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      5600  ( 1) -                                                    *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       region                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      given the description of a region of data defined by four       *
c      vertices in terms of trace and sample number, generate the      *
c      location descriptions of the data blocks within that region.    *
c                                                                      *
c  entry points:                                                       *
c      region  (luprt,nspt,ntrace,itm,itr,itmdel,itrdel,laptm,laptr,   *
c               scattr,vertex,idblok,maxdim,iblk,nbltot,prblok)        *
c  arguments:                                                          *
c      luprt   integer  ??iou*             -                           *
c      nspt    integer  ??iou*             -                           *
c      ntrace  integer  ??iou*             -                           *
c      itm     integer  ??iou*             -                           *
c      itr     integer  ??iou*             -                           *
c      itmdel  integer  ??iou*             -                           *
c      itrdel  integer  ??iou*             -                           *
c      laptm   integer  ??iou*             -                           *
c      laptr   integer  ??iou*             -                           *
c      scattr  logical  ??iou*             -                           *
c      vertex  integer  ??iou*  (4,2)      -                           *
c      idblok  integer  ??iou*  (maxdim,3) -                           *
c      maxdim  integer  ??iou*             -                           *
c      iblk    integer  ??iou*             -                           *
c      nbltot  integer  ??iou*             -                           *
c      prblok  logical  ??iou*             -                           *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/19  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      plyck           -                                               *
c      egnran  integer -                                               *
c  intrinsic functions called:                                         *
c      float   real    -                                               *
c      min0    integer -                                               *
c      atan2   generic -                                               *
c      max0    integer -                                               *
c  files:                                                              *
c      luprt  ( output sequential ) -                                  *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c                                                                      *
c      this subroutine locates a trapezoidal window on a region of     *
c      data.                                                           *
c      inputs:                                                         *
c      itm    = is block size in time direction                        *
c      itr    = is block size in trace direction                       *
c      itmdel = is order difference of two consecutive points in the   *
c               time direction                                         *
c      itrdel = is order difference of two consecutive points in the   *
c               trace direction                                        *
c      laptm  = points of window overlap in the time direction         *
c      laptr  = points of window overlap in the trace direction        *
c      scattr = if true, randomize starting locations of data blocks   *
c      vertex = is an array that contains coordinates of four corner   *
c               point of the trapezoidal window, the x coordinate in   *
c               the first column and the y coordinate in the second    *
c                                                                      *
c      output:                                                         *
c      idblok = is an array with "iblk" three dimensional vectors.     *
c               the first dimension of iblk-th vector contains the     *
c               trace number of the iblk-th row in data.               *
c               the second dimension of iblk-th vector contains the    *
c               data point number of the iblk-th row.                  *
c               the third dimension of the iblk-th vector contains     *
c               number of blocks that need to be processed in the      *
c               iblk-th row.                                           *
c                                                                      *
c      use with main program eign5a.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from e5awin for use with eign5b.                       *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/29  *
c      replace call to ccexit with stop.                               *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine region (luprt , nspt  , ntrace, itm   , itr   , itmdel,
     *                   itrdel, laptm , laptr , scattr, vertex, idblok,
     *                   maxdim, iblk  , nbltot, prblok)
      logical scattr, block1, prblok
      integer vertex(4,2), idblok(maxdim,3), egnran
      dimension theta(2:4), xvrtex(4), yvrtex(4)
      dimension a(4), b(4), c(4), d(4)
c
c     set iblk to zero (used as an error flag if zero on return)
c
      iblk = 0
c
c     array vertex contains the x,y coordinates of four vertices.
c     the x coordinate gives the trace number, the y coordinate gives
c     the time sample number.
c
c     sort vertices into ascending order based on second column (y,
c     time sample) value
c
      do 120 j = 1, 3
         l = j
         jp1 = j + 1
         do 100 i = jp1, 4
            if (vertex(l,2) .gt. vertex(i,2)) then
               l = i
            endif
  100    continue
         if (l .ne. j) then
            itmp1 = vertex(l,1)
            itmp2 = vertex(l,2)
            vertex(l,1) = vertex(j,1)
            vertex(l,2) = vertex(j,2)
            vertex(j,1) = itmp1
            vertex(j,2) = itmp2
         endif
  120 continue
c
c     find the minimum and maximum second column values (time)
c
      miny = vertex(1,2)
      maxy = vertex(4,2)
c
c     find the maximum and minimum first column values (trace)
c
      minx = min0(vertex(1,1),vertex(2,1),vertex(3,1),vertex(4,1))
      maxx = max0(vertex(1,1),vertex(2,1),vertex(3,1),vertex(4,1))
c
c     check these maxima and minima against the data set size
c
      if ((minx .le. 0) .or. (maxx .gt. ntrace)) then
         write (luprt,1200)
 1200    format(/' REGION:  trace vertex locations outside data'/)
         return
      endif
      if ((miny .le. 0) .or. (maxy .gt. nspt)) then
         write (luprt,1220)
 1220    format(/' REGION:  time vertex locations outside data'/)
         return
      endif
c
c     check the first two vertices for equal second columns
c
      if (vertex(1,2) .eq. vertex(2,2)) then
c
c        the first two vertices have equal second columns.  put
c        first two vertices in ascending order by first column
c        value.  if first columns are also equal, then vertices
c        are coincident and in error.
c
         if (vertex(1,1) .gt. vertex(2,1)) then
            itmp1 = vertex(1,1)
            itmp2 = vertex(1,2)
            vertex(1,1) = vertex(2,1)
            vertex(1,2) = vertex(2,2)
            vertex(2,1) = itmp1
            vertex(2,2) = itmp2
          else if (vertex(1,1) .eq. vertex(2,1)) then
            write (luprt,1240)
 1240       format(/' REGION:  ver. 1, 2 coincident (1200)'/)
            return
         endif
      endif
c
c     compute the angles between the y-axis through vertex 1
c     and the line connecting vertex 1 with each of the other
c     three vertices.
c
c                             v1***************** x-axis
c                            ** *
c                          *  **   *
c                        *    * *     *
c                      *      *  *       *
c                    *        *<----------->* theta(4)
c                 *<--------->*     *          *
c                *   theta(3) *     *             *
c             v3              *<---->* theta(2)       *
c                              *      *                 v4
c                              *       v2
c                              *
c                          y-axis
c
      do 140 i = 2, 4
         idelx = vertex(i,1) - vertex(1,1)
         idely = vertex(i,2) - vertex(1,2)
         if ((idelx .eq. 0) .and. (idely .eq. 0)) then
            write (luprt,1300) i
 1300       format(/' REGION:  ver. 1, ',i1,' coincident (1300)'/)
            return
         endif
         theta(i) = atan2(float(idelx),float(idely))
  140 continue
c
c     sort the angles into ascending order and swap the vertices
c     so that vertex 2 is the most negative angle, vertex 3 the
c     next, vertex 4 the most positive angle.
c
      do 180 j = 2, 3
         l = j
         jp1 = j + 1
         do 160 i = jp1, 4
            if (theta(l) .gt. theta(i)) then
               l = i
             else if (theta(l) .eq. theta(i)) then
               write (luprt,1400) i, l
 1400          format(/' REGION:  ver. 1, ',i1,', ',i1,
     *                ' colinear or coincident (1400)'/)
               return
            endif
  160    continue
         if (l .ne. j) then
            temp = theta(l)
            theta(l) = theta(j)
            theta(j) = temp
            itmp1 = vertex(l,1)
            itmp2 = vertex(l,2)
            vertex(l,1) = vertex(j,1)
            vertex(l,2) = vertex(j,2)
            vertex(j,1) = itmp1
            vertex(j,2) = itmp2
         endif
  180 continue
c
c     the vertices are now numbered counter clockwise from vertex 1.
c     the above diagram becomes
c
c                             v1***************** x-axis
c                            ** *
c                          *  **   *
c                        *    * *     *
c                      *      *  *       *
c                    *        *<----------->* theta(4)
c                 *<--------->*     *          *
c                *   theta(2) *     *             *
c             v2              *<---->* theta(3)       *
c                              *      *                 v4
c                              *       v3
c                              *
c                          y-axis
c
c
c     for this to be a convex region, the vertex 3 must lie outside
c     the triangle formed by vertices 1, 2, and 4.  this test also
c     ensures that vertices 2, 3, and 4 are not colinear.
c     for vertex location in which delx42 > 0:
c       the test is accomplished by making sure that the y component
c       of vertex 3 is larger than the y component at the point on
c       the line between vertices 2 and 4 with the same x component
c       as that of vertex 3.
c     for vertex location in which delx42 < or = 0:
c       if dely42 > 0, then the x component of vertex 3 must be larger
c         than the x component at the point on the line between
c         vertices 2 and 4 with the same y component as that of
c         vertex 3.
c       if dely42 < 0, then the x component of vertex 3 must be smaller
c         than the x component at the point on the line between
c         vertices 2 and 4 with the same y component as that of
c         vertex 3.
c
      delx42 = vertex(4,1) - vertex(2,1)
      delx32 = vertex(3,1) - vertex(2,1)
      dely42 = vertex(4,2) - vertex(2,2)
      dely32 = vertex(3,2) - vertex(2,2)
      vrtx2x = vertex(2,1)
      vrtx2y = vertex(2,2)
      vrtx3x = vertex(3,1)
      vrtx3y = vertex(3,2)
      if (delx42 .gt. 0.0) then
         yi = (dely42*delx32)/delx42 + vrtx2y
         if (vrtx3y .lt. yi) then
            write (luprt,1800)
 1800       format(/' REGION:  region is not convex (1800)'/)
            return
          else if (vrtx3y .eq. yi) then
            write (luprt,1810)
 1810       format(/' REGION:  ver. 2, 3, 4 colinear (1810)'/)
            return
         endif
       else if (delx42 .le. 0.0) then
         xi = (delx42*dely32)/dely42 + vrtx2x
         if (dely42 .gt. 0.0) then
            if (vrtx3x .gt. xi) then
               write (luprt,1820)
 1820          format(/' REGION:  region is not convex (1820)'/)
               return
             else if (vrtx3x .eq. xi) then
               write (luprt,1830)
 1830          format(/' REGION:  ver. 2, 3, 4 colinear (1830)'/)
               return
            endif
          else if (dely42 .lt. 0.0) then
            if (vrtx3x .lt. xi) then
               write (luprt,1840)
 1840          format(/' REGION:  region is not convex (1840)'/)
               return
             else if (vrtx3x .eq. xi) then
               write (luprt,1850)
 1850          format(/' REGION:  ver. 2, 3, 4 colinear (1850)'/)
               return
            endif
         endif
      endif
c
c     vertices have now been sorted and the enclosed region
c     is convex.  transfer the vertice descriptions to the
c     real arrays xvrtex and yvrtex for use in subroutine plyck
c     (which is used to determine whether a point is outside,
c     on, or inside a polygon).
c
      do 200 i = 1, 4
         xvrtex(i) = vertex(i,1)
         yvrtex(i) = vertex(i,2)
  200 continue
c
c     define the data blocks within the region enclosed by the
c     four vertices.
c
c     initialize the polygon checking routine.
c
      kount = 0
      call plyck (kount , xvrtex, yvrtex, a     , b     , c     ,
     *            4     , 0.    , 0.    , iq1   , ierr)
      if (ierr .ne. 0) then
         write (luprt,2000) ierr
 2000    format(/' REGION:  ierr = ',i2,' from subroutine plyck'/)
         return
      endif
      kount = 1
c
c     if printing block location information for debugging, print title
c
      if (prblok) then
         write (luprt,2200)
 2200    format(//' REGION:  data block location information')
      endif
c
c     scan over the possible y vertex values (scan in time direction).
c
      nbltot = 0
      block1 = .false.
      iy1 = miny
      do 600 i = 1, maxy-miny+1
c
c        set the y values for this data block row.  iy1 is the
c        first row.  the last row is at iy2, separated from
c        iy1 by (itm-1)*itmdel samples.  terminate data block
c        definition if iy2 exceeds maxy.
c
         iy2 = iy1 + (itm - 1)*itmdel
         ry1 = iy1
         ry2 = iy2
         if (iy2 .gt. maxy) return
c
c        scan over the possible x vertex values (trace direction).
c        scan up in ix value to find minimum ix value in polygon.
c
            do 500 ix = minx, maxx
c
c              set the x value for this data block column.
c
               rx1 = ix
c
c              check to see if both points (rx1,ry1) and (rx1,ry2)
c              are inside the region.
c
               call plyck (kount , xvrtex, yvrtex, a     , b     ,
     *                     c     , 4     , rx1   , ry1   , iq1   , ierr)
               call plyck (kount , xvrtex, yvrtex, a     , b     ,
     *                     c     , 4     , rx1   , ry2   , iq2   , ierr)
               if ((iq1 .ge. 1) .and. (iq2 .ge. 1)) go to 520
  500       continue
c
c        no points were found on or inside the polygon in this row.
c        go to the next row value by incrementing iy1 by 1 (this will
c        find the first row down from top of region which can hold
c        a data block) if block 1 is false.  otherwise, increment
c        iy1 by itm*itmdel-laptm to find the start of the next data
c        block row.
c
         if (block1) then
            iy1 = iy1 + itm*itmdel - laptm
          else
            iy1 = iy1 + 1
         endif
         go to 600
c
c        scan over the possible x vertex values (trace direction).
c        scan down in ix value to find maximum ix value in polygon.
c
  520    do 540 ix = maxx, minx, -1
c
c           set the x value for this data block column.
c
            rx2 = ix
c
c           check to see if both points (rx2,ry1) and (rx2,ry2) are
c           inside the region.
c
            call plyck (kount , xvrtex, yvrtex, a     , b     , c     ,
     *                  4     , rx2   , ry1   , iq1   , ierr)
            call plyck (kount , xvrtex, yvrtex, a     , b     , c     ,
     *                  4     , rx2   , ry2   , iq2   , ierr)
            if ((iq1 .ge. 1) .and. (iq2 .ge. 1)) go to 560
  540    continue
c
c        the following points have been found to lie on or inside
c        the data region:
c
c                  *(rx1,ry1)       * (rx2,ry1)
c
c                  *(rx1,ry2)       * (rx2,ry2)
c
c        note that the pairs (rx1,ry1):(rx2,ry1) and (rx1,ry2):(rx2,ry2)
c        may be coincident.
c
c        assign the x values to integer variables
 
  560    ix1 = rx1
         ix2 = rx2
c
c        determine how many data blocks lie between the left and right
c        limits of this row.  this must take into account the width
c        of the data block in the trace direction (itr), the separation
c        between data block samples in the trace direction (itrdel),
c        and the overlap between adjacent data blocks in the trace
c        direction (laptr).
c
         npts = ix2 - ix1 + 1
         nblks = (npts - laptr + itrdel - 1)/(itr*itrdel - laptr)
         if (nblks .gt. 0) then
c
c           if random scattering of the data block initial trace is
c           to be done, increase ix1 by a random number.  if this
c           reduces the block count below zero, do not scatter.
c
            jitter = 0
            if (scattr) then
               jitter = egnran(itr)
               nptst = npts - jitter
               nbltst = (nptst - laptr + itrdel - 1)/
     *                  (itr*itrdel - laptr)
               if ((nptst .ge. 1) .and. (nbltst .ge. 1)) then
                  npts = nptst
                  nblks = nbltst
                  ix1 = ix1 + jitter
               endif
            endif
c
c           load array idblok with the quantities defining data
c           block row number iblk after incrementing counter iblk.
c
            iblk = iblk + 1
            if (iblk .gt. maxdim) then
               write (luprt,5600) iblk, maxdim
 5600          format(/' REGION:  iblk = ',i5,' exceeds maximum',
     *                ' dimension allowed of ',i5/)
               stop 5600
            endif
            block1 = .true.
            idblok(iblk,1) = ix1
            idblok(iblk,2) = iy1
            idblok(iblk,3) = nblks
            nbltot = nbltot + nblks
            iy1 = iy1 + itm*itmdel - laptm
c
c           print block location information, usually for debugging
c
            if (prblok) then
               write (luprt,5700) iblk, (idblok(iblk,jxx),
     *                            jxx = 1, 3), jitter, nbltot
 5700          format(' iblk=',i5,3x,'col=',i5,3x,'row=',i5,3x,
     *                'n=',i5,3x,'jitter=',i5,3x,'nbltot=',i5)
            endif
          else
c
c           no blocks in this row.  if a row has been built
c           previously, increment iy1 by itm*itmdel-laptm.
c           otherwise, increment iy1 by 1, seeking the first
c           row that will hold a data block.
c
            if (block1) then
               iy1 = iy1 + itm*itmdel - laptm
             else
               iy1 = iy1 + 1
            endif
         endif
  600 continue
      return
      end
