C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       REVVAL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      REVVAL  (MBLSIZ,NEV,NORDER)                                     *
C  ARGUMENTS:                                                          *
C      MBLSIZ  INTEGER  ??IOU*        -                                *
C      NEV     INTEGER  ??IOU*        -                                *
C      NORDER  INTEGER  ??IOU*  (NEV) -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       revval                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      change the value of the elements of integer input vector norder.*
c      norder will have m elements numbered from 1 to mblsiz.  if an   *
c      element has value k, replace it with mblsiz+1-k.  this has      *
c      the effect of reversing the sense of order of the eigenvalues   *
c      of the calling program.  at the parameter specification stage   *
c      the largest eigenvalue is order 1.  subroutines called during   *
c      execution, however, assume that the smallest eigenvalue is      *
c      order 1.                                                        *
c                                                                      *
c  entry points:                                                       *
c      revval  (mblsiz,nev,norder)                                     *
c  arguments:                                                          *
c      mblsiz  integer  i        - order can be 1 to mblsiz in value   *
c      nev     integer  i        - number of orders specified in norder*
c      norder  integer  u  (nev) - vector containing eigenvalue orders *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/18  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      for use with main program eign5b.                               *
c                                                                      *
c  revised by:  ???                           revision date: ?y/?m/?d  *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine revval (mblsiz, nev, norder)
      integer norder(nev)
      do 200 k = 1, nev
         norder(k) = mblsiz + 1 - norder(k)
  200 continue
      return
      end
