C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ROBUST                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ROBUST  (LUPRT,NDBLOK,MBLSIZ,DBLOCK,DVCVAR,DVMEAN,EGNVEC,       *
C               EGNVAL,NEVP,NEV,BIWEGT)                                *
C  ARGUMENTS:                                                          *
C      LUPRT   INTEGER  ??IOU*                  -                      *
C      NDBLOK  INTEGER  ??IOU*                  -                      *
C      MBLSIZ  INTEGER  ??IOU*                  -                      *
C      DBLOCK  REAL     ??IOU*  (MBLSIZ,NDBLOK) -                      *
C      DVCVAR  REAL     ??IOU*  (MBLSIZ,MBLSIZ) -                      *
C      DVMEAN  REAL     ??IOU*  (MBLSIZ)        -                      *
C      EGNVEC  REAL     ??IOU*  (MBLSIZ,MBLSIZ) -                      *
C      EGNVAL  REAL     ??IOU*  (MBLSIZ)        -                      *
C      NEVP    INTEGER  ??IOU*  (MBLSIZ)        -                      *
C      NEV     INTEGER  ??IOU*                  -                      *
C      BIWEGT  INTEGER  ??IOU*                  -                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      EGMEDN  REAL -                                                  *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:                                                              *
C      LUPRT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      1000  ( 1) -                                                    *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       robust                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      implement robust encoding method, real covariance and           *
c      eigenvectors.                                                   *
c                                                                      *
c  entry points:                                                       *
c      robust  (luprt,ndblok,mblsiz,dblock,dvcvar,dvmean,egnvec,       *
c               egnval,nevp,nev,biwegt)                                *
c  arguments:                                                          *
c      luprt   integer  ??iou*                  -                      *
c      ndblok  integer  ??iou*                  -                      *
c      mblsiz  integer  ??iou*                  -                      *
c      dblock  real     ??iou*  (mblsiz,ndblok) -                      *
c      dvcvar  real     ??iou*  (mblsiz,mblsiz) -                      *
c      dvmean  real     ??iou*  (mblsiz)        -                      *
c      egnvec  real     ??iou*  (mblsiz,mblsiz) -                      *
c      egnval  real     ??iou*  (mblsiz)        -                      *
c      nevp    integer  ??iou*  (mblsiz)        -                      *
c      nev     integer  ??iou*                  -                      *
c      biwegt  integer  ??iou*                  -                      *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/08/18  *
c  language: fortran 77                  date last compiled: 87/08/19  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      egmedn  real -                                                  *
c  intrinsic functions called:                                         *
c      float   real -                                                  *
c  files:                                                              *
c      luprt  ( output sequential ) -                                  *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:                                                *
c      comments by dr. lynn kirlin --                                  *
c      this subroutine finds expansion coefficients, weighted          *
c      according to the data vector residual element variations        *
c      after already having encoded the data vector with all of the    *
c      other eigenvectors.  if any data vector residual element,       *
c      divided by its corresponding eigenvector element, lies several  *
c      sigma (biwegt) outside the median value of these ratios, that   *
c      element and subsequently its product with the eigenvector       *
c      element is weighted with a value less that unity.  sigma is     *
c      determined by the covariance matrix of the residual             *
c      eigenvectors not used in the coding:                            *
c                                                                      *
c      sum(i=m+1,n) lambda(i)*v(i)v(i)                                 *
c          = c - sum(i=1,m) lambda(i)*v(i)v(i) ,                       *
c                                                                      *
c      and this variance is normalized by the square of the            *
c      eigenvector element which will multiply the data element by     *
c      the data vector--eigenvector dot product.                       *
c                                                                      *
c      use with main program eign5b.                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/08/18  *
c      modified from version robust for use with eign5b.               *
c                                                                      *
c  revised by:  bill done                     revision date: 88/01/08  *
c      correct do loop at 200.  also required to loop over i, picking  *
c      out the value for ii.                                           *
c                                                                      *
c  revised by:  bill done                     revision date: 88/03/28  *
c      change call to ccexit to stop.                                  *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine robust (luprt , ndblok, mblsiz, dblock, dvcvar, dvmean,
     *                   egnvec, egnval, nevp  , nev   , biwegt)
      integer nevp(mblsiz), biwegt
      real egnval(mblsiz)
      real dblock(mblsiz,ndblok), egnvec(mblsiz,mblsiz)
      real dvcvar(mblsiz,mblsiz), dvmean(mblsiz)
c
      parameter (inblok = 100)
c
      real z(inblok), y(inblok)
      real xp(inblok), yp(inblok), xpp(inblok)
      real cn(inblok,inblok), var(inblok,inblok), bta(inblok,inblok)
c
c     check block size passed from main (mblsiz) to maximum
c     internal block size in this subroutine (inblok)
c
      if (mblsiz .gt. inblok) then
         write (luprt,1000) mblsiz, inblok
 1000    format(//' Block size error in robust:'/5x,'mblsiz = ',i5,
     *          3x,'inblok = ',i5//)
         stop 1000
      endif
c
c     check the value for the biweight parameter, biwegt
c
      if ((biwegt .lt. 6) .or. (biwegt .gt. 9)) then
         biwegt = 6
      endif
      do 100 ik = 1, mblsiz
         do 100 jk = 1, mblsiz
            cn(ik,jk) = dvcvar(ik,jk)
  100 continue
c
c     find the residual covariance matrix, cn
c
      do 200 i = 1, nev
         ii = nevp(i)
         do 200 ik = 1, mblsiz
            do 200 jk = 1, mblsiz
               cn(ik,jk) = cn(ik,jk)
     *                     - egnval(ii)*egnvec(ik,ii)*egnvec(jk,ii)
  200 continue
c
c     find the ratio of the e(square of the data element residual)
c     to the square of the eigenvector element:
c     e{(dvmean(r,i)**2)/(egnvec(k,i)**2)
c
      do 300 i = 1, nev
         ii = nevp(i)
         do 300 ik = 1, mblsiz
            d = egnvec(ik,ii)**2
            if (d .lt. 0.05) d = 0.05
            var(ik,i) = cn(ik,ik)/d
            if (var(ik,i) .eq. 0.) var(ik,i) = 0.01
  300 continue
      do 600 i = 1, ndblok
c
c        original data minus the most recent expansion approximation
c
         do 400 ik = 1, mblsiz
            z(ik) = dblock(ik,i) - dvmean(ik)
  400    continue
         do 560 ii = 1, nev
            jj = nevp(ii)
            do 500 ik = 1, mblsiz
               d = egnvec(ik,jj)
               if ((d .lt. 0.05) .and. (d .ge. 0.)) d = 0.05
               if ((d .gt. -0.05) .and. (d .le. 0.)) d= -0.05
c
c              compute the normalized deviations
c
               y(ik) = z(ik)/d
               yp(ik) = y(ik)
  500       continue
c
c           find the median of the element ratios dvmean(r,i)/egnvec(k,i)
c
            ym = egmedn(yp,mblsiz)
            bs = 0.
            bsy = 0.
c
c           compute the normalized deviation of dvmean(r,i)/egnvec(k,i)
c           from the median value.  this is compared to biwegt*sigma.
c           ideally, all dvmean(r,i)/egnvec(k,i) are equal.
c
            do 520 ik = 1, mblsiz
               d = .6754*(y(ik) - ym)/(float(biwegt)*var(ik,ii))
               d = d*d
               if (d .ge. 1.) then
                  bta(ik,ii) = 0.
                else
                  bta(ik,ii) = (1. - d)**2
               endif
               bs = bs + bta(ik,ii)
               bsy = bsy + bta(ik,ii)*y(ik)
  520       continue
c
c           xp is the bi-weighted normalized deviation
c
            xp(ii) = bsy/bs
c
c           compute the new residual z (and store in place)
c
            do 540 ik = 1, mblsiz
               z(ik) = z(ik) - xp(ii)*egnvec(ik,jj)
  540       continue
  560    continue
c
c        compute the new robust encoded data value
c
         do 580 ik = 1, mblsiz
            dblock(ik,i) = dvmean(ik)
            do 580 jk = 1, nev
               kkp = nevp(jk)
               dblock(ik,i) = dblock(ik,i) + egnvec(ik,kkp)*xp(jk)
  580    continue
  600 continue
      return
      end
