C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RTRAIN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RTRAIN  (LUPRT,LUCARD,JREC,IPSRC,LTRAIN,IERR)                   *
C  ARGUMENTS:                                                          *
C      LUPRT   INTEGER  ??IOU*        -                                *
C      LUCARD  INTEGER  ??IOU*        -                                *
C      JREC    INTEGER  ??IOU*        -                                *
C      IPSRC   INTEGER  ??IOU*  (4,2) -                                *
C      LTRAIN  INTEGER  ??IOU*        -                                *
C      IERR    INTEGER  ??IOU*        -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUCARD  ( INPUT  SEQUENTIAL ) -                                 *
C      LUPRT   ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c***********************************************************************
c  routine:       rtrain                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      used by program eign5b, this subroutine allows reading of new   *
c      3eign cards.  the 3eign card defines the training region        *
c      location and now has an additional parameter defining the       *
c      input seismic data record number through which the current      *
c      training region is valid.                                       *
c                                                                      *
c  entry points:                                                       *
c      rtrain  (luprt,lucard,jrec,ipsrc,ltrain,ierr)                   *
c  arguments:                                                          *
c      luprt   integer  ??iou*        -                                *
c      lucard  integer  ??iou*        -                                *
c      jrec    integer  ??iou*        -                                *
c      ipsrc   integer  ??iou*  (4,2) -                                *
c      ltrain  integer  ??iou*        -                                *
c      ierr    integer  ??iou*        -                                *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 88/04/20  *
c  language: fortran 77                  date last compiled: 88/04/20  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:                                                              *
c      lucard  ( input  sequential ) -                                 *
c      luprt   ( output sequential ) -                                 *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  ???                                                *
c  general description:  ???                                           *
c                                                                      *
c  revised by:  ???                           revision date: ?y/?m/?d  *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine rtrain (luprt, lucard, jrec, ipsrc, ltrain, ierr)
      integer ipsrc(4,2)
      character*80 icard3
      character*5  icrd3
      character*5  name3
      data name3 /'3EIGN'/
c
c     save old ltrain value
c
  100 ltrold = ltrain
c
c     read card 3:  the four vertices which define the training region
c                   and the record number through which this region
c                   holds.
c
      read (lucard,1000,err=500) icrd3, ipsrc(1,1), ipsrc(1,2),
     *                      ipsrc(2,1), ipsrc(2,2), ipsrc(3,1),
     *                      ipsrc(3,2), ipsrc(4,1), ipsrc(4,2),
     *                          ltrain, icard3
 1000 format(a5,5x,9i5,t1,a80)
c
c     check card 3 name.
c
      if (icrd3 .ne. name3) then
         write (luprt,2000) name3, jrec
 2000    format(/' RTRAIN:  expecting a ',a5,' card.'/
     *          10x,'Current data record = ',i5)
         ierr = 2000
         return
      endif
c
c     verify that ltrain > ltrold (ascending values of ltrain)
c
      if (ltrain .le. ltrold) then
         write (luprt,2200) jrec
 2200    format(/' RTRAIN:  new record number is not greater than',
     *          ' previous record number.'/
     *          10x,'Current data record = ',i5)
         ierr = 2200
         return
      endif
c
c     check ltrain against current data record number.  if ltrain is
c     less than jrec, an attempt will be made to read a new card.
c     this is done because situations could occur where ltrain could
c     be specified for a record number missing from the data set.
c     in that case, processing should continue if there is another
c     3eign card immediately following.
c
      if (ltrain .lt. jrec) then
         write (luprt,3000) jrec, ltrain, icrd3
 3000    format(/' RTRAIN:  current record ',i5,' exceeds record ',
     *          i5,' specified on ',a5,' card'/'          Attempt',
     *          ' to read another card')
         go to 100
      endif
c
c     print new training region vertices
c
      write (luprt,4000) jrec
 4000 format(/' Training region vertices:  current data record = ',i5)
      do 440 i = 1, 4
         write (luprt,4200) ipsrc(i,1), ipsrc(i,2)
 4200    format(1x,i5,3x,i5)
  440 continue
      write (luprt, 4800) ltrain
 4800 format(/' Current training region applies through record ',i5)
      ierr = 0
      return
c
c     error occurred when reading parameters
c
  500 write (luprt,5000)
 5000 format(/' RTRAIN:  error reading parameters')
      ierr = 5000
      return
      end
