/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
 
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define DISK_IT  disk_it_
#define DISK_WR  disk_wr_
#define DISK_RD  disk_rd_
#define DISK_RWIN  disk_rwn_
#define DISK_WWIN  disk_wwn_
#define DISK_DL  disk_dl_

        int ifdes;

int DISK_IT( int *nsamp,int *nbufsize,float *buf, int *nchars, char *dirct, int *ipid )
{
        int disk_it(int nsamp,int nbufsize,float *buf, int nchars, char *dirct, int ipid);
        int xnsamp;
        int xnchars;
        int xnbufsize;
	int xipid;
        int i;

        xnsamp = *nsamp;
        xnchars = *nchars;
        xnbufsize = *nbufsize;
	xipid = *ipid;
        i = disk_it(xnsamp, xnbufsize, buf,xnchars, dirct, xipid );
 
        return i;
}

int DISK_WR( int *nsamp,int *index,float *buf )
{
        int  disk_wrte(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_wrte(xnsamp, xindex, buf );
 
        return i;
}

int DISK_WWIN( int *nsamp,int *index, int *isamp, int *nsmp, float *buf )
{
        int  disk_wwin(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_wwin(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_RD( int *nsamp,int *index,float *buf )
{
        int  disk_reed(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_reed(xnsamp, xindex, buf );
 
        return i;
}

int DISK_RWIN( int *nsamp,int *index,int *isamp, int *nsmp, float *buf )
{
        int  disk_rwin(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_rwin(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_DL( )
{
        int i;

        i = disk_dlte();
 
        return i;
}


static FILE *fout;
static char FileName[81];
static int FileOpen = 0; 

#include <time.h>
 
/* initialize the disk buffer  */
        int disk_it(int nsamp,int nbufsize,float *buf,int nchars, char *dirct, int ipid)
{

        int n;
        char cn[81];
        void itox( int n, char s[]);


	/*  use pid for a unique disk dataset name */
	n = ipid;
        /* printf(" ipid is %d\n ",ipid); */
        itox(n, cn);

        if ( nchars > 0) {
          strncpy(FileName,dirct,nchars);
        }
	else {
          strcpy(FileName,"/tmp");
        }
        strcat(FileName,"/fxydeconjunk");
        strcat(FileName,cn);

        printf("Output work file is %s\n",FileName);

 
	/*        if((fout = fopen(FileName,"w+b"))==NULL) { */
	ifdes = open( FileName, O_RDWR | O_CREAT ) ;
	if (ifdes < 0) {
                printf("Cannot open output file!\n");
		printf(" ifdes is %d\n ",ifdes);
                exit(1);
                }
        FileOpen = -1;
	/*    printf(" Work unit number = %d \n", ifdes ); */

       sislgbuf(ifdes, "off");


/* do not bother to format the disk --- not needed for unit ---
=================================================================
        nbytes = nsampl * sizeof(float);
        for(i=0;i<nbufsize;i++) {
                actual = fwrite(buf, nbytes, ST_ONE, fout);
                   if ( actual != ST_ONE) {
                     printf("Error in fwrite during format\n");
                     printf("Requested index=%d\n",i);
                     printf("Requested Number of records=%d\n",ST_ONE);
                     printf("Actual Number of records wrote=%d\n",actual);
    
                       if((remove(FileName))!= 0) {
                         printf("Cannot remove output file!\n");
                         exit(1);
                         }
   
                     exit(1);
                   }
        }
=================================================================
*/

/*   WARNING   ---- DANGER   --- READ THIS ---
     warning   ---- danger   --- read this ---
     ok -  this is something I do not like--    
     to remove a file in the case of a job ending abnormally,
     I am taking the systems group's suggestion that I "unlink"
     the disk buffer so it will disappear at the end of the job.
     This seems dangerous, but it keeps the disks clean.      */
    
	/*    printf("Unlinking output file\n");  */
                       if((unlink(FileName))!= 0) {
                         printf("Cannot unlink output file!\n");
                         exit(1);
                         }
        /*      printf("Unlinking of output file successful\n"); */
   

        return 0;
}

/* write to the disk buffer  */
        int  disk_wrte(int nsamp,int index,float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf;


	indexf = index-1;
	nsamplf = nsamp;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	ipos = (off_t) iposf;

	/* perror("LSEEK"); */

	ierr = lseek( ifdes, ipos, SEEK_SET);

	/* perror("LSEEK-a"); */

	if ( (double)ierr < (double) 0) {
	  printf("Error in lseek a\n");
	  printf(" ierr= %g\n", (double)ierr);
	  printf(" ipos = %g \n", (double) ipos );
	  printf(" nsamplf = %g \n",  nsamplf);
	  printf(" indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes = nsamplf * tsizef;
        nby    =  nsamplf * tsizef;

        ndone = write( ifdes, buf, nbytes) ;
           if ( ndone != nby ) {
             printf("Error in write a\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of bytes=%u\n",nbytes);
             printf("Actual Number of bytes written=%d\n",ndone);
             printf("Unit number = %d \n", ifdes );
	     printf(" ipos = %g\n",(double)ipos);
	     printf(" index = %d \n",index);
	     printf(" nsamp= %d \n",nsamp);
             exit(1);
           }

        return 0;
}



/* write to the disk buffer for a window  */
        int  disk_wwin(int nsamp,int index, int isamp, int nsmp ,float *buf)
{

        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf, isampf;

	indexf = index-1;
	nsamplf = nsamp ;
	isampf = isamp -1;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	iposf = iposf + isampf * tsizef ;
	ipos = (off_t) iposf;

	ierr = lseek( ifdes, ipos, SEEK_SET);

	if ( (double)ierr < (double) 0) {
	  printf("Error in lseek b\n");
	  printf(" ierr= %g\n", (double)ierr);
	  printf(" ipos = %g \n", (double) ipos );
	  printf(" nsamplf = %g \n",  nsamplf);
	  printf(" indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes = nsmp * tsizef;
        nby    =  nsmp * tsizef;

        ndone = write( ifdes, buf, nbytes) ;
           if ( ndone != nby ) {
             printf("Error in disk_wwin \n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of bytes=%u\n",nbytes);
             printf("Actual Number of bytes written=%d\n",ndone);
             printf("Unit number = %d \n", ifdes );
	     printf(" ipos = %g\n",(double)ipos);
	     printf(" index = %d \n",index);
	     printf(" nsamp= %d \n",nsamp);
             exit(1);
           }


        return 0;
}


/* read from the disk buffer  */
        int  disk_reed(int nsamp,int index,float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf;

	indexf = index-1;
	nsamplf = nsamp;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	ipos = (off_t) iposf;

	ierr = lseek( ifdes, ipos, SEEK_SET);
	if ( (double)ierr < (double) 0) {
	  printf("Error in lseek a\n");
	  printf(" ierr= %g\n", (double)ierr);
	  printf(" ipos = %g \n", (double) ipos );
	  printf(" nsamplf = %g \n",  nsamplf);
	  printf(" indexf = %g \n",  indexf );
	  exit(1);
	}


        nbytes = nsamplf * tsizef;
        nby    =  nsamplf * tsizef;

	ndone = read(ifdes, buf, nbytes);
           if ( ndone != nby ) {
             printf("Error in read a\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of bytes=%u\n",nbytes);
             printf("Actual Number of bytes read=%d\n",ndone);
             printf("Unit number = %d \n", ifdes );
	     printf(" ipos = %g\n",(double)ipos);
	     printf(" index = %d \n",index);
	     printf(" nsamp= %d \n",nsamp);
             exit(1);
           }


        return 0;
}
 


/* read from the disk buffer for a window  */
        int  disk_rwin(int nsamp,int index, int isamp, int nsmp, float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf, isampf;




	indexf = index-1;
	nsamplf = nsamp ;
	isampf = isamp -1;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	iposf = iposf + isampf * tsizef ;
	ipos = (off_t) iposf;


	ierr = lseek( ifdes, ipos, SEEK_SET);
	if ( (double)ierr < (double) 0) {
	  printf("Error in lseek a\n");
	  printf(" ierr= %g\n", (double)ierr);
	  printf(" ipos = %g \n", (double) ipos );
	  printf(" nsamplf = %g \n",  nsamplf);
	  printf(" indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes =  nsmp * tsizef;
        nby    =  nsmp * tsizef;

	ndone = read(ifdes, buf, nbytes);
           if ( ndone != nby ) {
             printf("Error in disk_rwin\n");
             printf("Requested index=%d\n",index);
             printf("Requested Number of bytes=%u\n",nbytes);
             printf("Actual Number of bytes read=%d\n",ndone);
             printf("Unit number = %d \n", ifdes );
	     printf(" ipos = %g\n",(double)ipos);
	     printf(" index = %d \n",index);
	     printf(" nsamp= %d \n",nsamp);
             exit(1);
           }



        return 0;
}



/* remove he disk buffer  */
        int  disk_dlte(void)
{

        if (FileOpen == 0) {
         return 0;
        }

        if((fclose(fout))==EOF) {
                printf("Cannot close output file!\n");
                exit(1);
                }
 
/*
------------------------------------------------------------------
   I has previously unlinked this input file, so I can no longer
   remove it.  It should disappear automatically.
        if((remove(FileName))!= 0) {
                printf("Cannot remove output file!\n");
                exit(1);
                }
------------------------------------------------------------------
*/
   

        return 0;
}
/* itox ; convert n to characters in s */
void itox( int n, char s[])
{
  int i,sign;
  void reverse( char s[]);
 
  if ((sign = n) < 0)  /* record sign */
    n = -n ;
  i=0;
  do {   /* generate digits in reverse order */
    s[i++] = n % 10 + '0';  /* get next digit */
  } while ((n /= 10) > 0); /* delete it */
  if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
 
/* reverse: reverse string s in place */
void reverse( char s[])
{
  int c,i,j;
 
  for (i=0,j=strlen(s)-1; i<j; i++,j--)
    c=s[i],s[i]=s[j],s[j]=c;
}
