C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine ft3dSGI(sign, Fspace,nsamp2,ntrc2,ngath2,coeff)

         real sign,scl
         integer nsamp2,ntrc2,ngath2
         complex Fspace(nsamp2,ntrc2,ngath2)

         integer isamp,itrc,igath,i,j,k,jsz,ierr,ierrt,iabort
c        complex xtemp(ntrc2)
c        complex ytemp(ngath2)
         complex xtemp
         complex ytemp
         pointer (wkxtemp, xtemp(10))
         pointer (wkytemp, ytemp(10))

         integer isign

         complex coeff(nsamp2+ntrc2+ngath2+90)

         integer nsamp2sv,ntrc2sv,ngath2sv
         data nsamp2sv /0/
         data ntrc2sv /0/
         data ngath2sv /0/
         data iabort /0/
         data ierrt /0/
         data ierr  /0/

         save nsamp2sv,ntrc2sv,ngath2sv

         call sizefloat(jsz)
         call galloc (wkxtemp, 2*jsz*ntrc2, ierr, iabort)
         ierrt = ierrt + ierr
         call galloc (wkytemp, 2*jsz*ngath2, ierr, iabort)
         ierrt = ierrt + ierr

         if (nsamp2sv .ne. nsamp2 .or. ntrc2sv .ne. ntrc2 .or.
     :       ngath2sv .ne. ngath2 ) then
           nsamp2sv = nsamp2
           ntrc2sv = ntrc2
           ngath2sv=ngath2
C--SGI--           call cfft3di(nsamp2,ntrc2,ngath2,coeff)
         endif

         ierr = 0

         isign = nint(sign)


C--SGI--         call cfft3d(isign,
C--SGI--     :               nsamp2,ntrc2,ngath2,Fspace,
C--SGI--     :               nsamp2,ntrc2,  coeff)

         if (isign .eq. -1) then
            scl = float( nsamp2 * ntrc2 * ngath2 )
            do  k = 1, ngath2
                do  j = 1, ntrc2
                    do  i = 1, nsamp2
                        Fspace(i,j,k) = FSpace(i,j,k) / scl
                    enddo
                enddo
            enddo
         endif

        call gfree (wkxtemp)
        call gfree (wkytemp)

        return

100   continue

      write(LERR,*)' error ',ierr,' from fft routine'
      stop

        end











       subroutine ft3d(sign, Fspace,nsamp2,ntrc2,ngath2)

         real sign
         integer nsamp2,ntrc2,ngath2,i
         complex Fspace(nsamp2,ntrc2,ngath2)

         integer isamp,itrc,igath
         complex xtemp(ntrc2)
         complex ytemp(ngath2)

         ierr = 0

         isign = nint(sign)


         call nanchk(FSpace,nsamp2*ntrc2*2,13.e10)
C
C 3-D Fourier transform the traces
C

      do igath=1,ngath2
         do isamp=1,nsamp2
           do  i = 1, ntrc2
               xtemp(i) = cmplx(0.,0.)
           enddo
           do  i = 1, ntrc2
               xtemp(i)=FSpace(isamp,i,igath)
           enddo
           call ftu( sign, ntrc2, xtemp, ierr )
          if (ierr .ne. 0) then
             write(0,*) ' sign,ntrc2,ierr=',sign,ntrc2,ierr
             write(0,*) ' xxx1'
             goto 100
          endif
           do  i = 1, ntrc2
               FSpace(isamp,i,igath) = xtemp(i)
           enddo
         enddo
      enddo

         call nanchk(FSpace,nsamp2*ntrc2*2,12.e10)

      if (ngath2 .ge. 2) then
      do itrc=1,ntrc2
         do isamp=1,nsamp2
           do  i = 1, ngath2
               ytemp(i) = cmplx(0.,0.)
           enddo
           do  i = 1, ngath2
               ytemp(i)=FSpace(isamp,itrc,i)
           enddo
           call ftu( sign, ngath2, ytemp, ierr )
          if (ierr .ne. 0) then
             write(0,*) ' xxx2'
             goto 100
          endif
           do  i = 1, ngath2
               FSpace(isamp,itrc,i) = ytemp(i)
           enddo
         enddo
      enddo
      endif


         call nanchk(FSpace,nsamp2*ntrc2*2,11.e10) 

      do igath=1,ngath2
         do itrc=1,ntrc2
           call ftu( sign, nsamp2, FSpace(1,itrc,igath), ierr )
          if (ierr .ne. 0) then
             write(0,*) ' xxx3'
             goto 100
          endif
         enddo
      enddo

         call nanchk(FSpace,nsamp2*ntrc2*2,10.e10)


        return

100   continue

      write(LERR,*)' error ',ierr,' from fft routine'
      stop

        end
