C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
        subroutine outerfilt(
     :             nsamp,ntrc,ngath,
     :             w1,w2,w3, wo1,wo2,wo3, 
     :             nsamp2,ntrc2,ngath2,FKBUF,
     :             l2, l3, 
     :             LERR,JJfile )

      integer nsamp2,ntrc2,ngath2
      integer w1,w2,w3
      real    wo1,wo2,wo3
      real eps, alpha
      integer iweight, nsharp
      complex FKBUF(nsamp2,ntrc2,ngath2)


      integer nsamp,ntrc,ngath
      integer  ist,iend
      integer LERR,JJfile 
      integer index
      integer indexwallw

C--- nsamp2,ntrc2,ngath2 are the padded versions of w1,w2,w3
      real*4  windwt(w1,w2,w3)

      real pmodl1(w1,w2,w3)

      real trace(nsamp)

      real effzero 
      real*8 summ

C---

      complex coeff(nsamp2+ntrc2+ngath2+90)


      ipr = 0

c
c  --- keeping this here in case I need it for stabilization of the
c      ccgstep work sometime -----
c
cccc      write(0,*) ' check rms of input'
c--- check rms of input ---
c      index = 1
c      summ = 0.0
c      do j=1,ngath
c      do i=1,ntrc
c         call disk_rd(nsamp,index, trace)
c         do ii=1,nsamp
c            summ = summ + trace(ii)**2
c         enddo
c         index = index + 1
c      enddo
c      enddo
c      rmsdata = sqrt(summ/(nsamp*ntrc*ngath) )
ccc      write(0,*)    ' rms of data=',rmsdata
ccc      write(LERR,*) ' rms of data=',rmsdata






      n1 = nsamp
      n2 = ntrc
      n3 = ngath

      k1 = wo1 * n1/w1


      if (k1 .lt. 1) k1 = 1
      k2 = wo2 * n2/w2


      if (k2 .lt. 1) k2 = 1
      if (k2 .eq. 1 .and. n2 .gt. w2) k2 = k2 + 1
      k3 = wo3 * n3/w3

      if (k3 .lt. 1) k3 = 1
      if (k3 .eq. 1 .and. n3 .gt. w3) k3 = k3 + 1

 
cccc      call fxtent3( windwt, w1,w2,w3,ipr)
      call costent3( windwt, w1,w2,w3,ipr)

 
      indexwallw =  ntrc * ngath  + 1
      call dwallwt3( k1,k2,k3,windwt,
     *    w1,w2,w3, indexwallw, 
     *    nsamp,ntrc,ngath,ipr) 

c  ---- loop over windows -----

      do i3= 1, k3 


c         write(0,*)    ' i3=',i3,' of',k3,' k2=',k2,'  k1=',k1
c         write(LERR,*) ' i3=',i3,' of',k3,' k2=',k2,'  k1=',k1

       write(0,*) ' progress == starting ',i3,' of ', k3,' blocks'
      do i2= 1, k2

      do i1= 1, k1

          index = 1

          call dpatch3( 0,0, i1,i2,i3, k1,k2,k3,  index , n1,n2,n3,
     *         pmodl1, w1,w2,w3,ifirst)


        ampdata=snrm2(w1*w2*w3,pmodl1,1)/sqrt(float(w1*w2*w3))


              nwcount = (l3/2 + (l2 * ( l3-1)) ) * 2

c          ------ do not do zeroed windows ------

           if (ampdata .ne. 0.0) then

             call fx3decon( pmodl1, w1,w2,w3,
     :          nsamp2, l2, l3, FKBUF,
     :           nwcount)

           endif






C#          --- apply window weights ----

          call diag( 0, 0, windwt, w1*w2*w3, pmodl1,pmodl1)

          index = 1 + ntrc * ngath * 2

          call dpatch3( 1,1, i1,i2,i3, k1,k2,k3,  index, n1,n2,n3,
     *       pmodl1, w1,w2,w3,ifirst)


      enddo
      enddo
      enddo




C#          --- apply wall weights ----
       index = 1 + ntrc * ngath * 2
       call ddiag(0,0, indexwallw, n1, n2*n3, index )



      return

      end

c# 3-D fx decon
       subroutine fx3decon(  data,n1,n2,n3,
     :                       n1pow2,   a2,a3, fdata, 
     :                        nwcount)




       integer  n1,n2,n3, a2,a3,n1pow2,  nwcount
       real       lambda
       integer   i1,i2,i3,i,j,n2a,n3a
       integer a3off,a2off
       real scale

       real   data(n1,n2,n3)     

       complex fdata(n1pow2,n2,n3)

       complex fwdata(n2,n3)
       complex rdata(n2,n3)
       complex rrdata(n2,n3)
       complex r1data(n3,n2)
       complex r2data(n3,n2)
       complex r1datao(n2,n3)
       complex r2datao(n2,n3)

       complex cfilter(a2,a3)

       complex ctempa(n2+2*a2, n3+2*a3)
       complex ctempb(n3+2*a3,n2+2*a2)

       lambda = 0.01

       n2a = n2+2*a2
       n3a = n3+2*a3
       a3off = a3
       a2off = a2
       if (n3 .eq. 1) then
          n3a = 1
          n2a = n2
          a3off = 0
          a2off = 0
       endif

c           #   --- convert to complex, zero pad, and fft  ---
       do i3=1,n3 
          do i2=1,n2
             do i1=1,n1        
                fdata(i1,i2,i3) = cmplx(data(i1,i2,i3),0.0) 
             enddo
             do i1=n1+1,n1pow2 
                fdata(i1,i2,i3) = cmplx(0.0,0.0)         
             enddo

                 ierr = 0
             call ftu(-1.0, n1pow2, fdata(1,i2,i3), ierr )
                 if (ierr .ne. 0) write(0,*) ' ftu error '
          enddo

       enddo

c   -- big loop over frequency ---
       do i1=1,n1pow2 

c               #   --- forward prediction ----
          do j=1,n3 
          do i=1,n2 
             fwdata(i,j) = fdata(i1,i,j) 
          enddo
          enddo

cxxx      write(0,*) ' fwdata=',scnrm2(n1*n2*n3,fwdata,1)


cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
cxxxx          if (i1 .ne. 99999) goto 500
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

         
          call cnull ( ctempa, n2a*n3a)
           do j=1,n3 
           do i=1,n2 
              ctempa(i+a2off, j+a3off) = fwdata(i,j) 
           enddo
           enddo

        call predict3(ctempa,n2a,n3a,a2,a3,cfilter,lambda,nwcount,ierr)



           do j=1,n3 
              do i=1,n2 
                 fwdata(i,j) = ctempa(i+a2off, j+a3off) 
             enddo
           enddo


c#  --- for the two-d case, only do two passes ------
         if (n3 .ne.  1) then
c        #   --- reverse prediction ---
         do j=1,n3 
         do i=1,n2 
            rdata(i,j) = fdata(i1,i,n3-j+1) 
         enddo
         enddo
         
        call cnull ( ctempa, n2a*n3a)

        do j=1,n3 
        do i=1,n2 
           ctempa(i+a2off, j+a3off) = rdata(i,j) 
        enddo
        enddo

       call predict3(ctempa,n2a,n3a,a2,a3,cfilter,lambda,nwcount,ierr)

         do j=1,n3 
         do i=1,n2 
           rdata(i,j) = ctempa(i+a2off, j+a3off) 
         enddo
         enddo

         do j=1,n3 
         do i=1,n2 
          rrdata(i,j) = rdata(i,n3-j+1) 
         enddo
         enddo
   
         do j=1,n3 
         do i=1,n2 
          r1data(j,i) = fdata(i1,i,j) 
         enddo
         enddo
     
       call cnull ( ctempb, n2a*n3a)
       do i=1,n2 
          do j=1,n3 
             ctempb(j+a3off, i+a2off) = r1data(j,i) 
          enddo
       enddo

       call predict3(ctempb, n3a,n2a,a3,a2,cfilter,lambda,nwcount,ierr)

       do i=1,n2 
       do j=1,n3 
          r1data(j,i) = ctempb(j+a3off, i+a2off) 
       enddo
       enddo

       do j=1,n3  
       do i=1,n2 
         r1datao(i,j) = r1data(j,i) 
       enddo
       enddo

       endif
    

       do j=1,n3 
       do i=1,n2 
         r2data(j,i) = fdata(i1,n2-i+1,j) 
       enddo
       enddo

       call cnull ( ctempb, n2a*n3a)
       do i=1,n2 
       do j=1,n3 
          ctempb(j+a3off, i+a2off) = r2data(j,i) 
       enddo
       enddo

       call predict3(ctempb, n3a,n2a,a3,a2,cfilter,lambda,nwcount,ierr)

       do i=1,n2 
       do j=1,n3 
          r2data(j,i) = ctempb(j+a3off, i+a2off) 
       enddo
       enddo

       do j=1,n3
       do i=1,n2 
         r2datao(i,j) = r2data(j,n2-i+1) 
       enddo
       enddo
     

c                              #   --- merge into output ---
      if (n3 .ne.  1) then

c-----  fill in the edges -----

         do i3=1,a3-1
            do i2=1,n2 
               fdata(i1,i2,n3-i3+1) =fwdata(i2,n3-i3+1)
            enddo
         enddo

         do i2=1,a2-1
            do i3=1,n3 
               fdata(i1,i2,i3) = r2datao(i2,i3)
            enddo
         enddo

         do i3=1,a3-1
            do i2=1,n2 
               fdata(i1,i2,i3) = rrdata(i2,i3)
            enddo
         enddo

         do i2=1,a2-1
            do i3=1,n3 
               fdata(i1,n2-i2+1,i3) =r1datao(n2-i2+1,i3)
            enddo
         enddo
    
      else 
         do i2=1,n2 
            fdata(i1,i2,1) =fwdata(i2,1)
         enddo
      endif
    

      if (n3 .ne. 1) then
         do i3=a3,n3-1 
            do i2=a2,n2-1 
               fdata(i1,i2,i3) =
     :         ( fwdata(i2,i3) + rrdata(i2,i3) +
     :          r1datao(i2,i3) +r2datao(i2,i3)    )/4.0
            enddo
         enddo
      endif

cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
 500    continue
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

       
      enddo
c  --- end of big loop over freq


      do i3=1,n3            
         do i2=1,n2      ! #     --- fft and convert back to real ---
                 ierr = 0
            call ftu(+1.0, n1pow2, fdata(1,i2,i3), ierr )
                 if (ierr .ne. 0) write(0,*) ' ftu error '

            do i1=1,n1 
               data(i1,i2,i3) = data(i1,i2,i3)-real( fdata(i1,i2,i3) ) 
            enddo
         enddo
      enddo



      return

      end


      subroutine predict3( data,n2,n3, a2,a3, aa, lambda ,nwcount,ierr)
      integer n2,n3, a2,a3, nwcount
      integer niter,lag2,lag3
      complexdata(n2,n3), aa(a2,a3)
      real lambda
      real epsilon,dot
      integer i,j
      integeri2,i3, a23, r23, iter
      complex rr(n2*n3+a2*a3)
      complex da( a2,a3), dr( n2*n3+a2*a3 )
      complex sa( a2,a3), sr( n2*n3+a2*a3 )
      real raa(a2,a3), iaa(a2,a3)
      a23 = a2*a3
      r23 = n2*n3+a2*a3
      lag2 = (a2/2)+1
      lag3=1
      if(.not.(n3 .eq. 1))goto 23000
      lag2=1
23000 continue
      call cnull( rr, r23)
      call cnull( aa, a23)
      aa( lag2, lag3 ) = 1.
      call cnull( dr, r23)
      call cnull( da, a23)
      niter = ( (a3-1) * a2 + (a2-1)/2 )*2
      epsilon = sqrt( dot(n2*n3, data, data) * lambda**2)
      i=0
      do 23002 i2=1,a2
      do 23004 i3=1,a3 
      i=i+1
      rr(n2*n3+i) = aa(i2,i3)*epsilon 
23004 continue
23002 continue
      call cconv ( 0, 0, lag2,lag3, data,n2,n3, aa,a2,a3, rr )
      do 23006 i=1,n2*n3 
      rr(i) = -rr(i) 
23006 continue

cxxx      write(0,*) ' data=',scnrm2(n2*n3,data,1)

      do 23008 iter= 0, niter 
      call cconv ( 1, 0, lag2,lag3, data,n2,n3, da,a2,a3, rr )
      i=0
      do 23010 i2=1,a2
      do 23012 i3=1,a3 
      i=i+1
      da(i2,i3)=da(i2,i3)+epsilon*rr(n2*n3+i)
23012 continue
23010 continue
      i3= 1
      if(.not.(n3 .ne. 1))goto 23014
      do 23016 i2= lag2, a2 
      da(i2,i3) = cmplx(0.0,0.0) 
23016 continue
      goto 23015
23014 continue
      da(1,1) = cmplx(0.0,0.0)
23015 continue
      i=0
      do 23018 i2=1,a2
      do 23020 i3=1,a3 
      i=i+1
      rr(n2*n3+i) = aa(i2,i3)*epsilon 
23020 continue
23018 continue
      call cconv ( 0, 0, lag2,lag3, data,n2,n3, da,a2,a3, dr )
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
cxxx      write(0,*) ' dr=',scnrm2(n2*n3,dr,1)
cxxx      write(0,*) ' rr=',scnrm2(n2*n3,rr,1)

cxxx      write(0,*) ' a23,r23,iter=',a23,r23,iter
      call ccgstep( iter, a23 , aa,da,sa,r23 , rr,dr,sr ,ierr)
	if (ierr .ne. 0) then
	    write(0,*) ' ccgstep error  iter=',iter
	    goto 50000
	endif
23008 continue

50000 continue

      call cconv ( 0, 0, lag2,lag3, data,n2,n3, aa,a2,a3, rr )
      call rmov(data,n2,n3, rr)
      return
      end

C  -- complex convolution and adjoint

      subroutine cconv( conj,add, lg2,lg3, xx,n2,n3, bb,nb2,nb3, yy)
      integer conj,add, lg2,lg3, n2,n3, nb2,nb3
      complex xx(n2,n3), bb(nb2,nb3)
      complex yy(n2,n3)
      integer y1,y2,y3, x1,x2,x3, b1, b2, b3
      integer i,j

      if(.not.(add .eq. 0 ))goto 23028

      if(.not.( conj .eq. 0 ))goto 23030

      do  i=1,n2
         do  j=1,n3
            yy(i,j) = cmplx(0.0,0.0)
         enddo
      enddo

      goto 23031

23030 continue

      do  i=1,nb2
         do  j=1,nb3
            bb(i,j) = cmplx(0.0,0.0)
         enddo
      enddo


23031 continue

23028 continue

      if (conj .eq. 0) then

        do b3=1,nb3
         do  y3= 1+nb3-lg3, n3-lg3+1
            x3= y3 - b3 + lg3
            do  b2=1,nb2 
               do y2= 1+nb2-lg2, n2-lg2+1 
                  x2= y2 - b2 + lg2
                  yy(y2,y3)= yy(y2,y3) + bb(b2,b3) * (xx(x2,x3))
               enddo
            enddo
         enddo
        enddo

      else

        do b3=1,nb3
         do  y3= 1+nb3-lg3, n3-lg3+1
            x3= y3 - b3 + lg3
            do  b2=1,nb2 
               do y2= 1+nb2-lg2, n2-lg2+1 
                  x2= y2 - b2 + lg2
                  bb(b2,b3)= bb(b2,b3)+yy(y2,y3) * conjg(xx(x2,x3))
               enddo
            enddo
         enddo
        enddo

      endif



      return
      end



      subroutine ccgstep( iter, n, x, g, s, m, rr, gg, ss, ierr)
      integer i, iter, n, m, ierr
      complexx(n), rr(m),g(n), gg(m),s(n), ss(m)
      real*8 scdot, sds, gdg, gds, determ, gdr, sdr, alfa, beta
      if(.not.( iter .eq. 0 ))goto 23000
      do 23002 i= 1, n
      s(i) = cmplx(0.0,0.0)
23002 continue
      do 23004 i= 1, m
      ss(i) = cmplx(0.0,0.0)
23004 continue
      if(.not.( scdot(m,gg,gg).eq.0 ))goto 23006
      write(0,*) ' cgstep: grad vanishes identically'
      ierr = 1
      return
23006 continue
      alfa = scdot(m,gg,rr) / scdot(m,gg,gg)
      beta = 0.
      goto 23001
23000 continue
      gdg = scdot(m,gg,gg)
      sds = scdot(m,ss,ss)
      gds = scdot(m,gg,ss)
      determ = gdg * sds - gds * gds + 1.e-15
      gdr = scdot(m,gg,rr)
      sdr = scdot(m,ss,rr)
      alfa = ( sds * gdr - gds * sdr ) / determ
      beta = (-gds * gdr + gdg * sdr ) / determ
23001 continue
      do 23008 i= 1, n
      s(i) = alfa * g(i) + beta * s(i)
23008 continue
      do 23010 i= 1, m
      ss(i) = alfa * gg(i) + beta * ss(i)
23010 continue
      do 23012 i= 1, n
      x(i) = x(i) + s(i)
23012 continue
      do 23014 i= 1, m
      rr(i) = rr(i) - ss(i)
23014 continue
      return
      end

      real*8 function scdot( n, x, y )
      integer i, n
      complex x(n), y(n)
      real*8  val
      val = 0.
      do 23016 i=1,n 
      val = val + real(x(i)) * real(y(i)) 
23016 continue
      do 23018 i=1,n 
      val = val + aimag(x(i)) * aimag(y(i)) 
23018 continue
      scdot = val
      return
      end
