C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c---------------------------------------------
C# triangle tent weights for 3-D convolution

      subroutine costent3( windwt, w1,w2,w3,ipr)
        implicit none
      integer           a1,a2,a3,         w1,w2,w3, ipr
      real*4     	            windwt( w1,w2,w3)
      integer i1,i2,i3,  s1,s2,s3,  e1,e2,e3
      integer i,j,k
      real*4 mid1,mid2,mid3, wide1,wide2,wide3, x,y,z
      real*4 small
      real twopi,pihalf

      twopi = 3.14159 * 2.0
      pihalf = 3.14159/2.0

      a1=1
      a2=1
      a3=1
c     small = 0.001_4
      small = 0.001
      do i3=1,w3
      do i2=1,w2
      do i1=1,w1
          windwt(i1,i2,i3) = small 
      enddo
      enddo
      enddo

        s1= a1
	e1= w1
        mid1=(e1-1.0)/2.0 + 1.0
        wide1=(e1+1.)/2.
        if (wide1 .lt. 1) wide1 = 1.0
        s2= a2
	e2= w2
        mid2=(e2-1.0)/2.0 + 1.0
        wide2=(e2+1)/2.
        if (wide2 .lt. 1) wide2 = 1.0
        s3= a3
	e3= w3
        mid3=(e3-1.0)/2.0 + 1.0
        wide3=(e3+1)/2.
        if (wide3 .lt. 1) wide3=1.0

      do i3= s3, e3 
         y = (i3-mid1)/wide3
         y = abs( cos(pihalf * y ) )
      do i2= s2, e2 
         x = (i2-mid2)/wide2
         x = abs( cos(pihalf * x) )
      do i1= s1, e1 
         z = (i1-mid1)/wide1
         z = abs( cos(pihalf * z) )
	windwt(i1,i2,i3) = windwt(i1,i2,i3) +
     *                     max( small, x)  * 
     *                     max( small, y)  *
     *                     max( small, z) 
      enddo
      enddo
      enddo

      return
      end


C# triangle tent weights for 3-D convolution

      subroutine fxtent3( windwt, w1,w2,w3,ipr)
        implicit none
      integer           a1,a2,a3,         w1,w2,w3, ipr
      real*4     	            windwt( w1,w2,w3)
      integer i1,i2,i3,  s1,s2,s3,  e1,e2,e3
      real*4 mid1,mid2,mid3, wide1,wide2,wide3, x,y,z
      real*4 small

      a1=1
      a2=1
      a3=1
c     small = 0.001_4
      small = 0.001
      do i3=1,w3
      do i2=1,w2
      do i1=1,w1
          windwt(i1,i2,i3) = small 
      enddo
      enddo
      enddo

      s1= a1
	e1= w1
        mid1=(e1-1.0)/2.0 + 1.0
        wide1=(e1+1.)/2.
        if (wide1 .lt. 1) wide1 = 1
        s2= a2
	e2= w2
        mid2=(e2-1.0)/2.0 + 1.0
        wide2=(e2+1)/2.
        if (wide2 .lt. 1) wide2 = 1
        s3= a3
	e3= w3
        mid3=(e3-1.0)/2.0 + 1.0
        wide3=(e3+1)/2.
        if (wide3 .lt. 1) wide3=1

      do i3= s3, e3 
        y = abs((i3-mid3)/wide3)
      do i2= s2, e2 
        x = abs((i2-mid2)/wide2)
      do i1= s1, e1 
        z = abs((i1-mid1)/wide1)
	windwt(i1,i2,i3) = windwt(i1,i2,i3) +
     *                     max( small, 1.0 - abs(x))  * 
     *                     max( small, 1.0 - abs(y))  *
     *                     max( small, 1.0 - abs(z)) 
      enddo
      enddo
      enddo
Cxxxxxxxxxxx
cxxxxx       windwt = 1.0
czzzzzzzzzzzz
      return
      end


C---------------------------------------------
C# 3-D make wall weights from window weights.
C#
       subroutine dwallwt3( k1,k2,k3, windwt, w1,w2,w3,  
     *      indexin, n1,n2,n3,ipr)
        implicit none
       integer i,i1,i2,i3,k1,k2,k3,w1,w2,w3,n1,n2,n3,ipr
       real*4 windwt( w1,w2,w3)
       integer indexin, index, ierr, iabort, jsz
c      real bufd(n1)
       real bufd
       pointer (wkbufd, bufd(10))
       integer ifirstt
       real snrm2
       data iabort /0/

       call sizefloat(jsz)
       call galloc (wkbufd, jsz*n1, ierr, iabort)

       do  i = 1, n1
           bufd(i) = 0.0
       enddo

      index = indexin
       do i3= 1, n3 
       do i2= 1, n2 
           call disk_wr(n1,index, bufd )
           index = index + 1
       enddo
       enddo
ccccc       write(0,*) ' done zeroing wallwt'



       do i3= 1, k3  
       do i2= 1, k2  
       do i1= 1, k1  
	call dpatch3( 1,1, i1,i2,i3, k1,k2,k3,  indexin, n1,n2,n3,
     *     windwt, w1,w2,w3 ,ifirstt)
       enddo
       enddo
       enddo
ccccc       write(0,*) ' done initializing wallwt'


       index = indexin

       do i3= 1, n3 
       do i2= 1, n2 
           call disk_rd(n1,index, bufd )
       do i1= 1, n1 
	if(  bufd( i1) .ne. 0.) then
            bufd( i1)  = 1. / bufd( i1)
        else
        endif
       enddo
           call disk_wr(n1,index, bufd )
           index = index + 1
       enddo
       enddo

       call gfree (wkbufd)

       return
       end
C---------------------------------------------
C# dpatch3 ---- copy the j[123]-th of k[123] subcubes from a volume.
C#
       subroutine dpatch3( conj,add, j1,j2,j3, k1,k2,k3, 
     *  indexin, n1,n2,n3, wind, w1,w2,w3,ifirstt)
        implicit none
       integer conj,add, j1,j2,j3, k1,k2,k3,n1,n2,n3,w1,w2,w3
       integer i1,i2,i3, s1,s2,s3, d1,d2,d3
       integer ifirstt
cxxx       real*4 wall( n1,n2,n3),
       real*4 wind( w1,w2,n3)
c      real*4 bufd(n1)
       real bufd
       pointer (wkbufd, bufd(10))

       integer index,indexin
       integer isamp,nsmp,iabort,ierr,jsz

       data iabort /0/

       call sizefloat(jsz)
       call galloc (wkbufd, jsz*n1, ierr, iabort)


czzz       write(0,*) 'indexin,n1,n2,n3=',indexin,n1,n2,n3
czzz        write(0,*) ' ptx1  k1,k2,k3=',k1,k2,k3
czzz      write(0,*) '  w1,w2,w3=', w1,w2,w3


cxxx       call conjnull(conj,add, wall, n1*n2*n3, wind, w1*w2*w3)
      if (add .eq. 0) then
       if (conj .eq.  0) then
cxxx          wind = 0.0
          do i3=1,w3
             do i2=1,w2
                do i1=1,w1
                   wind(i1,i2,i3) = 0.0
                enddo
             enddo
          enddo
czzz        write(0,*) ' pty1  k1,k2,k3=',k1,k2,k3

       else

c----- zero out the disk buffer 
          call zerodbuf(indexin, n1,n2,n3)
          
       endif
      endif
czzz        write(0,*) ' ptx2  k1,k2,k3=',k1,k2,k3

       if( k3 .ne. 1) then
         if (j3 .eq. k3) then
          s3 = n3 - w3 + 1
         else
          s3 = 1.5 + (n3 - w3) * (j3-1.)/(k3-1.)
         endif
       else
          s3= 1
       endif
       if( k2 .ne. 1) then
         if (j2 .eq. k2) then
          s2 = n2 - w2 + 1
         else
          s2 = 1.5 + (n2 - w2) * (j2-1.)/(k2-1.)
         endif
       else 
          s2= 1
       endif
       if( k1 .ne. 1) then
         if (j1 .eq. k1) then
          s1 = n1 - w1 + 1
         else
          s1 = 1.5 + (n1 - w1) * (j1-1.)/(k1-1.)
         endif
       else 
          s1= 1
       endif
        ifirstt = s1

czzz        write(0,*) ' s1,s2,s3,k1,k2,k3=',s1,s2,s3,k1,k2,k3

       do i3= 1, w3 
           d3= i3 + s3 - 1
           do i2= 1, w2 
              d2= i2 + s2 - 1

              index = indexin+ (d2-1) + (d3-1)*n2
              isamp = s1
              nsmp = w1

cxxx        write(0,*) ' s1,s2,s3,k1,k2,k3=',s1,s2,s3,k1,k2,k3
cxxx        write(0,*) ' n1,index,isamp,nsmp=',n1,index,isamp,nsmp



              call disk_rwn(n1,index,isamp,nsmp, bufd )
              do i1= 1, w1 

                   if( conj .eq. 0 ) then
	             wind( i1,i2,i3) = 
     *               wind( i1,i2,i3) + bufd(i1)

cxxx     *               wind( i1,i2,i3) + wall( d1,d2,d3)
                   else
          	     bufd(i1) = 
     *               bufd(i1) + wind( i1,i2,i3)

cxxx     *               wall( d1,d2,d3) + wind( i1,i2,i3)
                   endif
              enddo

              call disk_wwn(n1,index,isamp,nsmp, bufd )

        enddo
        enddo

       call gfree (wkbufd)

       return
       end
C---------------------------------------------
       subroutine diag( conj, add, lambda,n,  pp,    qq)
        implicit none
       integer i,conj, add,n 
       real*4 lambda(n), pp(n), qq(n)
       if( conj .eq. 0 ) then
	if( add .eq. 0 ) then
           do i=1,n  
                qq(i) =    lambda(i) * pp(i) 
           enddo
	else           
           do i=1,n 
               qq(i) = qq(i) + lambda(i) * pp(i) 
           enddo
	endif
       else 
         if( add .eq. 0 ) then
          do i=1,n 
             pp(i) = lambda(i) * qq(i) 
          enddo
	else    
           do i=1,n 
              pp(i) = pp(i) + lambda(i) * qq(i)
           enddo
        endif
       endif

       return
       end

C---------------------------------------------
       subroutine ddiag( conj, add, indexwallw,nsamp, n, indexin)
        implicit none
       integer i,conj, add,n,nsamp
       integer index , indexin
       integer indexw, indexwallw, iabort, ierrt, ierr, jsz
c      real qq(nsamp)
c      real lambda(nsamp)
       real qq
       real lambda
       pointer (wkqq, qq(10))
       pointer (wklambda, lambda(10))
     
      
       integer ii
       data iabort /0/
       data ierrt /0/
       data ierr  /0/

       call sizefloat(jsz)
       call galloc (wkqq, jsz*nsamp, ierr, iabort)
       ierrt = ierrt + ierr
       call galloc (wklambda, jsz*nsamp, ierr, iabort)
       ierrt = ierrt + ierr

       if (add .ne. 0 .or. conj .ne. 0 ) then
          write(0,*) ' error in ddiag - no add or conj option available'
          stop 456
       endif

       index = indexin
       indexw = indexwallw
       do ii=1,n
        call disk_rd(nsamp,index, qq )
        call disk_rd(nsamp,indexw, lambda )



       if( conj .eq. 0 ) then
	if( add .eq. 0 ) then
           do i=1,nsamp
                qq(i) =    lambda(i) * qq(i) 
           enddo
	else           
           do i=1,nsamp 
               qq(i) = qq(i) + lambda(i) * qq(i) 
           enddo
	endif
       else 
         if( add .eq. 0 ) then
          do i=1,nsamp 
             qq(i) = lambda(i) * qq(i) 
          enddo
	else    
           do i=1,nsamp 
              qq(i) = qq(i) + lambda(i) * qq(i)
           enddo
        endif
       endif

         call disk_wr(nsamp,index,qq)
         index = index + 1
         indexw = indexw + 1
       enddo

       call gfree (wkqq)
       call gfree (wklambda)

       return
       end

       subroutine zerodbuf(indexin, n1,n2,n3)
       integer n1,n2,n3
c      real*4 bufd(n1)
       real*4 bufd
       pointer (wkbufd, bufd(10))
       integer i1,i2,i3,i
       integer indexin,index,ierrt, ierr, jsz
       
       data iabort /0/
       data ierrt /0/
       data ierr  /0/

       call sizefloat(jsz)
       call galloc (wkbufd, jsz*n1, ierr, iabort)
       ierrt = ierrt + ierr

c-----       write(0,*) ' indexin, n1,n2,n3=',indexin, n1,n2,n3
c----- zero out the disk buffer 
          index = indexin
          do  i = 1, n1
              bufd(i) = 0.0
          enddo
          do i3= 1, n3 
          do i2= 1, n2 
              call disk_wr(n1,index, bufd )
              index = index + 1
          enddo
          enddo 
          
       call gfree (wkbufd)

       return
       end
