C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rmdian(n,x,xmdian)

c***********************************************************************
c     This subroutine determines the median value of an array after
c     sorting into increasing order.
c
c**** Subroutine inputs.
c
c     n = The number of points in the input data array.
c     x = The input array of data values under consideration.
c
c**** Subroutine outputs.
c
c     x = The input array sorted into increasing order.
c     xmdian = The median value of the array x.
c
c**** Subroutines required.
c
c     rslect
c     rminsn
c     rswap
c
c***********************************************************************

      integer n
      real*4 x(n),xmdian,x1,x2,axmin
      integer nind2,index,indexa

      nind2 = n / 2

      if(mod(n,2).ne.0) then

        call rslect(nind2 + 1,n,x,xmdian)

        else

        call rslect(nind2,n,x,x1)
        call rminsn(nind2,x(nind2 + 1),x2,index,axmin,indexa)
        xmdian = (x1 + x2) / 2.0

      endif

      return
      end
