      subroutine rslect(k,n,arr,kval)

c***********************************************************************
c     This subroutine finds the kth. smallest value of an array.  The
c     input array is arranged such that elements with values less than
c     the kth will be from arr(1:k - 1) and elements larger than the kth
c     will be from arr(k + 1:n) in arbitrary order respectively.
c
c     See Press. et.al. "Numerical Recipes in Fortran", Page 333
c
c**** Subroutine inputs
c
c     k = The size ordered element for which the value is required
c     n = The length of the array, arr
c     arr = The array to be scanned
c
c**** Subroutine outputs
c
c     kval = The value of the kth. element
c     arr = The rearranged but not completely sorted array.
c
c**** Subroutine required
c
c     rswap
c
c***********************************************************************

      integer k,n
      real*4 arr(n)

      integer i,ir,j,l,mid,lp1
      real*4 a,kval

      l = 1
      ir = n

c***********************************************************************
c     Loop until the active partition has only two elements
c***********************************************************************

      do while(ir - l.gt.1)

c***********************************************************************
c     Choose the median of the left,centre, and right elements as the
c     partitioning element, a.
c     Arrange so that arr(l + 1) <= arr(l) <= arr(ir)
c***********************************************************************

        mid = (l + ir) / 2
        lp1 = l + 1
        call rswap(arr(mid),arr(lp1))
        if(arr(lp1).gt.arr(ir)) call rswap(arr(ir),arr(lp1))
        if(arr(l).gt.arr(ir)) call rswap(arr(ir),arr(l))
        if(arr(lp1).gt.arr(l)) call rswap(arr(l),arr(lp1))

c***********************************************************************
c     Initialize pointers for partitioning
c***********************************************************************

        i = lp1
        j = ir
        a = arr(l)

c***********************************************************************
c     begin innermost loop, scan up to find element > a
c***********************************************************************

    2   i = i + 1

        do while(arr(i).lt.a)

          i = i + 1

        enddo

c***********************************************************************
c     scan down to find element < a
c***********************************************************************

       j = j - 1

        do while(arr(j).gt.a)

          j = j - 1

        enddo

c***********************************************************************
c    if pointers do not cross, exchange elements go through inner loop
c     again.
c***********************************************************************

        if(j.ge.i) then

          call rswap(arr(i),arr(j))
          goto 2

        endif

c***********************************************************************
c     Insert partitioning element, keep active the partition containing
c     the kth. element
c***********************************************************************

        arr(l) = arr(j)
        arr(j) = a
        if(j.ge.k) ir = j - 1
        if(j.le.k) l = i

      enddo

c***********************************************************************
c     Active partition contains two elements, swap if necessary then
c     return kval.
c***********************************************************************

      if(ir - l.eq.1) then

        if(arr(ir).lt.arr(l)) call rswap(arr(ir),arr(l))

      endif

      kval = arr(k)
      return
      end
