C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cvnfre (lerr,input,lhed,tri,tro,filtr,temp,trnout,
     1                   n2,filtrc,tempc,trnc,nsamp,lngfl,iper,ampl,
     2                   isi,fftfrd,fftinv,ictr,ientry,noscl,mode,
     3                   rmplen,factor,xramp,icount,datlen,inverse,
     4                   rmpflg,zerofg,zeros,ramp,kop,iws,iwe,imut,
     5                   l_StaCor,l_RecNum,l_TrcNum,ifflg,phzo,ifh,
     6                   amps,phz,amps1,phz1,amps2,phz2,si,work,
     7                   prew,SZLNHD,SZTRHD,SZFFTB,SZSMPD,ITHWP1,
     8                   wweight,scalout)

c*****************************************************************
c
c  amoco production co. proprietary - to be maintained in confidence
c
c  apply time impulse response filter to data if mode 0. 
c  apply computed filter to data if mode 1 or 2.
c  SIS GENF ALGORITHM
c
c  primary differences from GENF:
c     1) reading writing of trace data done in calling routine - main
c     2) MathAdv FFT routines used to go to and from frequency domain
c
c******************************************************************
      integer
     : rmpdim, SZFFTB, SZLNHD
      parameter (rmpdim=48)

      real
     : tri(*),tro(*),filtr(*),temp(*),sclfr(512),
     : ramp(48),trnout(*), ampl(*), mxv, 
     : temp1, temp2, amps(*), phz(*), amps1(*), phz1(*),
     : amps2(*), phz2(*), work(*)

      complex
     : filtrc (*), tempc (*), trnc (*)

      logical
     : rmpflg, zerofg, zeros, inverse, phzo, wweight, scalout
 
      integer
     : input(*)
 
      integer
     :lhed(*)
 
      integer
     : SZSMPD, SZTRHD, fftfrd, fftinv, i, ictr,
     : ientry, ifflg, imut, iper,
     : irecno, isi, itrno, iwe, iws,
     : kop, lerr, lngfl, 
     : n2, n3, ne, noscl, ns, nsamp, nsu, 
     : ntrr, rmplen, factor, datlen
 
      save n3,idel,isign

      data 
     : mxv/32768.0/,sclfr/512*0/,ibad/0/

      IF (ientry .ne. 0) goto 100

      if(noscl .ne. 0 .and. ne .gt. 512) then
       write(lerr,*)' Traces/Record = ',ntrr
       write(lerr,*)'Can only handle a max of 512 traces'
       write(lerr,*)'per record when scaling is requested'
       write(lerr,*)' - command line parameters:'
       write(lerr,*)'  -ip, -is, -ie'
       stop
      endif
c
c build ramp function for early mute preservation
c
      if (imut .eq. 0) then
c------
c subroutine muproc is bldrmp modified.  bldrmp has multiple
c entry points which for some reason was not being compiled
c correctly
c------
         kop = 1
         call muproc(tri,nsamp,isi,lerr,kop,zeros,
     :        rmpdim,SZSMPD)
      endif

      ictr=0

100   continue

      irecno = l_RecNum
      itrno  = l_TrcNum

      call vmov (lhed(ITHWP1), 1, temp, 1, nsamp)

      do  i = 1, SZLNHD
          tempc (i) = cmplx (0.,0.)
          trnc  (i) = cmplx (0.,0.)
      enddo

 
350   if (imut .ne. 1) then
         kop = 3
         call muproc(temp,nsamp,isi,lerr,kop,zeros,
     :       rmpdim,SZSMPD)
c        if (zeros) go to 150
      endif
 
c*******************************************************

c-----
c  do this next stuff only once
c-----
      IF (ientry .eq. 0) THEN

        pi = 3.14159265
        twopi = 2 * pi
        raddeg = 180./pi
c n2 computed with function gfpw2 in main
        n3 = n2/2 + 1
c-----
c     do i =1,lngfl
c     write(22,*)i,ampl(i)
c     enddo
          do  i = lngfl+1, n3
              ampl(i) = 0.
          enddo
          call vmov(ampl,1,filtr(1),1,lngfl)
          call hilbertx (filtr, lngfl, ampl, ierr, SZSMPD)
          do  i = 1, lngfl
              ampl (i) = sqrt( filtr(i) **2 + ampl(i) **2 )
          enddo

c---
c  find max envelope
c---
          call maxmgv (ampl, 1, xmax, idel, lngfl)

          lw = idel - lngfl/10
          if (wweight .AND. (lw .gt. lngfl/10)) then
             do  i = 1, lngfl
                 ampl (i) = 1
             enddo
             do  i = 1, lw
                 wt = .5 * (1. + cos ( pi*(lw-i+1)/lw ))
                 ampl (i) = wt
                 ampl (lngfl-i+1) = wt
             enddo
             do  i = 1, lngfl
                 filtr (i) = filtr (i) * ampl (i)
             enddo
          endif
c         do i = 1, lngfl
c         write(13,*)i,filtr(i)
c         enddo

          isign = 1
          if     (mode .eq. 1) then
             idel = idel + 1
          elseif (mode .eq. 0 .and. .not.inverse) then
c            idel = 2
          elseif (mode .eq. 0 .and. inverse) then
             isign = -1
             idel = idel - 1
          elseif (mode .eq. 2) then
             idel = idel - 2
          endif

c         idel = idel - 1
          idel = idel - 2

          do  i = 1, lngfl
              filtrc (i) = cmplx (filtr(i),0.0)
c     write(8,*)i,filtr(i)
          enddo

          phz0 = twopi * (idel * si)
          fnyq = .5/si
          df = fnyq/float(n3-1)
c     write(0,*)'si,df= ',si,df

c----
c Frequency domain processing - using Math Advantage

c Move filter into filtr array for fft
c----

c----
c Following what's suggested in Math. Ad. manual

c Do forward fft on filter
c----
        call rfftb (filtr, filtrc, n2, 1)
c----
c Scale output and unpack into n2/2 + 1 complex elements
c Scaling: results are multiplied by (1/(4*n2))
c----
        call rfftsc (filtrc,n2,3,0)
c----
c  extract amplitude and phase of wavelet
c----

           do  i = 1, n3
               xr = real (filtrc(i) )
               xi = aimag (filtrc(i) )
               den = sqrt(xr*xr + xi*xi)
               amps (i) = den
               if (den .ne. 0.0) then
                  phz (i) = atan2 ( xi , xr )
               else
                  phz (i) = 0.0
               endif
c              phz1(i) = raddeg * phz(i)
           enddo
c          call unwrap(phz1,n3)

c          do  i = 1, n3
c     if(mod(i,2).eq.0)write(9,*)df*(i-1),amps(i),phz1(i)
c          enddo

c----
c   for inverse compute 1/amp
c----
           iord = .1 * n3
           if (inverse) then
              call SmoothFit (amps, n3, iord)
              call maxmgv (amps, 1, amax, loc, n3)
              thr = prew * amax
c     write(0,*)'thr= ',thr
              do  i = n3, 1, -1
                  if (amps(i) .gt. thr) then
                     ifh = i
                     go to 5
                  endif
              enddo
5             continue

c             do  i = 1, n3
c             write(9,*)i,amps(i)
c             enddo

              do  i = 1, n3
                  if (amps(i) .lt. thr) amps(i) = thr
                  amps (i) = 1 / amps(i)
              enddo
              call SmoothFit (amps, n3, iord)
              do i=1,n3
                 if (amps(i) .le. 0) amps(i) = 0
              enddo
           endif

           if (.not. scalout) then
              call maxmgv (amps, 1, amax, loc, n3)
              do  i = 1, n3
                  amps (i) = amps (i) / amax
              enddo
           else
              do  i = 1, n3
                  amps (i) = .5 * amps (i)
              enddo
           endif
c----
c   for phase only convolution flatten amplitude spectrum
c----
           if (phzo) then
              do  i = 1, n3
                  amps (i) = 1.0
              enddo
           endif

c          iord = .1 * n3
c          call SmoothFit (amps, n3, iord)
c          do  i = 1, n3
c              if(i .le. ifh) amps(i) = 1
c              if (amps(i) .lt. 0.0) amps(i) = 0.
c          write(11,*)i,amps(i),raddeg*phz(i)
c          enddo

c          call cvmexp (phz , 1, amps, 1, filtrc, 2, n3)
c          call rfftsc (filtrc,n2,-3,1)
c          call rfftb(filtrc,temp,n2, -1)
c          do i = 1, lngfl
c             write(12,*)i,temp(i)
c          enddo

c----
c The above needs to done only when first seismic trace is read
c----

      ENDIF
      ientry = 1
c*******************************************************
 
c----
c Do forward fft on trace
c----
      call vclr(tempc, 1, n2)
      call vclr(temp,1,n2)
      call vmov(tri,1,temp,1,nsamp)
      call rfftb (temp, tempc, n2, 1)
c----
c No scaling, just unpack into n2/2 + 1 complex elements
c----
      call rfftsc (tempc,n2,3,0)
c----
c   extract amplitude and phase of input data
c----

      IF (mode .eq. 0) THEN

         do  i = 1, n3
   
             xr = real(tempc(i))
             xi = aimag(tempc(i))
             den = sqrt(xr*xr + xi*xi)
             amps1 (i) = den
             if (den .ne. 0.0) then
                phz1 (i) = atan2 ( xi , xr )
             else
                phz1 (i) = 0.0
             endif
   
         enddo
c----
c   For inverse find the highest freq index of useful spectrum
c   and then limit spectrum
c----
         IF (inverse) THEN
c----
c   For inverse form product of inverse of wavelet spectrum and input
c   spectrum; phase is the sum of wavelet and input (sign depends on
c   inverse or not)
c----
            do  i = 1, n3
                amps2 (i) = (amps1 (i) * amps (i))
                phz2  (i) = phz1 (i) + isign * phz(i)
c     write(11,*)df*(i-1),amps2(i),phz2(i)
            enddo

         ELSE
c----
c   IF not inverse then form product of amp spectra of input and wavelet
c   and sum of phase spectra (sign depends on inverse or not).
c----
            do  i = 1, n3
                amps2 (i) =  (amps1 (i) * amps (i))
                phz2  (i) = phz1 (i) + isign * phz(i)
            enddo
         ENDIF

         do  i = 1, n2
             tempc (i) = 0.0
         enddo

c----
c   reform complex spectra from amp & phz
c----
         call cvmexp (phz2 , 1, amps2, 1, tempc, 2, n3)

c----
c No scaling, just packing into complex FFT format
c----
         call rfftsc (tempc,n2,-3,1)

      ELSE

c     write(0,*)'mode = ',mode
         do  i = 1, n3
             tempc (i) = tempc (i) * filtrc (i)
         enddo

      ENDIF
c----
c Do inverse FFT
c----
c     call rfft (tempc,n2,fftinv)
      call rfftb (tempc, work, n2, -1)

      call vclr (temp, 1, nsamp)

      IF (inverse) THEN
         do  i = 1, nsamp
             temp(i+idel) = work(i)
         enddo
      ELSE
         do  i = 1, nsamp
             temp(i) = work(i+idel)
         enddo

      ENDIF
 
c----
c            restores zeros to the front of the trace.....
c----

      if (imut .eq. 0) then
        kop = 2
        call muproc(temp,nsamp,isi,lerr,kop,zeros,
     :      rmpdim,SZSMPD)
      endif
 
      if(ifflg .ne. 0) go to 155
 
120   if (noscl .eq. 1) then
        call scal(temp,temp,iws,iwe,iper,isi,nsamp,sclfr(itrno))
      endif

c----
c Only format 3 data output.  saved statements pertinent
c to format 1 output in case - - - -
c----

150   call vmov (temp,1,tro,1,nsamp)

      if (noscl .eq. 0) then
        if(itrno .eq. ne) then
          call riprnt (irecno,lerr)
        endif
        if(itrno .eq. ne) ictr=ictr+1
        return
      endif

      if (itrno .eq. ne) then
        ictr=ictr+1
        call prntsf(sclfr,ns,ne,lerr,irecno,SZSMPD)
      endif

      return
 
155   nsu=nsamp-1

c----
c   differentiate
c----
      if (ifflg .ne. 1) then     

        temp2=temp(1)
        do  160  i = 2, nsu
            temp1   = temp(i)
            temp(i) = temp(i) - temp2
            temp2   = temp1
160     continue 

c----
c   integrate
c----
      else

        do  180  i = 2, nsu
            temp(i) = temp(i) + temp(i-1)
180     continue                   

      endif

      go to 120
 
      end
