C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c

c Changes:
c
c  July 14, 1998 - removed writes of blank lines to stderr when successfully
c                  allocating disk space - request from RLC - JEV
c  June 11, 1998 - allowed output sample interval and input sample interval
c                  to be the same - data will be passed unchanged - 
c                  per request from Richard Crider - JEV

c  October /97 --> added -noprefilter to shut off all prefiltering prior
c                  for interpolation.  This allows the user to choose his
c                  own filter for application.  This used to be the default
c                  but was changed to appease Hans Sugianto. 
c  Garossino

c  Mar 19, 1996 --> added -L option for GUPCO to do linear interpolation
c                   used for interval velocity datasets and for non-seismic
c                   datasets; P. Garossino
c
c gentrp reads seismic trace data from an input file,
c either interpolates or decimates the data to arbitrary sample interval
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer      SZS16
      parameter   (SZS16 = 16*SZLNHD)

      integer     itr
      pointer     (wkitr, itr(1))

      integer     nsamp, nsi, nso, ntrc, nrec, iform,obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nsampo, j, JJ, KK 
      integer     argis, ordfft
      integer     ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer     ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer     nover, ns, nu, nt, nt2, nto, nto2, nmax
      integer     ierr, ierrt, abort, nsin, nsinc, nsout, nst

      real        sii, sio
      real        rover, dt, dti, dto, fnyq, f1, f2, f3, f4

      real        tri, xtr
      real        wsinc, rwork
      real        tabl1, tabl2, zz
      integer     iz
      real        amp, phz
      real        fwt
      complex     work

      pointer     (wktri  , tri   (1))
      pointer     (wkxtr  , xtr   (1))

      pointer     (wktabl1, tabl1 (1))
      pointer     (wktabl2, tabl2 (1))
      pointer     (wkzz   , zz    (1))
      pointer     (wkiz   , iz    (1))

      pointer     (wkfwt  , fwt   (1))
      pointer     (wkamp  , amp   (1))
      pointer     (wkphz  , phz   (1))

      pointer     (wkrwork, rwork (1))
      pointer     (wkwork ,  work (1))
      pointer     (wkwsinc, wsinc (1))

      character   ntap * 256, otap * 256, name*6

      logical     verbos, micro, sinc, cube, heap, four, noprefilter
      logical     coarse, even, pass, butt, zerop, cubef, linear, combo
      logical     first
 

      data lbytes /0/
      data nbytes /0/
      data abort /0/
      data name /'GENTRP'/
      data sinc /.true./
      data heap /.true./
      data even /.true./
      data zerop /.true./
      data cubef /.true./
      data coarse /.false./
      data pass /.false./
      data butt /.false./
      data cube /.false./
      data linear /.false./
      data combo /.false./
      data noprefilter /.false./
      data first /.false./

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c open printout files

#include <f77/open.h>

c parse command line
 
      call gcmdln ( ntap, otap, sii, sio, nsoh, verbos, micro, cube, 
     :     sinc, nsinc, four, cubef, linear, noprefilter, combo)

c check for extraneous arguments and abort if found

      call xtrarg ( name, LER, .FALSE., .FALSE. )
      call xtrarg ( name, LERR, .FALSE., .TRUE. )

c get logical unit numbers for input and output

      call getln ( luin , ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c read line header of input
c save certain parameters
      itemi = SZLNHD * SZSMPD
      call galloc (wkitr, itemi, ierr, abort)
      if (ierr .ne. 0) then
         write(LERR,*)'FATAL ERROR in gentrp:'
         write(LERR,*)'unable to allocate ',itemi,' bytes'
         write(LER ,*)'FATAL ERROR in gentrp:'
         write(LER ,*)'unable to allocate ',itemi,' bytes'
         go to 999
      else
         write(LERR,*)'Allocating ',itemi,' bytes'
      endif
         

      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LOT,*)'GENTRP: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (micro) then
          unitsc = .000001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c print historical line header to printout file

      call hlhprt (itr, lbytes, name, 6, LERR)

c  deal with milli/micro secs conversion. This logic is to get around
c  cases where millisecs have been specified on the cmd line but one
c  or both are fractional
          
      if ( sii .lt. 1.0 .OR. sio .lt. 1.0) then

         sii = sii * 1000
         sio = sio * 1000

      endif

      if (sii .eq. 0.) then
         sii = nsi
      endif

      if (sio .eq. 0.) sio = sii
      nso = sio

      nsii = sii
      nsio = sio

c watch for command line override for output line header
c entry for sample interval

      if (nsoh .ne. 0) then
         nsoo = nsoh
      else
         nsoo = nso
      endif

      rio   = sii / sio

      if (sio .gt. sii) then
         coarse = .true.
         pass   = .false.
         sinc   = .false.
         nover  = nint ( sio / sii )
         noverc = nsii
         roverc = noverc
         rover  = sio / sii
         nsampo = nsamp / nover
         nsampc = noverc * nsamp
      elseif (sio .lt. sii) then
         coarse = .false.
         pass   = .false.
         nover  = nint ( sii / sio )
         noverc = nsii
         roverc = noverc
         rover  = sii / sio
         nsampo = nsamp * nover
         nsampc = noverc * nsamp
      else
         pass   = .true.
         nsampo = nsamp
c    
c changed to allow gentrp to pass data if input and output
c sample interval are the same - jev per rlc request - 6/11/98
c

c        write(LERR,*)'ERROR in gentrp:'

         write(LERR,*)'WARNING from gentrp:'
         write(LERR,*)'Input sample interval = Output sample interval'
         write(LERR,*)'Data will be passed unchanged'
 
         write(LER ,*)'WARNING from gentrp:'
         write(LER ,*)'Input sample interval = Output sample interval'
         write(LER,*)'Data will be passed unchanged'
      endif


c monitor type of interpolation attempted and set defaults
c accordingly [also set policemen to warn of preventable bad interpolations]

c---
c  not pass
c---
      if (.not. pass) then

c---
c  no explicit cmd line choices of interpolator
c---
      IF ( .not. cube .and. .not. sinc  .and. .not. combo
     :     .and. .not. four .and. .not. linear ) THEN

c---
c  ratio not an integer
c---
         if ((abs(rover - float(nover))) .ne. 0.0) then

c---
c  are both SIs ints? If so then we use
c  "combo" ...
c  This requires sinc interpolating sii to 1 and then
c  decimating to sio
c---
            if ( (sii - float(nsii)) .eq. 0.0 .AND.
     1           (sio - float(nsio)) .eq. 0.0) then
               combo  = .true.
               cube   = .false.
               sinc   = .false.
               four   = .false.
               linear = .false.
c---
c  ... If not then we're dealing with fractional
c  values for one of the sample intervals: use cubic spline
c---
            else
               cube   = .true.
               sinc   = .false.
               four   = .false.
               linear = .false.
            endif

c---
c  ratio is an integer so we have choices: fft (if ration pwr of 2)
c  or sinc (preferred)
c---
         elseif (mod(nover,2).eq.0 .OR. mod(nover,3).eq.0 .OR.
     1           mod(nover,5).eq.0 .OR. mod(nover,7).eq.0  ) then
            cube   = .false.
            sinc   = .true.
            four   = .false.
            linear = .false.

            if (coarse) then
               sinc = .false.
               if (mod(nover,2).eq.0) then
                  four = .true.
                  butt = .false.
               else
                  butt = .true.
                  four = .false.
               endif
            endif
         endif

      ENDIF

      io = 0
      if (coarse) then
         ideci = nint (sio / sii)
      else
         ideci = nint (sii / sio)
      endif

      samp = amax1 (sii, sio)

      dt   = samp * unitsc
      dti  = sii  * unitsc
      dto  = sio  * unitsc

      if (micro) then  
         mflag = 1
      else
         mflag = 0
      endif
c     call savew(itr, 'T_Unit', mflag, LINHED)

c----
c   set up trapezoidal filter freq points
c----
      fnyq = .5 / dt

      f1 = 0.
      f2 = 0.
      f3 = .90 * fnyq
      f4 = .98 * fnyq

c----
c   allocate memory based on max possible vector length
c----
      ierrt = 0
      ibtot = 0
      ntmax = max (nsamp, nsampo, nsampc)
      itemt =  (2 * ntmax + ITRWRD) * SZSMPD

      call grealloc (wkitr, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      call galloc (wktri, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      call galloc (wkxtr, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      call galloc (wktabl1, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      call galloc (wktabl2, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      call galloc (wkiz   , itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      itemt = 4 * ntmax * SZSMPD
      call galloc (wkzz   , itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      itemt  = (nsinc + 1) * max(nover,noverc) * SZSMPD
      call galloc (wkwsinc, itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      nu = ordfft(ntmax)
      nt = 2 ** nu
      itemt = 2 * nt * SZSMPD
      call galloc (wkrwork,  itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      itemt = 2 * nt * SZSMPD
      call galloc (wkwork,  itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      itemt = 2 * nt * SZSMPD
      call galloc (wkfwt,  itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      call galloc (wkamp,  itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt
      call galloc (wkphz,  itemt, ierr, abort)
      ierrt = ierrt + ierr
      ibtot = ibtot + itemt

      if ( ierrt .ne. 0 ) then
         write(LERR,*)'FATAL ERROR in getrp:'
         write(LERR,*)'Unable to allocate ',ibtot,' bytes'
         write(LER ,*)'FATAL ERROR in getrp:'
         write(LER ,*)'Unable to allocate ',ibtot,' bytes'
         go to 999
      else
         write(LERR,*)'Allocated ',ibtot,' bytes'
      endif
      
c----
c  the cmd line choice is cubic spline
c----
      IF (cube) THEN

c build interpolation tables

         nsampo = nint ( rio * float (nsamp) )

         if (coarse) then
            dt = dti
            ns = nsamp
            offset = sii - sio
         else
            dt = dto
            ns = nsampo
            offset = sii - sio
         endif
         if ( .not. coarse ) then
            io = nint(rio) - 1
            write(LERR,*)'Cubic: io = ',io
         endif
            
         do  j = 1, max(nsamp ,nsampo)
             tabl1(j) = float( j ) * sii
         enddo

         do  j = 1, max(nsamp,nsampo)
             tabl2(j) = float( j ) * sio + offset
         enddo

c----
c  the cmd line choice is sinc interpolator. requirement is that
c  the ratio be integer
c----
      ELSEIF (sinc) THEN

         if ( (float(nover)-rover) .ne. 0.0) then
            write(LERR,*)'FATAL ERROR in gentrp:'
            write(LERR,*)'sinc interpolator requires ratio be'
            write(LERR,*)'integer: currently ratio= ',rover
            write(LER ,*)'FATAL ERROR in gentrp:'
            write(LER ,*)'sinc interpolator requires ratio be'
            write(LER ,*)'integer: currently ratio= ',rover
            go to 999
         endif

         nsampo = nint ( float(nsamp) * rover )
         ns     = nsamp
         nsin   = nsamp + 2 * nsinc
         nsout  = nover  * nsin
         nst    = nover  * nsinc - nover
         noverc = nover
         if ( .not. coarse ) then
            io = 1
            write(LERR,*)'io set'
         endif

c----
c  the cmd line choice is sinc interpolator from sii to 1 followed
c  by decimation:  requirement is only that both sii & sio be ints
c----
      ELSEIF (combo) THEN

         if ( (float(nsii)-sii .ne. 0.0) .OR.
     1        (float(nsio)-sio .ne. 0.0) ) then
            write(LERR,*)'FATAL ERROR in gentrp:'
            write(LERR,*)'combo interpolator requires both SIs'
            write(LERR,*)'to be integer: currently sii= ',sii
            write(LERR,*)'sio= ',sio
            write(LER ,*)'FATAL ERROR in gentrp:'
            write(LER ,*)'combo interpolator requires both SIs'
            write(LER ,*)'to be integer: currently sii= ',sii
            write(LER ,*)'sio= ',sio
            go to 999
         endif

         if (coarse) then
            nsampo = nint ( float(nsamp) / rover )
         else
            nsampo = nint ( float(nsamp) * rover )
         endif
         ns     = nsamp
         nsin   = nsamp + 2 * nsinc
         nsout  = noverc * nsin
         nst    = noverc * nsinc - noverc
         io = 1

c----
c  the cmd line choice is linear (not recommended except for velocity
c  interpolation)
c----
      ELSEIF (linear) then

         nsampo = nint ( rio * float (nsamp) )

         coarse = .false.
         if ( nsampo .lt. nsamp) coarse = .true.

         if ( coarse ) then
            idec = nint (sio / sii)
            do  j = 1, max(nsampo,nsamp)
                tabl1(j) = float( j-1 ) * (sio/sii)
            enddo
         else
            do  j = 1, max(nsampo,nsamp)
                tabl1(j) = float( j-1 ) * (sio/sii)
            enddo
         endif

c----
c  the cmd line choice is FFT (requirement is that ratio be pwr of 2)
c----
      ELSEIF (four) THEN

         if (mod(nover,2) .ne. 0) then
            write(LERR,*)'FATAL ERROR in gentrp:'
            write(LERR,*)'FFT interpolator requires ratio be'
            write(LERR,*)'power of 2: currently = ',nover
            write(LER ,*)'FATAL ERROR in gentrp:'
            write(LER ,*)'FFT interpolator requires ratio be'
            write(LER ,*)'power of 2: currently = ',nover
            go to 999
         endif
         nsampo = nint ( float (nsamp) * rio)

      ELSE

         nsampo = nint ( float (nsamp) * rio)

      ENDIF

c----
c  prepare weights for trapezoidal filtering
c----

      ns = nsamp
      dt = dti
      nu = ordfft (nsamp)
      nt = 2 ** nu
      nt2 = nt / 2
      nto = nint ( rio * float (nt) )
      nto2 = nto / 2
      nmax = max (nt, nto) 

      call fweight (ns, ntfo, nfo, dt, df, f1, f2, f3, f4, 
     1              fwt, verbos)

      if (nsampo .gt. 2*SZLNHD) then
         write(LERR,*)' '
         write(LERR,*)'Output number samples > ',2*SZLNHD
         write(LERR,*)'which is the max number possible'
         write(LERR,*)'Will set nsampo = ',2*SZLNHD
         write(LERR,*)'WARNING '
         write(LER,*)' '
         write(LER,*)'GENTRP:'
         write(LER,*)'  Output number samples > ',2*SZLNHD
         write(LER,*)'  which is the max number possible'
         write(LER,*)'  Will set nsampo = ',2*SZLNHD
         write(LER,*)'WARNING '
         nsampo = 2*SZLNHD
      endif
 
      endif
c---
c  end pass block
c---

      if ( .not. coarse ) then
          nsampo = nsampo - ideci + 1
      endif

c----
c modify line header to reflect actual number of traces output
c----

      call savew(itr, 'NumSmp',nsampo, LINHED)
      call savew(itr, 'SmpInt', nsoo , LINHED)

c----
c update historical line header
c----

      call savhlh ( itr,lbytes,lbyout )

c----
c write output lineheader
c----

      call wrtape ( luout, itr, lbyout )

c----
c calculate number of output bytes per trace
c----

      obytes = SZTRHD + nsampo * SZSMPD

c----
c echo pertinent information to printout file
c----

      call verbal(nsamp, nsi, ntrc, nrec, iform, rio,
     1     nsampo, sii, sio, nso, micro, ntap, otap,
     2     cube, sinc, four, nsinc, coarse, nover, cubef, linear,
     :     noprefilter, combo, io )

c----
c BEGIN PROCESSING
c----
      
      icinit = 1

c----
c process all record and traces input
c----

      DO  JJ = 1, nrec
          
         DO  KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           StaCor, TRACEHEADER)
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum, TRACEHEADER)

c----
c if pass is true, input sample interval and output sample interval are same
c skip to writing out the trace 
c----
            IF (.not. pass) then
c----
c process only live traces
c----

            IF ( StaCor .ne. 30000) then

c-----
c  store mute sample
c-----
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               call detmut ( tri, imtop, nsamp)
c-----
c  for coarse resampling:
c  prefilter the data with a freq
c  domain trapezoid out-out-.9Nyq-.98Nyq
c  where Nyq is the lower of the input
c  and output nyquist freqs
c-----
               if ( coarse .AND. .not. noprefilter ) then
                   call trapf (nsamp, ntfo, nfo, dt, df, tri, fwt,
     :                         work, amp, phz, zerop)
                   if ( .not.first ) then
                      write(LERR,*)' '
                      write(LERR,*)f1,' ',f2,' ',f3,' ',f4,
     :                '  Anti-alias filter applied'
                      write(LERR,*)' '
                      first = .true.
                   endif
               endif

c---------------------
c  fractional sii & sio
c  interpolate data
c  using cubic spline
c  (going to coarser)
c---------------------
               
               if ( cube .AND. coarse ) then
                  
                  call fcuint (tabl1, tri, nsamp, tabl2, tri,
     1                    nsampo, iz, zz, icinit)

                  imtop = rio * imtop
                  call resmut ( tri, imtop, nsampo)
                  call vmov (tri(io+1), 1, itr(ITHWP1), 1, nsampo)
                  icinit = 0

c---------------------
c  fractional sio & sii
c  interpolate data
c  using cubic spline
c  (going to finer)
c the postfilter here is to prevent unwanted energy past the
c orignal Nyquist which will happen with cubic spline interpolation
c---------------------

               elseif ( cube .AND. .not.coarse ) then

                  call vclr (xtr, 1, nsamp)
                  call fcuint (tabl1, tri, nsamp, tabl2, xtr,
     1                 nsampo, iz, zz, icinit)
                  if (cubef)
     1                 call trapf (nsampo, ntfo, nfo, dt, df, xtr, fwt,
     2                 work, amp, phz, zerop)
                  imtop = rio * imtop
                  call resmut ( xtr, imtop, nsampo)
                  io = 0
                  call vmov (xtr(io+1), 1, itr(ITHWP1), 1, nsampo)
                  icinit = 0

c---------------------
c  whole number ratio
c  interpolate data
c  using sinc function
c---------------------

               elseif (sinc) then

                  call vclr (xtr, 1, nsin)
                  call vmov (tri, 1, xtr(nsinc), 1, nsamp)
                  call vclr (tri, 1, nsampo)
                  call oversampt (xtr, nsin, rwork, nsout, nover,
     1                 wsinc, nsinc, icinit)
                  imtop = rio * imtop
                  call vmov (rwork(nst), 1, tri, 1, nsampo)
                  call resmut ( tri, imtop, nsampo)
                  call vmov (tri(io+1), 1, itr(ITHWP1), 1, nsampo)

c---------------------
c  whole number sio & sii:
c  interpolate data
c  (coarse or fine)
c  using sinc function
c---------------------

               elseif (combo) then

                  call vclr (xtr, 1, nsin)
                  call vmov (tri, 1, xtr(nsinc), 1, nsamp)
                  call oversampt (xtr, nsin, rwork, nsout, noverc,
     1                 wsinc, nsinc, icinit)
                  imtop = noverc * imtop
                  call resmut ( rwork, imtop, nsout)
                  call vclr (tri, 1, nsampo)
                  call vmov (rwork(nst+io), nsio, tri, 1, nsampo)
                  call vmov (tri, 1, itr(ITHWP1), 1, nsampo)

c---------------------
c  interpolate data
c  using linear interpolation
c---------------------

               elseif ( linear ) then

                  call vclr (xtr, 1, nsampo )
                  call Linterp( tri, nsamp, xtr, nsampo, tabl1, idec,
     1                          rwork, coarse)
                  imtop = rio * imtop
                  call resmut ( xtr, imtop, nsampo)
                  call vmov (xtr, 1, itr(ITHWP1), 1, nsampo)

               else

c---------------------
c  interpolate data ratio pwr of 2
c  using FFT or filt/decimation:
c  FFT for power of 2
c  For decimation just take every ideci sample
c---------------------
 
                  call fftint (tri, xtr, work, nsamp, nt, nt2,
     1                         nto, nto2, nmax, coarse, ideci)
                  imtop = rio * imtop
                  call resmut ( xtr, imtop, nsampo)
                  call vmov   (xtr(io+1), 1, itr(ITHWP1), 1, nsampo)
                     

               endif
      
            ELSE

c clear all traces marked as dead

               call vclr (itr(ITHWP1), 1, nsampo)

            ENDIF

            ENDIF

c  write output data

            call wrtape (luout, itr, obytes)

         ENDDO

         if(verbos)write(LERR,*)'processed rec ',recnum
 
      ENDDO

c Normal Termination: close data files
      
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of gentrp, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Normal Termination'
      write(LER,*)' '
      write(LER,*)'gentrp: Normal Termination'

      stop

  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of gentrp, processed',JJ,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LERR,*)' '
      write(LERR,*)'Abnormal Termination'
      write(LER,*)' '
      write(LER,*)'gentrp: Abnormal Termination'
      stop
      end
 

      subroutine help

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for gentrp: interpolate / dec
     :imate data'
      write(LER,*)'  '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'WARNING'
      write(LER,*)' '
      write(LER,*)
     :'GENTRP HAS BEEN CHANGED TO DO PREFILTERING PRIOR TO MOST '
      write(LER,*)
     :'INTERPOLATION OPTIONS.....BE SURE TO USE -noprefilter IF YOU'
      write(LER,*)
     :'STILL WISH TO USE YOUR OWN PREFILTER DESIGN'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-i[]   -- input sample interval override  (input)'
      write(LER,*)'-s[]   -- output sample interval          (input)' 
      write(LER,*)'-h[]   -- output s.i. put in line header   ( -s )'
      write(LER,*) ' '
      write(LER,*)
     :' -c  sinc interpolate -i[] to 1 then decimate back to -s[]'
      write(LER,*)
     :' -C  include on command line to force cubic spline interpolation'
      write(LER,*)
     :' -CF cubic spline interpolation with post bandpass filter'
      write(LER,*)
     :' -S  include on command line to force sinc interpolation'
      write(LER,*)'-n[]  -- order of sinc interpolator         (32)'
      write(LER,*)
     :' -F  include on command line to force fft interpolation'
      write(LER,*)
     :' -L  include on command line to force linear interpolation'
      write(LER,*)
     :'     else, choice made automatically: -i > -s and even --> sinc'
      write(LER,*)
     :'           -i > -s not even, or -i < -s --> cubic'
      write(LER,*) ' '
      write(LER,*)
     :' -M  include on command line to do everything in micro secs'
      write(LER,*) ' '
      write(LER,*)
     :' -noprefilter  include on command line for no prefilter prior to'
      write(LER,*)
     :'                interpolation'
      write(LER,*) ' '
      write(LER,*)
     :' -V  include on command line if verbose printout is desired'
      write(LER,*) ' '
      write(LER,*)
     :'usage:   gentrp -N[] -O[] -i[] -s[] -h[]'
      write(LER,*)
     :'usage:         [ -c -S -n[] -C -CF -F -M -L -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c subroutine to parse command line
 
      subroutine gcmdln ( ntap, otap, sii, sio, nso, verbos, micro, 
     :     cube, sinc, nsinc, four, cubef, linear, noprefilter, combo)

c-----
c     get command arguments
c
c     ntap  - C*256     input file name
c     otap  - C*256     output file name
c     sii   - R*4       input sample interval override
c     sio   - R*4       output sample interval
c     nso   - I*4       output sample interval header override
c     micro -  L        convert input s.i. to micro secs
c     verbos -  L       verbose output or not
c     cube - L          use cubic spline interpolation
c     sinc - L          use sinc interpolation
c     nsinc -I*4        number of points in sinc interpolator
c     four - L          use Fourier interpolation
c     cubef - L         use cubic spline interpolation with post interpolation filter
c     linear - L        use linear interpolation
c     noprefilter - L   no prefilter prior to interpolation please
c
c-----

#include <f77/iounit.h>

c variables passed from calling routine

      integer     nso, nsinc
      real        sii, sio
      character   ntap*(*), otap*(*)
      logical     verbos, micro, cube, sinc, four, cubef, linear
      logical     combo, noprefilter

c local variables

      integer argis
 
            cubef  = (argis('-CF') .gt. 0)
            cube   = (argis('-C') .gt. 0)

            combo  = (argis('-c') .gt. 0)

            four   = (argis('-F') .gt. 0)

            call argi4( '-h', nso, 0, 0 )

            call argr4( '-i', sii, 0., 0. )

            linear  = (argis('-L') .gt. 0)

            micro  = (argis('-M') .gt. 0)

            noprefilter = ( argis('-noprefilter') .gt. 0)
            call argstr( '-N', ntap, ' ', ' ' )
            call argi4( '-n', nsinc, 32, 32 )

            call argstr( '-O', otap, ' ', ' ' )

            sinc   = (argis('-S') .gt. 0)
            call argr4( '-s', sio, 0., 0. )

            verbos = (argis('-V') .gt. 0)

      if (cubef) cube = .true.

      if (cube .and. sinc) then
         write(LERR,*)'ERROR in gentrp:'
         write(LERR,*)'Cannot have both -S and -C set. Choose one or'
         write(LERR,*)'none (gentrp chooses internally)'
         write(LER ,*)'ERROR in gentrp:'
         write(LER ,*)'Cannot have both -S and -C set. Choose one or'
         write(LER ,*)'none (gentrp chooses internally)'
         stop
      endif

      if (.not.micro .AND. (sii .lt. 1.0 .OR. sio .lt. 1.0)) then
         write(LERR,*)'WARNING in gentrp:'
         write(LERR,*)'One or both sio sii < 1 ... Turning on microsecs'
         write(LERR,*)'flag'
         write(LER ,*)'WARNING in gentrp:'
         write(LER ,*)'One or both sio sii < 1 ... Turning on microsecs'
         write(LER ,*)'flag'
         micro = .true.
      endif
 
      return
      end
 
      subroutine verbal( nsamp, nsi, ntrc, nrec, iform, rio,
     1     nsampo, sii, sio, nso, micro, ntap, otap,
     2     cube, sinc, four, nsinc, coarse, nover, cubef, linear,
     :     noprefilter, combo, io )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer     nsamp, nsi, ntrc, nrec, iform, nsampo, nso, nsinc
      integer     nover

      real        sio, sii, rio

      character   ntap*(*), otap*(*)

      logical     micro, cube, sinc, four, coarse, cubef, linear
      logical     combo, noprefilter

c local variables

      integer length
 
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set      =  stdin'
      endif
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' input samples/trace =  ', nsamp
      if (micro) then
         write(LERR,*) ' input sample interval =  ', nsi/1000
      else
         write(LERR,*) ' input sample interval =  ', nsi
      endif
      write(LERR,*) ' traces per record  =  ', ntrc
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform

      write(LERR,*)' '
      write(LERR,*)' variable values inside gentrp'

      write(LERR,*) ' output samples/trace =  ', nsampo
      write(LERR,*) ' input sample interval   = ',sii
      write(LERR,*) ' output sample interval   = ',sio
      if (micro) then
         write(LERR,*) ' input s.i. in header     =  ', nsi/1000
      else
         write(LERR,*) ' input s.i. in header     =  ', nsi
      endif
      write(LERR,*) ' output s.i. in header    =  ', nso
      write(LERR,*) ' sii / sio                =  ', rio
      write(LERR,*) ' resampling factor        =  ',nover
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name=  ', otap(1:length)
      else
        write(LERR,*) ' output data set     =  stdout'
      endif

      if (micro)
     1     write(LERR,*) ' input s.i. converted to micro secs'
      write(LERR,*)' '

      if (coarse) then
         write(LERR,*)' Sampling to coarser interval'
      else
         write(LERR,*)' Sampling to finer interval'
      endif

      if (cube)
     1     write(LERR,*)' Cubic spline interpolation selected'

      if (cubef)
     1     write(LERR,*)' Cubic spline interpolation with post interpola
     2tion filter selected'

      if (sinc) then
         write(LERR,*)' Sinc interpolation selected'
         write(LERR,*)' Sinc operator length =  ',nsinc
      endif

      if (combo) then
         write(LERR,*)' Will resample to unit sample interval'
         write(LERR,*)' using the sinc interpolator and then'
         write(LERR,*)' decimate to get the output sampling'
         write(LERR,*)' Sinc operator length =  ',nsinc
      endif


      if (four)
     1     write(LERR,*)' FFT interpolation selected'

      if (linear)
     1     write(LERR,*)' Linear interpolation selected'
      if (noprefilter)
     1     write(LERR,*)' No prefilter prior to interpolation'
      write(LERR,*)' '
      write(LERR,*)' '
      
      return
      end
