C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c reads in two data streams, attaches either the entire trace header
c of DSN1 to DSN2, or just a single header word, and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
c     integer     itr1 ( SZLNHD ), itr2 ( SZLNHD )
      integer     itr1, itr2
      integer     nsamp1, nsi1, ntrc1, nrec1, iform
      integer     nsamp2, nsi2, ntrc2, nrec2
      integer     luin1, luin2, luout, lbytes1, nbytes1, lbyout
      integer     pipe, lbytes2, nbytes2
      integer	  ierr,iabort,allbyts

      data iabort / 0 /
 
      pointer (wkitr1,itr1(1))
      pointer (wkitr2,itr2(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      character   ntap1 * 256, ntap2 * 256, otap * 256, name*7
      character   hdrwrd * 6
      logical     verbos, query
      integer     argis
 
      common / booger / intarr(250000)
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
      data lbytes / 0 /, nbytes / 0 /, name/'HDRSWAP'/
      data pipe /3/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap1, ntap2, otap, hdrwrd, verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin1 , ntap1,'r', 0)

      if (ntap2(1:1) .eq. ' ') then
         write(LERR,*)'hdrswap assumed to be running inside ikp'
         call sisfdfit (luin2, pipe)
      else
         call getln(luin2 , ntap2,'r', -1)
      endif
      if (luin2 .lt. 0) then
         write(LERR,*)'FATAL ERROR in hdrswap opening ntap2:'
         write(LERR,*)'Check file existence'
         stop
      endif

      call getln(luout, otap,'w', 1)
 
      call galloc(wkitr1,10000,ierr,iabort)
      if (ierr .ne. 0) then
	write(LER,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LER,*) '10000 bytes for dataset 1 line header'
	write(LER,*) ' storage - '
	write(LER,*) 'aborting job'
	write(LERR,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LERR,*) '10000 bytes for dataset 1 line header'
	write(LER,*) ' storage - '
	write(LERR,*) 'aborting job'
	stop 100
      endif
c-----
c     read line header of inputa DSN1 (rtape reads data into vector "itr1"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin1, itr1, lbytes1)
      if(lbytes1 .eq. 0) then
         write(LOT,*)'HDRSWAP: no header read from unit ',luin1
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
 
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr1, 'NumSmp', nsamp1, LINHED)
      call saver(itr1, 'SmpInt', nsi1  , LINHED)
      call saver(itr1, 'NumTrc', ntrc1 , LINHED)
      call saver(itr1, 'NumRec', nrec1 , LINHED)
      call saver(itr1, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      if (hdrwrd(1:1) .ne. ' ')
     1  call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)
c------
c     hlhprt prints out the historical line header of length lbytes AND
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------

      call hlhprt (itr1, lbytes1, name, 7, LERR)
 
      call galloc(wkitr2,10000,ierr,iabort)
      if (ierr .ne. 0) then
	write(LER,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LER,*) '10000 bytes for dataset 2 line header'
	write(LER,*) ' storage - '
	write(LER,*) 'aborting job'
	write(LERR,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LERR,*) '10000 bytes for dataset 2 line header'
	write(LER,*) ' storage - '
	write(LERR,*) 'aborting job'
	stop 100
      endif
 
c-----
c     read line header of inputa DSN1 (rtape reads data into vector "itr1"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin2, itr2, lbytes2)
      if(lbytes2 .eq. 0) then
         write(LOT,*)'HDRSWAP: no header read from unit ',luin2
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
 
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr2, 'NumSmp', nsamp2, LINHED)
      call saver(itr2, 'SmpInt', nsi2  , LINHED)
      call saver(itr2, 'NumTrc', ntrc2 , LINHED)
      call saver(itr2, 'NumRec', nrec2 , LINHED)
      call saver(itr2, 'Format', iform, LINHED)

      if (ntrc1 .ne. ntrc2) then
         write(LERR,*)'FATAL ERROR:'
         write(LERR,*)'Number traces/rec not equal in both DSNs'
         write(LERR,*)'ntrc1 = ',ntrc1,'  ntrc2= ',ntrc2
         stop
      endif
      if (nrec1 .ne. nrec2) then
         write(LERR,*)'FATAL ERROR:'
         write(LERR,*)'Number recs not equal in both DSNs'
         write(LERR,*)'nrec1 = ',nrec1,'  nrec2= ',nrec2
         stop
      endif
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr1,lbytes1,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr1, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp1, nsi1, ntrc1, nrec1,
     1                  nsamp2, nsi2, ntrc2, nrec2,
     2                  ntap1,ntap2,otap)
c     endif
 
      allbyts = SZTRHD+(nsamp1*SZSMPD)
      call grealloc(wkitr1,allbyts,ierr,iabort)
      if (ierr .ne. 0) then
	write(LER,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LER,*) allbyts,' bytes for dataset 1 trace '
	write(LER,*) 'storage - aborting job'
	write(LERR,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LERR,*) allbyts,' bytes for dataset 1 trace '
	write(LERR,*) 'storage - aborting job'
	stop 100
      endif

      allbyts = SZTRHD+(nsamp2*SZSMPD)
      call grealloc(wkitr2,allbyts,ierr,iabort)
      if (ierr .ne. 0) then
	write(LER,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LER,*) allbyts,' bytes for dataset 2 trace '
	write(LER,*) 'storage - aborting job'
	write(LERR,*) 'HDRSWAP: ERROR - Unable to allocate '
	write(LERR,*) allbyts,' bytes for dataset 2 trace '
	write(LERR,*) 'storage - aborting job'
	stop 100
      endif
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, transfer all or part of header, write output
c-----
c-----
c     process desired trace records
c-----
      DO 1000 JJ = 1, NREC1
 
            do 1001  kk = 1, ntrc1
 
                  nbytes1 = 0
                  call rtape( luin1, itr1, nbytes1)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes1 .eq. 0) then
                     write(LERR,*)'End of file on input 1:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
 
                  nbytes2 = 0
                  call rtape( luin2, itr2, nbytes2)
                  if(nbytes2 .eq. 0) then
                     write(LERR,*)'End of file on input 2:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif

                  if (hdrwrd(1:1) .eq. ' ') then

                     call move (1, itr1, itr2, SZTRHD)

                  else

                     call saver2 (itr2,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                           ihdrwrd, TRACEHEADER)
                     call savew2 (itr1,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                           ihdrwrd, TRACEHEADER)

                  endif

                  call wrtape (luout, itr1, nbytes1)

1001              continue
 
 
1000  CONTINUE
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin1 )
      call lbclos ( luin2 )
      call lbclos ( luout )
 
            write(LERR,*)'end of hdrswap, processed',nrec1,' record(s)',
     :               ' with ',ntrc1, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'hdrswap swaps the trc hdsrs of DSN 2 into those of DSN 1'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute hdrswap by typing hdrswap and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N1[ntap1]   (stdin)       : input data file name'
        write(LER,*)
     :' -N2[ntap2]   (none)        : input data from which hdrs taken'
        write(LER,*)
     :' -O [otap]    (stdout)      : output data file name'
        write(LER,*)
     :' -w [hdrwd]  (all header)   : header word mnemonic to transfer'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   hdrswap -N1[ntap1] -N1[ntap1] -O[otap] -w[] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap1, ntap2, otap, hdrwrd, verbos)
c-----
c     get command arguments
c
c     ntap1 - C*256    input file name
c     ntap2 - C*256    input file name
c     otap  - C*256    output file name
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap1*(*), ntap2*(*), otap*(*), hdrwrd * 6
      logical     verbos
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program hdrswap might be invoked in the following way:
 
c     hdrswap  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into hdrswap and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N1', ntap1, ' ', ' ' )
            call argstr( '-N2', ntap2, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-w', hdrwrd, ' ', ' ')
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp1, nsi1, ntrc1, nrec1,
     1                  nsamp2, nsi2, ntrc2, nrec2,
     2                  ntap1,ntap2,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*256   input file name
c     otap  - C*256   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp1, nsi1, ntrc1, nrec1
      integer     nsamp2, nsi2, ntrc2, nrec2
      character   ntap1*(*),ntap2*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) '1: # of samples/trace =  ', nsamp1
            write(LERR,*) '1: sample interval    =  ', nsi1
            write(LERR,*) '1: traces per record  =  ', ntrc1
            write(LERR,*) '1: records per line   =  ', nrec1
            write(LERR,*) '2: # of samples/trace =  ', nsamp2
            write(LERR,*) '2: sample interval    =  ', nsi2
            write(LERR,*) '2: traces per record  =  ', ntrc2
            write(LERR,*) '2: records per line   =  ', nrec2
            write(LERR,*) ' input data set1 name =  ', ntap1
            write(LERR,*) ' input data set2 name =  ', ntap2
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
