C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c qstk reads records of data and stacks non-null values               
c**********************************************************************c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>

c standard USP variables

      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
      integer     argis, thdr(ITRWRD)

      character   ntap * 512, otap * 512, name*4

      logical     verbos

c variables used with dynamic memory allocation

      integer abort1

      real  work,live,z


      pointer (pwork,work(2) )
      pointer (pz,z(2)),(plive,live(2))

c local variables

      integer static, ptrc, prec, TH, ins, ine, LH
      

c initialize variables
 
      data name/'QSTK'/
      data abort1/0/

c +===========================================================+
c | read program parameters from command line card image file |
c +===========================================================+

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis('-H') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help').gt.0 )then
            call help(ler)
            stop
      endif
 
#include <f77/open.h>
 
      TH = TRACEHEADER
      LH = LINEHEADER

      call gcmdln(ntap,otap,irs,ire,xnull,mode)

      if(mode.gt.1)mode=0

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c +===========================+
c | read line header of input |
c | save certain parameters   |
c +===========================+
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'QSTK: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif


c +==============================================+
c | Set up locations and offsets for, then read  |
c | some lineheader info.  Set up locations and  |
c | offsets for trace header info                |
c +==============================================+
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LH)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LH)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LH)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LH)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LH)
      call savelu('UnitSc',ifmt_UnitSc,l_UnitSc,ln_UnitSc,LH)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LH)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsi  ,LH)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntrc ,LH)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec ,LH)
      call saver2(itr,ifmt_Format,l_Format,ln_Format,iform,LH)
      call saver2(itr,ifmt_UnitSc,l_UnitSc,ln_UnitSc,unitsc,LH)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      lname = 4
      call hlhprt (itr, lbytes, name, lname, LERR)

c +==============================================================+
c | ensure that command line values are compatible with data set |
c | (i.e. start/end traces; start/end records)                   |
c +==============================================================+
      ins = 1
      ine = ntrc
      if (irs .le. 0) irs = 1
      if (ire .gt. nrec .or. ire .le. 0) ire = nrec
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      ptrc = ntrc
      prec = nrec
c +----------------------------------+
c | malloc space we are going to use |
c +----------------------------------+

      ierr = 0
      ner = 0

      iget = nsamp*ISZBYT
      call galloc(pwork, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(pz   , iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1
      call galloc(plive, iget, ierr, abort1)
      memsum=memsum+iget
      if (ierr .ne. 0.) ner=ner+1

      if (ner.ne.0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'QSTK: '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*)  memsum,'  bytes'
         write(LER,*)'FATAL '
         write(LER,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c +==============================================================+
c | modify line header to reflect actual number of traces output |
c +==============================================================+
      nrecc=ire - irs+1
      call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrecc,LH)
      call savew2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,1 ,LH)

c +---------------------+
c | number output bytes |
c +---------------------+
      obytes = SZTRHD + nsamp * ISZBYT
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout )

      call verbal(nsamp, nsi, ntrc, nrec,xnull,mode,otap,ntap,LERR)
c +================================+
c |     BEGIN PROCESSING           |
c | first skip unwanted records    |
c +================================+

      call recskp(1,irs-1,luin,ptrc,itr)

      DO jj = irs, ire

         mm = 0
         call vclr(live,1,nsamp)
         call vclr(z,1,nsamp)

         do kk = 1,ptrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input. qstk aborted.'
               call lbclos(luin)
               call lbclos(luout)
               stop
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,static,TH)

            IF (static .eq. 30000) then
               call vclr (itr(ITHWP1),1,nsamp)
            ELSE 

               if(mm.eq.0)then
                  call vmov(itr,1,thdr,1,ITRWRD)
                  mm=1
               endif

c +====================+
c | do the stacking    |
c +====================+
             call vmov(itr(ITHWP1),1,work,1,nsamp)

             do i=1,nsamp

                if(mode.eq.0)then

                 if (work(i).ne.xnull .and. work(i).ne.0.0) then
                     live(i) = live(i) + 1.
                     z(i) = z(i)+work(i)
                  endif

                else

                  if (work(i).ne.xnull .and. work(i).gt.0.0) then
                     live(i) = live(i) + 1.
                     z(i) = z(i) + log(work(i))
                  endif

                endif
             end do

            ENDIF

         end do    ! end read ptrc gather
c +====================+
c | write output data  |
c +====================+
         call vmov(thdr,1,itr(1),1,ITRWRD)
         call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,0,TH)
         call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,1,TH)

         if(mode.eq.0)then
           do i=1,nsamp
             if(live(i).ne.0.)z(i)=z(i)/live(i)
             if(z(i).eq.0.0)z(i)=xnull
           end do
         else
           do i=1,nsamp
             if(live(i).ne.0.0)z(i)=exp(z(i)/live(i))
             if(z(i).le.0.0)z(i)=xnull
           end do
         endif

         call vmov(z,1,itr(ITHWP1),1,nsamp)
         call wrtape(luout,itr,obytes)

      ENDDO        ! end read records/gathers
c +======================+
c | close data files and |
c | end processing       |
c +======================+
      call lbclos ( luin )
      call lbclos ( luout )
      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'qstk computes the average amplitude from the input data on  '
        write(LER,*)
     :'sample-by-sample basis, ignoring any values set to null, then'
        write(LER,*)
     :'setting to null any zero values in the stacked results '
        write(LER,*)
     :'see manual pages for details ( online by typing uman qstk )'
        write(LER,*)' '
        write(LER,*)
     :'execute qstk by typing qstk and the program parameters.'
        write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'Users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -null[null]   (default = 1000.)   : ignore this value in stack'
        write(LER,*)
     :' -opt[mode]   (default = 1)        : stacking mode '
        write(LER,*)
     :'                                     0 = arithmetic mean'      
        write(LER,*)
     :'                                     1 = geometric mean'
        write(LER,*)
     :'usage:   qstk -N[] -O[] -rs[] -re[] -null[] -opt[]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,xnull,mode)
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     irs, ire,mode
      real        xnull
      logical     verbos
      integer     argis
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argr4 ( '-null', xnull, 1000.,1000.)
            call argi4 ( '-opt', mode,  1, 1 )
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-re', ire ,   0  , 0 )
            call argi4 ( '-rs', irs ,   0  , 0 )
            verbos =   (argis('-V') .gt. 0)
      return
      end
 
      subroutine verbal(nsamp,nsi,ntrc,nrec,xnull,mode,otap,ntap,LERR)

      integer     nsamp, nsi, ntrc, nrec,mode
      real  xnull
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' null value          =  ', xnull
            if(mode.eq.0)then
            write(LERR,*) ' arithmetic mean        '
            else
            write(LERR,*) ' geometric mean         '
            endif
      return
      end
