C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------------  Main Routine -----------------------
c     Program Changes:
c
c     June 6, 2000: added value_constraint to allow value wise replacement
c                   of dataset -N[] with samples from -N2[].
c     Garossino
c
c     March 30, 1999: added logic to allow -hw1 -hw2 with -bias -scale
c     Garossino
c
c     March 31, 1999: fixed parsing of command line for -N2 so piping with
c                     -I option will work
c     Garossino
c
c
c     Program Description:
c     Program replace to perform a variety of value replacements
c     to USP formated data.
c     James M. Gridley
c     USP Team
c     Amoco 
c     July 1996
c	
c
c get machine dependent parameters 

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 
      
c dimension standard USP variables 

      integer     itr ( SZLNHD ), itr2(SZLNHD)
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     luin2, lbytes2, jerr
      integer     ist, iend, irs, ire, ns, ne, argis
      integer     iword1, iword2, iword3, nsamp2, i

      real        tri ( SZLNHD ), tri2 ( SZLNHD ) 

      character   ntap*255, otap*255, name*7

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort

      real    new_vel

      pointer (wkadr1, new_vel(200000))

c Program Specific _ static memory variables

      integer     trcnum,recnum, nsi2, ntrc2, nrec2, nbytes2, jj, kk
      integer iword4, nullval

      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_hdrwd1, l_hdrwd1, ln_hdrwd1
      integer ifmt_hdrwd2, l_hdrwd2, ln_hdrwd2
      integer ifmt_hdrwd3, l_hdrwd3, ln_hdrwd3
      integer ifmt_hdrwd4, l_hdrwd4, ln_hdrwd4

      real rword1, rword2, rword3, rword4, vbias, vscl, thr
      real        ValueOld, ValueNew
      real        vo, vgrad, refe
      real        minval, maxval

      real replacement_value

      character   ntap2*255
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6, hdrwd4 * 6

      logical     verbos,apend,single, math, top, bot, grad
      logical     File_Insert, Detect, DetOn, mask

      logical     Index_Constraint, No_Constraint
      logical     Pick_Constraint, Null_Constraint
      logical     Start_End_Constraint, value_constraint
      logical     Do_Val_Replc, Swap, Gradient
      logical     Min_Constraint, Max_Constraint
      logical     hang, No_Vel_Inv, repave

c Initialize variables

      data abort/1/
      data name/"REPLACE"/
      File_Insert=.false.

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters
      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, ntap2, 
     :     hdrwd1, hdrwd2, hdrwd3, hdrwd4,
     :     replacement_value,
     :     vbias, vscl, ValueOld, ValueNew,
     :     vo, vgrad, refe,
     :     minval, maxval,hang,
     :     File_Insert, Detect, DetOn, top, bot, thr, grad ,
     :     No_Vel_Inv, mask, repave )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open second input file (-N2) if there is a file to open
   
      if(ntap2(1:1) .ne. ' ') then

         call lbopen (luin2, ntap2,'r')
      
         apend = .true.
      else
         apend = .false.
      endif
      

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
   
      if(lbytes.eq.0)then
         write(LER,*)'REPLACE: no line header on 
     :        input dataset',ntap

         write(LER,*)'FATAL'
         stop
      endif
       
      if (ntap2(1:1) .ne. ' ' ) then
         call rtape  ( luin2, itr2, lbytes2)
         if(lbytes .eq. 0) then
            write(LER,*)'REPLACE: no header read from unit ',ntap2
            write(LER,*)'FATAL'
            stop
         endif
      endif
      
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      
      if (ntap2(1:1) .ne. ' ') then

         call saver(itr2, 'NumSmp', nsamp2, LINHED)
         call saver(itr2, 'SmpInt', nsi2  , LINHED)
         call saver(itr2, 'NumTrc', ntrc2 , LINHED)
         call saver(itr2, 'NumRec', nrec2 , LINHED)

      endif

c======================================================================
c     Set up the logical single if file2 has 1 rec 1 trace
      if (ntrc2 .eq. 1 .and. nrec2 .eq. 1) then
         single = .true.
      else
         single = .false.
      endif
c======================================================================      
c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
    
      if (hdrwd1 .ne. '-99999') then
         call savelu(hdrwd1,ifmt_hdrwd1,l_hdrwd1,ln_hdrwd1,
     :        TRACEHEADER)
      endif
      if (hdrwd2 .ne. '-99999') then
         call savelu(hdrwd2,ifmt_hdrwd2,l_hdrwd2,ln_hdrwd2,
     :        TRACEHEADER)
      endif
      if (hdrwd3 .ne. '-99999') then
         call savelu(hdrwd3,ifmt_hdrwd3,l_hdrwd3,ln_hdrwd3,
     :        TRACEHEADER)
      endif
      if (hdrwd4 .ne. '-99999') then
         call savelu(hdrwd4,ifmt_hdrwd4,l_hdrwd4,ln_hdrwd4,
     :        TRACEHEADER)
      endif
     

c update historical line header and print to printout file 

c      call hlhprt (itr, lbytes, name, 7, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )

      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

c      nreco = ire - irs + 1
c      ntrco = ne - ns + 1
      nreco = ire
      ntrco = ne
     
     
c======================================================================
c     Policeman to check the record/trace limits since this code
c     passes all records/traces and can be contrained by records/
c     traces. 
c     
c     That means you cannot edit a data set with this code!!
c

 

      if (ire .gt. nreco .or.
     :     irs .lt. 1 .or.
     :     ns .lt. 1 .or.
     :     ne .gt. ntrco ) then
         write(LER,*)' '
         write(LER,*)'Record/Trace Limits Invalid'
         write(LER,*)'Check your command line arguments and data'
         write(LER,*)' '
         write(LERR,*)' '
         write(LERR,*)'Record/Trace Limits Invalid'
         write(LER,*)'Check your command line argumentsand data'
         write(LERR,*)' '
         go to 999
      endif
c======================================================================
c     Policeman for Min/Max Change
c     
      if (minval .ne. -99999. ) then
         Min_Constraint = .true.
         if(replacement_value .eq. -99999.) 
     :        replacement_value = minval
      else
         Min_Constraint = .false.
      endif

      if ( maxval .ne. -99999.) then
         Max_Constraint = .true.
         if(replacement_value .eq. -99999.)
     :        replacement_value = maxval
      else
         Max_Constraint = .false.
      endif
         
c======================================================================
c     Policeman for Global change of values Global logical parameter

      if (replacement_value .ne. -99999. .and. .not. Min_Constraint 
     :     .and. .not.  Max_Constraint ) then 
        Do_Val_Replc  = .true.
      else
         Do_Val_Replc = .false.
      endif
    
c======================================================================
c     Policeman for Mathematics option and set logical math parameter
c     set defaults (1.0 and 0.0 for vslc and vbias, respectivley)

      if (vbias .ne. -99999. .or. vscl .ne. -99999. ) then
         math = .true.
c set the defaults
         if ( vbias .eq. -99999. ) vbias = 0.
         if ( vscl .eq. -99999. ) vscl = 1.0

      else
         math = .false.
      endif
    
c======================================================================
c     Policeman for Swap option and set logical swap parameter
c     
      if (ValueOld .ne. -99999. .or. ValueNew .ne. -99999. .OR.
     1    repave) then
         swap = .true.
      else
         swap = .false.
      endif
     
c======================================================================
c     Policeman for Gradient option and set logical Gradeint parameter
c     
      if (vo .ne. -99999. .or. vgrad .ne. -99999.) then
         Gradient = .true.


         if(vgrad .eq. -99999.) vgrad =1.0
         
c     the refe parameter is taken care of inside the subrountine
c     since it is case dependant on what it can be.  The idea
c     is to let it default to the sample just above the replacement
c     zone else be 0. unless it is specifically defined on command 
c     line.
         

      else
         Gradient = .false.
      endif

c======================================================================

c write the input nrec and ntrc to output  header, this means that
c the user cannot do an edit with replace.
c

  100 continue

      call savew(itr, 'NumRec', nrec, LINHED)
      call savew(itr, 'NumTrc', ntrc  , LINHED)


      if (ntap2(1:1) .ne. ' ' .and. .not. File_Insert) then
         call savew(itr, 'NumSmp', nsamp+nsamp2  , LINHED)

         write(LERR,*)' '
         write(LERR,*)'This will append a  velocity field '
         write(LERR,*)' to the entire input velocity field'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'This will append a  velocity field'
         write(LER,*)'to the entire input velocity field'
         write(LER,*)' '
      endif

c number output bytes

      if (.not. apend) then
         obytes = SZTRHD + SZSMPD * nsamp 
      elseif(File_Insert) then
         obytes = SZTRHD + SZSMPD * nsamp 
      elseif(apend .and. .not. File_Insert) then
         obytes = SZTRHD + SZSMPD * (nsamp+nsamp2)
      endif

c save out hlh and line header
     
      call savhlh  ( itr, lbytes, lbyout )
      
      call wrtape ( luout, itr, lbyout )
  

c dynamic memory allocation:  
c======================================================================

      if (apend .and. .not. File_Insert) then
         TraceSize = nsamp + nsamp2
         else
            TraceSize = nsamp 
         endif
    
     
      call galloc (wkadr1, TraceSize * SZSMPD, errcd1, abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif
c======================================================================
c initialize memory
         
      call vclr ( new_vel, 1, TraceSize)
c======================================================================
c open the second input file (-N2) in the case that it is a single
c function  that will be appended to all of the traces of the 
c input function (-N).

      if (apend .and.  single ) then
         call rtape( luin2, itr2, nbytes2)         
         call vmov( itr2(ITHWP1), 1, tri2, 1, nsamp2)
        
      elseif(File_Insert .and. single) then
         call rtape( luin2, itr2, nbytes2)         
         call vmov( itr2(ITHWP1), 1, tri2, 1, nsamp2) 
      
      endif
            
c======================================================================
c     Create internal logical units to make it easier to process data.
c     This is being done to simplfy the logical coding of the 
c     multivariate nature of the processes.
c
c     Index_Constraint --> True   = contrained by rec/trace values data
c                                   outside these limits are passed 
c                                   unchanged.
c
c                           False = Not constrained by rec/trace
c
c     Pick_Constraint -->   True  = constrained by HW1 and HW2
c                           False = Not constained by HW1 and HW
c
c     Start_End_Constraint --> True = constrained by -s -e
c                              False = Not constrained by -s -e
c
c                              This is also why you cannot edit with 
c                                  replace !!!!!
c     
c     Null_Constraint -->   True  = Null value (HW3) being implemented
c                           False = Not constrained by null value
c
c     
c======================================================================
c     Logical Index_Constraint

      Index_Constraint = .false.
            
      if (irs .ne. 1 .or. ire .ne. nrec .or.
     :     ns .ne. 1 .or.  ne .ne. ntrc)
     :   Index_Constraint = .true.
            
        

c     Logical Pick_Constraint

      Pick_Constraint = .false.
         
            
      if (hdrwd1 .ne. '-99999' .and. 
     :    hdrwd2 .ne. '-99999' )            
     :   Pick_Constraint = .true.
         

c     Logical Null_Constraint

      Null_Constraint = .false.
              
      if (hdrwd3 .ne. '-99999' )
     :   Null_Constraint = .true.

c     Logical Start_End_Constraint

      Start_End_Constraint = .false.
      if (ist .ne. 1 .or. iend .ne. nsamp) 
     :   Start_End_Constraint   = .true.

c special case of adding or subtracting from a hung horizon

      if (Start_End_Constraint .and. Pick_Constraint ) 
     :   Start_End_Constraint = .false.

           
c value_constraint --> if file_insertion and value specified then only
c                      insert value from second dataset if value is present
c                      in first dataset ...Garossino [June 7,2000]

      value_constraint = .false.
      if ( file_insert .and. ( Replacement_value .ne. -99999.) )
     :     value_constraint = .true.
                 
c     Logical No_Constraint
               
      No_Constraint = .false.
      if(.not. Index_Constraint .and.
     :   .not. Pick_Constraint  .and.
     :   .not. Null_Constraint  .and.
     :   .not. Start_End_Constraint.and.
     :   .not. mask             .and.
     :   .not. value_Constraint ) 
     :  No_Constraint = .true.
c======================================================================
c     Policeman for constraints
c     cases when all are true or all are false
c     
      if(Index_Constraint     .and. Pick_Constraint .and.
     :   Null_Constraint      .and. No_Constraint   .and.
     :   Start_End_Constraint .and. File_Insert ) then
                 
         go to 999
      endif
               
      if(.not. Index_Constraint .and. .not. Pick_Constraint .and.
     :   .not. Null_Constraint  .and. .not. No_Constraint   .and.
     :   .not. Start_End_Constraint .and. .not. value_constraint .and.
     :   .not. File_Insert .and. .not. No_Vel_Inv .and. .not. mask) then
                
         go to 999
      endif

c======================================================================
c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     verbos, ntap2, apend, No_Constraint ,hdrwd4,
     :     Index_Constraint,irs,ire,ns,ne, Pick_Constraint,hdrwd1,
     :     hdrwd3,
     :     Null_Constraint,hang, Start_End_Constraint,ist,iend,
     :     Detect,top,bot,DetOn,grad,thr,No_Vel_Inv, value_constraint,
     :     Replacement_value, mask, repave )

c======================================================================
c     write the logical unit constraint conditions to sisout
               
      write(LERR,*)'  '
      write(LERR,*)'  '
      write(LERR,*)'Constraint Options Being Applied'
      write(LERR,*)'--------------------------------'
      write(LERR,*)'  '
      if(mask)
     :   write(LERR,*)'Masking option'
      if(No_Constraint)
     :   write(LERR,*)'NO Constraint option'
      write(LERR,*)'  '

      if(Index_Constraint)
     :   write(LERR,*)'Constraint based on Record/Trace
     :                 Limitations given on command line' 
      write(LERR,*)'  '

      if( Pick_Constraint )
     :     write(LERR,*)'Constraint based on ',
     :                   hdrwd1,' and ',hdrwd2
      write(LERR,*)'  '

      if(Start_End_Constraint)
     :   write(LERR,*)'Constraint based on Start and End 
     :                 values provided on command line ',
     :                 ist*nsi,iend*nsi
      write(LERR,*)'  '

      if(Null_Constraint)
     :   write(LERR,*)'Constraint based on Null value ',
     :                 hdrwd3     
      write(LERR,*)'--------------------------------'
               
c======================================================================

c     check for case of both record/trace and header word constrained
                  
                
c     Not header word constrained
                  
c     Header word constrained
                
                  
c     global replacement
c     math
c     value swapping (value1 with value2)
c     gradient
                  

c======================================================================
c======================================================================
c BEGIN PROCESSING 

c skip unwanted input records
 
c no skipping since we need to always pass data
c      call recskp ( 1, irs-1, luin, ntrc, itr )
              
      DO JJ = 1, nrec
 
c skip to start trace
c no skipping since we need to always pass data       
c         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = 1, ntrc
 
            nbytes = 0
            nbytes2 = 0
           
            call rtape( luin, itr, nbytes)
c======================================================================
c open the second input file (-N2) in the case that it is not a  single
c function  that will be appended to each of the traces of the 
c input function (-N) on a trace by trace basis.

            if (apend .and. .not. single) 
     :           call rtape( luin2, itr2, nbytes2)

c======================================================================

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0 ) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )
            
            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            
            if (hdrwd1 .ne. '-99999') then
cmam...determine if word is real or integer
               if ((ifmt_hdrwd1 .eq. SAVE_SHORT_DEF) .or.
     :             (ifmt_hdrwd1 .eq. SAVE_LONG_DEF)) then
cmam....word is integer
                  call saver2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     :                 iword1 , TRACEHEADER)
               else
cmam....word is real or fake float
                  call saver2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     :                 rword1 , TRACEHEADER)
                  iword1 = nint(rword1)
               endif
            endif

            if (hdrwd2 .ne. '-99999') then
cmam...determine if word is real or integer
               if ((ifmt_hdrwd2 .eq. SAVE_SHORT_DEF) .or.
     :             (ifmt_hdrwd2 .eq. SAVE_LONG_DEF)) then
cmam....word is integer
                  call saver2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     :                 iword2 , TRACEHEADER)
               else
cmam....word is real or fake float
                  call saver2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     :                 rword2 , TRACEHEADER)
                  iword2 = nint(rword2)
               endif

            endif
            
            if (hdrwd3 .ne. '-99999') then
cmam...determine if word is real or integer
               if ((ifmt_hdrwd3 .eq. SAVE_SHORT_DEF) .or.
     :             (ifmt_hdrwd3 .eq. SAVE_LONG_DEF)) then
cmam....word is integer
                  call saver2 (itr,ifmt_hdrwd3,l_hdrwd3, ln_hdrwd3,
     :                 iword3 , TRACEHEADER)
               else
cmam....word is real or fake float
                  call saver2 (itr,ifmt_hdrwd3,l_hdrwd3, ln_hdrwd3,
     :                 rword3 , TRACEHEADER)
                  iword3 = nint(rword3)
               endif

            endif
          
c======================================================================  
c     process only live traces
            
            IF ( StaCor .ne. 30000) THEN

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]
         
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp)
  
c======================================================================
c     If HDRWD4 is input, then all other options are overridden,
c     and we immediately go to ValueChange subroutine to do the
c     work of substituting trace values for values in HDRWD4.
 
               if (hdrwd4 .ne. '-99999') then
cmam...determine if word is real or integer
                 if ((ifmt_hdrwd4 .eq. SAVE_SHORT_DEF) .or.
     :               (ifmt_hdrwd4 .eq. SAVE_LONG_DEF)) then
cmam....word is integer
                    call saver2 (itr,ifmt_hdrwd4,l_hdrwd4, ln_hdrwd4,
     :                   iword4 , TRACEHEADER)
                    rword4 = float(iword4)
                 else
cmam....word is real or fake float
                    call saver2 (itr,ifmt_hdrwd4,l_hdrwd4, ln_hdrwd4,
     :                   rword4 , TRACEHEADER)
                 endif

                 call ValueChange(tri,nsamp,new_vel,
     :              Index_Constraint,Pick_Constraint,
     :              Null_Constraint,No_Constraint,
     :              replacement_value,
     :              hdrwd1,hdrwd2,hdrwd3,hdrwd4,
     :              iword1,iword2,iword3,rword4,
     :              irs, ire, ns, ne, nsi,
     :              JJ,KK,nullval,
     :              Start_End_Constraint,ist,iend)
c 

cmam   jump immediately to output the trace...don't go thru other
cmam   logic for this option.
                 go to 444 

               endif

c======================================================================               
c Move the second file time series into tri2 in the case where it is
c not a single function being appeded to all the traces.

               if (apend .and. .not. single ) then
                  call vmov( itr2(ITHWP1), 1, tri2, 1, nsamp2)   
                 
               endif

c======================================================================
c     The Major loop of interest
c======================================================================
c Insert from -N2 into -N1

               if (File_Insert) then

                  call FileInsert(tri, nsamp, new_vel, tri2, nsamp2,
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint, value_constraint,
     :                 Replacement_value,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 recnum, trcnum, nullval,
     :                 Start_End_Constraint,ist,iend,
     :                 hang,single)
                  go to 444
               endif


c======================================================================
c======================================================================
c
c     Append a Function to the Input Data File:
c     replace    -N  -N2 

               if (apend .and. single .and. .not. File_Insert) then
                  call ApendFunc (tri, tri2, nsamp, nsamp2, new_vel)
                  go to 444
               endif

c======================================================================

               if(apend .and. .not. single .and. .not. File_Insert)then
                  call vmov( itr2(ITHWP1), 1, tri2, 1, nsamp2)   
               endif

c======================================================================
c     The Major loop of interest
c======================================================================
c
c     Append a Function to the Input Data File:
c     replace    -N  -N2  

               if (apend .and. .not. File_Insert) then
                 call ApendFunc (tri, tri2, nsamp, nsamp2, new_vel)
                 go to 444
               endif

c======================================================================
c     Perform a single value change

               if (Do_Val_Replc) then
                  call ValueChange(tri,nsamp,new_vel,
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 replacement_value,
     :                 hdrwd1,hdrwd2,hdrwd3,hdrwd4,
     :                 iword1,iword2,iword3,rword4,
     :                 irs, ire, ns, ne, nsi,
     :                 JJ,KK,nullval,
     :                 Start_End_Constraint,ist,iend)

               endif 

c======================================================================
c     Create a mask

               if (mask) then
                  do  i = 1, nsamp
                      if (abs(tri(i)) .gt. 0.0) tri(i) = 1.0
                  enddo
                  call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                  go to 777

               endif

c======================================================================

c     Perform a single value change

               if (Detect .OR. DetOn) then
                  call ValueDetect(tri, nsamp, new_vel, 
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 replacement_value,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 recnum, trcnum, nullval,
     :                 Start_End_Constraint,ist,iend,DetOn,
     :                 ifmt_hdrwd1,l_hdrwd1,ln_hdrwd1,
     :                 ifmt_hdrwd2,l_hdrwd2,ln_hdrwd2,itr,top,bot,
     :                 grad,thr,verbos,LERR)
               endif
c======================================================================
c     Perform a value change based on min/max values
c

               if (Min_Constraint .or. Max_Constraint) then
      
                  call Min_Max (tri, nsamp, new_vel, 
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 replacement_value,minval,maxval,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 JJ,KK, nullval,
     :                 Start_End_Constraint,ist,iend,
     :                 Min_Constraint, Max_Constraint,top,bot)
               endif
c======================================================================
c     Perform a mathematical operation with the
c     appropriate constraint
            
               if (math) then
                  call DoMath(tri, nsamp, new_vel, 
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 vbias,vscl,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 JJ,KK, nullval,
     :                 Start_End_Constraint,ist,iend )
               endif
c======================================================================
c     
               if (swap) then
                  call ValueSwap(tri, nsamp, new_vel, 
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 ValueOld, ValueNew,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 JJ,KK, nullval,
     :                 Start_End_Constraint,ist,iend,repave )
               endif
c======================================================================
c     Perform a gradient function replacement
c

               if (Gradient) then
                  call GradientFunc(tri, nsamp, new_vel, 
     :                 Index_Constraint,Pick_Constraint,
     :                 Null_Constraint,No_Constraint,
     :                 vo,vgrad,refe,
     :                 hdrwd1,hdrwd2,hdrwd3,
     :                 iword1,iword2,iword3,
     :                 irs, ire, ns, ne, nsi,
     :                 JJ,KK, nullval,
     :                 Start_End_Constraint,ist,iend,
     :                 hang)
               endif
               
c======================================================================
c     Eliminate velocity inversions
               if (No_Vel_Inv) then
                  call novelinv (tri, new_vel, nsamp)
               endif

c======================================================================
c     move the correct array to itr for writing to output
               
 444           if (apend .and. .not. File_Insert) then
                  call vmov (new_vel, 1, itr(ITHWP1), 1, nsamp+nsamp2)
               else
                  call vmov (new_vel, 1, itr(ITHWP1), 1, nsamp) 
               endif

	    ELSE
c======================================================================               
c for traces where StaCor .eq. 30000

               call vclr (itr(ITHWP1), 1, nsamp) 

            ENDIF

c======================================================================               
c write output data
777         continue

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

c        call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      if(ntap2(1:1) .ne. ' ') then
         call lbclos ( luin2 )
      endif
      Write(LERR,*)'replace: Normal Termination'
      write(LER,*)'replace: Normal Termination'
      stop
      
 999  continue
      
 998  call lbclos ( luin )
      call lbclos ( luout )
      if(ntap2(1:1) .ne. ' ') then
         call lbclos ( luin2 )
      endif
      write(LERR,*)'replace: ABNORMAL Termination'
      write(LER,*)'replace: ABNORMAL Termination'

      stop

      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>
c======================================================================
      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for REPLACE: '
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input>========================================<(def)'
      write(LER,*)' '
      write(LER,*)'                   Data I/O '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-N2[]  -- secondary input data se          (no file)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'          Replacement Constraint Parameters'
      write(LER,*)' '
      write(LER,*)'Start/End time constrained '
      write(LER,*)'-s[]   -- process start time (ms)                (1)'
      write(LER,*)'-e[]   -- process end time (ms)        (last sample)'
      write(LER,*)' '
      write(LER,*)'Index Constrained'
      write(LER,*)'-ns[]  -- start trace number                     (1)'
      write(LER,*)'-ne[]  -- end trace number              (last trace)'
      write(LER,*)'-rs[]  -- start record                           (1)'
      write(LER,*)'-re[]  -- end record                   (last record)'
      write(LER,*)' '
      write(LER,*)'Pick Constrained'
      write(LER,*)'-HW1[]  -- First Trace Header Word Menmonic   (none)'
      write(LER,*)'-HW2[]  -- Last Trace Header Word Nenmonic    (none)'
      write(LER,*)' '
      write(LER,*)'Null Value Constrained'
      write(LER,*)'-HW3[]  -- Trace Header Word Menmonic         (none)'
      write(LER,*)' '
      write(LER,*)'Replace values between -HW1 and -HW2 with -HW4'
      write(LER,*)'-HW4[]  -- Trc Hdr Word Mnemonic for value change'
      write(LER,*)'(this option overrides other options)         (none)'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'               Gradient Parameters '
      write(LER,*)'-vo[]    --  Initial Velocity (0 or previous sample)'
      write(LER,*)'-vgrad[] --  Velocity Gradient                (none)'
      write(LER,*)'-ref[]   --  Reference Elevation                 (0)'
      write(LER,*)'-hang    --  Hang vo from horizon at HW1            '
      write(LER,*)'              or hang vo from -s                    '
      write(LER,*)'-Noinv    --  No velocity inversion'
      write(LER,*)'----------------------------------------------------' 
      write(LER,*)'              Mathemtics Parameters '
      write(LER,*)'-bias[]   -- Bias Value                          (0)'
      write(LER,*)'-scale[]  -- Scale Value                         (1)'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'             Value Replacement Parameter'
      write(LER,*)'-value[]  -- Global Replacement Value         (none)'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'             Value Swap Parameters '
      write(LER,*)'-swapa[]   -- Value to be replaced            (none)'
      write(LER,*)'-swapb[]   -- Value to replace swapa with     (none)'
      write(LER,*)'----------------------------------------------------' 
      write(LER,*)'             Minimum/Maximum Parameters'
      write(LER,*)'-min[]   -- Minimum allowed value in data set (none)'
      write(LER,*)'-max[]   -- Maximum allowed value in data set (none)'
      write(LER,*)'       if -value[] is used all values outside the   '
      write(LER,*)'       limit will be change to that value'
      write(LER,*)'-top  -- top of trc down & stop after 1st violation'
      write(LER,*)'-bot  -- bottom of trc up & stop after 1st violation'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'             File Insertion  '
      write(LER,*)'-I    -- Insert file from -N2[] as based on the'
      write(LER,*)'        constraints defined. Some type of constriant'
      write(LER,*)'        must be defined.  This may be either a '
      write(LER,*)'        single function applied to all data or '
      write(LER,*)'        a volume of identical dimensions.'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'-D    -- Detect a value (-value) and change it to   '
      write(LER,*)'         the previous  sample in the time series    '
      write(LER,*)'-DO   -- Detect only -value[]'
      write(LER,*)'         If -top then write time into hdrwrd1'
      write(LER,*)'         If -bot then write time into hdrwrd2'
      write(LER,*)'-thr[]   -- % change to count as a detect. Default '
      write(LER,*)'            is to detect on value only'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'-M    -- create a mask with nonzero values -> 1.0'
      write(LER,*)'-A    -- replace zeros with average of trc non-zeros'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'     replace -N[] -N2[] -O[] -s[] -e[] -ns[] -ne[] '
      write(LER,*)'         -rs[] -re[] -HW1[] -HW2[] -HW3[] -HW4[]'
      write(LER,*)'         -vo[] -vgrad[] -ref[] -bias[] -scale[]'
      write(LER,*)'         -value[] -swapa[] -swapb[] -max[] -noinv'
      write(LER,*)'         -min[] -top -bot [-I -hang -D -M -DO -A] -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, ntap2,
     :     hdrwd1, hdrwd2, hdrwd3, hdrwd4,
     :     replacement_value, 
     :     vbias, vscl, ValueOld, ValueNew,
     :     vo, vgrad, refe,
     :     minval, maxval,hang,
     :     File_Insert, Detect, DetOn, top, bot, thr, grad,
     :     No_Vel_Inv, mask, repave )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis

      character  ntap*(*), otap*(*), name*(*), ntap2*(*)
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6, hdrwd4 * 6
      logical    verbos, File_Insert,hang, Detect, top, bot
      logical    DetOn, grad, No_Vel_Inv, mask, repave
      real       replacement_value, vbias, vscl
      real       ValueOld, ValueNew
      real       vo,vgrad,refe, thr
      real       minval,maxval

      

      call argr4 ( '-bias', vbias, -99999., -99999.)
      bot  = (argis('-bot') .gt. 0)

      repave = (argis('-A') .gt. 0)
      mask = (argis('-M') .gt. 0)
      No_Vel_Inv = (argis('-noinv') .gt. 0)
      DetOn  = (argis('-DO') .gt. 0)
      Detect = (argis('-D') .gt. 0)

      if (DetOn) Detect = .true.
      
      call argi4 ( '-e', iend, 0, 0 )

      hang = (argis('-hang') .gt. 0)
      call argstr( '-HW1', hdrwd1, '-99999', '-99999' )
      call argstr( '-Hw1', hdrwd1, hdrwd1, hdrwd1)
      call argstr( '-hw1', hdrwd1, hdrwd1, hdrwd1)

      call argstr( '-HW2', hdrwd2, '-99999', '-99999' )
      call argstr( '-Hw2', hdrwd2, hdrwd2, hdrwd2)
      call argstr( '-hw2', hdrwd2, hdrwd2, hdrwd2)

      call argstr( '-HW3', hdrwd3, '-99999', '-99999' )
      call argstr( '-Hw3', hdrwd3, hdrwd3, hdrwd3)
      call argstr( '-hw3', hdrwd3, hdrwd3, hdrwd3)

      call argstr( '-HW4', hdrwd4, '-99999', '-99999' )
      call argstr( '-Hw4', hdrwd4, hdrwd4, hdrwd4)
      call argstr( '-hw4', hdrwd4, hdrwd4, hdrwd4)

      File_Insert = (argis('-I') .gt. 0)

      call argr4 ( '-max', maxval, -99999., -99999. )
      call argr4 ( '-min', minval, -99999., -99999. )

      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N2', ntap2, ' ', ' ' )
      call argstr ( '-N', ntap, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' )
      
      call argr4 ( '-swapa', ValueOld, -99999., -99999. )
      call argr4 ( '-swapb', ValueNew, -99999., -99999. )
        
      top  = (argis('-top') .gt. 0)

      call argr4 ( '-value',replacement_value,
     :     -99999.,-99999. )

      call argr4 ( '-vgrad', vgrad, -99999., -99999. )

      call argr4 ( '-vo', vo, -99999., -99999. )

      call argr4 ( '-ref', refe, -99999., -99999. )
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      call argr4 ( '-scale', vscl, -99999., -99999.)      

      call argi4 ( '-s', ist, 1, 1 )

      verbos = (argis('-V') .gt. 0)

      if (DetOn) then
         call argr4 ( '-thr', thr, 0., 0.)
         grad = .false.
         if (thr .ne. 0.0) grad = .true.
         if (.not.top .AND. .not.bot) then
            write(LERR,*)'FATAL ERROR in replace option -DO'
            write(LERR,*)'Must enter one or both -top -bot'
            write(LER ,*)'FATAL ERROR in replace option -DO'
            write(LER ,*)'Must enter one or both -top -bot'
            stop
         endif
         if (replacement_value .eq. -99999.) then
            write(LERR,*)'FATAL ERROR in replace option -DO'
            write(LERR,*)'Must enter -value[]'
            write(LER ,*)'FATAL ERROR in replace option -DO'
            write(LER ,*)'Must enter -value[]'
            stop
         endif
         if (hdrwd1 .eq. '-99999') then
            write(LERR,*)'FATAL ERROR in replace option -DO'
            write(LERR,*)'Must enter -hw1[] hdr word mnemonic'
            write(LER ,*)'FATAL ERROR in replace option -DO'
            write(LER ,*)'Must enter -hw1[] hdr word mnemonic'
            stop
         endif
         if (hdrwd2 .eq. '-99999' .AND. bot) then
            write(LERR,*)'FATAL ERROR in replace option -DO'
            write(LERR,*)'Must enter -hw2[] hdr word mnemonic'
            write(LER ,*)'FATAL ERROR in replace option -DO'
            write(LER ,*)'Must enter -hw2[] hdr word mnemonic'
            stop
         endif
      endif
      
c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c     verbal printout of pertinent program particulars
      subroutine verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     verbos, ntap2, apend, No_Constraint, hdrwd4,
     :     Index_Constraint,irs,ire,ns,ne,Pick_Constraint,hdrwd1,hdrwd3,
     :     Null_Constraint,hang, Start_End_Constraint,ist,iend,
     :     Detect,top,bot,DetOn,grad,thr,No_Vel_Inv, value_constraint,
     :     value, mask,repave )

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs
      integer     ire, ns, ne, nsi

      real value

      character  ntap*(*), otap*(*),ntap2*(*)
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6, hdrwd4 * 6
      
      logical   verbos, apend,  No_Constraint, Index_Constraint
      logical   Pick_Constraint, Null_Constraint
      logical   Start_End_Constraint,hang,Detect,top,bot
      logical   DetOn, grad, No_Vel_Inv
      logical   value_constraint, mask, repave

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      if (ntap2(1:1) .ne. ' ') then
         write(LERR,*) ' secondary input data set name = ',ntap2
         write(LERR,*) ' Will be appending ', ntap2, 'to ',ntap
      else
         write(LERR,*)'No secodary input file opened no file apend'
      endif

      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
cmam  if hdrwd4 is supplied, all other constraint options are overridden
      if (hdrwd4 .ne. '-99999') then
          write(LERR,*) 'Replacing trace values between time in ',
     :    hdrwd1,' and ', hdrwd2,' with value in ',hdrwd4
          go to 100
      endif

      if (Detect) then
         write(LERR,*) 'Do standard detect/replace function'
      elseif (DetOn) then
         if (grad)
     1   write(LERR,*) 'Gradient threshold detection %  ',thr
         if (top) then
         write(LERR,*) 'Do detect from top of trace down and write time'
         write(LERR,*) 'into trc hdr word1'
         endif
         if (bot) then
         write(LERR,*) 'Detect from bottom of trace up and write time'
         write(LERR,*) 'into trc hdr word2'
         endif
      endif

      if (No_Constraint) then
          write(LERR,*) 'No Contraint, the replacement option will be'
          write(LERR,*) 'applied to all data'
          if (top) then
          write(LERR,*)'Looking from the start of trace down, the'
          write(LERR,*)'replacement will stop after the first violation'
          endif
          if (bot) then
          write(LERR,*)'Looking from the bottom of trace up, the'
          write(LERR,*)'replacement will stop after the first violation'
          endif
          if (repave) then
          write(LERR,*)'Replace zeroes with average of live samples'
          endif
      endif
         
      if( mask ) then
         write(LERR,*) 'Masking Operation:'
         write(LERR,*) 'Constraining masking between records ',
     :        irs,' to ',
     :        ire, ' and from trace ', ns, ' to trace ',ne
      endif
      if( Index_Constraint) then
         write(LERR,*) 'Index Constraint option'
         write(LERR,*) 'Constraining replacement between records ',
     :        irs,' to ', 
     :        ire, ' and from trace ', ns, ' to trace ',ne
      endif
      if( Pick_Constraint) then
         write(LERR,*) 'Pick Constraint option'
         write(LERR,*) 'Constraining replacement between the values in 
     :        header words ', hdrwd1,' and ', hdrwd2
      endif

      if( Null_Constraint) then
         write(LERR,*) 'Null Constraint option'
         write(LERR,*) 'Null replacement option for values in 
     :        header word ', hdrwd3
      endif
      if (Detect) then
         write(LERR,*) 'Detect Mode Enabled'
         write(LERR,*) 'Detect Mode Enabled'
      endif

      if (No_Vel_Inv) then
         write(LERR,*) 'Eliminate velocity inversions'
      endif

      if( value_Constraint) then
         write(LERR,*) 'Value Constraint option'
         write(LERR,*) 'amplitudes of ',value,' from dataset -N[] will'
         write(LERR,*) 'be replaced by values from dataset -N2[]'
      endif

cmam
  100 continue

      write(LERR,*)'========================================== '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
	if (hang) write(LERR,*)'Hanging gradient off of
     : the horizon'
      if ( verbos )  write(LERR,*) ' verbose printout requested (not
     :     that it matters)'

      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





