C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine LoadFirstTrace ( luval, X, Y, maxpts, nullval, minx, 
     :     maxx, intx, UnitSc_in, SI_units )

c routine to load first ASCII trace and determine minx, max and intx
c parameters required for output USP lineheader

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer luval, maxpts, minx, maxx, intx

      real nullval, UnitSc_in
      real X(maxpts), Y(maxpts)

      logical SI_units

c declare local variables

      integer i

      real Yi

      character card*80

c go


      do i = 1, maxpts
         read (luval, '(a80)', err= 991, end=992) card

         call fsscnf ( card, '%f %f', X(i),Yi )
         if (abs(nullval-Yi) .lt. 1.e-30) then
            Y(i) = 0.
         else
            Y(i) = Yi
         endif
      enddo

      
      if ( SI_units ) then
         intx  = nint ( ( X (2) - X (1) ) / UnitSc_in )
         minx  = nint ( X (1) / UnitSc_in )
         maxx  = nint ( X (maxpts) / UnitSc_in )
      else
         intx  = nint ( X (2) - X (1) )
         minx  = nint ( X (1) )
         maxx  = nint ( X (maxpts) )
      endif

      if (intx .eq. 0) intx = 1
       
      return

 991  continue

c-----
c error reading data on stdin in reverse mode
c-----

      write(LERR,*)' '
      write(LERR,*)' error reading data on ', luval, 'while attempting'
      write(LERR,*)' to read the first ASCII trace '
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)'SIS_XY: '
      write(LER,*)' error reading data on ', luval, 'while attempting'
      write(LER,*)' to read the first ASCII trace '
      write(LER,*)'FATAL'

      stop

 992  continue

c-----
c premature EOF on stdin while reading first trace in reverse mode
c-----

      write(LERR,*)' '
      write(LERR,*)' premature EOF on ',luval,' while attempting '
      write(LERR,*)' to read the first ASCII trace'
      write(LERR,*)' Check -nsamp[] value on input '
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)'SIS_XY: '
      write(LER,*)' premature EOF on ',luval,' while attempting '
      write(LER,*)' to read the first ASCII trace'
      write(LER,*)' Check -nsamp[] value on input '
      write(LER,*)'FATAL'

      stop
      end

