C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c Store reads a list static values and writes them 
c to the trace header of an input file.
c Results are written to an output file.
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout,lbyte
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      integer     recnum, trcnum, static, srcloc, recind
      integer     srptxc, rcptxc
      real        ss, rs
      pointer     (wkss, ss(1))
      pointer     (wkrs, rs(1))
      character   ntap * 512, otap * 512, name*4
      character   sfile * 512
      character   srcwrd*6, recwrd*6
cmam....added amplitude option.....10-26-95
      character   ampwrd*6
      logical     ampopt
cmam...added option to make 2d data look like 3d in headers
      logical     x2d
      logical     verbos,cards,disco,source,rec,sis,fp
cmam...........add option to interpolate input statics or not
      logical	  intrp
      integer     argis, ierr, ierrt, iabort
 
      data lbytes / 0 /, nbytes / 0 /, name/'STOR'/
      data ierr/0/
      data ierrt/0/
      data iabort/0/
c     data rs /200000 * -30000./, ss /200000 * -30000./
 
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
cmam  call gcmdln(ntap,otap,sfile,ns,ne,irs,ire,isb,irb,
      call gcmdln(ntap,otap,sfile,ns,ne,irs,ire,isb,irb,intrp,
     1    srcsft,recsft,cards,sis,disco,source,rec,fp,unet,verbos,
     2    srcwrd,recwrd, ampopt, ampwrd, x2d)
cmam 2    srcwrd,recwrd, ampopt, ampwrd)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     open cardfile
c-----
        call alloclun (lus)
        lenlus = lenth (sfile)

	if (cards) then
c           open(unit=lus, file=sfile,form = 'formatted')
           open(unit=lus, file=sfile(1:lenlus),status = 'old',
     1          form = 'formatted', iostat = ierr)
	elseif (sis ) then
           open(unit=lus, file=sfile(1:lenlus),status = 'old',
     1          form = 'formatted', iostat = ierr)
	elseif (ampopt) then
           open(unit=lus, file=sfile(1:lenlus),status = 'old',
     1          form = 'formatted', iostat = ierr)
	elseif (disco) then
           open(unit=lus, file=sfile(1:lenlus),status = 'old',
     1          form = 'formatted', iostat = ierr)
        endif

        if(ierr .ne. 0) then
           write(LER,*)'FATAL ERROR in storeit:'
           write(LER,*)'Could not open input card file ',
     :             sfile(1:lenlus)
           write(LER,*)'Check existance and rerun '
           stop
        endif

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STORE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
         unitsc = .001
         call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

cmam.....added amplitude option.....10-26-95
      IF (ampopt) then
         call savelu(ampwrd,ifmt_ampwrd,l_ampwrd,ln_ampwrd,1)
      ELSE
cmam......not the amplitude option
         if (isb .eq. 0) then
            call savelu(srcwrd,ifmt_srcwrd,l_srcwrd,ln_srcwrd,1)
            isb = l_srcwrd
         else
            l_srcwrd    = isb
            ln_srcwrd   = 2
            ifmt_srcwrd = 4
         endif

         if (irb .eq. 0) then
            call savelu(recwrd,ifmt_recwrd,l_recwrd,ln_recwrd,1)
            irb = l_recwrd
         else
            l_recwrd    = irb
            ln_recwrd   = 2
            ifmt_recwrd = 4
         endif

      ENDIF

      call hlhprt (itr, lbytes, name, 4, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     output of all pertinent information before
c     processing begins
c-----
      call verbal(nsamp, nsi, ntrc, nrec, iform,intrp,
     1        recsft,srcsft,ntap,otap,sfile,isb,irb,
     2        srcwrd,recwrd, ampopt, ampwrd,x2d)
cmam 2                  srcwrd,recwrd, ampopt, ampwrd)
c--------------------------------------------------
c  figure out design window times

      dt = nsi * unitsc

      call readdim (nent, fp, unit, lus, sis, card, disco, ampopt,
     1              minent, maxent)

      call galloc (wkss, maxent*SZSMPD, ierr, iabort)
      ierrt = ierrt + ierr
      call galloc (wkrs, maxent*SZSMPD, ierr, iabort)
      ierrt = ierrt + ierr
      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR in storeit:'
         write(LERR,*)'Unable to allocate ',2*maxent*SZSMPD,' bytes'
         write(LER ,*)'FATAL ERROR in storeit:'
         write(LER ,*)'Unable to allocate ',2*maxent*SZSMPD,' bytes'
      else
         write(LERR,*)'Allocated ',2*maxent*SZSMPD,' bytes'
      endif

c--------------------------------------------------
c     READ STATICS FILE
      IF (sis  ) then

         call readcards(ss,rs,lus,unet)
cmam...........check if interpolating or not
         if(.not.intrp) then
            call fill1(ss,maxent)
            call fill1(rs,maxent)
         endif

      ELSEIF (cards) then

         call rfile (maxent,ss,rs,lus,mingi,maxgi,fp,unet)

cmam.......check option to interpolate or not
         if(.not.intrp) then

c     interpolate source statics
            igflag = 1
            igss = 1
            do 150 il = mingi + 1, maxgi
              if ( ss(il) .eq. -30000. ) then
                igflag = 0
              else
                if (igflag .eq. 0) then
                  sl=(ss(il)-ss(igss))/(float(il-igss))
                        do 250 jl = igss, il
                          ss(jl) = sl * (jl - igss) + ss(igss)
250                     continue
                  igss = il
                  igflag = 1
                else
                  igss = il
                endif
              endif
150         continue
c
c
c     interpolate receiver statics
            igflag = 1
            igss = 1
            do 350 il = mingi + 1, maxgi
              if ( rs(il) .eq. -30000. ) then
                igflag = 0
              else
                if (igflag .eq. 0) then
                  sl=(rs(il)-rs(igss))/(float(il-igss))
                  do 450 jl = igss, il
                    rs(jl) = sl * (jl - igss) + rs(igss)
450               continue
                  igss = il
                  igflag = 1
                else
                  igss = il
                endif
              endif
350         continue
         endif
cmam.............end of interpolation code

      ELSEIF (disco) then

         if (source) then
             call sdisco(lus,ss,ns,unet)
cmam.........check whether to interpolate or not
             if(.not.intrp) call fill1(ss,maxent)
         else
             call rdisco(lus,rs,nr,unet)
cmam.........check whether to interpolate or not
             if(.not.intrp) call fill1(rs,maxent)
         endif
cmam....added amplitude option....10-26-95

      ELSEIF (ampopt) then

        call rdamp (lus,ss,rs)

      ENDIF
c
      if (verbos) then
        write(LERR,*)'*************************************************'
        write(LERR,*)'Source Station Statics (x 100)'
        do i = 1, maxent, 8
           write(LERR,992)i,(ss(i-1+ii),ii=1,8)
        enddo
        write(LERR,*)' '
        write(LERR,*)'Receiver Station Statics (x 100)'
        do i = 1, maxent, 8
           write(LERR,992)i,(rs(i-1+ii),ii=1,8)
        enddo
992     format(i5,3x,8F8.0)
        write(LERR,*)'*************************************************'
      endif
c-----
c     process desired trace records
c-----
      do 1000 jj = 1, nrec

            do 1001 kk = 1, ntrc
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        static, TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idist , TRACEHEADER)
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum, TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum, TRACEHEADER)
                  call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc, TRACEHEADER)
                  call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind, TRACEHEADER)
                  call saver2(itr,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1                        ipri  , TRACEHEADER)
                  call saver2(itr,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                        ispn  , TRACEHEADER)
                  call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                        srptxc  , TRACEHEADER)
                  call saver2(itr,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                        rcptxc  , TRACEHEADER)

                  dist   = iabs ( idist )
                  if (srcloc .lt. 0 ) srcloc = 2*32768 + srcloc
                  isrc10 = ispn     
                  if(x2d) then
                     call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                           idi, TRACEHEADER)
                     ipri = idi - recind
                  endif

                  IF(static .ne. 30000) then

                  IF (sis  ) then

                     if ( ss(ipri)   .le. -10000.) ss(ipri  ) = 0.
                     if ( rs(recind) .le. -10000.) rs(recind) = 0.
                     itrisb =nint( ss(ipri  ) + srcsft) 
                     itrirb =nint( rs(recind) + recsft) 
                     itotal_static = itrisb + itrirb
                     call savew2(itr,ifmt_srcwrd,l_srcwrd, ln_srcwrd,
     1                           itrisb, TRACEHEADER)
                     call savew2(itr,ifmt_recwrd,l_recwrd, ln_recwrd,
     1                           itrirb, TRACEHEADER)
                     call savew2(itr,ifmt_stacor,l_stacor, ln_stacor,
     1                           itotal_static, TRACEHEADER)

                   ELSEIF (cards) then

                     if ( ss(isrc10) .eq. -30000.) ss(isrc10) = 0.
                     if ( rs(recind) .eq. -30000.) rs(recind) = 0.
                     itrisb =nint( ss(isrc10) + srcsft )
                     itrirb =nint( rs(recind) + recsft )
                     itotal_static = itrisb + itrirb
                     call savew2(itr,ifmt_srcwrd,l_srcwrd, ln_srcwrd,
     1                           itrisb, TRACEHEADER)
                     call savew2(itr,ifmt_recwrd,l_recwrd, ln_recwrd,
     1                           itrirb, TRACEHEADER)
                     call savew2(itr,ifmt_stacor,l_stacor, ln_stacor,
     1                           itotal_static, TRACEHEADER)

                   ELSEIF (disco) then

                     if(source) then
                        if ( ss(isrc10) .le. -10000.) ss(isrc10) = 0.
                        itrisb =nint(srcsft)
                        call savew2(itr,ifmt_SrPtSC,l_SrPtSC,
     1                              ln_SrPtSC, itrisb, TRACEHEADER)
                     else
                        if ( rs(recind) .le. -10000.) rs(recind) = 0.
                        itrirb =nint(recsft)
                        call savew(itr,ifmt_RcPtXC,l_RcPtXC,
     1                             ln_RcPtXC, itrirb, TRACEHEADER)
                     endif

cmam....added amplitude option.....10-26-95

                   ELSEIF (ampopt) then

                      xamp = ss(ipri) + rs(recind)
                      xamp = exp(xamp)
                      call putfp2(itr,ifmt_ampwrd,l_ampwrd,
     :                            ln_ampwrd, xamp, TRACEHEADER)
                  ENDIF

                  ENDIF     !  end of 30000 loop
c
c-----------------------
c
                  call wrtape( luout, itr, nbytes)
 1001             continue
 
c----------------------
 
 1000       continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
c        111111111122222222223333333333444444444455555555556666666666777
c23456789012345678901234567890123456789012345678901234567890123456789012
c.............................................................................
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE STOREIT  --  WRITE STATICS TO USP TRACE-HEADERS'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :'Program STOREIT writes a list of static values to trace headers.'
      WRITE(LER,*)
     :'A constant time shift can be added to each header word written.'
      WRITE(LER,*)
     :'Statics can then be applied with program REST.'
      WRITE(LER,*)
     :'NOTE: When using the sis OR card option, the source and receiver'
      WRITE(LER,*)
     :'      statics are output to specified header words, BUT their'
      WRITE(LER,*)
     :'      sum is placed automatically in mnemonic word StaCor(125).'
      WRITE(LER,*)
     :'NOTE: When using the sis option, the source and receiver'
      WRITE(LER,*)
     :'      statics will have two implied decimals so use a scale'
      WRITE(LER,*)
     :'      factor of 100 in Program REST to apply the correct static.'
      WRITE(LER,*)
     :'NOTE: For sis option with nearest ms accuracy, use -u100.0'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :'Static values are supplied to the program through a flat file:'
      WRITE(LER,*)
     :'                    using 8stat,9corr cards'
      WRITE(LER,*)
     :'                    using disco data cards'
      WRITE(LER,*)
     :'                    using gi, receiver stats, and src stats'
      WRITE(LER,*)
     :'Missing static values are linearly interpolated, unless the'
      WRITE(LER,*)
     :'interpolation is turned off (use -nin on command line.)'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :'Another function of storeit is to put amplitude correction'
      WRITE(LER,*)
     :'values into a specified header word, and then use REST to apply'
      WRITE(LER,*)
     :'the correction to the data.  This option should not use any'
      WRITE(LER,*)
     :'scaling (the corrections are log values).  These corrections'
      WRITE(LER,*)
     :'will come from PICKER and SC3D using their -amp option.  Use'
      WRITE(LER,*)
     :'the -A option in REST to apply the amplitude corrections.'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :'Execute STOREIT by typing "storeit" followed by:'
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)' '
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output data file name'
        WRITE(LER,*)
     :' -ST[sfile]     (no default) : statics or amp flatfile name'
      WRITE(LER,*)' '
        WRITE(LER,*)
     :' -sis         (opt 1):input statics from 8stat, 9corr cards'
        WRITE(LER,*)
     :' -C           (opt 2):input statics from gi, rec, src cards'
        WRITE(LER,*)
     :' -u[unet]  (default=1.0) Divide static by unet, then store'
        WRITE(LER,*)
     :'             to remove effect of unet in rest,use same value'
        WRITE(LER,*)
     :' -disco[disco](opt 3):input statics from disco data cards'
        WRITE(LER,*)
     :'    -S : disco data cards for source statics(disco only)'
        WRITE(LER,*)
     :'    -R : disco data cards for receiver statics(disco only)'
      WRITE(LER,*)' '
	WRITE(LER,*)
     :' -nin     (default is to interpolate) Do not interpolate'
        WRITE(LER,*)
     :'             for missing statics.  This option only applies'
        WRITE(LER,*)
     :'             to statics, not amplitudes.'
        WRITE(LER,*) 
     :' -IS [isb]      (InStAp)   : initiation static hdr word'
        WRITE(LER,*) 
     :' -IR [isb]      (RcStAp)   : reception static hdr word'
        WRITE(LER,*) 
     :' -is [isb]      (9)        : (old) trace header half word to'
        WRITE(LER,*) 
     :'                               write initiation static value' 
        WRITE(LER,*) 
     :' -ir [isr]      (12)       : (old) trace header half word to'
        WRITE(LER,*) 
     :'                               write reception static value' 
        WRITE(LER,*)
     :' -st [srcsft] (0)          : initiation static constant'
        WRITE(LER,*)
     :'                               time shift (ms)'
        WRITE(LER,*)
     :' -rt [recsft] (0)          : reception static constant'
        WRITE(LER,*)
     :'                               time shift (ms)'
        WRITE(LER,*)
     :' -V [verbos]  ( no )       : print additional info'
	write(LER,*)
     :' -amp         (opt 4):input amplitude scalars from flat file'
	write(LER,*)
     :'                      containing REC-AMPL and SHT-AMPL cards'
	write(LER,*)
     :'                      created by picker and sc3d using -amp'
	write(LER,*)' '
	write(LER,*)
     :' -IA [ampwrd]  (no default): word to store amplitude exp in'
	write(LER,*)
     :'                           this word will contain the value:'
	write(LER,*)
     :'                            exp( sa(PrRcNm) + ra(RecInd) )'
        WRITE(LER,*)
     :' -2d                       : option to substitute di-gi for'
        WRITE(LER,*)
     :'                             pri(make 2d data work with sc3d'
        WRITE(LER,*)
     :'                             amplitude option)'
        WRITE(LER,*)' '
        WRITE(LER,*)
     :' EXAMPLE 1:'
        WRITE(LER,*)
     :' storeit -N/home/data/ntap -O/home/data/otap -STstat.file'
        WRITE(LER,*) 
     :'       -ISInStAp -IRRcStAp -st20 -rt45 -disco -sis -u100.0 '
        WRITE(LER,*)' '
        WRITE(LER,*)
     :' EXAMPLE 2:'
        WRITE(LER,*)
     :' storeit -N/home/data/ntap -O/home/data/otap -STamp.file'
        WRITE(LER,*)
     :'       -IATVPT01 -amp '
        WRITE(LER,*)' '
        WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
c.............................................................................

cmam  subroutine gcmdln(ntap,otap,sfile,ns,ne,irs,ire,isb,irb,
      subroutine gcmdln(ntap,otap,sfile,ns,ne,irs,ire,isb,irb,intrp,
     1          srcsft,recsft,cards,sis,disco,source,rec,fp,unet,verbos,
     2          srcwrd,recwrd, ampopt, ampwrd,x2d)
cmam 2          srcwrd,recwrd, ampopt, ampwrd)
cmam.....added amplitude option....10-26-95
cmam 2          srcwrd,recwrd)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
C     sis         - l   read 8stat, 9corr cards
C     cards       - l   read gi, rec, source cards
C     disco       - l   reading an input disco flat file
C     source      - l   disco flat file has source statics
C     rec         - l   disco flat file has receiver statics
c    unet   - r      time units override
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), sfile*(*)
      character   srcwrd*6, recwrd*6
cmam....added amplitude option....10-26-95
      character   ampwrd*6
      logical     ampopt
cmam....added option to make 2d data look like 3d in headers
      logical     x2d
      integer     ns, ne, irs, ire
      logical     cards,verbos,disco,source,rec,sis,fp
cmam.............add option to interpolate or not the input statics
      logical     intrp
      integer     argis
 
      cards  = (argis('-C') .gt. 0)

      disco  = (argis('-disco') .gt. 0)

      fp     = (argis('-F') .gt. 0)

cmam....added amplitude option....10-26-95
      call argstr( '-IA', ampwrd, ' ', ' ' )
      ampopt    = (argis('-amp'). gt. 0)

      if(ampopt) then
        if(ampwrd(1:1).eq.' ') then
           write(LERR,*)'FATAL ERROR in storeit -amp option:'
           write(LERR,*)'Must have header word specification -IA[] on'
           write(LERR,*)'cmd line for output of amplitude scaler'
           write(LER ,*)'FATAL ERROR in storeit -amp option:'
           write(LER ,*)'Must have header word specification -IA[] on'
           write(LER ,*)'cmd line for output of amplitude scaler'
           stop 666
         endif

      else

         call argstr( '-IR', recwrd, 'RcStAp', 'RcStAp' )
         call argstr( '-IS', srcwrd, 'InStAp', 'InStAp' )
         call argi4 ( '-ir', irb ,  0  , 0    )
         call argi4 ( '-is', isb ,  0  , 0    )
      endif

      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argstr( '-N', ntap, ' ', ' ' )

      call argstr( '-O', otap, ' ', ' ' )

      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )
      call argr4 ( '-rt', recsft, 0., 0. )
      rec    = (argis('-R') .gt. 0)

      sis    = (argis('-sis'). gt. 0)
      CALL ARGSTR( '-ST', sfile, ' ', ' ' )
      call argr4( '-st', srcsft, 0., 0. )
      source = (argis('-S') .gt. 0)
      intrp = (argis('-I') .gt. 0)
      x2d = (argis('-2d') .gt. 0)


      call argr4 ( '-u', unet ,  1.0  , 1.0    )

      verbos = (argis('-V') .gt. 0)

      if (unet .ne. 1.0) fp = .true.
c
      return
      end
c
c.............................................................................
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,intrp,
     1                  recsft,srcsft,ntap,otap,sfile,isb,irb,
     2                  srcwrd,recwrd, ampopt, ampwrd,x2d)
cmam 2                  srcwrd,recwrd, ampopt, ampwrd)
cmam....added amplitude option....10-26-95
cmam 2                  srcwrd,recwrd)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), sfile*(*)
      character   srcwrd*6, recwrd*6
cmam....added amplitude option....10-26-95
      character   ampwrd*6
      logical     ampopt,intrp
      logical     x2d
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
            write(LERR,*) ' input statics file    =  ', sfile
cmam...added amplitude option....10-26-95
            if(ampopt) then
            write(LERR,*) ' requested amplitude option'
            write(LERR,*) ' word for amplitude scalar =', ampwrd
            else
            write(LERR,*) ' Init. statics word    =  ', isb,' ',srcwrd
            write(LERR,*) ' Recp. statics word    =  ', irb,' ',recwrd
            write(LERR,*) ' job static shift source   (ms) =  ', srcsft
            write(LERR,*) ' job static shift receiver (ms) =  ', recsft
            endif
cmam...added interpolation option....
            if(intrp) then
                write(LERR,*) ' statics/amplitudes will NOT be ',
     :          'interpolated'
            else
                write(LERR,*) ' statics/amplitudes will be ',
     :          'interpolated'
            endif
            if(x2d) then
                write(LERR,*) ' use pri=di-gi substitution for 2d data'
            endif
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
c
c.............................................................................
