C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine readdim (nent, fp, unit, lus, sis, card, disco, ampopt,
     1                    minent, maxent)
#include <f77/iounit.h>

      integer   nent, lus, minent, maxent, ic, loc
      real      entry(8), si, ri, gi, unit, xstatic
      logical   fp, sis, card, disco, ampopt
      character label*5, dtag*8

      minent =  999999999
      maxent = -999999999
      nent   = 0
      ic     = 0

      rewind (lus)

      IF (sis) THEN

         do while (1.eq.1)
            read(lus,100,end=999,err=666) label, entry, id
100         format(a5, 1x, 8f7.0, 13x, i5)
            ic = ic + 1
            if (id .le. minent) minent = id
            if (id .ge. maxent) maxent = id
         enddo

      ELSEIF (card) THEN

         runit = unit
         if (.not. fp) runit = 1.
            
         do while (1.eq.1)
            read (lus, *, end=999, err=666) gi, ri, si
            ic = ic + 1
            id = nint (si/runit)
            if (id .le. minent) minent = id
            if (id .ge. maxent) maxent = id
            id = nint (ri/runit)
            if (id .le. minent) minent = id
            if (id .ge. maxent) maxent = id
         enddo

      ELSEIF (disco) THEN
            
         do while (1.eq.1)
            read(lus,'(a8,i8,f8.1)',end=999,err=666) dtag, loc, xstatic
            ic = ic + 1
            id = loc
            if (id .le. minent) minent = id
            if (id .ge. maxent) maxent = id
         enddo

      ELSEIF (ampopt) THEN

         do while (1.eq.1)
            read(lus,'(a8,i8,f16.8)',end=999,err=666) dtag, loc, xstatic
            ic = ic + 1
            id = loc
            if (id .le. minent) minent = id
            if (id .ge. maxent) maxent = id
         enddo

      ELSE
        write(LERR,*)'FATAL ERROR in storeit:'
        write(LERR,*)'Input type must be -C or -sis or -disco'
        write(LER ,*)'FATAL ERROR in storeit:'
        write(LER ,*)'Input type must be -C or -sis or -disco'
        call ccexit (666)
      ENDIF

999   continue

      nent = ic
      if (nent .eq. 0) then
        write(LERR,*)'FATAL ERROR in storeit:'
        write(LERR,*)'No entries read from statics file'
        write(LER ,*)'FATAL ERROR in storeit:'
        write(LER ,*)'No entries read from statics file'
        call ccexit (666)
      endif
      return

666   continue
      write(LERR,*)'FATAL ERROR in storeit:'
      write(LERR,*)'Error reading statics file line ',ic-1
      write(LER ,*)'FATAL ERROR in storeit:'
      write(LER ,*)'Error reading statics file line ',ic-1

      return
      end
      subroutine rfile (N,ss,rs,lus,mingi,maxgi,fp,unit)

#include <f77/iounit.h>

      integer N, lus, mingi, maxgi

      real ss(N), rs(N), unit

      logical fp

c local variables

      real real_ir, real_is, real_igi, real_r, real_s
c
      mingi = 999999999
      maxgi = 0
10    continue
	if (fp) then
	 read (lus, *, end=30, err=30) real_igi, real_r, real_s
         rs(igi) = real_r/unit
         ss(igi) = real_s/unit
	else
         read (lus, *, end=30, err=30) real_igi, real_ir, real_is
         igi = nint(real_igi)
         rs(igi) = real_ir
         ss(igi) = real_is
	endif
         if ( igi .lt. mingi) mingi = igi
         if ( igi .gt. maxgi) maxgi = igi
      go to 10
30    continue
      return
      end
c.............................................................................
	subroutine readcards( ss, rs, lus,unit)
	dimension ss(*),rs(*), entry(8)
	character label*5
	icount = 0
	jcount = 0
	jstart = 1
	kstart = 1
        rewind (lus)

10	continue
	
c
c          read 8stat,9corr card
c
	read(lus,100,end=999) label, entry, id
100	format(a5, 1x, 8f7.0, 13x, i5)
c
c           check for card type (assumes 8stat comes first)
c
	if (label .eq. '8STAT' .or. label .eq. '8stat')then
		if ( id .ne. 0 ) jstart = id
		do 20 j = 1,8
			if (entry(j) .lt. 9999.) then
				icount = icount + 1
 				rs(jstart) = entry (j)/unit
				jstart = jstart + 1
			else
				go to 10
			endif
20		continue
	else
	 	if ( id .ne. 0 ) kstart = id
		do 30 j = 1, 8
			if (entry(j) .lt. 9999.) then
				jcount = jcount + 1
 				ss(kstart) = entry(j)/unit
				kstart = kstart + 1
			else
				return
			endif
30		continue
	endif
	go to 10
999	return
	end
c.............................................................................
      SUBROUTINE FILRM2(ARRAY,BEG,END)                                  DUM00010
C=======================================================================DUM00020
C                                                                       DUM00030
      IMPLICIT INTEGER (A-Z)                                            DUM00040
      real   ARRAY(*), temp
cmam  INTEGER   ARRAY(*)                                                DUM00050
      REAL INC                                                          DUM00060
C                                                                       DUM00070
      TEMP=ARRAY(BEG)                                                   DUM00080
      INC=(ARRAY(END)-TEMP)/FLOAT(END-BEG)                              DUM00090
C                                                                       DUM00100
      DO 10 I=1,END-BEG-1                                               DUM00110
         ARRAY(BEG+I)=TEMP+I*INC                                        DUM00120
  10  CONTINUE                                                          DUM00130
C                                                                       DUM00140
C                                                                       DUM00150
      RETURN                                                            DUM00160
      END                                                               DUM00170
c.............................................................................
cmam  SUBROUTINE FILL1(ARRAY,NSAMP)                                     DUM00180
cmam  DIMENSION ARRAY(*)                                                DUM00190
cmam  CALL ELRAMP1(ARRAY,NSAMP)   
cmam  RETURN                                                            DUM00350
cmam  END                                                               DUM00360
c.............................................................................
cmam  SUBROUTINE ELRAMP1(ARRAY,N)  
      SUBROUTINE FILL1(ARRAY,N)
C=======================================================================DUM00380
C                                                                       DUM00390
      IMPLICIT INTEGER(A-Z)                                             DUM00400
      real   ARRAY(*), temp
cmam  INTEGER   ARRAY(*)                                                DUM00410
C                                                                       DUM00420
C                                                                       DUM00430
      DO 10 I=1,N                                                       DUM00440
         IF(array(i).ne.-30000.) THEN
            FIRST=I                                                     DUM00460
            TEMP=ARRAY(I)                                               DUM00470
            DO 5 J=1,I                                                  DUM00480
               ARRAY(J)=TEMP                                            DUM00490
   5        CONTINUE                                                    DUM00500
            GOTO 20                                                     DUM00510
         ENDIF                                                          DUM00520
  10  CONTINUE                                                          DUM00530
C                                                                       DUM00540
  20  DO 30 I=N,1,-1                                                    DUM00550
         IF(array(i).ne.-30000.) THEN
            LAST=I                                                      DUM00570
            TEMP=ARRAY(I)                                               DUM00580
            DO 25 J=N,I,-1                                              DUM00590
               ARRAY(J)=TEMP                                            DUM00600
  25        CONTINUE                                                    DUM00610
            GOTO 40                                                     DUM00620
         ENDIF                                                          DUM00630
  30  CONTINUE                                                          DUM00640
C                                                                       DUM00650
C                                                                       DUM00660
  40  BEG=FIRST                                                         DUM00670
	if(first.eq.last) go to 60
      DO 50 I=FIRST+1,LAST                                              DUM00680
         IF(array(i).ne.-30000.) THEN
            END=I                                                       DUM00700
            CALL FILRM2(ARRAY,BEG,END)                                  DUM00710
            BEG=END                                                     DUM00720
         ENDIF                                                          DUM00730
  50  CONTINUE                                                          DUM00740
  60	continue
C                                                                       DUM00750
C                                                                       DUM00760
      RETURN                                                            DUM00770
      end
c
c.............................................................................
	subroutine sdisco(lus,ss,ns,unit)
	dimension ss(*)
	character card*8
	do 5 i = 1,50000
5	ss(i) = 0.0
	do while (1.eq.1)
cmam............read(lus,'(a8,2i8)',end=999) card, loc, istatic
cmam............ss(loc) = float(istatic)/unit
		read(lus,'(a8,i8,f8.1)',end=999) card, loc, xstatic
		ss(loc) = xstatic/unit
    	enddo
999	ns = i-1
	return
	end
c.............................................................................
		subroutine rdisco(lus,rs,nr,unit)
	dimension rs(*)
	character card*8
	do 5 i = 1,50000
5	rs(i) = 0.0
	do while (1.eq.1)
cmam............read(lus,'(a8,2i8)',end=999) card, loc, istatic
cmam............rs(loc) = float(istatic)/unit
		read(lus,'(a8,i8,f8.1)',end=999) card, loc, xstatic
		rs(loc) = xstatic/unit
        enddo
999	nr = i - 1
	return
	end
c
c.............................................................................
        subroutine rdamp(lus,sa,ra)
cmam....added amplitude option......10-26-95
cmam.....this routine reads the amplitude "cards" created by sc3d
        dimension sa(*), ra(*)
        character card*8
cmam......clear arrays before reading into them
        call vclr(sa,1,50000)
        call vclr(ra,1,50000)
        nsa = 0
        nra = 0
        do 10 i = 1,100000
                read(lus,'(a8,i8,e16.8)',end=999) card, loc, xamp
                if(card(1:3).eq.'SHT') then
                  sa(loc) = xamp
                else
                  ra(loc) = xamp
                endif
10      continue
999     continue
        return
        end
