C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : COMTRAND2
C Description : FORMS UP DPSWF'S FROM DPSS (DOUBLE PRECISION)
C Maintainer : A. T. WALDEN
C Version no.: 1
C Date : 17 NOV 1987
C Component class : SUBROUTINE
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: NEEDED BY THOMSPEC TO COMPUTE POWER SPECTRUM 
C  BY AVERAGING OF EIGENSPECTRA.
C 
C--
      SUBROUTINE COMTRAND2(TMP, U, N, NREQ, MFT, J, QFFT, IFAULT)
C
C  CALCULATES DPSWF'S FROM CORRESPONDING DPSS
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  TMP     Real(N)       input    discrete prolate spheroidal sequence
C                                 from which to calculate U
C
C  U       Real(MFT)    output    Fourier transform of TMP (padded with
C                                 zeros if required, including multipli-
C                                 cation by epsilon(k) and time shift, as
C                                 in Thomson(1982).
C
C  N       Integer       input    length of dpss
C
C  NREQ    Integer       input    length of dpss after zero padding
C
C  MFT     Integer       input    (max) number of frequency components
C                                 of Fourier transform: (NREQ/2)+1
C
C  J       Integer       input    chosen dpss; if j=1 then order 0; if
C                                 j=N then order N-1.
C
C  QFFT    Logical       input    if true, use power of 2 FFT
C
C  IFAULT  Integer      output    IFAULT=0 indicates successful completion
C                                 =1 if N < 2 or NREQ < N
C                                 =2 if J > N 
C                                 =3 if REIM (FFT) fails
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
      INTEGER J, I, N, NREQ, IFAIL, IFAULT, N2, MFT, JJ, NJ
      DOUBLE PRECISION TMP(NREQ),
     *  ZERO, HALF, ONE, FOUR, FREQ, PI, FACT
      DOUBLE COMPLEX CEKO1, U(MFT)
      LOGICAL QFFT
C
      DATA ZERO,HALF,ONE,FOUR/0.0D0,0.5D0,1.0D0,4.0D0/
C
      IFAULT=1
      IF(N .LT. 2 .OR. NREQ .LT. N) RETURN
      IFAULT=2
      IF(J .GT. N) RETURN
C
      PI=FOUR*ATAN(ONE)
      FACT=PI*FLOAT(N-1)
C
      IF(MOD(J-1,2) .EQ. 0) THEN
                 CEKO1=CMPLX(ONE,ZERO)
      ELSE
                 CEKO1=CMPLX(ZERO,ONE)
      END IF
C
C  NOW CARRY OUT SUITABLE FFT. 
C
C  NOTE: ALL THE SOFTWARE FOR THOMSON'S METHOD HAS BEEN WRITTEN
C        FOR SINGLETON-COMPATIBLE LENGTHS, I.E., A POWER OF 2 IS
C        NOT A PREREQUISITE. HOWEVER, IF THE GENERAL (SINGLETON)
C        FFT IS TO BE USED, THE SOFTWARE MUST OBVIOUSLY BE AVAILABLE.
C
C        OPTION 1:
C
C        NAG LIBRARY C06EAF CAN BE CALLED BY SUBROUTINE REIM TO
C        ACHIEVE THIS. OPTION 1 IS HERE DISABLED, BUT MAY BE
C        IMPLEMENTED BY REMOVING COMMENTS 'C' AND COMMENTING
C        OUT OPTION 2.
C
C        OPTION 2:
C
C        AN AVAILABLE  POWER OF 2 ALGORITHM CAN BE USED. BUT THEN
C        DATA LENGTH MUST BE A POWER OF 2.
C
C ********************** OPTION 1 ********************************* 
C
C  THE SUBROUTINE REIM TAKES IN THE REAL ARRAY X(.) AND IF QFFT IS
C  TRUE IT CAN CALCULATE THE DFT USING A POWER OF 2 ALGORITHM (OR A 
C  MORE GENERAL ALGORITHM); IF QFFT IS FALSE IT MUST USE A NON-POWER
C  OF 2 ALGORITHM (SUCH AS SINGLETON'S) AND IN THIS CASE CERTAIN
C  VALUES OF NREQ MAY BE EXCLUDED - HENCE THE NEED FOR AN ERROR
C  FLAG, IFAULT. IF IFAULT .EQ. 2 ON RETURN FAILURE INDICATED.
C  THE DFT IS DONE "IN PLACE" AND THE RESULTS RETURNED IN
C  HERMITIAN FORM , I.E., ON RETURN FOR  (0.LE. K .LE. NREQ/2) THE
C  REAL PARTS A(K) ARE EXPECTED IN X(K+1), WHILE FOR (NREQ/2+1 .LE.
C  K. LE. NREQ-1) THE IMAGINARY PARTS B(NREQ-K) ARE EXPECTED IN
C  X(K+1). 
C  NOTE THAT THE ALGORITHM SHOULD BE SUM{ X(J) EXP(-I 2PI JK/NREQ } 
C  WITHOUT ANY SCALING BY NREQ OR SQRT(NREQ) OR ANYTHING ELSE. 
C
C            CALL REIM(TMP,NREQ,QFFT,IFAIL)
C            IFAULT=3
C            IF(IFAIL .NE. 0) RETURN
C
C  NOW PUT THE REAL AND IMAGINARY PARTS INTO THE COMPLEX VARIABLE U
C
C            N2=(NREQ+1)/2
C            U(1)=CMPLX(TMP(1),ZERO)
C            DO 4 JJ=2,N2
C                NJ=NREQ-JJ+2
C  4             U(JJ)=CMPLX( TMP(JJ),TMP(NJ) )
C            IF(MOD(NREQ,2).EQ.0) U(N2+1)=CMPLX( TMP(N2+1),ZERO)
C ******************END OF OPTION 1*******************************
C
C ******************* OPTION 2 ************************************
C
            CALL DFORRT(TMP,NREQ)
C
C  SCALE BY REMOVING DIVIDE BY NREQ
C
            DO 5 J=1,NREQ
  5             TMP(J)=TMP(J)*FLOAT(NREQ)
C
C  NOW PUT THE REAL AND IMAGINARY PARTS INTO THE COMPLEX VARIABLE U
C

            N2=NREQ/2
            U(1)=CMPLX(TMP(1),ZERO)
            DO 4 JJ=2,N2
                NJ=JJ+N2
  4             U(JJ)=CMPLX( TMP(JJ),TMP(NJ) )
            U(N2+1)=CMPLX( TMP(N2+1),ZERO)
C
C ******************* END OF OPTION 2 ******************************
C
C  U IS COMPLEX AT THIS POINT
C  MULTIPLY BY EPSILON(K) AND TIME SHIFT
C
            DO 6 JJ=1,N2
                FREQ=FLOAT(JJ-1)/FLOAT(NREQ)
  6             U(JJ)=CEKO1*EXP(CMPLX(ZERO,FREQ*FACT))*U(JJ)
            IF(MOD(NREQ,2) .EQ. 0) THEN
                FREQ=HALF
                U(N2+1)=CEKO1*EXP(CMPLX(ZERO,FREQ*FACT))*U(N2+1)
            END IF
            IFAULT=0
            RETURN
            END
