C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : CROSS_SPECTRUM_THOM
C Description : THOMSON'S MULTI-TAPER METHOD FOR CROSS-SPECTRA
C Maintainer : A. T. WALDEN
C Version no.: 1
C Date : 11 AUG 1988
C Component class : SUBROUTINE
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C--
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  (i/o) denotes input or output parameter
C
C  IINPAR(8)Integer (i)    special array holding input values:
C     (1)   N      length of dpss
C     (2)   NST    number of traces to process
C     (3)   NDPMAX max number of dpss allowed in calling prog
C     (4)   K0     minimum order for dpss (e.g., 0)
C     (5)   K1     maximum order for dpss (e.g., 5)
C     (6)   K00    minimum order for dpss for initial spectral estimate
C     (7)   K10    maximum order for dpss for initial spectral estimate
C     (8)   NITER  number of refining iterations to perform using weights
C                  (typically 2)
C
C  IXR      Integer (i)     XARR(IXR) is first element of first trace.
C                           IXR .ge. 1.
C
C  LSTEP    Integer (i)     XARR(IXR), XARR(IXR+LSTEP),XARR(IXR+2*LSTEP)
C                           etc are first elements of traces. Clearly,
C                           N .le. LSTEP.
C
C  NMAX     Integer (i)     max permitted size for N (first dim of Z
C
C  NSTMAX   Integer (i)     max number of traces to process (included
C                           only for complete definition of C)
C
C  NREQ     Integer (i)     number of terms for FFT (e.g., 2**p)
C                           or Singleton-compatible length
C
C  NREQMAX  Integer (i)     max permitted size of NREQ (e.g., 4096)
C                           (defines dim of D, Y etc. in calling prog)
C
C  NDPMAX   Integer (i)     max number of dpss allowed in calling
C                           program. This is also in the IINPAR list,
C                           but must be an argument in this subroutine
C                           in order that the dimensions of DSQR is
C                           properly defined.
C
C  NDP      Integer (i)     number of dpss to use
C
C  RNW      Real    (i)     product NW defining dpss
C
C  QMEAN    logical (i)     if true, carry out Thomson's mean
C                           removal; if false simple average is
C                           subtracted from each trace (latter
C                           not recommended)
C
C  QWGTS    logical (i)     if true, weights are automatically computed
C                           a la Thomson; if false each weight set to 
C                           unity. Seems safer for cross-spectrum given 
C                           that Parseval's theorem is not satisfied
C                           for weighting scheme in univariate case.
C                           Lanzerotti et al (1986) use unit weights,
C                           while Thomson (1982, p1089) uses non-unity
C                           weights.
C
C  XARR(.)  Real (i)        Array holding data traces as defined above.
C
C  IND(NMAX)  Integer       workspace
C
C  FV(NMAX,10) Real         workspace
C
C  X(NREQ)  Real            workspace
C  
C  UR((NREQMAX/2)+1,K1-K0+1) real workspace or (o) dpswf in columns, 
C                            at Fourier freq defined by NREQ 
C
C  XIN(N)   Real            workspace
C
C  SS((NREQMAX/2)+1,NST)  real (o)  spectra computed individually
C                                   by Thomson's method for each 
C                                   channel or trace stored in SS
C                                   by the column.
C
C  U((NREQ/2)+1)  complex   workspace
C
C  Y((NREQMAX/2)+1,K1-K0+1) complex workspace
C
C  Z(NMAX,K1-K0+1)  Real  (o)  the dpss of orders K0 to K1 in first 
C                              (K1-K0+1) columns
C
C  RLAM(K1-K0+1)  Real    (o)  the (approximate) eigenvalues corresponding
C                              to dpss orders K0 to K1
C
C  D((NREQMAX/2)+1,K1-K0+1)  real (o) final weights at Fourier freq 
C                                     defined by NREQ, by column for 
C                                     different orders of dpss
C
C  VAR(NST)  Real          (o)   estimated variance for each trace
C
C  DF((NREQ/2)+1)  Real   (o)   estimated degrees of freedom at Fourier
C                               frequencies defined by NREQ
C
C  S((NREQ/2)+1)      real (o)  average spectra using weights over NST
C                               traces or time series
C
C  C(NSTMAX,NSTMAX,(NREQ)/2+1) Real  (o)  Upper triangular elements
C                                           e.g., C(1,1),C(1,2),C(1,3)
C                                are the real parts of the cross-power
C                                spectrum between traces 1,1; 1,2; 1,3
C                                etc. C(1,2,0) is at zero freq., 
C                                C(1,2,NP2/2+1) is at Nyquist. Lower
C                                triangular elements are corresponding
C                                imaginary parts.
C
C  YEIG((NREQMAX/2)+1, NDPMAX, NST) complex  (o) Eigencoefficients.
C                              First index is frequency. Second is 
C                              order of dpss. Third is trace number.
C
C  DSQR((NREQMAX/2)+1, NDPMAX, NST) real (o) Square root of squared
C                              weights in D.
C                              First index is frequency. Second is 
C                              order of dpss. Third is trace number.
C                                  
C  IFAULT     Integer  (o)     if IFAULT =0 then success
C                               1 if N .le. 2 or N .gt. NMAX
C                                 or IXR .lt. 1 or N .gt. LSTEP
C                               2 if NST .le. 0 or NST .gt. NSTMAX
C                               3 if N .gt. NREQ or NREQ .gt. NREQMAX
C                               4 if NDP .lt. 1 or NDP .gt. NDPMAX
C                               5 if K0 .lt. 0 or K1 .lt. K0 or
C                                 K0 .gt. N-1 
C                               6 if K1 .lt. 0 or K1 .gt. N-1
C                               7 if K00 .lt. 0 or K10 .lt. K00 or
C                                 K00 .gt. N-1
C                               8 if K10 .lt. 0 or K10 .gt. N-1
C                               9 if NITER .lt. 0
C                              10 if W .lt. 0 or W .gt. 1/2
C                              11 if failure of TRIDPSSD
C                              12 if failure of EIGVAL
C                              13 if failure of DPSWFA
C                              14 if failure of DMOMENTS
C                              15 if failure of initial THOMLOOP_CROSS
C                              16 if failure in THOMWGTA
C                              17 if failure in subsequent 
C                                 THOMLOOP_CROSS
C
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      SUBROUTINE CROSS_SPECTRUM_THOM( IINPAR, IXR, LSTEP, 
     * RNW, QMEAN, QWGTS, XARR, IND, FV, 
     * X, UR, XIN, SS,  U, Y, Z, RLAM, D, VAR, DF, S, 
     * C, YEIG, DSQR, IFAULT, NF1, ntapr, ngrp)
C
      IMPLICIT NONE
C
      integer NF1, ntapr, ngrp
      INTEGER N, NMAX, NST, NREQ, NREQMAX, K0, K1, K00, K10, 
     * K, KK, NDP, NL, NN, KSPICER, JR, I, NITER, ITER, 
     * LST, IXR, LSTEP, LIN, LL, J, KK0, KK1,
     * IFAULT, MITS, IFAULT1, IFAULT2, IFAULT3,
     * IFAULT4, IFAULT5, IFAULT6, IFAULT7
C
      INTEGER IND(LSTEP), IINPAR(8)
c     INTEGER IND(1000), IINPAR(8)
C
      DOUBLE PRECISION RNW, W, ZERO, ONE, TWO, XX, S1, S2, S3, S4, 
     * SUMSQRT , HALF, DKS2, DF1, WM, FKK, DSQRW
C
      DOUBLE PRECISION 
     * FV(LSTEP,12), Z(LSTEP,ntapr), RLAM(ntapr),
     * X(2*NF1), UR(NF1,ntapr), D(NF1,ntapr),
     * XIN(LSTEP), S(NF1),
     * SS(NF1,ngrp), DF(NF1), 
     * VAR(ngrp), XARR(ngrp*LSTEP),
     * DSQR(NF1, ntapr, ngrp),
     * C(ngrp, ngrp, NF1)
 
      DOUBLE COMPLEX U(NF1), Y(NF1,ntapr),
     * YEIG(NF1,ntapr,ngrp), ATERM, BTERM, SUMTAP

c     DOUBLE PRECISION
c    * FV(1000,10), Z(1000,21), RLAM(21),
c    * X(1024), UR(513,21), D(513,21),
c    * XIN(1000), S(513),
c    * SS(513,12), DF(513),
c    * VAR(12), XARR(12000),
c    * DSQR(513, 21, 12),
c    * C(4, 4, 513)
c     DOUBLE COMPLEX U(513), Y(513,21),
c    * YEIG(513,21,12), ATERM, BTERM, SUMTAP

      LOGICAL QMEAN, PAD, QFFT, QWGTS
C
      DATA ZERO, HALF, ONE, TWO/0.0D0, 0.5D0, 1.0D0, 2.0D0/
C
C EXTRACT INTEGER PARAMETERS FROM IINPAR
C
C NOTE NDPMAX OR IINPAR(3) IS A PARAMETER AND HAS BEEN PASSED 
C  AS AN ARGUMENT
C
c     write (0,*) ' inside CROSS_SPECTRUM_THOM'

c     write(0,*)'NF1,LSTEP,ntapr,ngrp= ',NF1,LSTEP,ntapr,ngrp
      N    = IINPAR(1)
      NST  = IINPAR(2)
      K0   = IINPAR(4)
      K1   = IINPAR(5)
      K00  = IINPAR(6)
      K10  = IINPAR(7)
      NITER= IINPAR(8)

c  -- got ride of hard wired junk
c     NMAX=1000
c     NREQMAX=1024
      NMAX    = LSTEP
      NREQMAX = 2 * (NF1-1)
      NREQ    = NREQMAX
 
c     write(0,*)'LSTEP,NST,NREQ,NDP,IXR= ',LSTEP,NST,NREQ,NDP,IXR
c     write(0,*)'N,NST,K0,K1,K00,K10,NITER= ',
c    1N,NST,K0,K1,K00,K10,NITER

C NOW CHECK THAT PARAMETER VALUES ARE SENSIBLE
 
      IFAULT=1
      IF(N .LE. 2 .OR. N .GT. NMAX .OR. IXR .LT. 1 .OR. 
     * N .GT. LSTEP) RETURN
      IFAULT=2
      IF(NST .LE. 2 ) RETURN
      IFAULT=3
c???  IF(N .GT. NREQ .OR. NREQ .GT. NREQMAX) RETURN
      IFAULT=4
c???  IF(NDP .LT. 1 .OR. NDP .GT. 21) RETURN
      IFAULT=5
      IF(K0 .LT. 0 .OR. K1. LT. K0 .OR. K0 .GT. N-1) return
      IFAULT=6
      IF(K1 .LT. 0 .OR. K1 .GT. N-1) RETURN
      IFAULT=7
      IF(K00 .LT. 0 .OR. K10. LT. K00 .OR. K00 .GT. N-1) return
      IFAULT=8
      IF(K10 .LT. 0 .OR. K10 .GT. N-1) RETURN
      IFAULT=9
      IF(NITER .LT. 0) RETURN
C
      MITS=5
      IFAULT=10
      W=RNW/FLOAT(N) ! THOMSON TENDS TO USE NW=4
      IF(W .LT. 0. OR. W. GT. HALF) RETURN
c     write (0,*) ' calling TRIDPSSD'
c     write(0,*)'N,NMAX,K0,K1,W= ',N,NMAX,K0,K1,W
      CALL TRIDPSSD(N,NMAX,W,K0,K1,FV,MITS,IND,Z,IFAULT1)
      IFAULT=11
      IF(IFAULT1 .NE. 0) RETURN
C
C  DETERMINE CORRESPONDING EIGENVALUES
C
c     write (0,*) ' calling EIGVAL:N,NMAX,K0,K1= ',N,NMAX,K0,K1

      CALL EIGVAL(N, NMAX, K0, K1, W, Z, RLAM, IFAULT2)
      IFAULT=12
      IF(IFAULT2 .NE. 0) RETURN
C
      NL=(NREQ/2)+1
c     write(0,*)'NL= ',NL
C
      IF(QMEAN) THEN
C
C  THE SELECTION OF THOMSON'S METHOD OF CORRECTING FOR THE MEAN
C  REQUIRES THAT THE DPSWF'S (UR) ARE FOUND
C
c     write (0,*) ' calling DPSWFA: N,NMAX,NREQMAX= ',N,NMAX,NREQMAX
          CALL DPSWFA(N, NMAX, NREQ, NREQMAX, K0, K1, Z, X, 
     * U, UR, PAD, QFFT, IFAULT3) 
          IFAULT=13
          IF(IFAULT3 .NE. 0) RETURN
      END IF
C
C  INITIALIZE WEIGHT MATRIX WITH NON-UNITY OR UNITY WEIGHTS
C
      KK=(K1-K0+1)
      FKK=FLOAT(KK)
      DO 150 K=1,KK
           DO 155 I=1,NL
155          D(I,K)= RLAM(K) ! INITIAL STANDARD. SQUARED WEIGHTS
150   CONTINUE
C
C FIND SUM OF EIGENVALUES TO STANDARDIZE SQUARED WEIGHTS (NOTE THE ROOT
C OF THE EIGENVALUE IS THE WEIGHT)
C
      IF( QWGTS ) THEN
        DF1=ZERO
        DKS2=ZERO
        DO 160 K=1,KK
           DF1=DF1+RLAM(K)*RLAM(K)
160        DKS2=DKS2+RLAM(K)
        DO 165 K=1,KK
          DO 170 I=1,NL
            DF(I)=TWO*DKS2*DKS2/DF1
170         D(I,K)=D(I,K)/DKS2
165     CONTINUE
      ELSE
        DO 166 K=1,KK
          DO 171 I=1,NL
             DF(I)=TWO*FKK
171          D(I,K)=ONE/FKK      ! STANDARDIZED UNITY WEIGHTS 
166     CONTINUE
      END IF
C
C  WE HAVE NOW SET UP EVERYTHING TO DO WITH THE TAPERS ALONE. NOW
C  START USING THE DATA.
C
C  LOOP OVER TRACES:
C
      DO 70 JR=1, NST
           DO 5 I=1,N
               LST=IXR+(JR-1)*LSTEP
  5            XIN(I)=XARR(LST+I-1)
C
C  FIND VARIANCE OF EACH DATA TRACE
C
           NN=0 ! SET NUMBER OF TERMS COUNTER TO ZERO
           KSPICER=2 ! ONLY SUM OF SQUARES REQUIRED
             DO 115 I=1,N
              XX=XIN(I)
c     write (0,*) ' calling DMOMENTS'
115           CALL DMOMENTS(XX,KSPICER,NN,S1,S2,S3,S4,IFAULT4)
           IFAULT=14
           IF(IFAULT4 .NE. 0) RETURN
C
C S2 CONTAINS THE SUM OF SQS COMPUTED FROM THE POINTS IN ALL THE TRACES
C
           VAR(JR)=S2/FLOAT(NN) ! SUM OF SQS OVER ALL TRACES / TOTAL NO TERMS
C
C  MAIN CALCULATIONS CARRIED OUT HERE.
C
C  THOMLOOPA DOES THE FOLLOWING:
C
C  (1) COMPUTES THE EIGENCOEFFICIENTS (WITH OR WITHOUT MEAN REMOVED BY
C      STANDARD METHOD). SUBROUTINE EIGENCOEFF.
C  (2) IF THOMSON MEAN REMOVAL TO BE USED, CALCULATES THOMSON'S MU
C      IN SUBROUTINE DJTMEANA.
C  (3) COMPUTES WEIGHTED SUM OF EIGENSPECTRA, WITH REMOVAL OF
C      MEAN BY THOMSON'S METHOD IF REQUESTED. SUBROUTINE SPECONA.
C      THESE EIGENSPECTRA ARE THEN AVERAGED OVER TRACES.
C
C
C  FIRST USE ONLY TAPERS K00 TO K01 TO OBTAIN PRELIM VERSION OF 
C  SPECTRUM.
C
C
C  USE SAME WEIGHTS FOR ALL CHANNELS INITIALLY
C

C
C  IF QWGTS TRUE, THEN THE FOLLOWING CALL TO THOMLOOP_CROSS ONLY
C  PROVIDES PRELIM ESTIMATES AND HENCE WE USE ONLY THE RESTRICTED
C  RANGE FOR K, K=K00,K10.
C
C  IF QWGTS FALSE, THEN THE CALL PROVIDES FINAL ESTIMATES AND HENCE
C  WE USE THE FULL RANGE FOR K, K=K0,K1.
C
           IF( QWGTS ) THEN
               KK0=K00
               KK1=K10
           ELSE
               KK0=K0
               KK1=K1
           END IF
C
c     write (0,*) ' calling THOMLOOP_CROSS'
           CALL THOMLOOP_CROSS(N, NMAX, NREQ, NREQMAX, KK0, KK1, Z, 
     *        X, XIN, Y, UR, D, S, QMEAN, IFAULT5) 
           IFAULT=15
           IF(IFAULT5 .NE. 0) RETURN
C
C  STORE SPECTRUM FOR CHANNEL JR
C
           DO 10 I=1,NL
 10          SS(I,JR)=S(I)
C
C  IF UNIT WEIGHTS USED ESTIMATION IS COMPLETE (I.E. NO ITERATION
C  OVER WEIGHTS):
C
           IF( .NOT. QWGTS ) THEN
C
C  COPY EIGENCOEFFICIENTS TO ARRAY TO BE SAVED
C
             DO 2 J=1,KK
               DO 1 I=1,NL
                 YEIG(I,J,JR)=Y(I,J)    ! DOUBLE COMPLEX
  1            CONTINUE
  2          CONTINUE
           END IF
 70   CONTINUE
C
C  ITERATE TO OBTAIN WEIGHTS
C
      IF( QWGTS ) THEN
         DO 200 ITER=1, NITER
C
C SS(.) CONTAINS PRELIM ESTIMATE OF SPECTRA.
C
            DO 25 JR=1,NST
                LST=IXR+(JR-1)*LSTEP
C
C NOW COMPUTE THOMSON WEIGHTS (ASSUMING MY VERSION CORRECT!)
C
C  COMPUTE WEIGHT MATRIX, D
C
c     write (0,*) ' calling THOMWGTA'
                CALL THOMWGTA(N, NREQ, NREQMAX, K0, K1, RLAM,
     *          SS(1,JR), VAR(JR), D, DF, IFAULT6)
                IFAULT=16
                IF(IFAULT6 .NE. 0) RETURN
                DO 22 I=1,N
 22                XIN(I)=XARR(LST+I-1)
C
C  REPEAT SPECTRAL ESTIMATION USING ALL TAPERS K0 TO K1 WITH WEIGHTS
C
c     write (0,*) ' calling THOMLOOP_CROSS'
                CALL THOMLOOP_CROSS(N, NMAX, NREQ, NREQMAX, 
     *        K0, K1, Z, X, XIN, Y, UR, D, S, QMEAN, IFAULT7)
                IFAULT=17
                IF(IFAULT7 .NE. 0) RETURN
                DO 30 I=1,NL
 30               SS(I,JR)=S(I)
C
C  IF ITER=NITER KEEP RESULTS
C
                IF(ITER .EQ. NITER) THEN
                 DO 32 J=1,KK
                   DO 31 I=1,NL
                      YEIG(I,J,JR)=Y(I,J)
                      DSQR(I,J,JR)=SQRT(D(I,J))
 31                CONTINUE
 32              CONTINUE
                END IF
 25         CONTINUE      
200      CONTINUE
      END IF
C
C  HAVE NOW LOOPED OVER ALL TRACES AND CALCULATED THEIR EIGENCOEFFICIENTS
C  NOW WE COMBINE THEM PAIRWISE:
C
      DO 270 JR=1, NST
C
C  AUTOSPECTRA FIRST:
C  SUM OVER TAPERS FOR TRACE JR
C
        DO 275 I=1,NL
          C(JR,JR,I)=SS(I,JR)
275     CONTINUE
C
C  NOW FOR CROSS SPECTRA
C
          IF(JR .EQ. NST) THEN
                        IFAULT =0
                        RETURN ! FINISHED
          END IF
          LIN=JR+1
        IF( QWGTS ) THEN
C
          DO 290 LL=LIN, NST
            DO 375 I=1,NL
              SUMTAP=ZERO
              DO 380 J=1,KK
C
C  WORK OUT PRODUCT OF JR WEIGHTED EIGENCOEFFICIENT WITH LL CONJUGATE
C  WEIGHTE EIGENCOEFFICIENT
C
                  ATERM= DSQR(I,J,JR)*YEIG(I,J,JR)
                  BTERM= DSQR(I,J,LL)*CONJG(YEIG(I,J,LL))  
380           SUMTAP=SUMTAP+ ATERM*BTERM
C
C  NOW TRANSFER REAL PART OF RESULT TO UPPER TRIANGLE
C
                  C(JR,LL,I)=DREAL(SUMTAP)
                  C(LL,JR,I)=DIMAG(SUMTAP)
375         CONTINUE
290       CONTINUE
      ELSE  ! UNITY WEIGHTS
C
        DSQRW=ONE/FKK
        DO 390 LL=LIN, NST
          DO 475 I=1,NL
            SUMTAP=ZERO
            DO 480 J=1,KK
                  ATERM= YEIG(I,J,JR)
                  BTERM= CONJG(YEIG(I,J,LL))  
480         SUMTAP=SUMTAP+ CMPLX(DSQRW,ZERO)*ATERM*BTERM
C
C  NOW TRANSFER REAL PART OF RESULT TO UPPER TRIANGLE
C
                  C(JR,LL,I)=DREAL(SUMTAP)
                  C(LL,JR,I)=DIMAG(SUMTAP)
475       CONTINUE
390     CONTINUE
      END IF
C
270   CONTINUE
      END
