C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : EIGENCOEFF
C Description : COMPUTES EIGENCOEFFS USING THOMSON'S (1982) METHOD
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 17 NOV 1987
C Component class : SUBROUTINE
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information: CALCS EIGENCOEFFS FROM THOMSON'S METHOD
C 
C--
      SUBROUTINE EIGENCOEFF(N, NMAX, NREQ, NREQMAX, K0, K1, Z, X, Y, 
     *  XIN, QMEAN, IFAULT)
C
C  THIS SUBROUTINE COMPUTES EIGENCOEFFICIENTS.
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N       Integer      input    length of dpss sequence
C
C  NMAX      Integer      input    size of first dim of Z in the
C                                calling program; max value of N
C
C  NREQ    Integer      input   power of 2 or alternative Singleton-
C                               factorable length for FFT
C
C  NREQMAX Integer      input   max length of FFT permitted (defines
C                               first dim of Y in calling prog)
C
C  K0      Integer      input    minimum order for dpss (e.g., 0)
C
C  K1      Integer      input    maximum order for dpss (e.g., 5)
C                                (averages dpss orders 0 to 5)
C  
C  Z(NMAX,K1-K0+1) Real   input    the dpss of orders K0 to K1 in first
C                                K1-K0+1 columns
C
C  X(NREQ) Real         workspace
C
C  Y((NREQMAX/2)+1,K1-K0+1)  Complex  output   columns are eigencoeffs
C                                pertaining to dpss orders K0 to K1 .
C                                Fourier freqs defined by NREQ.
C
C  XIN(N)  Real         input    input time series
C
C  QMEAN   Logical      input    if false, mean was formerly removed by
C                                standard method (ie straight subtraction)
C                                but as this is not a good idea, this has
C                                been disabled. So no action.
C                                if true, no action
C
C  IFAULT  Integer      output   if IFAULT=0 then success
C                                =1 if NREQ<N or N<2
C                                =2 if K0<0 or K1>N-1
C                                =3 if failure in PADP2
C                                =4 if failure in COMTRAND2
C
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
C
      INTEGER N, NMAX, NREQ, K0, K1, K, J, MFT, KL, KU, N2, JJ, IF0,
     * IFAULT, IF1, I, NREQMAX
C
      DOUBLE COMPLEX  Y((NREQMAX/2)+1,K1-K0+1)
C
      DOUBLE PRECISION Z(NMAX,K1-K0+1), ZERO, XIN(N), DAVE, X(NREQ)
C
      LOGICAL PAD, QFFT, QMEAN, PCH, P2CH
C
      DATA ZERO/0.0D0/      
C
      IFAULT=1
      IF(NMAX .LT. N .OR. N .LT. 2) RETURN
      IFAULT=2
      IF(K0 .LT. 0 .OR. K1 .GT. N-1) RETURN
      N2=(NREQ+1)/2
C
C  MAXIMUM NUMBER OF FREQUENCIES FOR DISCRETE FOURIER TRANSFORM INVOLVING
C  NREQ POINTS. IF NREQ IS ODD, E.G. 7 THEN THERE ARE FOUR REAL PARTS
C  AND THREE IMAGINARY PARTS. IF NREQ IS EVEN, E.G. 8, THEN THERE ARE FIVE
C  REAL PARTS AND THREE IMAGINARY PARTS.
C
      MFT=(NREQ/2)+1
      KL=K0+1
      KU=K1+1
C
C  TOTAL NUMBER OF EIGENCOEFFS:
C
      K=KU-KL+1
C
C  CALCULATE EIGENCOEFFS
C
      DO 5 J=1,K
C           IF(.NOT. QMEAN) THEN
C
C  STANDARD MEAN REMOVAL (DON'T USE IN PRACTICE!! FOR RESEARCH ONLY)
C  THIS OPTION NOW DISABLED.
C                   DAVE=ZERO
C                   DO 9 I=1,N
C  9                  DAVE=DAVE+XIN(I) ! SUM TAPERED DATA VALUES
C                   DAVE=DAVE/FLOAT(N)
C                   DO 12 I=1,N
C 12                  XIN(I)= XIN(I)-DAVE
C           END IF
C
C  NOW APPLY DATA TAPER IN Z(.) TO TIME SERIES XIN(.)
C
          DO 10 I=1,N
 10            X(I)= XIN(I)*Z(I,J) 

C
C  FOURIER TRANSFORM TAPERED TIME SERIES, APPLY EPSILON(K) AND
C  TIME SHIFT TO OBTAIN Y()(F)
C
          PCH=.TRUE.
          P2CH=.TRUE.
          CALL PADP2(N, NREQ, X, PCH, PAD, P2CH, QFFT, IF0) 
          IFAULT=3
          IF(IF0 .NE. 0) RETURN
C
          CALL COMTRAND2(X,Y(1,J),N,NREQ,MFT,KL+J-1,QFFT,IF1)
          IFAULT=4
          IF(IF1 .NE. 0) RETURN
C
  5    CONTINUE
      IFAULT=0
      RETURN
      END
