C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : PADP2
C Description : PADS WITH ZEROS AND CHECKS WHETHER A POWER OF 2
C Maintainer : A.T. WALDEN
C Version no.: 1
C Date : 3 DEC 1987
C Component class : SUBROUTINE 
C Source location : 
C Object location : 
C Documentation location : 
C Category : 
C
C 
C Additional information:
C 
C--
      SUBROUTINE PADP2(N, NREQ, X, PCH, PAD, P2CH, QFFT, IFAULT)
C
C  PADS WITH ZEROS IF REQUIRED, AND INDICATES SUCH ACTION WITH 
C  THE LOGICAL 'PAD'.
C
C  DECIDES WHETHER A POWER OF 2, AND INDICATES WITH THE LOGICAL
C  'QFFT'.
C
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
C  N         Integer   input      length of sequence when unpadded
C
C  NREQ      Integer   input      length of sequence after padding
C
C  X         Real      input      first N values are input time series
C                     output      first NREQ values are output time
C                                 series with zero padding if requested
C
C  PCH       Logical   input      if true, pads with zeros if NREQ>N
C                                 and sets PAD=true; otherwise no effect
C
C  PAD       Logical  output      if true, data has been padded with zeros
C
C  P2CH      Logical   input      if true, see if NREQ is a power of 2,
C                                 and if it is set QFFT=true; otherwise
C                                 no effect
C
C  QFFT      Logical  output      if true, required length NREQ has been
C                                 found to be a power of 2.
C
C  IFAULT    Integer  output      0: indicates successful completion
C                                 1: NREQ < N or NREQ < 0 or N < 0
C
C  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      IMPLICIT NONE
      INTEGER IFAULT, NREQ, N, J, K
      LOGICAL PCH, PAD, P2CH, QFFT
      DOUBLE PRECISION X(NREQ), ZERO, TWO, HALF, RNREQ
      DATA ZERO, HALF, TWO/0.0D0, 0.5D0, 2.0D0/
C
      IFAULT=1
      IF(NREQ .LT. N .OR. NREQ .LE. 0 .OR. N .LE. 0) RETURN
C
C  ONLY CHECK AND DO ZERO PADDING IF REQUIRED
C
      IF( PCH ) THEN
         IF(NREQ .GT. N) THEN
                     PAD=.TRUE.
                     DO 5 J=N+1,NREQ
  5                    X(J)=ZERO
         ELSE
                     PAD=.FALSE.
         END IF
      END IF
C
C  SEE IF NREQ=2**K IF REQUIRED
C
      IF( P2CH ) THEN
        RNREQ=FLOAT(NREQ)
        K=DLOG(RNREQ)/DLOG(TWO)+HALF
        IF(NREQ .EQ. 2**K) THEN
             QFFT=.TRUE.
        ELSE
             QFFT=.FALSE.
        END IF
      END IF
C
      IFAULT=0
      RETURN
      END
