C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C++
C Component name : GL_RSTR
C Description : Transform from frequency domain into time series 
C Maintainer : S. DEREGOWSKI
C Version no.: 1
C Date : 1978
C Component class : SUBROUTINE
C Source location : GEOLIB:[GEOLIB.GL_LIB]
C Object location : GEOLIB:[GEOLIB]GL_LIB
C Documentation location : GRBS$DISK:[GEOLIB.TEXT.FFT]FFTPAK.TXT
C Category : FFT
C
C 
C Additional information:
C
C INPUT     N   -   transform window length in samples
C           KG  -   INTEGER output from GL_STWI
C           IR  -   ARRAY containing sin/cosine tables, output from GL_STWI
C           W2  -   ARRAY containing sin/cosine tables, output from GL_STWI
C           C1  -   ARRAY - Real part of tranformed array
C	    C2  -   ARRAY - Imaginary part of transformed array
C 
C OUTPUT    C1  -   ARRAY - first half of series.
C           C2  -   ARRAY - second half of series.
C          
C WORK      D   -   ARRAY of size N/2
C--

       SUBROUTINE RSTR(N1,KG,IR,W2,C1,C2)
       DIMENSION  IR(*),W2(*),C1(*),C2(*),D(513)
       N=N1-1
       XN=FLOAT(N+N)
       DO I = 1, N1

         C1(I) = C1(I)/XN 
         C2(I) = C2(I)/XN 

       ENDDO

       CALL RSTR1(N,KG,IR,W2,C1,C2,D)

       RETURN
       END
