C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SMAINCH(A,B,C,D,N,JERR,ISING,
     1                   AD,BD,CD,DD)
C      INVERSION OF COMPLEX HERMITIAN MATRIX BY ESCALATOR METHOD
C      A,B ARE RE ,IM PARTS OF I/P MATRIX. C,D THOSE OF INVERSE
C      JERR - ERROR FLAG IF JERR=1 THE COMPLETE MATRIX IS PRINTED IF
C      IT IS DETERMINED AS SINGULAR, NO PRINT IF JERR .NE. 1.
C      ISING - EVERY TIME A SINGULAR MATRIX IS DETERMINED ISING IS 
C      INCREMENTED BY 1.
C      IF THE INPUT MATRIX IS DETERMINED TO BE SINGULAR THEN THE REAL 
C      DIAGONAL ELEMENTS ARE INCREASED BY 0.1% AND THE INVERSION REPEATED
C      IF NO NON-SINGULAR MATRIX IS DETERMINED AFTER 10 SUCH INCREASES
C      WE GIVE UP. Double precision needed!
C
#include <f77/iounit.h>

      DIMENSION A(N,N),B(N,N),C(N,N),D(N,N)
      DOUBLE PRECISION AD(N,N),BD(N,N),CD(N,N),DD(N,N)
      DOUBLE PRECISION EK,EZERO	
c     ILP = 6
      JERR = 0
      KNTSIN = 0
   60 DO 5 I=1,N
       DO 5 J=1,N
        CD(I,J)=0.0D0
        DD(I,J)=0.0D0
	AD(I,J)=DBLE(A(I,J))
	BD(I,J)=DBLE(B(I,J))
    5 CONTINUE 
      CD(1,1)=1.0/AD(1,1)
      DD(1,1)=0.0D0
      IF(N-1)41,41,11
   11 DO 40 M=2,N
      K=M-1
      EK=AD(M,M)
      EZERO = EK**4
      EZERO = EZERO*0.000001		
      DO 10 I=1,K
      DO 10 J=1,K
      EK=EK-AD(M,I)*(CD(I,J)*AD(J,M)-DD(I,J)*BD(J,M))
      EK=EK+BD(M,I)*(DD(I,J)*AD(J,M)+CD(I,J)*BD(J,M))
   10 CONTINUE
      IF(EK.GT. EZERO)GOTO 12
      ISING = ISING + 1
      IF (JERR .NE. 1)GOTO 50
      WRITE(LERR,98)FK,K
      WRITE(LERR,98)EK,M
      WRITE(LERR,99)((AD(I,J),I=1,N),J=1,N)
      WRITE(LERR,99)((BD(I,J),I=1,N),J=1,N)
   50 DO 13 I=1,N
       A(I,I) = A(I,I)*1.001
   13 CONTINUE
c     JERR = 1
      KNTSIN = KNTSIN + 1
      IF (KNTSIN .GT. 10)GOTO 41
      GOTO 60
   98 FORMAT(22H MATRIX SINGULAR   EK=,E12.4,6H    M=,I2)
   99 FORMAT(1X,6E12.4)
C
C	MATRIX NOT SINGULAR
C
   12 CD(M,M)=1.0D0/EK
      FK=EK
      DD(M,M)=0.0
      DO 30 I=1,K
      DO 20 J=1,K
      CD(I,M)=CD(I,M)-(CD(I,J)*AD(J,M)-DD(I,J)*BD(J,M))/EK
      DD(I,M)=DD(I,M)-(DD(I,J)*AD(J,M)+CD(I,J)*BD(J,M))/EK
   20 CONTINUE
      CD(M,I)=CD(I,M)
   30 DD(M,I)=-DD(I,M)
      DO 40 I=1,K
      DO 40 J=1,K
      CD(I,J)=CD(I,J)+(CD(I,M)*CD(M,J)-DD(I,M)*DD(M,J))*EK
      DD(I,J)=DD(I,J)+(DD(I,M)*CD(M,J)+CD(I,M)*DD(M,J))*EK
   40 CONTINUE
	DO I=1,N
		DO J=1,N
			C(I,J)=SNGL(CD(I,J))
			D(I,J)=SNGL(DD(I,J))
		ENDDO
	ENDDO
   41 RETURN
      END
