C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	SUBROUTINE SSERB(NTA,ESS,ASP,ANP,II,SUL,SLL)
C	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C	Subroutine used by SANE to calculate error bars on the signal
C	using the formula
C	 SE(S)/S = SQRT[(1 + 2/mp(f))/n]    
C	Where
C	  m=number of traces =NTA,  p(f)=ASP(f)/ANP(f)=S/N at freq f.
C	  n=spectral smoothing factor = ESS
C	SUL and SLL are the signal+SE and signal-SE.
C	If the signal power is 0, the upper and lower limits are both 
C	set to 10**-30 
C	---------------------------------------------------------------
	DIMENSION ASP(II),ANP(II),SUL(II),SLL(II)
	SM1=1./ESS
	SNA=2./FLOAT(NTA)
	DO J=1,II
	IF(ASP(J).GT.0.)THEN
		SEA=1.+SNA*ANP(J)/ASP(J)
		SE=SQRT(SM1*SEA)
		SUL(J)=ASP(J)*(1.+SE)
		SLL(J)=ASP(J)*(1.-SE)
		ELSE
		SUL(J)=1.0E-30
		SLL(J)=1.0E-30
		ENDIF
	ENDDO
	RETURN
	END
