C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SSMPH(IUW,LW,SI,ESP,II,FI,WFIL_PREFIX,
     1                 TITLE,WCOMM,NDOF,DOF,FAPPLY,xtr,luwav,irec)
#include <f77/iounit.h>
c     SUBROUTINE SSMPH(IUW,IW,LW,SI,ESP,II,FI,WFIL_PREFIX,
c    1                 TITLE,WCOMM,NOW,DOF,FAPPLY)
C     ...Calculation of minimum-phase wavelet given energy spectrum
C      .. IF FI=FREQY INCREMENT, SI=SAMPLE INTERVAL
C       NYQUIST FREQY=XN*FI/2 , XN=2**N2POW ,N2POW=POWER OF 2 FOR F.F.T
C      I/P ESP= ENERGY SPECTRUM   O/P W=MIN-PHASE WAVELET LENGTH 1.25*LW
C	(Plotted wavelets length LW = Max lag Papoulis window)
C	Can handle more than 1 drop-off parameter DF
C : : Outputs the wavelet(s) to a wavelet file on unit IUW starting at position
C	IW.  TITLE is the wavelet title/run identifier used by SANE; the value
C	of DF will be written in the comment line, as will a
C	character string containing info on the i/p seismic data
c       NDOF -- number wavelets:  DOF(1,...,NDOF)
C
      real  xtr(2*LW)
      integer luwav, irec
c     DIMENSION A(513),D(513),ESP(513),Y(513),P(513),W(512)
c     DIMENSION RAN(257),IR(513),W2(257),E(513),DP(513)
c     DIMENSION CC(771),WW(771),DD(2),V(5),Q(513)
      DIMENSION ESP(II), DD(2), V(5)
      integer   IR
      real  A, D, Y, P, W, RAN, W2, E, DP, CC, WW, Q
      pointer (wkA, A(1))
      pointer (wkD, D(1))
      pointer (wkY, Y(1))
      pointer (wkP, P(1))
      pointer (wkW, W(1))
      pointer (wkRAN, RAN(1))
      pointer (wkIR, IR(1))
      pointer (wkW2, W2(1))
      pointer (wkE, E(1))
      pointer (wkDP, DP(1))
      pointer (wkCC, CC(1))
      pointer (wkWW, WW(1))
      pointer (wkQ, Q(1))
      integer   jsz, ierr, ierrt, abort
	CHARACTER*50 TITLE
	CHARACTER*1 U
	CHARACTER*70 WCOMM(3)
        CHARACTER*(*) WFIL_PREFIX
        CHARACTER*2 WFIL_SUFFIX(10)
c	COMMON/SANE_WWR/WCOMM
      data      ierr/0/, ierrt/0/, abort/0/
C
C : : FORMAT STATEMENTS.
C
  700 FORMAT(1H1)
  701 FORMAT(/,10X,'****MINIMUM PHASE WAVELET(S) BY HILBERT TRANSFORM')
  702 FORMAT(/,5X,'Low frequency drop-off = ',F4.1,'dB/Oct',/,5X,
     1'Applied below',F6.2,'Hz',/,5X,'Wavelet output to position',I3,/)
 277 	FORMAT ('  WAVELET WRITE FAILED, STATUS=',I4,' UNIT =',I4)
	WCOMM(3)(1:52)='Minimum phase wvlt from SANE : low freq. drop
     1-off = '

      IW = 1
C
C	READ IN DROP-OFF'S AND FREQ BELOW WHICH THEY APPLY
C
	LWO=5*LW/4+1
	IF(FAPPLY.LT.0.1)FAPPLY=8.
c---
c  II = NF+1
c---
      II2 = 2 * II
      NH=II-1
      N1=II
      N=2*NH
      XN=N
      N2=N+2
	FNQ=XN*FI/2.

      call sizefloat(jsz)
c     DIMENSION A(513),D(513),ESP(513),Y(513),P(513),W(512)
c     DIMENSION RAN(257),IR(513),W2(257),E(513),DP(513)
c     DIMENSION CC(771),WW(771),DD(2),V(5),Q(513)

c  N is the natural power of 2 of the FT
c  dimension up by factor of 4 since 512/N (the interp factor)
c  might be as high as 4

      call galloc (wkA, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkD, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkY, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkP, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkW, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkRAN, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkIR, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkW2, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkE, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkDP, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkQ, 4*jsz*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkCC, 4*jsz*3*(N+1), ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkWW, 4*jsz*3*(N+1), ierr, abort)
      ierrt = ierrt + ierr

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from wavest:'
         write(LERR,*)'Unable to allocate memory in routine ssmph'
         write(LER ,*)'FATAL ERROR from wavest:'
         write(LER ,*)'Unable to allocate memory in routine ssmph'
         call ccexit (666)
      endif
C
C	PERFORM SPECTRAL ALTERATIONS COMMON TO ALL DOF'S
C	INCLUDING INTERPOLATION
C
      SMPR=0.0
      PMIN=1.0E+06
	DO J=1,II
        SMPR=SMPR+ESP(J)
	IF(ESP(J).GT.0.0.AND.ESP(J).LT.PMIN)PMIN=ESP(J)
	ENDDO
      SMPR=2.0*SMPR-ESP(1)-ESP(N1)			!Total power
      SWS=SMPR/XN		
      SDP=0.3*PMIN
      SMPR=0.0
C
C	"WHITEN" LOW POWER - ASSUME ONLY AT DC AND HI FREQ
C
      DO I=2,N1
      IF(ESP(I).LT.SDP)THEN
			SDP=SDP/1.1
      			ESP(I)=SDP
			ENDIF
  	SMPR=SMPR+ESP(I)
	ENDDO
      SMPR=2.0*SMPR+ESP(1)-ESP(N1)
C
C      NORMALISE POWER TO SAME LEVEL AS INPUT WAVELET
C
      PNORM=SWS*XN/SMPR
      DO I = 1,N1
      ESP(I)= ESP(I)*PNORM
      ENDDO
C
C      SMOOTH POWER SPECTRUM NEAR D.C. IF ALMOST ZERO
C
      IF(ESP(2).LT.SDP)ESP(2)=SDP
      IF(ESP(3).LT.SDP)ESP(3)=SDP
      A(2)=0.5*ALOG(ESP(2))
      A(3)=0.5*ALOG(ESP(3))
      PRF=1.4427*(A(3)-A(2))
C
C	SET UP WORKING ARRAY P WITH ENERGY SPECTRUM
C
	DO J=1,II
	P(J)=ESP(J)
	ENDDO
C
C      AVOID PUTTING TOO SMALL A VALUE OF P(1) INTO SPLINE INTERPOLATION
C      IN ORDER TO GET SMOOTH SPECTRUM AROUND P(2) AND P(3) - NO
C      OVERSHOOT/UNDERSHOOT OSCILLATION
C
       EST=A(2)-1.64792*PRF
      IF(PRF.LT.0.0) EST=A(2)+1.64792*PRF
      EST=EXP(2.0*EST)
C
C      REMOVE ANY ABNORMAL DC VALUE
C
      IF(P(1).GT.P(2))P(1)=EST
      IF(P(1).GE.EST)GO TO 100
      P(1)=EST
 100  CONTINUE
      IF(P(1).LE.0.0)P(1)=SDP
      DO I=1,N1
      Q(I)=ALOG(P(I))
      RAN(I)=FLOAT(I-1)
	ENDDO
      JDER=1
      DD(1)=0.0
      DD(2)=0.0
      CALL SPLN1(N1,RAN,Q,JDER,DD,CC,WW)
      N1IN=N1
      INTERP=512/N
c     write(0,*)'N,N1IN,INTERP= ',N,N1IN,INTERP
      if (INTERP .lt. 1) INTERP = 1
      IF (INTERP .GT. 4) INTERP = 4
      N=INTERP*N
      NH=N/2
      DR=1.0/FLOAT(INTERP)
      N1=N/2+1
      N2=N+2
      XN=FLOAT(N)
      INTERP=INTERP-1
      J=N1+1
      K=0
      NN=N1IN+1
      DO 140 I=1,N1IN
      J=J-1
      K=K+1
      L=NN-I
      P(J)=P(L)
      DP(J)=DP(L)
      D(J)=SQRT(P(J))
      A(J)=0.5*Q(L)
      Y(K)=A(J)
      IF(INTERP.LE.0)GOTO 140
      IF(J.LE.1) GOTO 140
      	DO INK=1,INTERP
	      V(1)=RAN(L)-FLOAT(INK)*DR
	      CALL SPLN2(N1IN,RAN,Q,CC,V)
	      J=J-1
	      A(J)=0.5*V(2)
	      K=K+1
	      Y(K)=A(J)
	      D(J)=EXP(A(J))
	      P(J)=D(J)*D(J)
	      DP(J)=0.0
  	ENDDO
  140 CONTINUE
      INTERP=INTERP+1				!Restore INTERP to 2 or 4
	PRFO=PRF
	N1O=N1
C
C	SET UP ARRAYS TO STORE ORIGINAL SPECTRUM
C
	DO I=1,N1
	DP(I)=D(I)
	P(I)=A(I)
	Q(I)=Y(I)
	ENDDO
      CALL STWI(NH,KP,IR,W2)
	WRITE(LERR,701)
C
C	START OF LOOP FOR CALCULATING MIN PHASE
C
	FII=FNQ/NH                                ! freq incr
	NAP=INT(FAPPLY/FII+0.5)			  ! Drop-offs applied to this pt
	AFAP=FLOAT(NAP)*FII

c+++++++++
c     write(0,*)'NDOF= ',NDOF
	DO KD=1,NDOF
	IF(DOF.GT.900.) GO TO 999             ! All valid DOFs already used
	IF(KD.GT.1)WRITE(LERR,700)
c	WRITE(WCOMM(3)(53:63),9)DOF(KD)
  9	FORMAT(1X,F4.1,'dB/Oct')
	WRITE(LERR,702)DOF,AFAP,IW
	IDF=INT(DOF/6.+0.5)
	DF=FLOAT(IDF)				 !Convert to power law
C
C	SET UP INTERP SPECTRUM FOR HILBERT TRANSFORM
C
	N1=N1O					!Reset N1
	DO I=1,N1
	D(I)=DP(I)
	A(I)=P(I)
	Y(I)=Q(I)
	ENDDO
	PRF=PRFO
C
C      NO ALTERATION OF SPECTRAL VALUES IF ABS(DF) EQ 0.0 OR GT 12.0
C
      IF(ABS(DF).LE.0.0.OR.ABS(DF).GT.12.0) GO TO 200
C
C      IMPOSE APPROPRIATE POWER LAW BELOW FAPPLY, HZ
C
      IF(PRF.LT.DF)PRF=DF
      IF(DF.LT.0.0)PRF=-DF
      CON=A(NAP+1)-PRF*ALOG(FLOAT(NAP))

      DO J=2,NAP
      A(J)=CON+PRF*ALOG(FLOAT(J)-1.0)
      K=N1+1-J
      Y(K)=A(J)
      D(J)=EXP(A(J))
  	ENDDO
C
C      DC SMOOTHING FOR APPROPRIATE F**DF LAW
C
      A(2)=A(2)-0.04523*PRF
      A(1)=A(2)-1.64792*PRF
      A(3)=A(3)-0.01062*PRF
      Y(N)=A(2)
      J=N-1
      Y(J)=A(3)
      D(1)=0.0
  200 CONTINUE
C
C      HILBERT TRANSFORM BY DOUBLE F.T. WITH RE AND IM INTERCHANGE
C
      CALL FTRD(N1,KP,IR,W2,A,Y)
      N1=N1-1
      DO I=2,N1
      Y(I)=A(I)/XN
      A(I)=0.0
      ENDDO
      A(1)=0.0
      Y(1)=0.0
      N1=N1+1
      A(N1)=0.0
      Y(N1)=0.0
      CALL RSTR(N1,KP,IR,W2,A,Y)
C
C      FORM RE AND IM PARTS OF SPECTRUM OF MINIMUM-DELAY WAVELET
C
      DO I=1,N1
      A(I)=A(I)*XN
      DUM=D(I)
      D(I)=DUM*COS(A(I))
      E(I)=DUM*SIN(A(I))
	ENDDO
C
C      TRANSFORM TO WAVELET
C
      CALL RSTR(N1,KP,IR,W2,D,E)
	LST=MIN0(II,LWO)
	W(1)=0.
      DO I=2,LST
	W(I)=D(I-1)
      ENDDO
	IF(LWO.GT.II)THEN
		LST=LST+1
		KT=0
		DO I=LST,LWO
		KT=KT+1
		W(I)=E(KT)
		ENDDO
			ENDIF
C
C      GRAPH MIN-DELAY WAVELET
C
      CALL MAXDAT(LW,W,WMX)
c     write(0,*)'ssmph: LW,WMX,LWO= ',LW,WMX,LWO
      CALL DGRAPH(LERR,W,LW,WMX)
C
C	WRITE OUT TO FILE
C
        do  i = 1, LWO
            xtr (i) = w(i)
        enddo

	TZ=0.0
	IFL=1

        if (luwav .ge. 1) then
           write(luwav,*)'"rec= ',irec
           do i=1,LWO
             write(luwav,*)i,w(i)
           enddo
           write(luwav,888)
888        format()
        endif

	IW=IW+1			!Increment wavelet position
	CALL ZERO(LWO,W)
	CALL ZERO(N1IN,E)
      	ENDDO	
c+++++++++
C
C	END OF LOOP
C
  999 CONTINUE
       call gfree (wkA)
       call gfree (wkD)
       call gfree (wkY)
       call gfree (wkP)
       call gfree (wkW)
       call gfree (wkRAN)
       call gfree (wkIR)
       call gfree (wkW2)
       call gfree (wkE)
       call gfree (wkDP)
       call gfree (wkCC)
       call gfree (wkWW)
       call gfree (wkQ)

      RETURN
      END
