C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE STPPF2(LB,N1,N2,B,R,THETA,IOP)
C
C      OPTIMUM 3-POINT PREWHITENING FILTER FOR A STRONGLY PEAKED 
C      SPECTRUM.
C      OPTIMUM S(J) IS APPROXIMATE INVERSE OF INPUT B(J)
C
C	All write statements (except errors) removed for new SANE    Sue 4/85
C
C ***   INPUT VARIABLES
C
C       B(I) - VECTOR CONTAINING THE INPUT SPECTRUM
C       LB - SIZE OF THE VECTOR B
C       N1 - POINTER TO THE LOWEST FREQUENCY OVER WHICH THE APPROX 
C            OF A HIGHLY PEAKED SPECTRUM IS VALID
C       N2 - POINTER TO THE UPPER FREQUENCY OVER WHICH THE APPROX
C            OF A HIGHLY PEAKED SPECTRUM IS VALID
C       IOP - FORMALLY REQUIRED AS A PRINT PARAMETER. REDUNDANT IN
C             THIS VERSION
C
C ***  OUTPUT VARIABLES
C
C       S(I) - APPROXIMATE INVERSE OF B(I). S(I) IS PARAMETERIZED BY
C              THE TWO VARIABLES R AND THETA
C       R - PARAMETRER USED TO DEFINE S(I)
C       THETA - PARAMETER USED TO DEFINE S(I)
C
C ***  THIS SUBROUTINE IS BASED ON 'POWER SPECTRUM PARAMETER 
C ***  ESTIMATION' BY M.J. LEVIN, IEEE TRANS. ON INFOR. THEORY.
C ***  VOL. 11, PP 100-107.
C
C ***  MODIFIED T.C.REDSHAW                                   AUG. 85
C      1. ADDED WRITE STATEMENT IF FOUND A NEGATIVE ARGUMENT TO THE
C         SQUARE ROOT CALLS. CHANGED THE ARGUMENT TO ZERO IN THIS 
C         CASE.
C
C
C ***  MODIFIED T.C.REDSHAW                                   APR. 86
C      1. DELETED ALL OF THE SENSITIVITY ANALYSIS ETC WHICH IS NOT
C         USED BY SANE.
C      2. REFORMATED SOME OF THE STATEMENTS.
C
      DIMENSION B(LB),S(513),A(513)
C
C ***  CHECK THE INPUT DIMENSIONS
C
      IF (N1.LT.1) N1=1
      IF (N2.GT.LB) N2=LB
      LX = N2-N1+1

c     write (*,*) ' STPPF2:  LX=',LX
C
C      ASSUME GAUSSIAN DISTRIBUTION FOR FIRST ESTIMATION OF PEAK
C      FREQUENCY AND BANDWIDTH
C
      IMAX=N1
      DO 10 I=N1,N2
       IF (B(I) .LE. 0.0) then
           LX=LX-1
c          write (*,*) ' B(I)=',B(I),' LX=',LX
       endif
       IF (B(I) .GT. B(IMAX)) IMAX=I
   10 CONTINUE
C
C ***  CHECK FOR AN ERROR RETURN
C
      IF (LX. LT. 3) THEN 
       WRITE(6,51)LX
   51  FORMAT(/,5X,'***TPPF2 INPUT ERROR - LX=',I3)
       RETURN
      ENDIF
C
      KNT=IMAX-N1
      IF ((N2-IMAX) .LT. KNT) KNT=N2-IMAX
      S1=B(IMAX)
      ISGN=1
      IF (B(IMAX-1) .GT. B(IMAX+1)) ISGN=-1
C
C ***  FIND THE POINT IN THE SPECTRUM WHICH IS NO MORE THAN 6DB DOWN
C ***  FROM THE MAXIMUM
C
    5                            CONTINUE 
      J = IMAX + ISGN*(KNT-1)
      IF ((2.0*B(J)) .GT. S1) GOTO 4
      KNT = KNT-1
      GOTO 5
C
    4                            CONTINUE
      IF (KNT .LT. 1) KNT=1
      S2=0.0
      S3=0.0
      DO 20 I=1,KNT
       XI=I
       J = IMAX-I
       K = IMAX+I
       S1 = S1 + B(J) + B(K)
       S2 = S2 + XI*(B(K)-B(J))
       S3 = S3 + XI*XI*(B(J)+B(K))
   20 CONTINUE
      S2 = S2/S1
      S3 = S3/S1
C
C ***  BUILD THE INITIAL ESTIMATE OF R AND THETA AND ALSO SET
C ***  THEIR SEARCH VALUES DR AND DTH. USE A GAUSSIAN MODEL FOR
C ***  THIS INITIAL FIT.
C
      DTH = 3.14159265/FLOAT(LB-1)
      ETH = DTH
      THETA = (FLOAT(IMAX-1)+S2)*DTH
      S1 = S2*S2
      IF (S3 .LT. S1) S3 = S1 + 0.01
      EPS = SQRT(1.3863*(S3-S1))*DTH
      DR = 0.0
      R = 1.0 + EPS
      FNO=THETA/ETH
C
C ***  INITIAL MODEL BUILT. NOW REFINE IT BY ITERATING.
C
C      IT=NO.OF ITERATIONS WHICH USE REDUCED VALUES OF DR AND DTH
C      ITT=NO.OF ITERATIONS INCLUDING THOSE WITH UNCHANGED DR AND DTH
C      III=NO.OF DOUBLE SEARCHES(THROUGH R AND THETA)
C
      III=0
    2                            CONTINUE
      IT=0
      ITT=0
      III=III+1
    1                            CONTINUE
      T = THETA-DTH
      RR = R-DR
      IMAX = 1
      ITT = ITT+1
      DT = 0.2*DTH
      DRR = 0.2*DR
C
      DO 30 I=1,10
       RR=RR+DRR
       T = T + DT
       CALL TPFSP(LB,S,RR,T)
       A(I) = 0.0
       PROD = 0.0
       DO 50 J=N1,N2
        A(I) = A(I) + ALOG(S(J))
        PROD = PROD + B(J)*S(J)
   50  CONTINUE
       A(I) = A(I) - FLOAT(LX)*ALOG(PROD)
       IF (A(I) .GT. A(IMAX))IMAX=I
   30 CONTINUE
C
C ***  UPDATE THETA AND R
C
      THETA = THETA - DTH + FLOAT(IMAX)*DT
      R = R - DR + FLOAT(IMAX)*DRR
      FNO = THETA/ETH
      DLLI = 0.0001*(DT+DRR)*(DT+DRR)
      DLL = DLLI
C
      IF (IMAX .NE. 10 .AND. IMAX .NE. 1) THEN
       DLL=2.0*A(IMAX)-A(IMAX+1)-A(IMAX-1)
      ENDIF
C
      IF (DLL .LT. DLLI) DLL = DLLI
      IF (ITT .GT. 7) GOTO 9
      IF (IMAX .EQ. 1 .OR. IMAX .EQ. 10) GOTO 1
      IT = IT + 1
      DR = 0.1*DR
      DTH = 0.1*DTH
      IF (IT .LT. 3) GOTO 1
    9 IF (R .LT. 1.0001) GOTO 99
      IF (FNO .LT. FLOAT(N1-1) .OR. FNO .GT. FLOAT(N2-1)) GOTO 99
      GOTO (7,6,7,6,7,3),III
    7 EPS = R-1.0
      DR = 0.2*EPS/FLOAT(4*III-3)
      DTH = 0.0
      TD = DT/(SQRT(DLL)*THETA)
      GOTO 2
    6                            CONTINUE       
      DR = 0.0
      DTH = 0.2*ETH/FLOAT(III)
      RD = DRR/(SQRT(DLL)*R)
      GOTO 2
   99                            CONTINUE
C
C ***  SINGLE SPIKE IN INPUT SPECTRUM INVERSE IS ALSO A SINGLE SPIKE
C
      R=0.0
      THETA=0.0
      RETURN
    3                            CONTINUE
C 
C *** OPTIMUM R AND THETA DETERMINED. OBTAIN THE POWER SPECTRA FOR 
C *** THIS SIMPLE 3-POINT FILTER BEFORE RETURNING.
C
      CALL TPFSP(LB,S,R,THETA)
      RETURN
      END
