C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE wavest
c
c     Estimate wavelets
C
C**********************************************************************C
C
C wavest READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C computes the wavelets using a rolling buffer abd outputs the
c results in either usp format of xgraph format
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, cross
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis, ordfft, ier, iert, iabort
      integer     ngrp, luout, luwav, luspec
      integer     gatestart, gatelength, gateinc
      integer     maxlag, estopt, outtype, phztype, numwav
      integer     phzstart, phzinc
      integer     itaper, itapermax
      real        lfdrop, lfthresh
#include <f77/pid.h>
      REAL        wtrce(2*SZLNHD),xtrace(2*SZLNHD)
      real        data, sigspec, nsespec, bw
      pointer     (wkdata, data(1))
      pointer     (wksigspec, sigspec(1))
      pointer     (wknsespec, nsespec(1))
      pointer     (wkbw, bw(1))
      integer     trcnum
      pointer     (wktrcnum, trcnum(1))
      real        XR, XI, ES, EN, C, CS
      double precision    C_CST
      pointer     (wkXR, XR(1))
      pointer     (wkXI, XI(1))
      pointer     (wkES, ES(1))
      pointer     (wkEN, EN(1))
      pointer     (wkC, C(1))
      pointer     (wkCS, CS(1))
      pointer     (wkC_CST, C_CST(1))
      CHARACTER   NAME * 4, ntap * 512, otap * 512
      CHARACTER   wtap * 512, stap * 512
      CHARACTER   wavtitle * 80, ofpref * 3
      logical     verbos, query, first
 
      DATA NAME     /'WAVEST'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      data iabort/0/
      data first/.true./
      data luout/1/
      data luwav/-1/
      data luspec/-1/
      data itapermax/21/

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,wtap,stap,nst,ned,nrst,nred,verbos,
     1           ngrp, gatestart, gatelength, gateinc,
     2           maxlag, estopt, outtype, phztype, numwav,
     3           phzstart, phzinc, lfdrop, lfthresh, itaper,
     4           wavtitle, ofpref)

C**********************************************************************C
C     open I/O data sets & assign logical units
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

C**********************************************************************C
C     read input line header; save certain parameters; adjust output
C     line header; update historical line header
C**********************************************************************C
      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'WAVEST: no header read on ',ntap,' unit= ',luin
         write(LERR,*)'Check existence of file & rerun'
         write(LERR,*)'FATAL'
         stop
      endif
      CALL HLHprt    ( ITR , LBYTES, NAME, 4,         LERR)
#include <f77/saveh.h>

c---
c  open ascii xgraph format files for wavelet and/or spectra
c---
      if (wtap(1:1) .ne. ' ') then
         call alloclun (luwav)
         open (luwav, file=wtap, status='unknown')
      endif
      if (stap(1:1) .ne. ' ') then
         call alloclun (luspec)
         open (luspec, file=stap, status='unknown')
      endif
c---
c  build pointers to selected trace headers
c---
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
c-------------------------------------------
c  check start/end rec/trc parameters
      call cmdchk ( nst, ned, nrst, nred, ntrc, nrec)

      jtrc=ned-nst+1
      call savew( itr, 'NumTrc',    1 , LINHED)
      nrecc=nred-nrst+1
      call savew( itr, 'NumRec', nrecc, LINHED)

      if (ngrp .gt. jtrc/2) then
         write(LERR,*)' '
         write(LERR,*)'WARNING FROM wavest:'
         write(LERR,*)'Asking for rolling buffer > number trcs/2'
         write(LERR,*)'bad idea. Setting ngrp = jtrc/2'
         write(LER ,*)' '
         write(LER ,*)'WARNING FROM wavest:'
         write(LER ,*)'Asking for rolling buffer > number trcs/2'
         write(LER ,*)'bad idea. Setting ngrp = jtrc/2'
         ngrp = jtrc / 2
      endif

c     if (jtrc .gt. 512) then
c        write(LERR,*)' '
c        write(LERR,*)'FATAL ERROR in wavest:'
c        write(LERR,*)'You have asked for ',jtrc,' traces / record but'
c        write(LERR,*)'currently we only support input records < 513'
c        write(LERR,*)'traces. Limit using more restrictive -ns[]'
c        write(LERR,*)'and -ne[] cmd line entries. This limitation'
c        write(LERR,*)'is being looked at but no ETA'
c        write(LER ,*)' '
c        write(LER ,*)'FATAL ERROR in wavest:'
c        write(LER ,*)'You have asked for ',jtrc,' traces / record but'
c        write(LER ,*)'currently we only support input records < 513'
c        write(LER ,*)'traces. Limit using more restrictive -ns[]'
c        write(LER ,*)'and -ne[] cmd line entries. This limitation'
c        write(LER ,*)'is being looked at but no ETA'
c        go to 999
c     endif
c---
c  check gate start and length to make sure we don't demand data
c  off the ends of the available trace
c---
      its = gatestart
      gatestart = gatestart / nsi
      if (gatestart .eq. 0) gatestart = 1
      if (gatelength .eq. 0) gatelength = nsi*(nsamp-1)
      itl = gatelength
      if (its+itl .ge. nsi*(nsamp-1)) then
         write(LERR,*)'WARNING:'
         write(LERR,*)'Gatelength= ',itl,' + gate start= ',its,' >'
         write(LERR,*)'trace length = ',nsi*(nsamp-1)
         gatelength = nsi*(nsamp-1)
         gatestart = 1
         write(LERR,*)'Resetting gatelength= ',gatelength
         write(LERR,*)'Resetting gate start= ',nsi*(gatestart-1)
      endif

c---
c  For non-zero itaper:
c  make sure itaper is even
c  check prewhitening taper zone to make sure we don't ask for
c  data after the end of the trace
c  make sure altered itaper is even and of reasonable length
c---

      if (mod(itaper,2) .ne. 0) itaper = itaper + 1

      IF (itaper .ne. 0) THEN
         left = gatestart - itaper
         if (left .lt. 1) then
            write(LERR,*)'WARNING:'
            write(LERR,*)'Prewhitening taper ',itaper,' samples <'
            write(LERR,*)'gate start position ',gatestart,' samples'
            itaper = (gatestart - 1)
            if (mod(itaper,2) .ne. 0) itaper = itaper - 1
            if (itaper .lt. 4) itaper = 0
            write(LERR,*)'Resetting taper to ',itaper
         endif
      ENDIF

c---
c  maxlag is the 1-sided length of the crosscorrelations. Since we will
c  be computing the crossspectra (FFT's) we wil need the number of
c  frequencies, nf
c---
      if (maxlag .eq. 0) maxlag = gatelength / 2
      if (maxlag .gt. gatelength/2) maxlag = gatelength / 2
      dtms = nsi
      si = unitsc * float(nsi)
      lags = 2*maxlag / nsi
      nu  = ordfft (lags)
      nt  = 2 ** nu
      nf  = nt / 2
      nf1 = nf + 1

c---
c  it is much easier to deal with gate lengths which are power of 2. We will
c  then make sure we allocate enough memory for the data arrays
c---
      LG  = gatelength
      LT  = LG / nsi + 1
      nu  = ordfft (LT)
      nt  = 2 ** nu
      LT2 = nt / 2
      gatelength = (nt-1) * nsi

c---
c  For non-zero itaper:
c  check prewhitening taper zone to make sure we don't ask for
c  data before the start of the trace
c  make sure altered itaper is even and of reasonable length
c---
      IF (itaper .ne. 0) THEN

         left = gatestart - itaper
         LM2  = 2 * (LT2 + itaper/2)
         iend = LM2 + left - 1
         if (iend .gt. nsamp) then
            write(LERR,*)'WARNING:'
            write(LERR,*)'Prewhitening taper ',itaper,' samples >'
            write(LERR,*)'end of data = ',nsamp,' samples'
            itaper = (nsamp-left) - 2 * LT2
            LM2  = 2 * (LT2 + itaper/2)
            iend = LM2 + left - 1
            if (mod(itaper,2) .ne. 0) itaper = itaper - 1
            if (itaper .lt. 4) itaper = 0
            write(LERR,*)'Resetting taper to ',itaper,LM2,iend
         endif
      ENDIF

c---
c  figure out the output samples for options
c---
      wls = float(maxlag) / dtms + 1.5
      lw  = int (wls)

      if (phztype .eq. 0) then
         ladj = lw / 8
         lwo  = lw + 2*ladj
         lh   = lwo / 2
         lzw  = 2 * lh + 1
      else
         lzw  = 5 * lw / 4 + 1
      endif

c---
c  memory allocations
c---
      nmax = max (nt, nsamp, iend)
      itemt = jtrc * nmax * SZSMPD
      itemf = jtrc * (nf+1) * SZSMPD
      itemi = jtrc * SZSMPD
      iert = 0
      ibytot = 0
      call galloc (wkdata, itemt, ier, iabort)
      ibytot = ibytot + itemt
      iert = iert + ier
      call galloc (wksigspec, itemf, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
      call galloc (wknsespec, itemf, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
      call galloc (wkbw, itemi, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
      call galloc (wktrcnum, itemi, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
c---
c  get max dimensions for time vectors
c  get max dimensions for freq vectors
c---
      LMI  = 2 * (LT2 + itaper/2)
      NFI  = 2 * (nf + 1)
      NFC  = NF1
      itemt =        ngrp * LMI * SZSMPD
      itemf =        ngrp * NFI * SZSMPD
      itemc = ngrp * ngrp * NFI * SZSMPD
      items = ngrp * ngrp * NFC * SZSMPD
      itemj = ngrp * ngrp       * SZSMPD

      call galloc (wkXR, itemt, ier, iabort)
      ibytot = ibytot + itemt
      iert = iert + ier
      call galloc (wkXI, itemt, ier, iabort)
      ibytot = ibytot + itemt
      iert = iert + ier
      call galloc (wkES, itemf, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
      call galloc (wkEN, itemf, ier, iabort)
      ibytot = ibytot + itemf
      iert = iert + ier
      call galloc (wkC, itemc, ier, iabort)
      ibytot = ibytot + itemc
      iert = iert + ier
      call galloc (wkC_CST, 2*items, ier, iabort)
      ibytot = ibytot + 2*items
      iert = iert + ier
      call galloc (wkCS, itemj, ier, iabort)
      ibytot = ibytot + itemj
      iert = iert + ier

      if (ier .ne. 0) then
         write(LERR,*)'FATAL ERROR in wavest:'
         write(LERR,*)'Unable to allocate ',ibytot,' bytes'
         go to 999
      endif

      obytes = SZTRHD + SZSMPD * lzw
      call savew( itr, 'NumSmp', lzw  , LINHED)

      write(LERR,*)
      write(LERR,*)' Values read from input data set line header'
      write(LERR,*)
      write(LERR,*) ' # of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval    =  ', nsi  
      write(LERR,*) ' Traces per Record  =  ', ntrc 
      write(LERR,*) ' Records per Line   =  ', nrec
      write(LERR,*) ' Format of Data     =  ', iform
      write(LERR,*) ' Number of lags     =  ', 2*lags,' ms'
      write(LERR,*) ' Window start       =  ',its,' ms'
      write(LERR,*) ' Window length      =  ',LG,' ms ',LT,' samples'
      write(LERR,*) ' 1/2 pwr 2 gate     =  ',LT2,' samples'
      write(LERR,*) ' Working window size=  ', nt,' (nt) samples'
      write(LERR,*) ' Taper length       =  ',itaper,' samples'
      write(LERR,*) ' Number samp max    =  ',nmax
      write(LERR,*) ' '
      if (estopt .eq. 0) then
         write(LERR,*) ' Papoulis method'
      else
         write(LERR,*) ' Thomson method'
      endif
      if (phztype .eq. 0) then
         write(LERR,*) ' zero phase wavelet'
      else
         write(LERR,*) ' minimum delay wavelet'
      endif
      if (outtype .eq. 0) then
         write(LERR,*) ' output estimated signal wavelet'
      else
         write(LERR,*) ' output estimated noise wavelet'
      endif
      write(LERR,*) ' '
 
c----------------------------------------------------------
c  update historical line header & write out output header
      call savhlh( itr, lbytes, lbyout)
      call wrtape(luout,itr,lbyout)
 
C**********************************************************************C
C     skip to desired start record
C**********************************************************************C
      call recskp(1,nrst-1,luin,ntrc,itr)

C**********************************************************************C
C
C     READ TRACE, DO WAVEST (cross)
C
C**********************************************************************C
 
      DO 100 JJ = NRST, NRED

c-------------------------------
c  skip to desired trace
c-------------------------------
           call trcskp(jj,1,nst-1,luin,ntrc,itr)

c---
c  fill up data array with each live trace.  Note that the array is
c  dimensioned in time by "nmax" which could exceed nsamp. This is so
c  we can use the power of 2 gate length. If we end up with zeroes at
c  the end of array then so be it.
c---
           ic = 0
           DO 99 KK = NST, NED

                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif

                 call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)

                 IF(istatic .ne. 30000) THEN

                    ic = ic + 1

                    call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          trcnum(ic) , TRACEHEADER)
                    call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          irec   , TRACEHEADER)

                    call vclr (xtrace, 1, nmax)
                    call vmov (itr(ITHWP1), 1, xtrace, 1, nsamp)
                    iptr = (ic-1) * nmax
                    call vmov (xtrace, 1, data(iptr+1), 1, nsamp)
                 ELSE
                    call vclr (xtrace, 1, nsamp)
                 ENDIF

   99      CONTINUE
           live = ic

           IF (live .ge. 1) THEN

              if (live .lt. ngrp) then
                 ngrpj = live
                 write(LER ,*)' '
                 write(LER ,*)'Rec ',irec,' number of live traces ',live
                 write(LER ,*)'Adjusting rolling buffer from ',ngrp,' to
     1 ',ngrpj
                 write(LERR,*)' '
                 write(LERR,*)'Rec ',irec,' number of live traces ',live
                 write(LERR,*)'Adjusting rolling buffer from ',ngrp,' to
     1 ',ngrpj
              else
                 ngrpj = ngrp
              endif

              call wavproc (wavtitle, ofpref, nmax, live, ngrpj, data, 
     1                      gatestart, gatelength, gateinc, si, unitsc,
     2                      maxlag, estopt, outtype, phztype,numwav,nsi,
     3                      phzstart, phzinc, lfdrop, lfthresh, first, 
     4                      LT2, nf, nf1, sigspec, nsespec, itaper,
     5                      ier, wtrce, luwav, irec, trcnum, bw, nsamp,
     6                      luspec, itapermax,
     7                      XR, XI, ES, EN, C, CS, C_CST, LMI, NFI)
          ELSE
             write(LER ,*)' '
             write(LER ,*)'Rec ',irec,' no live trace -- zero wavelet'
             write(LERR,*)' '
             write(LERR,*)'Rec ',irec,' no live trace -- zero wavelet'
             call vclr (wtrce, 1, lzw) 
          ENDIF
           
          call vmov (wtrce, 1, itr(ITHWP1), 1, lzw)
          call wrtape (luout, itr, obytes)

            if(verbos) then
              write(LERR,*)' Wavelet Estimated for Record= ',irec
            endif

c------------------------------------
c  skip to end of current record
c------------------------------------
            call trcskp(jj,ned+1,ntrc,luin,ntrc,itr)

  100 CONTINUE

  999 continue
         call lbclos(luin)
         call lbclos(luout)
      END

c----------------------------------------------------------
c   online help section
c----------------------------------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for wavest: Signal And'
        write(LER,*)'                                 Noise Estimation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-W[wtap]   -- optional wavelet xgraph output file'
        write(LER,*)'-S[stap]   -- optional spectra xgraph output file'
        write(LER,*)'-ng[ngrp]  -- number of trcs in rolling buffer (4)'
        write(LER,*)'-gs[start] -- start time for window (ms)       (0)'
        write(LER,*)'-gl[length]-- window length (ms)           (trace)'
        write(LER,*)'-ml[lags]  -- maximum 1-sided lags (ms) (window/2)'
c       write(LER,*)'-ps[phzs]  -- phase start (deg)                (0)'
c       write(LER,*)'-pi[phzi]  -- phase incement (deg)             (0)'
c       write(LER,*)'-nw[nwav]  -- number wavelets                  (1)'
        write(LER,*)'-t[taper]  -- edge effect taper (points)      (20)'
        write(LER,*)'-lfd[drop] -- db/octave drop off               (0)'
        write(LER,*)'-lft[fdrop]-- freq below which drop off applies(8)'
        write(LER,*)'-b[title]  -- character string title       (blank)'
        write(LER,*)'-ns[nstr]  -- start trace number           (first)'
        write(LER,*)'-ne[netr]  -- end trace number              (last)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-T         -- Thomson crosspectral calculation'
        write(LER,*)'              else Papoulis used'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'    wavest -N[] -O[] -W[] -S[] -ng[] -gs[] -gl[]'
        write(LER,*)'            -ml[] -t[] -lfd[] -lft[] -t[]'
        write(LER,*)'            -ns[] -ne[] -rs[] -re[]'
        write(LER,*)'            [-noise -mindelay -T -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*512  input file name
c     otap  - C*512  output file name
c    lags   - I      autocorrelation lags
c     nst   - I      start trace
c     ned   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,wtap,stap,nst,ned,nrst,nred,verbos,
     1           ngrp, gatestart, gatelength, gateinc,
     2           maxlag, estopt, outtype, phztype, numwav,
     3           phzstart, phzinc, lfdrop, lfthresh, itaper,
     4           wavtitle, ofpref)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*), wtap*(*), stap*(*)
      character  wavtitle*(*), ofpref*(*)
      integer    nst,ned,nrst,nred,argis
      integer    ngrp
      integer    gatestart, gatelength, gateinc
      integer    maxlag, estopt, outtype, phztype, numwav
      integer    phzstart, phzinc, itaper
      real       lfdrop, lfthresh
      logical    verbos, noise, mdelay, thom

      thom   = .false.
      noise  = .false.
      mdelay = .false.
          thom   = (argis('-T') .gt. 0)
          noise  = (argis('-noise') .gt. 0)
          mdelay = (argis('-mindelay') .gt. 0)

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argstr('-W',wtap,' ',' ') 
          call argstr('-S',stap,' ',' ') 
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argi4('-ng',ngrp,4,4)
          call argi4('-gs',gatestart,0,0)
          call argi4('-gl',gatelength,0,0)
          call argi4('-gi',gateinc,0,0)
          call argi4('-ml',maxlag,0,0)

          if (ngrp .le. 2) then
             write(LERR,*)' '
             write(LERR,*)'WARNING from wavest:'
             write(LERR,*)'ng <= 2 bad; Setting ng=3'
             write(LER ,*)' '
             write(LER ,*)'WARNING from wavest:'
             write(LER ,*)'ng <= 2 bad; Setting ng=3'
             ngrp = 3
          endif

          estopt  = 0
          outtype = 0
          phztype = 0
          if (thom) estopt = 1
          if (noise) outtype = 1
          if (mdelay) phztype = 1

          call argi4('-ps',phzstart,0,0)
          call argi4('-pi',phzinc,0,0)
          call argi4('-nw',numwav,1,1)
          call argi4('-t',itaper,10,10)
          call argr4('-lfd',lfdrop,0.0,0.0)
          call argr4('-lft',lfthresh,8.0,8.0)
          call argstr('-b',wavtitle,' ',' ') 
          call argstr('-o',ofpref,' ',' ') 
          verbos = (argis('-V') .gt. 0)

      return
      end
