C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C	WAVEST : SIGNAL AND NOISE ESTIMATION VIA MULTIPLE COHERENCE
C	Output (line printer plots of S and N spectra and wavelets plus
C	Table of final S/N estimates, and parameter file for later xgraph
C	plots) and options - Papoulis or Thomson method for spectra, 4 traces
C	per group pre-set, running average or independent groups, zero-phase
C	wavelets available, user can specify up to 6 values for the low
C	frequency drop-off parameter in one job.
C	See WAVEST documentation for details
C	
C	**** This is a rough "fixit" so a number of parameters are retained
C	even though they appear redundant.  
 

        subroutine wavproc(out_wav_title,
     +                          out_filename_prefix,
     +                          nsamp,
     +                          jtrc,
     +                          ngrp,
     +                          data,
     +                          gate_start,
     +                          gate_length,
     +                          gate_increment,
     +                          si,
     +                          unitsc,
     +                          max_lag,
     +                          estimation_option,
     +                          output_type,
     +                          phase_type,
     +                          num_out_wavelets,
     +                          nsi,
     +                          phase_start,
     +                          phase_inc,
     +                          lf_dropoff,
     +                          lf_threshold,
     +                          first, LT2, NF, NF1, sigspec, nsespec,
     +                          itaper, ier, xtr, luwav, irec,
     +                          trcnum, btr, nsamp0, luspec, itapermax,
     +                          XR, XI, ES, EN, C, CS, C_CST, LMI, NFI)

#include <f77/iounit.h>

       integer  nsamp, jtrc, ngrp, LT2, NF, itaper, luwav, irec

       dimension  XR(ngrp, LMI), XI(ngrp, LMI)
       dimension  ES(ngrp,NFI), EN(ngrp,NFI)
       dimension  C(ngrp,ngrp,NFI), CS(ngrp,ngrp)
       double precision C_CST(ngrp,ngrp,NF1)


       integer  luspec
       integer  trcnum (jtrc)
       real     data (nsamp, jtrc), xtr(*)
       real     sigspec (nf1, jtrc)
       real     nsespec (nf1, jtrc)
       real     btr (jtrc)
       character*(*) out_wav_title
       character*(*) out_filename_prefix
       integer first_time
       integer  gate_start
       integer  gate_length
       integer  gate_increment
       integer  max_lag
       integer estimation_option
       integer num_out_wavelets
       integer output_type
       integer phase_type
       integer ier
       integer print_flag
       real phase_start
       real phase_inc
       real lf_dropoff
       real lf_threshold

c	REAL SP(12),G(12),CMAX(12)
c	REAL S(513),TS(2070),V(513),IR(1024),W2(513)
c	REAL SNR(12)
c	REAL PREW(513),TC(2070),UN(513),PRWF(3),UG(12)
c	REAL RS2(513),RS3(513),RSTN(513),RSP(513),RSUM(513)
c	REAL VRSUM(513),ASP(513),ANP(513),SUL(513),SLL(513)
c	REAL SDB(513),VDB(513)
c	REAL RARRAY(513)

        real PRWF(3)
        real SP, G, CMAX, S, TS, V, IR, W2, SNR, PREW, TC, UN
        real UG, RS2, RS3, RSTN, RSP, RSUM, VRSUM, ASP, ANP, SUL
        real SLL, SDB, VDB, RARRAY, CI, SPACE, XP, SSP
        pointer (wkSP, SP(1))
        pointer (wkG, G(1))
        pointer (wkCMAX, CMAX(1))
        pointer (wkS, S(1))
        pointer (wkTS, TS(1))
        pointer (wkV, V(1))
        pointer (wkIR, IR(1))
        pointer (wkW2, W2(1))
        pointer (wkSNR, SNR(1))
        pointer (wkPREW, PREW(1))
        pointer (wkTC, TC(1))
        pointer (wkUN, UN(1))
        pointer (wkUG, UG(1))
        pointer (wkRS2, RS2(1))
        pointer (wkRS3, RS3(1))
        pointer (wkRSTN, RSTN(1))
        pointer (wkRSP, RSP(1))
        pointer (wkRSUM, RSUM(1))
        pointer (wkVRSUM, VRSUM(1))
        pointer (wkASP, ASP(1))
        pointer (wkANP, ANP(1))
        pointer (wkSUL, SUL(1))
        pointer (wkSLL, SLL(1))
        pointer (wkSDB, SDB(1))
        pointer (wkVDB, VDB(1))
        pointer (wkRARRAY, RARRAY(1))
        pointer (wkCI, CI(1))
        pointer (wkSPACE, SPACE(1))
        pointer (wkXP, XP(1))
        pointer (wkSSP, SSP(1))
        
C
C       Thomson
C
c       INTEGER IND_CST(1000)
c       DOUBLE PRECISION FV_CST(1000,10),Z_CST(1000,21),
c    1  RLAM_CST(21),X_CST(1024),UR_CST(513,21),D_CST(513,21),
c    2  XIN_CST(1000),S_CST(513),SS_CST(513,12),DF_CST(513),
c    3  VAR_CST(12),XARR_CST(12000),DSQR_CST(513,21,12)
c       DOUBLE COMPLEX U_CST(513),Y_CST(513,21),YEIG_CST(513,21,12)

        DOUBLE PRECISION FV_CST,Z_CST,RLAM_CST,X_CST,UR_CST,D_CST
        DOUBLE PRECISION XIN_CST,S_CST,SS_CST,DF_CST,VAR_CST
        DOUBLE PRECISION XARR_CST,DSQR_CST
        DOUBLE COMPLEX   U_CST,Y_CST,YEIG_CST
        pointer (wkFV_CST, FV_CST(1))
        pointer (wkZ_CST, Z_CST(1))
        pointer (wkRLAM_CST, RLAM_CST(1))
        pointer (wkX_CST, X_CST(1))
        pointer (wkUR_CST, UR_CST(1))
        pointer (wkD_CST, D_CST(1))
        pointer (wkXIN_CST, XIN_CST(1))
        pointer (wkS_CST, S_CST(1))
        pointer (wkSS_CST, SS_CST(1))
        pointer (wkDF_CST, DF_CST(1))
        pointer (wkVAR_CST, VAR_CST(1))
        pointer (wkXARR_CST, XARR_CST(1))
        pointer (wkDSQR_CST, DSQR_CST(1))
        pointer (wkU_CST, U_CST(1))
        pointer (wkY_CST, Y_CST(1))
        pointer (wkYEIG_CST, YEIG_CST(1))

        integer IND_CST
        pointer (wkIND_CST, IND_CST(1))

	DOUBLE PRECISION RNW_CST
C

	CHARACTER*10 wav_type
	CHARACTER*80 WFIL_PREFIX
	CHARACTER*50 TITLE,OFNAM,WFIL,SPENAM
	CHARACTER*70 STAB(200)
	CHARACTER*70 WCOMM(3)
	CHARACTER*1 OPT,WTYP
        logical  first
        integer lenth
c       external lens !$pragma C ( lens )
C
C	Thomson
C
	INTEGER IINPAR(8)

	LOGICAL QMEAN,QWGTS
        integer ierr, ierrt, abort, jsz
        data ierr/0/, ierrt/0/, abort/0/

        call sizefloat(jsz)
        itemt = 2 * LT2 + itaper
        itemf = 2 * NF1
        itemj = jtrc
        itemn = ngrp * ngrp
        call galloc (wkSP, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkG, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkCMAX, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSNR, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkUG, jsz*max(itemf,itemj), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkTS, jsz*2*(itemt+3), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkTC, jsz*2*(itemt+3), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkIR, 2*jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkS, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkV, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkW2, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkPREW, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkUN, jsz*max(itemj,itemf), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRS2, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRS3, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRSTN, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRSP, jsz*itemj, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRSUM, jsz*max(itemf,itemj), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkVRSUM, jsz*max(itemf,itemj), ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkASP, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkANP, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSUL, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSLL, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSDB, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkVDB, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkRARRAY, jsz*itemf, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkCI, jsz*itemn, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSPACE, jsz*itemn, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkXP, jsz*itemn, ierr, abort)
        ierrt = ierrt + ierr
        call galloc (wkSSP, jsz*itemn, ierr, abort)
        ierrt = ierrt + ierr

 
      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from wavest:'
         write(LERR,*)'Unable to allocate memory in routine wavproc 1'
         write(LER ,*)'FATAL ERROR from wavest:'
         write(LER ,*)'Unable to allocate memory in routine wavproc 1'
         call ccexit (666)
      endif

C----SET UP THOMSON HARDWIRED VARIABLES
 
	IINPAR(2)=ngrp		!4 traces per group
	IINPAR(3)=itapermax				!allow up to 21 tapers
	IINPAR(4)=0					!Minimum order
	IINPAR(6)=0					!Min order initial est
	IINPAR(7)=1					!Max order initial est
	IINPAR(8)=2					!2 iterations
        LSTEP_CST=2 * LT2     ! get rid of hardwired potential disaster
c       LSTEP_CST=1000
	NST_CST=ngrp
c	NREQ_CST=1024
        NREQ_CST = 2 * (NF1 - 1)
	QWGTS=.FALSE.					!Unit weights
	QMEAN=.TRUE.					!Thomson mean
C----END SET UP THOMSON HARDWIRED VARIABLES
 
        dtms  = nsi
	ICALL = 0
	IPASS=0
	IOUT=0
	LPRW = 1
	LPP=3
	CALL ZERO(LPP,PRWF)
	PRWF(1) = 1.0
	IERR=0				!No error/warning messages from SSNRDET
	JERR=0				!No printing for each singular matrix
	MSING=0				!But count singular matrices!
        print_flag = 0

	NOW = num_out_wavelets
	PHW = phase_start
	PHINC = phase_inc
        NDOF = 1

c      write(0,*)'nsamp, nsamp0= ',nsamp, nsamp0

c       do j=1,jtrc
c          do i=1,nsamp
c          write(7,*)i,data(i,j)
c          enddo
c          write(7,888)
c       enddo

c     write(0,*)'lf_dropoff,lf_threshold= ',lf_dropoff,lf_threshold
c     write(0,*)'output_type,phase_type= ',output_type,phase_type

	DOF = lf_dropoff
	FAPPLY = lf_threshold

C------------------------------------------------------------------------------
        write (LER,*)
        write (LER,*) ' **************************************'
        write (LER,*) ' *** WAVEST is generating a wavelet ***'
        write (LER,*) ' *** for record ',irec
        write (LER,*) ' *** with ',jtrc,' live traces'
        write (LER,*) ' **************************************'
        write (LER,*)


        first_time = 1

        TITLE = ' '

c       write(0,*) ' TITLE=',TITLE

        OFNAM = 'Printout file, WAVESTxxx'
	WRITE(LERR,1)irec,jtrc
	WRITE(LERR,11) OFNAM

        if (estimation_option .eq. 0) then
          WTYP = 'P'
          wav_type = ' Papoulis '
        else
          WTYP = 'T'
          wav_type = ' Thomson ' 
        endif

        OPT = 'R'

        num_traces = jtrc
        NAN = num_traces
        LG  = gate_length
        jst = gate_start
        its = (jst-1) * nsi
        MLP = max_lag

c     write(0,*)'LG,jst,ngrp,MLP= ',LG,jst,ngrp,MLP
c     write(0,*)'nsamp, LT2, LMI, NFI= ',nsamp,LT2, LMI, NFI


        ngrp1 = ngrp - 1
	N     = ngrp				! 4 traces per group
	NT    = N
	NIP1  = NAN-ngrp1
	NIP   = NAN/ngrp
	NTA   = NAN
	JIPP  = NAN
        iroll = 1
        jgrp  = 0


c+++++++++++++++++++++++++++++
c  extracted code snippets from ssread
c+++++++++++++++++++++++++++++
        LT = gate_length / nsi + 1

c     write(0,*)'gate_length, NF, itaper= ',gate_length, NF,itaper
c     write(0,*)'BWIN: itaper,LT,LWL= ',itaper,LT,LWL

        LWL=2*MLP/nsi
        ESS=3.408*FLOAT(LT)/FLOAT(LWL)
        BWIN=1000.*ESS/FLOAT(LG)
        IESS=INT(ESS+0.5)
        FI=(0.5/SI)/FLOAT(NF)
c       WRITE(WCOMM(2)(1:70),709)LG,IESS,OPT,DFIL
        WRITE(LERR,66)IESS,BWIN
        WRITE(LER ,66)IESS,BWIN

C----Calculate effective smoothing, window bandwidth

        LPW=2*MLP

c     write(0,*)'WTYP,LPW,MLP= ',WTYP,LPW,MLP

        IF (WTYP.EQ.'P') THEN                           !Papoulis

                WRITE(LERR,64)MLP
                WRITE(LER ,64)MLP
c               WRITE(WCOMM(1)(1:),707)LPW
                ntapr = itapermax
        ELSE                                            !Thomson

C----set up number of tapers

c     write(0,*)'THOM: MLP,LT,LPW= ',MLP,LT,LPW
                IINPAR(1)=LT
                W=3.408*dtms/(4.*FLOAT(MLP))
                WNP=LT*W
                KT=2*INT(WNP)
                IF(KT.GT.20)THEN                        !reset: max 21 tapers
                        KT=20
                        WNP=10.
                        W=WNP/FLOAT(LT)
                        PML=3.408*dtms/(4.*W)
                        MLP=INT(PML+0.5)
                ENDIF
                IINPAR(5)=KT
                ntom = LT
                ktom = KT
                IXR_CST=1
                RNW_CST=WNP
                write(LERR,*) ' NDP_CST=',NDP_CST,' MLP=', MLP
c               write(0,*) ' NDP_CST=',NDP_CST,' MLP=', MLP
                NDP_CST = KT
                WRITE(LERR,65)NDP_CST,MLP
                WRITE(LER ,65)NDP_CST,MLP
                write(LERR,*) ' LPW=',LPW
c               write(LER ,*) ' LPW=',LPW
c               WRITE(WCOMM(1)(1:),708)LPW
                ntapr = KT
        ENDIF

        BSUM = 0
        KO   = 0
        dtms = nsi
        do  J = 1, jtrc
            call unband (LT, data(1,J), dtms, btr(J), duma, dumb)
            BSUM = BSUM + btr(J)
        enddo
c       write(LER ,*)'BSUM= ',BSUM
c+++++++++++++++++++++++++++++

      LG = gate_length / nsi + 1
c     write(0,*)'LT, LG, itapermax= ',LT, LG,itapermax
      
      LSTEP = LSTEP_CST
      itmx = ngrp
      mtapr = ntapr+1
      mgrp = ngrp
      jsz2 = 4 * jsz
      call galloc (wkFV_CST, jsz2 * LSTEP * 12, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkZ_CST, jsz2 * LSTEP * mtapr, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkRLAM_CST, jsz2 * mtapr, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkX_CST, jsz2 * 2*NF1, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkUR_CST, jsz2 * NF1 * mtapr, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkD_CST, jsz2 * NF1 * mtapr, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkXIN_CST, jsz2 * LSTEP, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkS_CST, jsz2 * NF1, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkSS_CST, jsz2 * NF1 * mgrp, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkDF_CST, jsz2 * NF1, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkVAR_CST, jsz2 * mgrp, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkXARR_CST, jsz2 * mgrp * LSTEP, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkDSQR_CST, jsz2 * NF1 * mtapr * mgrp, ierr, abort)
      ierrt = ierrt + ierr

      call galloc (wkU_CST, 2*jsz2 * NF1, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkY_CST, 2*jsz2 * NF1 * mtapr, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkYEIG_CST, 2*jsz2 * NF1 * mtapr * mgrp, ierr, abort)
      ierrt = ierrt + ierr
      call galloc (wkIND_CST, jsz * LSTEP, ierr, abort)
      ierrt = ierrt + ierr

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR from wavest:'
         write(LERR,*)'Unable to allocate memory in routine wavproc 2'
         write(LER ,*)'FATAL ERROR from wavest:'
         write(LER ,*)'Unable to allocate memory in routine wavproc 2'
         call ccexit (666)
      endif

C---------------------------------------------------------------------
 
c+++++++
c  looks like IPASS = 0,1
c+++++++
	DO WHILE (IPASS.LT.2)  ! we always me two passes

                IF(ICALL.EQ.1) LPRW = 3    ! first time ICALL=0; next ICALL=1
		CALL ZERO(jtrc,RS2)
		CALL ZERO(jtrc,RS3)
		CALL ZERO(jtrc,RSTN)
		CALL ZERO(jtrc,RSP)
		CALL ZERO(max(itemf,itemj),RSUM)
		CALL ZERO(max(itemf,itemj),VRSUM)
		IPASS=IPASS+1  !first time around IPASS=1 here
		INNF=0
		NO=0
		IA=1

c           write(0,*) '-----------------------------------'
c           write(0,*) ' IPASS, ICALL=',IPASS,ICALL
c           write(0,*) '-----------------------------------'

c---------  JIP loop --- going through jtrc ngrp traces at a time

		DO 700 JIP=1,NIP1

c       write (0,*) ' **************************'
c       write (0,*) ' Processing sequence no = ',JIP,' JIP'
c       write (0,*) ' **************************'

C      PART 1 ... READ AND NORMALISE TRACES
C      READISK READS itaper POINTS BEFORE I/P STARTING POINT

c----
c   JIP = trc counter [1, ..., num_trcs-3]
c   if JIP == 1 then we have to read a full "ngrp" buncha traces,
c   otherwise we just need to drop the first trace, roll the current group
c   down 1, and then read in the next trace for the grp

c   for the subsequent reads out of the data array we need to drop the
c   first trace of the previous group, roll the next ngrp-1, and then
c   read the next trace in the group from data

c   LT2 at this point is set to its ground state

c   The itaper stuff is there just for the convolutions in the prewhitening
c   section where we want to eliminate the edge effects of the filters.
c   After the prew section we toss the start itaper stuff from TC
c   and get back to 1,...,LT2 (grnd)
c----
	    IF(JIP.GT.1) THEN

		  LM=LT2+itaper/2
c     write(0,*) ' wavesthifting traces: LT2=',LT2,itaper,LM,jst
		  DO I=1,N-1
		    DO J=1,LM
		 	XR(I,J)=XR(I+1,J)
		 	XI(I,J)=XI(I+1,J)
		    ENDDO
		  ENDDO

                  iroll = JIP + (N-1)
c     write(0,*)'Extracting next trace ',iroll
                  jj = jst-1 - itaper
                  do J = 1, LM
                     XR(N,J) = 0.0
                     XI(N,J) = 0.0
                  enddo
                  do J = 1, LM
                     jj = jj + 1
                     XR(I,J) = data(jj,iroll)
                        if (jj+LM .le. nsamp0) then
                           XI(I,J) = data(jj+LM,iroll)
                        else
                           XI(I,J) = 0.0
                        endif
                  enddo

	    ELSE

c---
c  for the first read out of the data array we need to get ngrp
c  of traces
c  note that we back off the start time jst by itaper samples as a
c  sacrificial zone for the prewhitening filter
c---
		  LM=LT2+itaper/2
c     write(0,*)'Extracting first ',N,'  traces',' LM,jst= ',LM,jst
                  do I = 1, N
                     jj = jst-1 - itaper
                     do J = 1, LM
                        XR(I,J) = 0.0
                        XI(I,J) = 0.0
                     enddo
                     do J = 1, LM
                        jj = jj + 1
                        XR(I,J) = data(jj,I)
                        if (jj+LM .le. nsamp0) then
c     if(I.eq.1)write(0,*)i,jj,jj+LM
                           XI(I,J) = data(jj+LM,I)
                        else
                           XI(I,J) = 0.0
                        endif
                     enddo
                  enddo

c     if(first_time .ne. -1) then
c     do kk=1,10
c          jj = jst-1 - itaper
c       do ii=1,2*LM
c          jj=jj + 1
c          write(8,*)ii,data(jj,kk)
c       enddo
c       write(8,888)
c     enddo
c     endif

c     if(first_time .ne. -1) then
c     do jj=1,4
c     iii=0
c     do ii=1,LT2+itaper/2
c        iii = iii+1
c        write(10,*)iii,xr(jj,ii)
c     enddo
c     do ii=1,LT2+itaper/2
c        iii = iii+1
c        write(10,*)iii,xi(jj,ii)
c     enddo
c     write(10,888)
c     enddo
c     endif
                  first_time = -1

	    ENDIF

c     if(first_time .eq. -1) then
c     iii=0
c     do ii=1,LT2+itaper/2
c        iii = iii+1
c        write(12,*)iii,xr(N,ii)
c     enddo
c     do ii=1,LT2+itaper/2
c        iii = iii+1
c        write(12,*)iii,xi(N,ii)
c     enddo
c     write(12,888)
c     endif


c----
c   Here LT2 has been reset to its grnd state
c   remember XR contains the first LT2(mod) elements from the input trace and
c   XI contains the next LT2(mod)
c   LT2(mod) here is the next pwrof2 of 1/2 the data window length + itaper/2
c----

		LT=LT2
		XLT=0.5/FLOAT(LT)
		NF1=1+NF
		LT1=1+LT
		LTT=LT2+LT2

C      ***   PREWHITENING SECTION   ***

c---
c  LPP=3, always; 1st pass [ICALL=0] LPRW=1; next pass [ICALL=1] LPRW=3
c  PRWF(1,2,3) = 1,0,0
c  Sooo, we only go thru this time->freq->time prew filter calculation once
c  per subr call (see NO below)
c---
		IF(LPRW.NE.LPP)THEN
c                        write(0,*) ' calling enorm'
			CALL ENORM(PRWF,LPRW,FNF)
c                  write(0,*) ' back from enorm: FNF=',FNF,' LPRW=',LPRW
		ENDIF

		IST=1
		IF(NO.GT.0)IST=N
c---
c  at the start of this subr NO=0 so at this point for the 1st pass (IPASS,
c  ICALL) IST=1. All other passes IST=N. This seems to satisfy rolling buffer
c  logic so that you only need to do stuff to the latest trace after first
c  doing it to all the traces in the initial full buffer
c---

c---------------
c     write(0,*)'ipass= ',ipass,' ist= ',ist
		DO IT=IST,N
C      READISK READS itaper POINTS BEFORE I/P STARTING POINT
c      we bump up LT2 and LTT by itaper/2 (the pad) and we later restore them
c      we need to do this because there really LT2+itaper/2 data elements in
c      both XR & XI
			LT2=LT2+itaper/2
			LTT=2*LT2 + itaper
                        LG = LTT
			DO I=1,LT2
				J=I+LT2
				TS(I)=XR(IT,I)
				TS(J)=XI(IT,I)
			ENDDO

c     if(ipass.eq.1.and.icall.eq.0) then
c     do ii=1,2*LT2
c        write(29,*)ii,ts(ii)
c     enddo
c     write(29,888)
c     endif


C
C	change here to fix error in prnorm: should use true gate length LG
C	not Fourier padded LTT as previously
C
			CALL PRNORM(TS,LG,PNF)
c                       write(0,*) ' return from prnorm: PNF=',PNF,IA
			SP(IT)=0.0
			IF(PNF.ne.0.0)SP(IT)=1.0/(PNF*PNF)
			RSP(IA)=SP(IT)
c     write(0,*)'IT= ',IT,' prnorm: LG=',LG,' LTT,rsp=',LTT,RSP(IA)
			IA=IA+1

C      APPLY PREWHITENING FILTER TO ALL TRACES
c---
c  LTT = 2 * LT2, LT2 = next pwrof2 of 1/2 window length of input data
c  The 1st time we do anything LPRW=1; thereafter LPRW=3
c  PRWF=[1,0,0]

c  TS is the input array;  TC is the convolution output array
c---

c                       write(0,*) ' PREWHITENING: LPRW= ',LPRW,LTT,LC
c     write(0,*) (PRWF(ii),ii=1,LPRW)
                        LC=LTT+LPRW-1

			IF (LPRW.LT.1) THEN
				GOTO 777   ! abort
			ELSE IF (LPRW.EQ.1) THEN ! do this 1st time thru
				DO I=1,LTT
					TC(I)=TS(I)
				ENDDO
			ELSE ! do this thereafter
c                             write(0,*) ' calling fold'
c                             write(0,*) ' LTT=',LTT,' LPRW=',
c    +                            LPRW,' LC=', LC
				CALL FOLD(LTT,TS,LPRW,PRWF,LC,TC)
			ENDIF

c     if(ipass.eq.2) then
c     do ii=1,LC
c     write(32,*)ii,tc(ii)
c     enddo
c     write(32,888)
c     endif


c---
c  restore LT2 & LTT to their grnd states
c  We repack the XR & XI arrays
c  AND notice that we now toss the starting itaper stuff so that
c  XR[1,...,LT2] and XI[1,...,LT2]
c---
c     if (ipass .eq. 2) then
c     do ii=1,LTT
c     write(31,*)ii,ts(ii)
c     enddo
c     write(31,888)
c     do ii=1,LC
c     write(32,*)ii,tc(ii)
c     enddo
c     write(32,888)
c     endif

			LT2=LT2-itaper/2
			LTT=LTT-itaper
c     write(0,*)'LT2,LTT= ',LT2,LTT, itaper

			DO I=1,LT2
				K=I+itaper  ! toss the first itaper elements of TC
				L=K+LT2
				XR(IT,I)=TC(K)
				XI(IT,I)=TC(L)
			ENDDO

c     if (ipass.eq.1) then
c     do ii=1,LT2
c     write(30,*)ii,xr(it,ii)
c     enddo
c     do ii=1,LT2
c     write(30,*)ii+LT2,xi(it,ii)
c     enddo
c     write(30,888)
c     endif

		ENDDO
c---------------
c     write(0,*)'TC: ipass, icall= ',ipass,icall
c     if (ipass.eq.2) then
c     if (jip.eq.1) then
c     do j=1,4
c     do ii=1,LT2
c     write(33,*)ii,xr(j,ii)
c     enddo
c     do ii=1,LT2
c     write(33,*)ii+LT2,xi(j,ii)
c     enddo
c     write(33,888)
c     enddo
c     else
c     do ii=1,LT2
c     write(33,*)ii,xr(iroll,ii)
c     enddo
c     do ii=1,LT2
c     write(33,*)ii+LT2,xi(iroll,ii)
c     enddo
c     write(33,888)
c     endif
c     endif


c---
c  LT2 again reset to grnd state at this point
c---

		IF(NF.EQ.INNF)GOTO 96
c---
c  after first pass thru this section (JIP==1) we will jump staight to 96
c  fist pass LPRW=1 with ICALL=0, next pass LPRW=3 with ICALL=1
c  Sooo, we only do this section once per subr call
c  NF -- num freqs computed as 1/2 pwrof2 of 2-sided number of lags 2*MLP
c---
		INNF=NF
C      COMPUTE POWER TRANSFER FUNCTION OF PREWHITENING FILTER
c               write(0,*) ' POWER TRANSFER FUNCTION'
		LPRW=(LPRW+1)/2
		IF(LPRW.LT.NF)LPRW=NF
c     write(0,*) ' calling STWI: LPRW= ',LPRW
		CALL STWI(LPRW,KP,IR,W2)
		CALL ZERO(LPRW,PREW)
		CALL ZERO(LPRW,UN)

c---
c  move time response [1,0,0] from PRWF -> PREW
c---
		DO I=1,LPP
			PREW(I)=PRWF(I)
		ENDDO

		LPR1=LPRW+1
c     write(0,*) ' calling FTRD: LPR1=',LPR1

c---
c  ok now we compute freq domain PREW as smoothed pwr spectrum
c  in the normal course of events LPRW=NF (if above LPRW<NF) so KK=1 and
c  J initially = 0. I suppose it might be possible to have prew sampled on
c  a finer grid (LPRW>NF) but in that case the ration would have to be modulo
c  2 and KK = 2, 4, etc, so that J would incr by that factor
c---
		CALL FTRD(LPR1,KP,IR,W2,PREW,UN)
		KK=LPRW/NF
		J=1-KK
c     write(0,*)'prew: ICALL,IPASS,JIP,NF,nf1,kk= ',ICALL,IPASS,JIP,NF,
c    1nf1,kk
c     do i=1,nf1
c     write(11,*)i,prew(i)
c     enddo
c     write(11,888)
888   format()

		DO 90 I=1,NF1
			J=J+KK
			PREW(I)=PREW(J)*PREW(J)+UN(J)*UN(J)
			IF(PREW(I).GT.0.0)GOTO 90
			IF(J.GT.1)GOTO 94
			PREW(1)=0.5*PREW(2)*PREW(2)
			GOTO 90
94			PREW(I)=0.5*(PREW(J+1)*PREW(J+1)+
     +                           PREW(J-1)*PREW(J-1)+UN(J+1)*
     +                           UN(J+11)+UN(J-1)*UN(J-1))
92				WRITE(LERR,191)I,PREW(I)
90			CONTINUE
 
C----write prewhitening filter to parameter file
C      ***   END OF PREWHITENING SECTION   ***
 
c---
c  reset LPRW=3
c---
			LPRW=LPP

96			CONTINUE

c---
c  remember LT is length trc window and 
c  NF -- num freqs computed as 1/2 pwrof2 of 2-sided number of lags 2*MLP
c---
			KK=LT/NF
c     write(0,*)'LT,NF,KK= ',LT,NF,KK
 
C---------------------------------------------------------------------
C      PART 2 ... CALCULATION OF SMOOTHED CROSS-SPECTRAL MATRIX
C       FREQUENCY INCREMENT OF FTRD O/P IS 1/(LENGTH OF TRACE),2 D.F.
C      PER INCREMENT. SMOOTHING IN BLOCKS OF KK GIVES 2*KK D.F. PER
C      SMOOTHED VALUE AT FREQUENCY INCREMENTS OF KK/(TRACE LENGTH)
C---------------------------------------------------------------------

c---
c  LT2 is currently at grnd state; LT1=1+LT2 is also based on LT2 grnd
c  state
c  LT3 = LT2 (grnd)
c---
		LT3=LT1-1  ! really LT2 out of ssread [LT1=1+LT2]

c      if (icall .eq. 1 .and. print_flag .eq. 0) then
c       write(0,*) ' '
c       write(0,*) ' Performing final spectral estimation'
c       print_flag = 1
c      endif

c     if (ipass.eq.2) then
c     if (jip.eq.1) then
c     do j=1,4
c     do ii=1,LT2
c     write(20,*)ii,xr(j,ii)
c     enddo
c     do ii=1,LT2
c     write(20,*)ii+LT2,xi(j,ii)
c     enddo
c     write(20,888)
c     enddo
c     else
c     do ii=1,LT2
c     write(20,*)ii,xr(iroll,ii)
c     enddo
c     do ii=1,LT2
c     write(20,*)ii+LT2,xi(iroll,ii)
c     enddo
c     write(20,888)
c     endif
c     endif



C-----------------------------------------------------cross spectra
			IF(WTYP.EQ.'P')THEN
 
C----               PAPOULIS
c    remember N=4
c    LWL = 2*MLP/SI  (MLP=max lag positions)

c     write(0,*) ' Papoulis: calling SPCMTX: LT3,N,NF1,LWL=',
c    1 LT3,N,NF1,LWL

			  CALL SPCMTX(N,LT3,C,NF1,LWL,IR,W2,XR,XI,ipass,
     1                                ICALL)
c     write(0,*) ' Papoulis: finished'

			ELSE
 
C---               THOMSON
 
C---load into arrays for Thomson cross-spectrum
c   LT3 <--> LT2
c   reals go 1,...,LT2
c   imags go LT2+1,...,2*LT2
c   LSTEP_CST=1000 so that each successive trace occupies the 1st 2*LT2
c   cells of the next block 1000 cells of XARR_CST
c   IXR_CST=1
C---load into arrays for Thomson cross-spectrum

c       write(0,*) ' LT3, LSTEP_CST=',LT3, LSTEP_CST

			  DO KI=1,ngrp
				LST=IXR_CST+(KI-1)*LSTEP_CST
				DO I=1,LT3
					J=I+LT3
					XARR_CST(LST+I-1)=XR(KI,I)
					XARR_CST(LST+J-1)=XI(KI,I)
				ENDDO
			  ENDDO
 
C********************Thomson cross spectrum************************
 
c       write(0,*) ' calling CROSS_SPECTRUM_THOM'
c       write(0,*)(IINPAR(ii),ii=1,8)

	CALL CROSS_SPECTRUM_THOM (IINPAR,IXR_CST,LSTEP_CST,
     +          RNW_CST,
     +          QMEAN,QWGTS,XARR_CST,IND_CST,FV_CST,X_CST,UR_CST,
     +          XIN_CST,SS_CST,U_CST,Y_CST,Z_CST,RLAM_CST,D_CST,
     +          VAR_CST,DF_CST,S_CST,C_CST,YEIG_CST,DSQR_CST,IFLT,
     +          NF1,mtapr,mgrp)
 
c       write(0,*) ' back from CROSS_SPECTRUM_THOM: IFLT= ',IFLT
C********************************************************************

		IF(IFLT.NE.0)THEN		!error
			WRITE(LERR,678)IFLT
                        ier = -1
			GO TO 777		!abort
		ENDIF

C----reload arrays, subsampling as appropriate
c    (got rid of this since it was all hardwired and i didn't see any
c     improvement even when everything was dimensioned right)

c		IADJ=512/(NF1-1)
                IADJ=1

			DO KI=1,NF1
				DO J=1,N
				DO I=1,N
					KJ=IADJ*(KI-1)+1
					C(I,J,KI)=C_CST(I,J,KJ)
				ENDDO
				ENDDO
			ENDDO
C-----------------------------------------------------cross spectra
			ENDIF

c     if(ipass.eq.1 .and.icall.eq.0.and.jip.eq.1) then
c     do k=1,n
c     do j=1,n
c       do ii=1,nf1
c          write(10,*)ii,C(ii,J,K)
c       enddo
c       write(10,888)
c     enddo
c     enddo
c     endif

c---
c  ESS ~ 3.408 * (length data) / (2*lags)
c---
			KK=IESS
			NO=ngrp*JIP ! was 4*JIP
 
C  PART 3  ...  CALCULATION OF SIGNAL AND NOISE ESTIMATES BY
C               MEANS OF THE MULTIPLE COHERENCES
 
			XNF=FLOAT(NF)
			NQ=N-1
			XN=FLOAT(N)               ! N=4
			XNQ=FLOAT(NQ)
			XKK=1.0/FLOAT(KK)
			BM=0.96*FLOAT(NQ)*XKK
			BM1=1.0-BM
			BM2=BM+0.01*BM1
			VAR=2.0*FLOAT(KK-NQ+1)
			IF(VAR)203,203,204
204			VAR=1.0/VAR
C			BIAS=0.5*FLOAT(NQ)/FLOAT(KK-NQ)
			SDC=SQRT(VAR)
203			SMX=0.0
 
C   ADD WHITE NOISE TO STABILISE CALCS WHERE SIGNAL LOW
C   THIS WILL BE REMOVED BY SSNRDET
C   FIRST FIND MAX POWER AND STORE IN CMAX
C   fix this so CMAX includes prewhitening	(SAR in response to ATW 12/9/88)
 
               IF(LPRW.GT.1)THEN
       			  DO IT=1,N
        			CMAX(IT)=0.
              			DO I=1,NF1
              			  CDPW=C(IT,IT,I)/PREW(I)
               			  IF(CDPW.GT.CMAX(IT))CMAX(IT)=CDPW
               			ENDDO
c                   write(0,*) ' IT=',IT,' CMAX(IT)=',CMAX(IT)
               		  ENDDO
		ELSE			!code as before for no PREW
			  DO IT=1,N
			    CMAX(IT)=0.
			    DO I=1,NF1
			      IF(C(IT,IT,I).GT.CMAX(IT))
     +					CMAX(IT)=C(IT,IT,I)
			    ENDDO
c                   write(0,*) ' IT=',IT,' CMAX(IT)=',CMAX(IT)
			  ENDDO
               	ENDIF
 
C----CHECK FOR DEAD TRACE
 
		DO IT=1,N
			IF(CMAX(IT).LT.1.0E-05)CMAX(IT)=1.0E-05
		ENDDO
 
		DO 200 I=1,NF1
			SUM=0.0
			SMX=0.0
 
			DO IT=1,N
			        SUM=SUM+C(IT,IT,I)
				SMX=SMX+C(IT,IT,I)*C(IT,IT,I)
				DO JT=1,N
C----CORRECT SPECTRA FOR PREWHITENING
				C(IT,JT,I)=C(IT,JT,I)/PREW(I)
				CS(IT,JT)=C(IT,JT,I)
				ENDDO
			ENDDO
				S(I)=SUM
				SUM=SUM/PREW(I)
				IF(CS(1,1).LE.0.0)GOTO 202
				IF(SUM-0.0001*XNF)202,202,201
202				DO K=1,N
					ES(K,I)=0.0
					EN(K,I)=0.0
				ENDDO
			GOTO 200
201			IDEB = 0
			IF(VAR.LE.0.0.OR.(KK-N).LT.2)IDEB=1
 
C----ADD 1% WHITE NOISE
 
			DO IT=1,N
				CS(IT,IT)=CS(IT,IT)+CMAX(IT)*0.01
			ENDDO

c     write(0,*) ' **** calling SSNRDET: N=',N,' Freq= ',I

c---
c  MSING - number of singular matrices
c---
	                CALL SSNRDET(N,CS,ES(1,I),EN(1,I),SNR,G,
     +                         CI,SPACE,XP,SSP,
     +                         IERR,JERR,MSING,IDEB,BM,BM1,BM2,CMAX)

			IF(N.LE.0)N=-N
			UN(I)=0.

			DO K=1,N
				UN(I)=UN(I)+G(K)		
			ENDDO
200		CONTINUE

c     if(ipass.eq.1 .and.icall.eq.0.and.jip.eq.1) then
c     do k=1,n
c     do j=1,n
c       do ii=1,nf1
c          write(13,*)ii,C(ii,J,K)
c       enddo
c       write(13,888)
c     enddo
c     enddo
c     endif

		UN(1)=0.5*UN(1)
		UN(NF1)=0.5*UN(NF1)

		DO K=1,N
		      UG(K)=0.0
		ENDDO

C    ESTIMATE SIGNAL POWER GAINS RELATIVE TO SMALLEST GAIN BY
C    SUMMING SIGNAL POWERS WEIGHTED BY AVERAGE COHERENCE AT EACH FREQY

		DO I=1,NF1
		      DO K=1,N
			 UG(K)=UG(K)+2.0*ES(K,I)*UN(I)
		      ENDDO
		ENDDO

		SUM2 = 0.0
		SUM3 = 0.0
		IMIN=1
		JR=JIP

		DO K=1,N
			S2=0.0
			S3=0.0

			DO I=1,NF1
				S(I)=ES(K,I)
				V(I)=EN(K,I)
				S2=S2+S(I)
				S3=S3+V(I)
			ENDDO

			S2=(S2-0.5*S(1)-0.5*S(NF1))/XNF
			S3=(S3-0.5*V(1)-0.5*V(NF1))/XNF

			RS2(JR)=RS2(JR)+S2
			RS3(JR)=RS3(JR)+S3
			JR=JR+1
			SUM2 = SUM2 + S2
			SUM3 = SUM3 + S3
		ENDDO

		DEN=UG(IMIN)
		S2=0.0

		DO 280 I=1,NF1
			S(I)=0.0
			V(I)=0.0

			DO K=1,N
				S(I)=S(I)+ES(K,I)
				V(I)=V(I)+EN(K,I)
				KS=K+(JIP-1)
		                JRR=KS
		                IF(KS.GT.N)JRR=N
		                IF(KS.GT.NIP1)JRR=N-(KS-NIP1)
		                RSUM(I)=RSUM(I)+ES(K,I)/JRR
		                VRSUM(I)=VRSUM(I)+EN(K,I)/JRR
			ENDDO
			IF(I.GT.N)GOTO 280
			IF(DEN.GT.0.0)UG(I)=UG(I)/DEN
			S2=S2+UG(I)
280			CONTINUE

C----GRAPH SUM OF SIGNAL SPECTRA ESTIMATED FROM MULTIPLE COHERENCES

   		DEN=S2*S2
700		CONTINUE
c     write(0,*)'***********************'
c     write(0,*)'End of loop: JIP = ',JIP
c     write(0,*)'***********************'
c---------  end JIP loop

c----
c  OK, at this point we have done calculations for the group of N traces
c  currently in the buffer
c----
 
C----CORRECT RUNSUM SPECTRA FOR NUMBER OF ANALYSES
c    ICALL == 1:  second time around

c    NIP is the number of ngrp bundles in the full record of jtrc traces

 
		DO I=1,NF1
			S(I)=RSUM(I)/FLOAT(NIP)
		        V(I)=VRSUM(I)/FLOAT(NIP)
		ENDDO
	        IF(ICALL.EQ.1)THEN
			DO K=1,NF1
				ASP(K)=S(K)
				ANP(K)=V(K)
			ENDDO
		ENDIF

c     do ii =1,nf1
c      write(12,*)ii,s(ii)
c     enddo
c      write(12,888)
c     do ii =1,nf1
c      write(12,*)ii,v(ii)
c     enddo

                jgrp = jgrp + 1
c     write(0,*)'jgrp= ',jgrp
                do  k = 1, NF1
                    sigspec (k,jgrp) = S(K)
                    nsespec (k,jgrp) = V(K)
c     write(12,*)k,S(K),V(K)
                enddo
c     write(12,888)
		DO JR=1,JIPP
			JRR=JR
			IF(JR.GT.N)JRR=N
			RS2(JR)=RS2(JR)/JRR
			RS3(JR)=RS3(JR)/JRR
			IF(RS2(JR).GT.0.0)RSTN(JR)=RS2(JR)/RS3(JR)
			IF(ICALL.EQ.1)THEN
				ASN=SUM2/SUM3		!Mean S/N
				IF(RS2(JR).GT.1.0E-30)THEN
					SNDB=10.*ALOG10(RSTN(JR))
				ELSE
					RSTN(JR)=999.
					SNDB=999.
				ENDIF
			WRITE(LERR,80)irec,trcnum(JR),its,
     1                        RSP(JR),RSTN(JR),SNDB,btr(JR)
c			WRITE(STAB(JR)(29:60),80)RSP(JR),RSTN(JR),SNDB
			ENDIF
		ENDDO

C----NOW SORT OUT AVERAGING 
 
		IF(ICALL.EQ.0)THEN
			KLI=0
			IF(MSING.GT.0)THEN
				WRITE(LERR,86)MSING
				MSING=0
			ENDIF
                        WRITE(LERR,81)
		ELSE

 
C----MEAN DATA BANDWIDTH, MAST smoothing for BRAT c 0.5
c    BAV  - average unbiassed data bandwidth
c    BRAT - bandwidth ratio Bwindow/Bdata
 
			BAV=BSUM/FLOAT(NTA)  ! NTA = num_traces
			BRAT=BWIN/BAV
			SWL=4.*FLOAT(MLP)*BRAT		!lwind=2*mlp
			MSWL=10*INT(SWL/10.+1.)		!Min MAST window,ms
			WRITE(LERR,83)BAV,BRAT,MSWL
			IF(BRAT.LT.0.25)WRITE(LERR,84)
			IF(BRAT.GT.0.5)WRITE(LERR,85)

			IF(MSING.GT.0)WRITE(LERR,87)MSING
c			WRITE(LERR,89)(STAB(K),K=1,NTA)
			ASN=10.*ALOG10(ASN)
			WRITE(LERR,667)NTA,ASN

                        if (luwav .ge. 1) then
                           WRITE(luwav,*)'"',wav_type,'"'
                           WRITE(luwav,*)
     1                     '"Ave unbiased bandwidth= ',BAV,
     2                     '  Bandwidth ratio= ',BRAT,'"'
                           WRITE(luwav,*)
     1                     '"Running ave of spectra for ',NTA,
     2                     '  traces : Mean S/N= ',ASN,'"'
                        endif

			CALL MAXDAT(NF1,ASP,SMX)
		        CALL MAXDAT(NF1,ANP,VMX)
		        IF(VMX.GT.SMX)SMX=VMX
			WRITE(LERR,668)FI

c     write(0,*) ' calling SSNGRPH'

c     do ii = 1, nf1
c     write(13,*)ii,ASP(ii)
c     enddo
c     write(13,888)
c     do ii = 1, nf1
c     write(13,*)ii,ANP(ii)
c     enddo
c     close (13)
 	        	CALL SSNGRPH(ASP,ANP,NF1,FI,SMX,SDB,VDB,IOUT,
     1                               luspec,irec)
 
C----CALCULATE ERROR BARS ON SIGNAL
 
c     write(0,*) ' calling SSERB'

 			CALL SSERB(NTA,ESS,ASP,ANP,NF1,SUL,SLL)

C----Write SPE file

                write(LERR,*)' '
                write(LERR,*)' '
                write(LERR,*)' '
                write(LERR,*)'******************************************
     1**********'
                write(LERR,*)'****** Signal & Noise Spectra & Error Bars
     1  ********'
                write(LERR,*)'Record= ',irec
                write(LERR,*)' '
	        WRITE(LERR,*)out_wav_title
                write(LERR,*)'******************************************
     1**********'
                write(LERR,*)'Freq  SIG(db)  NSE(db)  SIG_hi(db)  SIG_lo
     1(db)'
		DO K = 1,IOUT
			RARRAY(K) = FI*(K-1)
                        IF(SUL(K).GT.0.0) SULDB=10.*ALOG10(SUL(K))
                        IF(SLL(K).GT.0.0) SLLDB=10.*ALOG10(SLL(K))
                        WRITE (LERR,341)RARRAY(K),SDB(K),VDB(K),SULDB,
     1                                  SLLDB
                        SULDB = 0.0
                        SLLDB = 0.0
		ENDDO
                write(LERR,*)'******************************************
     1**********'
 
C----WAVELETS
 
                        IFL=0
			IW=1
C
			WLS=FLOAT(MLP)/dtms+1.5
			LW=INT(WLS)		!Wavelet length, samples

c       write (0,*) ' SI=',dtms,' MLP=',MLP,' WLS=',WLS,' LW=',LW

c----
c   output type == 0:  output signal wavelet stuff
c----
			IF (output_type .eq. 0) THEN

c       write(0,*) ' writing signal wavelet ',phase_type
			WRITE(LERR,671)
			   if (phase_type .eq. 0) then
c     do i=1,NF1
c     write(14,*)i,ASP(i)
c     enddo
c     write(14,888)
c     close (14)
 			     CALL SSCPH(IUW,LW,dtms,ASP,NF1,
     +                                  WFIL_PREFIX,TITLE,WCOMM,NOW,
     +                                  PHW,PHINC,xtr,luwav,irec)
			   else

 			     CALL SSMPH(IUW,LW,dtms,ASP,NF1,FI,
     +                                  WFIL_PREFIX,TITLE,WCOMM,NDOF,
     +                                  DOF,FAPPLY,xtr,luwav,irec)


                           endif 

c----
c   output type != 0:  output noise wavelet stuff
c----
			ELSE
c       write(0,*) ' writing noise wavelet'
			WRITE(LERR,670)
c----
c   calculate zero ph wavelet or NOW suite of const phase wvlts from
c   PHW to ... in increments of PHINC
c----
			   if (phase_type .eq. 0) then
                             CALL SSCPH(IUW,LW,dtms,ANP,NF1,
     +                                  WFIL_PREFIX,TITLE,WCOMM,NOW,
     +                                  PHW,PHINC,xtr,luwav,irec)
c----
c   calculate min phase wavelet from energy spectr with NDOF db/oct
c   drop-offs
c----
			   else

        		     CALL SSMPH(IUW,LW,dtms,ANP,NF1,FI,
     +                                  WFIL_PREFIX,TITLE,WCOMM,NDOF,
     +                                  DOF,FAPPLY,xtr,luwav,irec)
                           endif 

			ENDIF
                        write(LERR,*)' '
                        write(LERR,*)' '
                        write(LERR,*)'***   WAVELET (wav)   ***'
                        write(LERR,833)(xtr(ii),ii=1,LW)
                        write(LERR,*)'***   WAVELET   ***'
                        write(LERR,*)' '

		ENDIF

		IF (IPASS.LT.2) THEN

c       write(0,*) ' calling SPREW32: IPASS=',IPASS,' ICALL=',ICALL

c----
c   spectral prewhitening [noise & sig spec read in from IFILE]
c   ICALL set == 1
c----
		   CALL SPREW32(ICALL,PRWF,jgrp,jtrc,OPT,FI,
     +                          NIP,NF1,IDUMY,JDUMY,KDUMY,
     +                          sigspec, nsespec)

c       write(0,*) ' after SPREW32: IPASS=',IPASS,' ICALL=',ICALL

		ENDIF
	ENDDO
c+++++++       !  IPASS loop

777	CONTINUE

        write (LER,*)
        write (LER,*) ' **************************************'
        write (LER,*) ' *** WAVEST finished current record ***'
        write (LER,*) ' **************************************'

        first = .false.

        call gfree (wkSP)
        call gfree (wkG)
        call gfree (wkCMAX)
        call gfree (wkS)
        call gfree (wkTS)
        call gfree (wkV)
        call gfree (wkIR)
        call gfree (wkW2)
        call gfree (wkSNR)
        call gfree (wkPREW)
        call gfree (wkTC)
        call gfree (wkUN)
        call gfree (wkUG)
        call gfree (wkRS2)
        call gfree (wkRS3)
        call gfree (wkRSTN)
        call gfree (wkRSP)
        call gfree (wkRSUM)
        call gfree (wkVRSUM)
        call gfree (wkASP)
        call gfree (wkANP)
        call gfree (wkSUL)
        call gfree (wkSLL)
        call gfree (wkSDB)
        call gfree (wkVDB)
        call gfree (wkRARRAY)
        call gfree (wkCI)
        call gfree (wkSPACE)
        call gfree (wkXP)
        call gfree (wkSSP)

        call gfree (wkFV_CST)
        call gfree (wkZ_CST)
        call gfree (wkUR_CST)
        call gfree (wkD_CST)
        call gfree (wkSS_CST)
        call gfree (wkDSQR_CST)
        call gfree (wkY_CST)
        call gfree (wkYEIG_CST)
        call gfree (wkRLAM_CST)
        call gfree (wkVAR_CST)
        call gfree (wkX_CST)
        call gfree (wkXARR_CST)
        call gfree (wkXIN_CST)
        call gfree (wkS_CST)
        call gfree (wkDF_CST)
        call gfree (wkU_CST)
        call gfree (wkIND_CST)

        return

    1 FORMAT(//,1X,'*** WAVEST : CALCULATION OF SIGNAL AND NOISE ',
     + 'SPECTRA VIA MULTIPLE COHERENCE ***',//,5X,
     + 'Record =  ',I6,5x,'live traces =  ',I5)
   11 FORMAT(/,5X,'Spectra, signal error bars and S/N output to ',A50)
   50 FORMAT(A50)
   51 FORMAT(A1,2X,A1,2X,A1)
   52 FORMAT(A1)
   60   FORMAT(/,5X,'Seismic data input from file ',A50)
   61   FORMAT(/,5X,'Running average option : total of',I4,
     +    ' traces to be analysed')
   62   FORMAT(/,5X,'Analysis of',I3,
     +             ' independent groups of 4 traces each')
   63   FORMAT(5X,'Analysis performed on',I5,'ms (',I5,
     +           ' samples) gate')
   64   FORMAT(5X,'Spectra smoothed using Papoulis window with',
     +            ' maximum lag',I4,'ms')
   65   FORMAT(5X,'Spectra estimated using Thomson multitaper',
     +            ' method with',I3,' tapers',/,
     +      5X,'Equivalent Papoulis window has maximum lag',I4,'ms')
   66   FORMAT(5X,'Effective smoothing factor =',I3,4X,
     +           'Window bandwidth = ',F5.1,'Hz')
   67   FORMAT(1X,I5,1X,I5,1X,I5)
   68   FORMAT(1X,I2,1X,I4,1X,I3,2X,I4)
   69   FORMAT(4X,F5.1,1X)
  707   FORMAT(1X,'Spectra smoothed with Papoulis window length',
     +                                          I4,'ms')
  708   FORMAT(1X,'Thomson multi-taper method: '
     +            'equivalent Papoulis window length',I4,'ms')
  709   FORMAT(1X,'LG=',I4,'ms SM=',I3,1X,A1,1X,A50)
   80 FORMAT(3X,I5,2X,I3,2X,I3,4X,E10.4,3X,F6.2,2X,F7.2,2x,F7.1)
   81 FORMAT(//,5X,'S/N RESULTS :',/,5X,'Seismic data from : ',
     +/,5X,'For each trace, T is the gate start time',/,21X,
     +'BW the unbiassed bandwidth',/,21X,
     +'Total power is the value before normalising' 
     +,/,5X,'All traces are normalised to unit power before S/N',
     + ' calculations',//,6X,'Rec',2X,'Tr',2X,'T ms',3X,'Total power'
     +,4X,'S/N',4X,'S/N(dB)',4X,'BW(Hz)')
   82 FORMAT(//,5X,'S/N RESULTS :',A50,/,5X,'Seismic data from : ',A50,
     +/,5X,'For each trace, T is the gate start time',/,21X,
     +'BW the unbiassed bandwidth',/,21X,
     +'Total power is the value before normalising' 
     +,/,5X,'All traces are normalised to unit power before S/N',
     + ' calculations',//,2X,'Inline',1X,'Xline',1X,'T ms',3X,
     +'Total power',4X,'S/N',4X,'S/N(dB)',4X,'BW(Hz)')
   83 FORMAT(/,5X,'Average unbiassed data bandwidth = ',F5.1,'Hz.',
     + /,5X,'Bandwidth ratio Bwindow/Bdata = ',F4.2,//,5X,
     + 'Based on this you should probably run your MAST scans with a',
     + /,5X,'smoothing',' window at least ',I3,'ms long')
   84 FORMAT(/,3X,'**WAVEST results are undersmoothed - use a smaller ',
     + 'maximum lag next time')
   85 FORMAT(/,3X,'**WAVEST results are oversmoothed - use a larger ',
     + 'maximum lag next time')
   86 FORMAT(//,2X,'**On FIRST pass cross-spectral matrix was ',
     + 'singular on',I5,' occasions',/)
   87 FORMAT(//,2X,'**On SECOND pass (i.e. optimal pre-whitening)',/
     +,5X,'Cross-spectral matrix was singular on',I5,' occasions',/)
   88 FORMAT(//,5X,'SIGNAL(X) + NOISE(.) spectra for GROUP',I3,5X,
     +'Frequency increment = ',F5.2,'Hz')
   89 FORMAT(1X,A70)   
  191 FORMAT(' ***WARNING***',///,'  PREWHITENING RESPONSE IS ZERO AT',
     +    ' FREQUENCY',I3,3X,E12.4,' SUBSTITUTED',///)
  341 FORMAT(1X,F5.1,1X,F7.2,1X,F7.2,3X,F7.2,3X,F7.2)
  503 FORMAT(A12)
  666 FORMAT(1H1,//,2X,' AVERAGE SPECTRA FOR',I3,' INPUT GROUPS : ',
     + 'MEAN S/N = ',F7.2,'dB')
  667 FORMAT(//,2X,' RUNNING AVERAGE OF SPECTRA FOR',I4,' TRACES : ',
     + 'MEAN S/N = ',F7.2,'dB')
  668 FORMAT(7X,' Signal(X) + Noise(.) : Frequency increment ='
     +,F5.2,'Hz.')
  669 FORMAT(//,2X,' SIGNAL WAVELET OUTPUT TO FILE ',A50)
  670 FORMAT(//,2X,' NOISE WAVELET(S) OUTPUT')
  671 FORMAT(//,2X,' SIGNAL WAVELET(S) OUTPUT')
  678 FORMAT(//,2X,' ********ERROR IN THOMSON CROSS-SPECTRUM*****',
     +       /,5X,'IFAULT = ',I2,' Please contact Tim Crews',
     +       /,5X,'This run will be aborted immediately')
  833 format(7(E10.4,1X))


	END	!of WAVEST
