C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine model 
     1           (nfreq, nthicks, nlayers, nlayers2,limpout, lrcout,
     2            tl, th, tinc, fracntg, fl, fh, fi, otap, ipadimp,
     3            t, rcmodel, imp, gfr, gfi, rc, ipadrc, si, dti,
     4            ampl, phase, rcout, impout, xgraph, itr, xtr,
     5            lu_amp, lu_phz, lu_rc, lu_imp, ITHWP1,
     6            obytesf, obytesr, obytesi,
     7            ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     8            ifmt_RecNum,l_RecNum,ln_RecNum)

#include <f77/iounit.h>

      character otap*(*), outfile * 512

      integer nfreq,nthicks,i,j,k,lrcout,limpout
      integer nlayers,nlayers2,numtot,inext,inexte
      integer ipadimp, ipadrc, obytesf, obytesr, obytesi

      integer itr(*)
      real    xtr(*)

      real  rc(nlayers2),t(nlayers2,nthicks)
      real  rcmodel(nlayers2,nthicks),imp(nlayers2,nthicks)
      real  gfr(nfreq,nthicks),gfi(nfreq,nthicks)
      real  ampl(nfreq,nthicks),phase(nfreq,nthicks)
      real  rcout(lrcout),impout(limpout)

      real  tl,th,fl,fh,f,tinc,thick,tmean,fracntg,thickf,thick0
      real  pi2,angle,angle1,drd2dg,thickadd,rock
      real  si, dti

      integer ierr, lu_amp, lu_phz, lu_rc, lu_imp

      logical xgraph

      parameter (pi2 = 2.0 * 3.14159265)
      parameter (drd2dg = 180.0 / 3.14159265)


c---- Calculate Frequency Spectrum of wedge model

      f = fl

      DO i = 1,nfreq      ! Increment frequency by 1Hz each over Freq. range

        thick = tl        ! Set current thickness to minimum
        angle1 = pi2 * f  ! Set initial frequency contribution to phase angle

        do j = 1,nthicks ! Increment frequency by 1Hz each over trace of model

c Net thickness / layer

          thickf = (thick * fracntg) / float(nlayers)

c Not-Net thickness / layer

          thick0 = (thick * (1.0 - fracntg)) / float(nlayers - 1)
 
          t(1,j) = 0.0          ! Time delay of first RC = 0.0
          rcmodel(1,j) = rc(1)  ! model RC
          imp(1,j) = 1.0        ! Arbitray impedance value (binary 1 or -1)

          gfr(i,j) = rc(1)      ! Real component in frequency domain
          gfi(i,j) = 0.0        ! Imaginary component in frequency domain

          do k = 2,nlayers2     ! loop over each subsequent interface

            if(mod(k,2).eq.0) then    ! Pay layer

              thickadd = thickf
              tmean = tmean + thickadd
              numtot = numtot + 1
              rock = -1.0

            else                      ! Not pay layer

              thickadd = thick0
              rock = 1.0

            endif

c  Current time delay from first intinteface
            t(k,j) = t(k - 1,j) + thickadd
            angle = angle1 * t(k,j)          ! Current phase angle
            gfr(i,j) = gfr(i,j) + rc(k) * cos(angle) ! sum reals
            gfi(i,j) = gfi(i,j) - rc(k) * sin(angle) ! sum imaginaries
            rcmodel(k,j) = rc(k)             ! current RC
            imp(k,j) = rock                  ! current impedance (arbitrary #)

          enddo        ! end interface loop

c----- Convert from rectangular to polar

          if (gfr(i,j) .eq. 0.0 .AND. gfi(i,j) .eq. 0.0) then
             ampl(i,j) = 0
             phase(i,j)= 0
          else
             ampl(i,j) = sqrt (gfr(i,j)**2 + gfi(i,j)**2)
             phase(i,j)= atan2 (gfi(i,j),gfr(i,j))
          endif
          phase(i,j) = drd2dg * phase(i,j)    ! Convert radians - degrees
          thick = thick + tinc                ! Increment wedge thickness

        enddo   ! end loop over thicknesses

        f = f + fi                            ! Increment frequency

      ENDDO   ! end freq loop

c      do j=1,nthicks
c      write(0,*)'J= ',j
c      write(0,222)(t(ii,j),ii=1,nlayers2,2)
c      write(0,222)(t(ii,j),ii=2,nlayers2,2)
c222   format(11f7.4)
c      enddo

      IF (xgraph) THEN

         call alloclun (lu_amp)
         call alloclun (lu_phz)
         call alloclun (lu_rc)
         call alloclun (lu_imp)

         outfile = otap(1:lenth(otap))//'.amp_xg'
         open (lu_amp, file= outfile, status= 'unknown', iostat= ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'wedge FATAL ERROR in xgraph option:'
            write(LERR,*)'unable to open open ',
     1      outfile(1:lenth(outfile)),' in this directory'
            call ccexit (666)
         endif

         outfile = otap(1:lenth(otap))//'.phz_xg'
         open (lu_phz, file= outfile, status= 'unknown', iostat= ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'wedge FATAL ERROR in xgraph option:'
            write(LERR,*)'unable to open open ',
     1      outfile(1:lenth(outfile)),' in this directory'
            call ccexit (666)
         endif

         outfile = otap(1:lenth(otap))//'.rc_xg'
         open (lu_rc, file= outfile, status= 'unknown', iostat= ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'wedge FATAL ERROR in xgraph option:'
            write(LERR,*)'unable to open open ',
     1      outfile(1:lenth(outfile)),' in this directory'
            call ccexit (666)
         endif

         outfile = otap(1:lenth(otap))//'.imp_xg'
         open (lu_imp, file= outfile, status= 'unknown', iostat= ierr)
         if (ierr .ne. 0) then
            write(LERR,*)'wedge FATAL ERROR in xgraph option:'
            write(LERR,*)'unable to open open ',
     1      outfile(1:lenth(outfile)),' in this directory'
            call ccexit (666)
         endif

c----- Write out amplitude spectrum of wedge model (sis_xy -R format)

         do j = 1,nthicks

           do i = 1,nfreq
             write(lu_amp,'(1x,i6,1x,g15.7)') i,ampl(i,j)
           enddo
          write(lu_amp,*)

         enddo

c----- Write out phase spectrum of wedge model (sis_xy -R format)

         do j = 1,nthicks

           do i = 1,nfreq
             write(lu_phz,'(1x,i6,1x,g15.7)') i,phase(i,j)
           enddo
           write(lu_phz,*)

         enddo

c----- Write out RC of wedge model (sis_xy -R format)
c----- This crudely goes to nearest sample - needs anti-alias interpolation

         do j = 1,nthicks

           do i = 1, lrcout
              rcout(i) = 0.0
           enddo

           do i = 1,nlayers2
             inext = nint(t(i,j) / si) + ipadrc + 1
             if(rcout(inext) .eq. 0.0) rcout(inext) = rcmodel(i,j)
           enddo

           do i = 1,lrcout
             write(lu_rc,'(1x,i6,1x,g15.7)') i,rcout(i)
           enddo
           write(lu_rc,*)
         enddo

c----- Write out Impedance wedge model (sis_xy -R format)
c----- This crudely goes to nearest sample - needs anti-alias interpolation

         do j = 1,nthicks

           do i = 1, limpout
              impout(i) = 1.0
           enddo

           do i = 2,nlayers2

             inext = nint(t(i - 1,j) / dti) + ipadimp + 1
             inexte = nint(t(i,j) / dti) + ipadimp + 1

             do k = inext,inexte - 1
               if(impout(k).eq.1.0) impout(k) = imp(i,j)
             enddo

           enddo

           do i = 1,limpout
             write(lu_imp,'(1x,i6,1x,g15.7)') i,impout(i)
           enddo
           write(lu_imp,*)

         enddo

         close (lu_amp)
         close (lu_phz)
         close (lu_rc)
         close (lu_imp)

      ELSE

c----- Write out amplitude spectrum of wedge model in usp format

         do j = 1,nthicks

           call savew2 (itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,j,1)
           call savew2 (itr,ifmt_RecNum,l_RecNum, ln_RecNum,1,1)
           call vmov (ampl(1,j), 1, itr(ITHWP1), 1, nfreq)
           call wrtape (lu_amp, itr, obytesf)

         enddo

c----- Write out phase spectrum of wedge model in usp format

         do j = 1,nthicks

           call savew2 (itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,j,1)
           call savew2 (itr,ifmt_RecNum,l_RecNum, ln_RecNum,1,1)
           call vmov (phase(1,j), 1, itr(ITHWP1), 1, nfreq)
           call wrtape (lu_phz, itr, obytesf)

         enddo

c----- Write out RC of wedge model in usp format
c----- This crudely goes to nearest sample - needs anti-alias interpolation

      ii=0
         do j = 1,nthicks

           do i = 1, lrcout
              rcout(i) = 0.0
           enddo

           do i = 1,nlayers2
             inext = nint(t(i,j) / si) + ipadrc + 1
             if(rcout(inext) .eq. 0.0) rcout(inext) = rcmodel(i,j)
           enddo

           call savew2 (itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,j,1)
           call savew2 (itr,ifmt_RecNum,l_RecNum, ln_RecNum,1,1)
           call vmov (rcout, 1, itr(ITHWP1), 1, lrcout)
           call wrtape (lu_rc, itr, obytesr)

         enddo

c----- Write out Impedance wedge model in usp format
c----- This crudely goes to nearest sample - needs anti-alias interpolation

         do j = 1,nthicks

           do i = 1, limpout
              impout(i) = 1.0
           enddo

           do i = 2,nlayers2

             inext = nint(t(i - 1,j) / dti) + ipadimp + 1
             inexte = nint(t(i,j) / dti) + ipadimp + 1

             do k = inext,inexte - 1
               if(impout(k).eq.1.0) impout(k) = imp(i,j)
             enddo

           enddo

           call savew2 (itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,j,1)
           call savew2 (itr,ifmt_RecNum,l_RecNum, ln_RecNum,1,1)
           call vmov (impout, 1, itr(ITHWP1), 1, limpout)
           call wrtape (lu_imp, itr, obytesi)

         enddo

      ENDIF

c---- tidy up 

      return
      end
