C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  wedgeusp: generate a record of ntr traces with wedge
c                            defined by refl coefs and times
C
C**********************************************************************C
C
C For a given near offset time, t0, a given velocity, and a given group
C interval, program computes either a refraction event or a reflection
C hyperbola  and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LTR ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUOUT, LBYTES,obytesf,obytesr,obytesi
      integer argis
#include <f77/pid.h>
      REAL        xtr ( SZLNHD )
      real        tl,th,fl,fh,fi,tinc
      real        fracntg
      real        pad
      integer     nfreq,nthicks,j,nsamprc,nsampimp,lrcout,limpout
      integer     nlayers,nlayers2,ipadrc,ipadimp
      integer     iabort
      integer     ierr, ierrt, lu_rc, lu_amp, lu_phz, lu_imp
      CHARACTER   NAME * 8, ntap * 512, otap * 512
      CHARACTER   outfile * 512
      logical     verbos,xgraph

      real        rc, rcmodel, rcout, impout, imp
      real        t, gfr, gfi, ampl, phase
      pointer     (wkrc     ,      rc(1))
      pointer     (wkrcmodel, rcmodel(1))
      pointer     (wkrcout  ,   rcout(1))
      pointer     (wkimpout ,   impout(1))
      pointer     (wkimp    ,     imp(1))
      pointer     (wkt      ,       t(1))
      pointer     (wkgfr    ,     gfr(1))
      pointer     (wkgfi    ,     gfi(1))
      pointer     (wkampl   ,    ampl(1))
      pointer     (wkphase  ,   phase(1))
 
      DATA NAME     /'WEDGEUSP'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /
      DATA  obytes / 0 /
      DATA  iabort / 0 /
      data verbos/.false./
      data itr/SZLNHD*0/
      data ltr/SZLNHD*0/

c--------------------------------
c  get online help if necesssary
c--------------------------------
      if ( argis( '-?' ) .gt. 0 .or. 
     :     argis( '-h' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0 )then
         call help()
         stop
      endif

c------------------------
c  open printout file
c------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM command line
C**********************************************************************C
      call cmdln(ntap,otap,nlayers,tl,th,fl,fh,tinc,fracntg,
     1           fi,pad,nsi,unitsc,dti,verbos,xgraph)

      nlayers2 = nlayers * 2
      nfreq    = int((fh - fl)/fi) + 1
      nthicks  = int((th - tl) / tinc) + 1 ! No. of traces in model

      si = float (nsi) * unitsc
      ipadrc   = int(pad / si)
      ipadimp  = int(pad / dti)
      nsamprc  = int(th / si) + 1
      nsampimp = int(th / dti) + 1
      lrcout   = ipadrc * 2 + nsamprc        !nsamp of ouput RC trace
      limpout  = ipadimp * 2 + nsampimp      !nsamp of ouput Impedance trace
      nrec     = 1
      ntrc     = nthicks

      nbrc      = nlayers2
      nbrcmodel = nlayers2 * nthicks
      nbrcout   = lrcout
      nbimpout  = limpout
      nbimp     = nlayers2 * nthicks
      nbt       = nlayers2 * nthicks
      nbgfr     = nfreq * nthicks     
      nbgfi     = nfreq * nthicks     
      nbampl    = nfreq * nthicks     
      nbphase   = nfreq * nthicks     
      
      ntot      = nbrc+nbrcmodel+nbrcout+nbimpout+nbimp+
     1            nbt+nbgfr+nbgfi+nbampl+nbphase
      ierrt = 0
      call galloc (wkrc     , nbrc      *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkrcmodel, nbrcmodel *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkrcout  , nbrcout   *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkimpout , nbimpout  *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkimp    , nbimp     *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkt      , nbt       *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkgfr    , nbgfr     *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkgfi    , nbgfi     *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkampl   , nbampl    *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr
      call galloc (wkphase  , nbphase   *SZSMPD, ierr, iabort) 
      ierrt = ierrt + ierr

      if (ierrt .ne. 0) then
         write(LERR,*)'FATAL ERROR:'
         write(LERR,*)'Unable to allocate ',ntot*SZSMPD,' bytes'
         write(LER ,*)'FATAL ERROR:'
         write(LER ,*)'Unable to allocate ',ntot*SZSMPD,' bytes'
         call ccexit (666)
      else
         write(LERR,*)'Allocated ',ntot*SZSMPD,' bytes'
      endif

      call alloclun (lu_rc)
      open (lu_rc, file= ntap(1:lenth(ntap)), status= 'old',
     1      iostat= ierr)
      if (ierr .ne. 0) then
         write(LERR,*)'wedgeusp FATAL ERROR:'
         write(LERR,*)'unable to open open refl coef file ',
     1   ntap(1:lenth(ntap)),' in this directory'
         write(LER ,*)'wedgeusp FATAL ERROR:'
         write(LER ,*)'unable to open open refl coef file ',
     1   ntap(1:lenth(ntap)),' in this directory'
         call ccexit (666) 
      endif    

      rewind (lu_rc)
      do j = 1, nlayers2
         read (lu_rc,*) rc (j)
      enddo
      close (lu_rc)

      write(LERR,*)'Layer    Top RC    Bot RC'
      jj = 0
      do j = 1, nlayers2, 2
         jj = jj + 1
         write(LERR,111) jj, rc(j), rc (j+1)
111      format(i5,5x,2f7.2)
      enddo

C**********************************************************************C
C     open output data set; build line header
C**********************************************************************C
      IF (.not. xgraph) THEN
         len = lenth(otap)
         outfile = otap(1:len)//'.amp.usp'
         call getln( lu_amp, outfile, 'w', 1)
         outfile = otap(1:len)//'.phz.usp'
         call getln( lu_phz, outfile, 'w', 1)
         outfile = otap(1:len)//'.rc.usp'
         call getln( lu_rc, outfile, 'w', 1)
         outfile = otap(1:len)//'.imp.usp'
         call getln( lu_imp, outfile, 'w', 1)

         iform = 3
         call savew( itr, 'NumTrc', ntrc   , LINHED)
         call savew( itr, 'NumRec', nrec   , LINHED)
         call savew( itr, 'Format', iform  , LINHED)
         call savew( itr, 'UnitSc', 1.0000 , LINHED)
c------
c     save certain trace header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
         call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                TRACEHEADER)
         call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,
     1                TRACEHEADER)
         call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     1                TRACEHEADER)
         call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,
     1                TRACEHEADER)
         call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,
     1                TRACEHEADER)
         call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1                TRACEHEADER)
         call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1                TRACEHEADER)
         call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     1                TRACEHEADER)

      ENDIF

c----------------------------------
c  print out parameters
c----------------------------------
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Reflection coef file =  ',ntap(1:lenth(ntap))
        if (otap(1:1) .ne. ' ') then
        write(LERR,*) ' Output file base name=  ',otap(1:lenth(otap))
        endif

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C

      IF (.not. xgraph) THEN
c-------------------------------------
c  update line header; historical LH
c-------------------------------------
         obytesf = SZTRHD + SZSMPD*nfreq
         obytesr = SZTRHD + SZSMPD*lrcout
         obytesi = SZTRHD + SZSMPD*limpout

         lbytes = HSTOFF
         nbyt = 2 * SZHFWD
         call savew( itr, 'HlhEnt',  0   , LINHED)
         call savew( itr, 'HlhByt', nbyt , LINHED)
         call savhlh( itr, lbytes, lbyout )


c---
c  write out headers for ampl & phase data sets
c---
         call savew( itr, 'SmpInt', 1      , LINHED)
         call savew( itr, 'NumSmp', nfreq  , LINHED)
         CALL wrtape ( lu_amp, itr, lbyout )
         CALL wrtape ( lu_phz, itr, lbyout )

c---
c  write out headers for refl coef data set
c---
c
         call savew( itr, 'SmpInt', nsi    , LINHED)
         call savew( itr, 'NumSmp', lrcout , LINHED)
         call savew( itr, 'UnitSc', unitsc , LINHED)
         CALL wrtape ( lu_rc, itr, lbyout )
c---
c  figure out the output inpedance sample interval and the scale factor
c  write out headers for impedance data set
c---
         fac     = 1.0
         dtfac   = dti
         unitsci = 1.0
         do while (dtfac .lt. 1.0)
                  dtfac = 10 * dtfac
                  fac   = 10 * fac
         enddo
         unitsci = 1 / fac
         nsi = nint (dtfac)
         call savew( itr, 'SmpInt', nsi    , LINHED)
         call savew( itr, 'NumSmp', limpout, LINHED)
         call savew( itr, 'UnitSc', unitsci, LINHED)
         CALL wrtape ( lu_imp, itr, lbyout )

      ENDIF
C**********************************************************************C
C     put wedge in appropriate place & write out to otap
C**********************************************************************C

      call model 
     1           (nfreq, nthicks, nlayers, nlayers2,limpout, lrcout,
     2            tl, th, tinc, fracntg, fl, fh, fi, otap, ipadimp,
     3            t, rcmodel, imp, gfr, gfi, rc, ipadrc, si, dti,
     4            ampl, phase, rcout, impout, xgraph, ltr, xtr,
     5            lu_amp, lu_phz, lu_rc, lu_imp, ITHWP1,
     6            obytesf, obytesr, obytesi,
     7            ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     8            ifmt_RecNum,l_RecNum,ln_RecNum)

      IF (.not. xgraph) THEN

        call lbclos(lu_amp)
        call lbclos(lu_phz)
        call lbclos(lu_rc)
        call lbclos(lu_imp)

      ENDIF

      END

c----------------------------
c  online help section
c----------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for wedgeusp: wedge generati
     1on'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input reflection coef file'
        write(LER,*)'-O[otap]   -- output base data set name'
        write(LER,*)'-nl[nl]    -- number of layers'
        write(LER,*)'-ng[ng]    -- net to gross fraction'
        write(LER,*)'-pd[pd]    --                       wedge pad (.4)'
        write(LER,*)'-si[si]    -- sample interval of RC output'
        write(LER,*)'-sc[sc]    -- scale factor of si above'
        write(LER,*)'-ri[ri]    -- scale factor of impedance SI (.0005)'
        write(LER,*)'-tl[tl]    -- starting wedge thickness (sec)   (0)'
        write(LER,*)'-th[th]    -- ending wedge thickness (sec)    (.2)'
        write(LER,*)'-ti[ti]    -- wedge thickness incr (sec)    (.001)'
        write(LER,*)'-fl[fl]    -- freq start (Hz)                  (0)'
        write(LER,*)'-fh[fh]    -- freq end (Hz)                  (100)'
        write(LER,*)'-fi[fi]    -- freq increment (Hz)              (1)'
        write(LER,*)'-X         -- output all in xgraph fmt'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      wedgeusp -N[] -O[] -nl[] -ng[] -pd[] -si[]'
        write(LER,*)'             -sc[] -ri[] -tl[] -th[] -ti[]'
        write(LER,*)'             -fl[] -fh[] -fi[] [ -X ]'
        write(LER,*)' '
      
      return
      end

c-----
c     get command arguments
c
c     otap  - C*100  output file name
c      t0   - R      normal incidence time
c       v   - R      velocity (ft/s or m/s)
c      x0   - R      near offset
c     ntr   - I      number traces
c     nsi   - I      sample interval
c     amp   - R      amplitude of wedges
c      ns   - I      number samples
c    refl   - L      reflection
c    refr   - L      refraction
c    up     - L      updip refraction
c    down   - L      downdip refraction
c    dip    - R      dip angle of reflector/refractor
c    v2     - R      velocity below refractor
c    verbos - L      verbose output or not
c-----
      subroutine cmdln(ntap,otap,nlayers,tl,th,fl,fh,tinc,fracntg,
     1                 fi,pad,nsi,unitsc,dti,verbos,xgraph)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    nsi, nlayers, argis
      real       tl, th, fh, fracntg, pad
      logical    verbos, xgraph

      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argi4('-nl', nlayers,1,1)
      call argi4('-si', nsi,4,4)
      call argr4('-sc', unitsc,0.001,0.001)
      call argr4('-ri', dti,0.0005,0.0005)
      call argr4('-tl', tl,0.0,0.0)
      call argr4('-th', th,0.2,0.2)
      call argr4('-ti', tinc,0.001,0.001)
      call argr4('-fl', fl,0.0,0.0)
      call argr4('-fh', fh,100.0,100.0)
      call argr4('-fi', fi,1.0,1.0)
      call argr4('-ng', fracntg,1.0,1.0)
      call argr4('-pd', pad,0.4,0.4)

      xgraph = ( argis( '-X' ) .gt. 0 )
      verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
