C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine usp_xy (iunit, nsi, nf, times,
     2                   NDI, NLI, limin, limax,
     3                   dimin, dimax, xyscl, notrp, verbos,
     4                   lidel, didel, RC, noedge)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer    itr(SZLNHD), ndi, nli
      real       times (ndi, nli)

      integer    J, lidel, didel
      integer    limin, limax, dimin, dimax
      real       amax, amin, tmax, tmin
      logical    notrp, verbos, RC, noedge
      
      do  j = 1, nli
          do  i = 1, ndi
              times (i,j) = 0.
          enddo
      enddo


      tmin = 1.e20
      tmax = -1.e20

      DO  J = 1, NLI
          call rtape (iunit, itr, nbytes)
          if (nbytes .eq. 0) then
             write(LERR,*)'FATAL ERROR in tim2hed3d: usp horz file'
             write(LERR,*)'Hit unexpected EOF on trace (LI) ',J
             write(LERR,*)'Was expecting ',NLI,' traces'
             write(LER ,*)'FATAL ERROR in tim2hed3d: usp horz file'
             write(LER ,*)'Hit unexpected EOF on trace (LI) ',J
             write(LER ,*)'Was expecting ',NLI,' traces'
             call ccexit (666)
          endif
          call vmov (itr(ITHWP1), 1, times(1,J), 1, NDI)
          call maxv (itr(ITHWP1), 1, amax, loc, NDI)
          call minv (itr(ITHWP1), 1, amin, loc, NDI)
          if (amax .ge. tmax) tmax = amax
          if (amin .le. tmin) tmin = amin
      ENDDO
      write(LERR,*)'Minimum time= ',tmin
      write(LERR,*)'Maximum time= ',tmax
      write(LERR,*)' '

c-----
c  do 2Dx2D interpolation of the input times
c-----
      if (notrp) then
          write(LERR,*)'No horizon file interpolation'
          write(LER ,*)'No horizon file interpolation'
          return
      else
          write(LERR,*)'Horizon file interpolation of zeros'
          write(LER ,*)'Horizon file interpolation of zeros'
      endif
 
      if ( noedge ) then
         write(LERR,*)'Interpolating out to survey edges'
         write(LER ,*)'Interpolating out to survey edges'
         call trp2d (1, nli, 1, ndi, nli, ndi, times)
      else
         write(LERR,*)'No interpolation out to survey edges'
         write(LER ,*)'No interpolation out to survey edges'
         call trp2de (1, nli, 1, ndi, nli, ndi, times)
      endif


c      do  j = 1, nli
c      do  i = 1, ndi
c          write(10,*)j,i,times(i,j)
c      enddo
c       write(10,777)
c 777   format()
c      enddo
c     if (nli .gt. 0) stop

      return

      end
